// components/ip_protection/mojom/data_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/ip_protection/mojom/data_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"




#include "components/ip_protection/mojom/data_types.mojom-data-view.h"




namespace std {

template <>
struct hash<::ip_protection::mojom::ProxyLayer>
    : public mojo::internal::EnumHashImpl<::ip_protection::mojom::ProxyLayer> {};

template <>
struct hash<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus>
    : public mojo::internal::EnumHashImpl<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus> {};

template <>
struct hash<::ip_protection::mojom::IpProxyStatus>
    : public mojo::internal::EnumHashImpl<::ip_protection::mojom::IpProxyStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::ProxyLayer, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ip_protection::mojom::ProxyLayer, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ip_protection::mojom::ProxyLayer>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::IpProxyStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ip_protection::mojom::IpProxyStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ip_protection::mojom::IpProxyStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::GeoHintDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::GeoHintDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::GeoHint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::country_code(input)) in_country_code = Traits::country_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->country_code)::BaseType> country_code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_country_code,
      country_code_fragment);

    fragment->country_code.Set(
        country_code_fragment.is_null() ? nullptr : country_code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->country_code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null country_code in GeoHint struct");

    decltype(Traits::iso_region(input)) in_iso_region = Traits::iso_region(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->iso_region)::BaseType> iso_region_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_iso_region,
      iso_region_fragment);

    fragment->iso_region.Set(
        iso_region_fragment.is_null() ? nullptr : iso_region_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->iso_region.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null iso_region in GeoHint struct");

    decltype(Traits::city_name(input)) in_city_name = Traits::city_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->city_name)::BaseType> city_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_city_name,
      city_name_fragment);

    fragment->city_name.Set(
        city_name_fragment.is_null() ? nullptr : city_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->city_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null city_name in GeoHint struct");
  }

  static bool Deserialize(::ip_protection::mojom::internal::GeoHint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ip_protection::mojom::GeoHintDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::BlindSignedAuthTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::BlindSignedAuthTokenDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::BlindSignedAuthToken_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_token,
      token_fragment);

    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in BlindSignedAuthToken struct");

    decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration)::BaseType> expiration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expiration,
      expiration_fragment);

    fragment->expiration.Set(
        expiration_fragment.is_null() ? nullptr : expiration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expiration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expiration in BlindSignedAuthToken struct");

    decltype(Traits::geo_hint(input)) in_geo_hint = Traits::geo_hint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->geo_hint)::BaseType> geo_hint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::ip_protection::mojom::GeoHintDataView>(
      in_geo_hint,
      geo_hint_fragment);

    fragment->geo_hint.Set(
        geo_hint_fragment.is_null() ? nullptr : geo_hint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->geo_hint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null geo_hint in BlindSignedAuthToken struct");
  }

  static bool Deserialize(::ip_protection::mojom::internal::BlindSignedAuthToken_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ip_protection::mojom::BlindSignedAuthTokenDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::ProbabilisticRevealTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::ProbabilisticRevealTokenDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::ProbabilisticRevealToken_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->version = Traits::version(input);

    decltype(Traits::u(input)) in_u = Traits::u(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->u)::BaseType> u_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_u,
      u_fragment);

    fragment->u.Set(
        u_fragment.is_null() ? nullptr : u_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->u.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null u in ProbabilisticRevealToken struct");

    decltype(Traits::e(input)) in_e = Traits::e(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->e)::BaseType> e_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_e,
      e_fragment);

    fragment->e.Set(
        e_fragment.is_null() ? nullptr : e_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->e.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null e in ProbabilisticRevealToken struct");
  }

  static bool Deserialize(::ip_protection::mojom::internal::ProbabilisticRevealToken_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ip_protection::mojom::ProbabilisticRevealTokenDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::TryGetProbabilisticRevealTokensResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::TryGetProbabilisticRevealTokensResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::TryGetProbabilisticRevealTokensResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus>(
      Traits::status(input),
      &fragment->status);

    fragment->network_error_code = Traits::network_error_code(input);

    decltype(Traits::try_again_after(input)) in_try_again_after = Traits::try_again_after(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->try_again_after)::BaseType> try_again_after_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_try_again_after,
      try_again_after_fragment);

    fragment->try_again_after.Set(
        try_again_after_fragment.is_null() ? nullptr : try_again_after_fragment.data());
  }

  static bool Deserialize(::ip_protection::mojom::internal::TryGetProbabilisticRevealTokensResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ip_protection::mojom::TryGetProbabilisticRevealTokensResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::TryGetProbabilisticRevealTokensOutcomeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::TryGetProbabilisticRevealTokensOutcomeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::TryGetProbabilisticRevealTokensOutcome_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tokens(input)) in_tokens = Traits::tokens(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tokens)::BaseType>
        tokens_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tokens_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::ip_protection::mojom::ProbabilisticRevealTokenDataView>>(
      in_tokens,
      tokens_fragment,
      &tokens_validate_params);

    fragment->tokens.Set(
        tokens_fragment.is_null() ? nullptr : tokens_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tokens.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tokens in TryGetProbabilisticRevealTokensOutcome struct");

    decltype(Traits::public_key(input)) in_public_key = Traits::public_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_key)::BaseType> public_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_public_key,
      public_key_fragment);

    fragment->public_key.Set(
        public_key_fragment.is_null() ? nullptr : public_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->public_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null public_key in TryGetProbabilisticRevealTokensOutcome struct");

    fragment->expiration_time_seconds = Traits::expiration_time_seconds(input);

    fragment->next_epoch_start_time_seconds = Traits::next_epoch_start_time_seconds(input);

    fragment->num_tokens_with_signal = Traits::num_tokens_with_signal(input);

    decltype(Traits::epoch_id(input)) in_epoch_id = Traits::epoch_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->epoch_id)::BaseType> epoch_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_epoch_id,
      epoch_id_fragment);

    fragment->epoch_id.Set(
        epoch_id_fragment.is_null() ? nullptr : epoch_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->epoch_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null epoch_id in TryGetProbabilisticRevealTokensOutcome struct");
  }

  static bool Deserialize(::ip_protection::mojom::internal::TryGetProbabilisticRevealTokensOutcome_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ip_protection::mojom::TryGetProbabilisticRevealTokensOutcomeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ip_protection::mojom {

inline void GeoHintDataView::GetCountryCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->country_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GeoHintDataView::GetIsoRegionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->iso_region.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GeoHintDataView::GetCityNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->city_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BlindSignedAuthTokenDataView::GetTokenDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->token.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BlindSignedAuthTokenDataView::GetExpirationDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiration.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void BlindSignedAuthTokenDataView::GetGeoHintDataView(
    GeoHintDataView* output) {
  auto pointer = data_->geo_hint.Get();
  *output = GeoHintDataView(pointer, message_);
}


inline void ProbabilisticRevealTokenDataView::GetUDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->u.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProbabilisticRevealTokenDataView::GetEDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->e.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TryGetProbabilisticRevealTokensResultDataView::GetTryAgainAfterDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->try_again_after.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void TryGetProbabilisticRevealTokensOutcomeDataView::GetTokensDataView(
    mojo::ArrayDataView<ProbabilisticRevealTokenDataView>* output) {
  auto pointer = data_->tokens.Get();
  *output = mojo::ArrayDataView<ProbabilisticRevealTokenDataView>(pointer, message_);
}
inline void TryGetProbabilisticRevealTokensOutcomeDataView::GetPublicKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->public_key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TryGetProbabilisticRevealTokensOutcomeDataView::GetEpochIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->epoch_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // ip_protection::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::ip_protection::mojom::ProxyLayer> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ip_protection::mojom::ProxyLayer value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::ip_protection::mojom::IpProxyStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ip_protection::mojom::IpProxyStatus value);
};

} // namespace perfetto

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SHARED_H_