// components/ip_protection/mojom/data_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_DATA_VIEW_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/ip_protection/mojom/data_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace ip_protection::mojom {
class GeoHintDataView;

class BlindSignedAuthTokenDataView;

class ProbabilisticRevealTokenDataView;

class TryGetProbabilisticRevealTokensResultDataView;

class TryGetProbabilisticRevealTokensOutcomeDataView;



}  // ip_protection::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ip_protection::mojom::GeoHintDataView> {
  using Data = ::ip_protection::mojom::internal::GeoHint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ip_protection::mojom::BlindSignedAuthTokenDataView> {
  using Data = ::ip_protection::mojom::internal::BlindSignedAuthToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ip_protection::mojom::ProbabilisticRevealTokenDataView> {
  using Data = ::ip_protection::mojom::internal::ProbabilisticRevealToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ip_protection::mojom::TryGetProbabilisticRevealTokensResultDataView> {
  using Data = ::ip_protection::mojom::internal::TryGetProbabilisticRevealTokensResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ip_protection::mojom::TryGetProbabilisticRevealTokensOutcomeDataView> {
  using Data = ::ip_protection::mojom::internal::TryGetProbabilisticRevealTokensOutcome_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ip_protection::mojom {


enum class ProxyLayer : int32_t {
  
  kProxyA = 0,
  
  kProxyB = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ProxyLayer value);
inline bool IsKnownEnumValue(ProxyLayer value) {
  return internal::ProxyLayer_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TryGetProbabilisticRevealTokensStatus : int32_t {
  
  kSuccess = 0,
  
  kNetNotOk = 1,
  
  kNetOkNullResponse = 2,
  
  kNullResponse = 3,
  
  kResponseParsingFailed = 4,
  
  kInvalidTokenVersion = 5,
  
  kInvalidTokenSize = 6,
  
  kTooFewTokens = 7,
  
  kTooManyTokens = 8,
  
  kExpirationTooSoon = 9,
  
  kExpirationTooLate = 10,
  
  kInvalidPublicKey = 11,
  
  kInvalidNumTokensWithSignal = 12,
  
  kRequestBackedOff = 13,
  
  kNoGoogleChromeBranding = 14,
  
  kInvalidEpochIdSize = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

 std::ostream& operator<<(std::ostream& os, TryGetProbabilisticRevealTokensStatus value);
inline bool IsKnownEnumValue(TryGetProbabilisticRevealTokensStatus value) {
  return internal::TryGetProbabilisticRevealTokensStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IpProxyStatus : int32_t {
  
  kOk = 0,
  
  kFeatureNotEnabled = 1,
  
  kMaskedDomainListNotEnabled = 2,
  
  kMaskedDomainListNotPopulated = 3,
  
  kAuthTokensUnavailable = 4,
  
  kUnavailable = 5,
  
  kBypassedByDevTools = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, IpProxyStatus value);
inline bool IsKnownEnumValue(IpProxyStatus value) {
  return internal::IpProxyStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GeoHintDataView {
 public:
  GeoHintDataView() = default;

  GeoHintDataView(
      internal::GeoHint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCountryCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCountryCode(UserType* output) {
    
    auto* pointer = data_->country_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIsoRegionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsoRegion(UserType* output) {
    
    auto* pointer = data_->iso_region.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCityNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCityName(UserType* output) {
    
    auto* pointer = data_->city_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GeoHint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlindSignedAuthTokenDataView {
 public:
  BlindSignedAuthTokenDataView() = default;

  BlindSignedAuthTokenDataView(
      internal::BlindSignedAuthToken_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetGeoHintDataView(
      GeoHintDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeoHint(UserType* output) {
    
    auto* pointer = data_->geo_hint.Get();
    return mojo::internal::Deserialize<::ip_protection::mojom::GeoHintDataView>(
        pointer, output, message_);
  }
 private:
  internal::BlindSignedAuthToken_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProbabilisticRevealTokenDataView {
 public:
  ProbabilisticRevealTokenDataView() = default;

  ProbabilisticRevealTokenDataView(
      internal::ProbabilisticRevealToken_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t version() const {
    return data_->version;
  }
  inline void GetUDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadU(UserType* output) {
    
    auto* pointer = data_->u.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadE(UserType* output) {
    
    auto* pointer = data_->e.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProbabilisticRevealToken_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TryGetProbabilisticRevealTokensResultDataView {
 public:
  TryGetProbabilisticRevealTokensResultDataView() = default;

  TryGetProbabilisticRevealTokensResultDataView(
      internal::TryGetProbabilisticRevealTokensResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus>(
        data_value, output);
  }
  TryGetProbabilisticRevealTokensStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus>(data_->status));
  }
  int32_t network_error_code() const {
    return data_->network_error_code;
  }
  inline void GetTryAgainAfterDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTryAgainAfter(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `try_again_after` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTryAgainAfter` instead "
    "of `ReadTryAgainAfter if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->try_again_after.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::TryGetProbabilisticRevealTokensResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TryGetProbabilisticRevealTokensOutcomeDataView {
 public:
  TryGetProbabilisticRevealTokensOutcomeDataView() = default;

  TryGetProbabilisticRevealTokensOutcomeDataView(
      internal::TryGetProbabilisticRevealTokensOutcome_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokensDataView(
      mojo::ArrayDataView<ProbabilisticRevealTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTokens(UserType* output) {
    
    auto* pointer = data_->tokens.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ip_protection::mojom::ProbabilisticRevealTokenDataView>>(
        pointer, output, message_);
  }
  inline void GetPublicKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKey(UserType* output) {
    
    auto* pointer = data_->public_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t expiration_time_seconds() const {
    return data_->expiration_time_seconds;
  }
  uint64_t next_epoch_start_time_seconds() const {
    return data_->next_epoch_start_time_seconds;
  }
  int32_t num_tokens_with_signal() const {
    return data_->num_tokens_with_signal;
  }
  inline void GetEpochIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEpochId(UserType* output) {
    
    auto* pointer = data_->epoch_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TryGetProbabilisticRevealTokensOutcome_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ip_protection::mojom

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_DATA_VIEW_H_