// components/input/render_input_router.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/input/render_input_router.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/input/render_input_router.mojom-params-data.h"
#include "components/input/render_input_router.mojom-shared-message-ids.h"

#include "components/input/render_input_router.mojom-import-headers.h"
#include "components/input/render_input_router.mojom-test-utils.h"


namespace input::mojom {
RenderInputRouterConfig::RenderInputRouterConfig()
    : rir_client(),
      grouping_id(),
      force_enable_zoom(false) {}

RenderInputRouterConfig::RenderInputRouterConfig(
    ::mojo::PendingRemote<::blink::mojom::RenderInputRouterClient> rir_client_in,
    const ::base::UnguessableToken& grouping_id_in,
    bool force_enable_zoom_in)
    : rir_client(std::move(rir_client_in)),
      grouping_id(std::move(grouping_id_in)),
      force_enable_zoom(std::move(force_enable_zoom_in)) {}

RenderInputRouterConfig::~RenderInputRouterConfig() = default;

void RenderInputRouterConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rir_client"), this->rir_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::RenderInputRouterClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "grouping_id"), this->grouping_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_enable_zoom"), this->force_enable_zoom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RenderInputRouterConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchTransferState::TouchTransferState()
    : down_time_ms(),
      root_widget_frame_sink_id(),
      web_contents_y_offset_pix(),
      dip_scale(),
      browser_would_have_handled(false) {}

TouchTransferState::TouchTransferState(
    ::base::TimeTicks down_time_ms_in,
    const ::viz::FrameSinkId& root_widget_frame_sink_id_in,
    float web_contents_y_offset_pix_in,
    float dip_scale_in,
    bool browser_would_have_handled_in)
    : down_time_ms(std::move(down_time_ms_in)),
      root_widget_frame_sink_id(std::move(root_widget_frame_sink_id_in)),
      web_contents_y_offset_pix(std::move(web_contents_y_offset_pix_in)),
      dip_scale(std::move(dip_scale_in)),
      browser_would_have_handled(std::move(browser_would_have_handled_in)) {}

TouchTransferState::~TouchTransferState() = default;

void TouchTransferState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "down_time_ms"), this->down_time_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_widget_frame_sink_id"), this->root_widget_frame_sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::FrameSinkId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_contents_y_offset_pix"), this->web_contents_y_offset_pix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dip_scale"), this->dip_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_would_have_handled"), this->browser_would_have_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchTransferState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

RenderInputRouterDelegate::IPCStableHashFunction RenderInputRouterDelegate::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderInputRouterDelegate>(message.name())) {
    case messages::RenderInputRouterDelegate::kStateOnTouchTransfer: {
      return &RenderInputRouterDelegate::StateOnTouchTransfer_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged: {
      return &RenderInputRouterDelegate::ForceEnableZoomStateChanged_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegate::kStopFlingingOnViz: {
      return &RenderInputRouterDelegate::StopFlingingOnViz_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegate::kRestartInputEventAckTimeoutIfNecessary: {
      return &RenderInputRouterDelegate::RestartInputEventAckTimeoutIfNecessary_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegate::kNotifyVisibilityChanged: {
      return &RenderInputRouterDelegate::NotifyVisibilityChanged_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegate::kResetGestureDetection: {
      return &RenderInputRouterDelegate::ResetGestureDetection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderInputRouterDelegate::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderInputRouterDelegate>(message.name())) {
      case messages::RenderInputRouterDelegate::kStateOnTouchTransfer:
            return "Receive input::mojom::RenderInputRouterDelegate::StateOnTouchTransfer";
      case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged:
            return "Receive input::mojom::RenderInputRouterDelegate::ForceEnableZoomStateChanged";
      case messages::RenderInputRouterDelegate::kStopFlingingOnViz:
            return "Receive input::mojom::RenderInputRouterDelegate::StopFlingingOnViz";
      case messages::RenderInputRouterDelegate::kRestartInputEventAckTimeoutIfNecessary:
            return "Receive input::mojom::RenderInputRouterDelegate::RestartInputEventAckTimeoutIfNecessary";
      case messages::RenderInputRouterDelegate::kNotifyVisibilityChanged:
            return "Receive input::mojom::RenderInputRouterDelegate::NotifyVisibilityChanged";
      case messages::RenderInputRouterDelegate::kResetGestureDetection:
            return "Receive input::mojom::RenderInputRouterDelegate::ResetGestureDetection";
    }
  } else {
    switch (static_cast<messages::RenderInputRouterDelegate>(message.name())) {
      case messages::RenderInputRouterDelegate::kStateOnTouchTransfer:
            return "Receive reply input::mojom::RenderInputRouterDelegate::StateOnTouchTransfer";
      case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged:
            return "Receive reply input::mojom::RenderInputRouterDelegate::ForceEnableZoomStateChanged";
      case messages::RenderInputRouterDelegate::kStopFlingingOnViz:
            return "Receive reply input::mojom::RenderInputRouterDelegate::StopFlingingOnViz";
      case messages::RenderInputRouterDelegate::kRestartInputEventAckTimeoutIfNecessary:
            return "Receive reply input::mojom::RenderInputRouterDelegate::RestartInputEventAckTimeoutIfNecessary";
      case messages::RenderInputRouterDelegate::kNotifyVisibilityChanged:
            return "Receive reply input::mojom::RenderInputRouterDelegate::NotifyVisibilityChanged";
      case messages::RenderInputRouterDelegate::kResetGestureDetection:
            return "Receive reply input::mojom::RenderInputRouterDelegate::ResetGestureDetection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderInputRouterDelegate::StateOnTouchTransfer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec9275be;  // IPCStableHash for input::mojom::RenderInputRouterDelegate::StateOnTouchTransfer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegate::ForceEnableZoomStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85211f50;  // IPCStableHash for input::mojom::RenderInputRouterDelegate::ForceEnableZoomStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegate::StopFlingingOnViz_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0045fcc6;  // IPCStableHash for input::mojom::RenderInputRouterDelegate::StopFlingingOnViz
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegate::RestartInputEventAckTimeoutIfNecessary_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf807684b;  // IPCStableHash for input::mojom::RenderInputRouterDelegate::RestartInputEventAckTimeoutIfNecessary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegate::NotifyVisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93fc95e3;  // IPCStableHash for input::mojom::RenderInputRouterDelegate::NotifyVisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegate::ResetGestureDetection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9ef8a69;  // IPCStableHash for input::mojom::RenderInputRouterDelegate::ResetGestureDetection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RenderInputRouterDelegateProxy::RenderInputRouterDelegateProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderInputRouterDelegateProxy::StateOnTouchTransfer(
    TouchTransferStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::StateOnTouchTransfer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type TouchTransferStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kStateOnTouchTransfer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::input::mojom::TouchTransferStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in RenderInputRouterDelegate.StateOnTouchTransfer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("StateOnTouchTransfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateProxy::ForceEnableZoomStateChanged(
    bool in_force_enable_zoom, const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::ForceEnableZoomStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force_enable_zoom"), in_force_enable_zoom,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->force_enable_zoom = in_force_enable_zoom;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in RenderInputRouterDelegate.ForceEnableZoomStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("ForceEnableZoomStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateProxy::StopFlingingOnViz(
    const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::StopFlingingOnViz", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kStopFlingingOnViz), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_StopFlingingOnViz_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in RenderInputRouterDelegate.StopFlingingOnViz request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("StopFlingingOnViz");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateProxy::RestartInputEventAckTimeoutIfNecessary(
    const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::RestartInputEventAckTimeoutIfNecessary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kRestartInputEventAckTimeoutIfNecessary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in RenderInputRouterDelegate.RestartInputEventAckTimeoutIfNecessary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("RestartInputEventAckTimeoutIfNecessary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateProxy::NotifyVisibilityChanged(
    const ::viz::FrameSinkId& in_frame_sink_id, bool in_is_hidden) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::NotifyVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_hidden"), in_is_hidden,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kNotifyVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in RenderInputRouterDelegate.NotifyVisibilityChanged request");

  params->is_hidden = in_is_hidden;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("NotifyVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateProxy::ResetGestureDetection(
    const ::viz::FrameSinkId& in_root_widget_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::ResetGestureDetection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_widget_frame_sink_id"), in_root_widget_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kResetGestureDetection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_ResetGestureDetection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_widget_frame_sink_id)::BaseType> root_widget_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_root_widget_frame_sink_id,
    root_widget_frame_sink_id_fragment);

  params->root_widget_frame_sink_id.Set(
      root_widget_frame_sink_id_fragment.is_null() ? nullptr : root_widget_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_widget_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_widget_frame_sink_id in RenderInputRouterDelegate.ResetGestureDetection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("ResetGestureDetection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RenderInputRouterDelegateStubDispatch::Accept(
    RenderInputRouterDelegate* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderInputRouterDelegate>(message->header()->name)) {
    case messages::RenderInputRouterDelegate::kStateOnTouchTransfer: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegate.0
      bool success = true;
      TouchTransferStatePtr p_state{};
      RenderInputRouterDelegate_StateOnTouchTransfer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StateOnTouchTransfer(        
        std::move(p_state));
      return true;
    }
    case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegate.1
      bool success = true;
      bool p_force_enable_zoom{};
      ::viz::FrameSinkId p_frame_sink_id{};
      RenderInputRouterDelegate_ForceEnableZoomStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_force_enable_zoom = input_data_view.force_enable_zoom();
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceEnableZoomStateChanged(        
        std::move(p_force_enable_zoom), 
        std::move(p_frame_sink_id));
      return true;
    }
    case messages::RenderInputRouterDelegate::kStopFlingingOnViz: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_StopFlingingOnViz_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_StopFlingingOnViz_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegate.2
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      RenderInputRouterDelegate_StopFlingingOnViz_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopFlingingOnViz(        
        std::move(p_frame_sink_id));
      return true;
    }
    case messages::RenderInputRouterDelegate::kRestartInputEventAckTimeoutIfNecessary: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegate.3
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RestartInputEventAckTimeoutIfNecessary(        
        std::move(p_frame_sink_id));
      return true;
    }
    case messages::RenderInputRouterDelegate::kNotifyVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegate.4
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      bool p_is_hidden{};
      RenderInputRouterDelegate_NotifyVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success)
        p_is_hidden = input_data_view.is_hidden();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyVisibilityChanged(        
        std::move(p_frame_sink_id), 
        std::move(p_is_hidden));
      return true;
    }
    case messages::RenderInputRouterDelegate::kResetGestureDetection: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_ResetGestureDetection_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_ResetGestureDetection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegate.5
      bool success = true;
      ::viz::FrameSinkId p_root_widget_frame_sink_id{};
      RenderInputRouterDelegate_ResetGestureDetection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRootWidgetFrameSinkId(&p_root_widget_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetGestureDetection(        
        std::move(p_root_widget_frame_sink_id));
      return true;
    }
  }
  return false;
}

// static
bool RenderInputRouterDelegateStubDispatch::AcceptWithResponder(
    RenderInputRouterDelegate* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderInputRouterDelegate>(message->header()->name)) {
    case messages::RenderInputRouterDelegate::kStateOnTouchTransfer: {
      break;
    }
    case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged: {
      break;
    }
    case messages::RenderInputRouterDelegate::kStopFlingingOnViz: {
      break;
    }
    case messages::RenderInputRouterDelegate::kRestartInputEventAckTimeoutIfNecessary: {
      break;
    }
    case messages::RenderInputRouterDelegate::kNotifyVisibilityChanged: {
      break;
    }
    case messages::RenderInputRouterDelegate::kResetGestureDetection: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderInputRouterDelegateValidationInfo[] = {
    { &internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegate_StopFlingingOnViz_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegate_ResetGestureDetection_Params_Data::Validate,
     nullptr /* no response */},
};

bool RenderInputRouterDelegateRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::input::mojom::RenderInputRouterDelegate::Name_,
    kRenderInputRouterDelegateValidationInfo);
}

// The declaration includes the definition on other builds.

RenderInputRouterDelegateClient::IPCStableHashFunction RenderInputRouterDelegateClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderInputRouterDelegateClient>(message.name())) {
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent: {
      return &RenderInputRouterDelegateClient::NotifyObserversOfInputEvent_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks: {
      return &RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource: {
      return &RenderInputRouterDelegateClient::OnInvalidInputEventSource_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegateClient::kStateOnOverscrollTransfer: {
      return &RenderInputRouterDelegateClient::StateOnOverscrollTransfer_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegateClient::kRendererInputResponsivenessChanged: {
      return &RenderInputRouterDelegateClient::RendererInputResponsivenessChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderInputRouterDelegateClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderInputRouterDelegateClient>(message.name())) {
      case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent:
            return "Receive input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEvent";
      case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks:
            return "Receive input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks";
      case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource:
            return "Receive input::mojom::RenderInputRouterDelegateClient::OnInvalidInputEventSource";
      case messages::RenderInputRouterDelegateClient::kStateOnOverscrollTransfer:
            return "Receive input::mojom::RenderInputRouterDelegateClient::StateOnOverscrollTransfer";
      case messages::RenderInputRouterDelegateClient::kRendererInputResponsivenessChanged:
            return "Receive input::mojom::RenderInputRouterDelegateClient::RendererInputResponsivenessChanged";
    }
  } else {
    switch (static_cast<messages::RenderInputRouterDelegateClient>(message.name())) {
      case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent:
            return "Receive reply input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEvent";
      case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks:
            return "Receive reply input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks";
      case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource:
            return "Receive reply input::mojom::RenderInputRouterDelegateClient::OnInvalidInputEventSource";
      case messages::RenderInputRouterDelegateClient::kStateOnOverscrollTransfer:
            return "Receive reply input::mojom::RenderInputRouterDelegateClient::StateOnOverscrollTransfer";
      case messages::RenderInputRouterDelegateClient::kRendererInputResponsivenessChanged:
            return "Receive reply input::mojom::RenderInputRouterDelegateClient::RendererInputResponsivenessChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderInputRouterDelegateClient::NotifyObserversOfInputEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa41424ce;  // IPCStableHash for input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe7e1f9a8;  // IPCStableHash for input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegateClient::OnInvalidInputEventSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x644f2ddb;  // IPCStableHash for input::mojom::RenderInputRouterDelegateClient::OnInvalidInputEventSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegateClient::StateOnOverscrollTransfer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1659b009;  // IPCStableHash for input::mojom::RenderInputRouterDelegateClient::StateOnOverscrollTransfer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegateClient::RendererInputResponsivenessChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6caf14b;  // IPCStableHash for input::mojom::RenderInputRouterDelegateClient::RendererInputResponsivenessChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RenderInputRouterDelegateClientProxy::RenderInputRouterDelegateClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderInputRouterDelegateClientProxy::NotifyObserversOfInputEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, bool in_dispatched_to_renderer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dispatched_to_renderer"), in_dispatched_to_renderer,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderInputRouterDelegateClient.NotifyObserversOfInputEvent request");

  params->dispatched_to_renderer = in_dispatched_to_renderer;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegateClient::Name_);
  message.set_method_name("NotifyObserversOfInputEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateClientProxy::NotifyObserversOfInputEventAcks(
    ::blink::mojom::InputEventResultSource in_ack_source, ::blink::mojom::InputEventResultState in_ack_result, ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack_source"), in_ack_source,
                        "<value of type ::blink::mojom::InputEventResultSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack_result"), in_ack_result,
                        "<value of type ::blink::mojom::InputEventResultState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::InputEventResultSource>(
    in_ack_source,
    &params->ack_source);

  
  mojo::internal::Serialize<::blink::mojom::InputEventResultState>(
    in_ack_result,
    &params->ack_result);
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderInputRouterDelegateClient.NotifyObserversOfInputEventAcks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegateClient::Name_);
  message.set_method_name("NotifyObserversOfInputEventAcks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateClientProxy::OnInvalidInputEventSource(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send input::mojom::RenderInputRouterDelegateClient::OnInvalidInputEventSource");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegateClient::Name_);
  message.set_method_name("OnInvalidInputEventSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateClientProxy::StateOnOverscrollTransfer(
    ::blink::mojom::DidOverscrollParamsPtr in_overscroll) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegateClient::StateOnOverscrollTransfer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("overscroll"), in_overscroll,
                        "<value of type ::blink::mojom::DidOverscrollParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegateClient::kStateOnOverscrollTransfer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->overscroll)::BaseType> overscroll_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DidOverscrollParamsDataView>(
    in_overscroll,
    overscroll_fragment);

  params->overscroll.Set(
      overscroll_fragment.is_null() ? nullptr : overscroll_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegateClient::Name_);
  message.set_method_name("StateOnOverscrollTransfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateClientProxy::RendererInputResponsivenessChanged(
    bool in_is_responsive, std::optional<::base::TimeTicks> in_ack_timeout_ts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegateClient::RendererInputResponsivenessChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_responsive"), in_is_responsive,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack_timeout_ts"), in_ack_timeout_ts,
                        "<value of type std::optional<::base::TimeTicks>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegateClient::kRendererInputResponsivenessChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_responsive = in_is_responsive;
  mojo::internal::MessageFragment<
      typename decltype(params->ack_timeout_ts)::BaseType> ack_timeout_ts_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_ack_timeout_ts,
    ack_timeout_ts_fragment);

  params->ack_timeout_ts.Set(
      ack_timeout_ts_fragment.is_null() ? nullptr : ack_timeout_ts_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegateClient::Name_);
  message.set_method_name("RendererInputResponsivenessChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RenderInputRouterDelegateClientStubDispatch::Accept(
    RenderInputRouterDelegateClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderInputRouterDelegateClient>(message->header()->name)) {
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegateClient.0
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      bool p_dispatched_to_renderer{};
      RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success)
        p_dispatched_to_renderer = input_data_view.dispatched_to_renderer();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegateClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyObserversOfInputEvent(        
        std::move(p_event), 
        std::move(p_dispatched_to_renderer));
      return true;
    }
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegateClient.1
      bool success = true;
      ::blink::mojom::InputEventResultSource p_ack_source{};
      ::blink::mojom::InputEventResultState p_ack_result{};
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAckSource(&p_ack_source))
        success = false;
      if (success && !input_data_view.ReadAckResult(&p_ack_result))
        success = false;
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegateClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyObserversOfInputEventAcks(        
        std::move(p_ack_source), 
        std::move(p_ack_result), 
        std::move(p_event));
      return true;
    }
    case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegateClient.2
      bool success = true;
      RenderInputRouterDelegateClient_OnInvalidInputEventSource_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegateClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInvalidInputEventSource(        );
      return true;
    }
    case messages::RenderInputRouterDelegateClient::kStateOnOverscrollTransfer: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegateClient.3
      bool success = true;
      ::blink::mojom::DidOverscrollParamsPtr p_overscroll{};
      RenderInputRouterDelegateClient_StateOnOverscrollTransfer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOverscroll(&p_overscroll))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegateClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StateOnOverscrollTransfer(        
        std::move(p_overscroll));
      return true;
    }
    case messages::RenderInputRouterDelegateClient::kRendererInputResponsivenessChanged: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterDelegateClient.4
      bool success = true;
      bool p_is_responsive{};
      std::optional<::base::TimeTicks> p_ack_timeout_ts{};
      RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_responsive = input_data_view.is_responsive();
      if (success && !input_data_view.ReadAckTimeoutTs(&p_ack_timeout_ts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegateClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RendererInputResponsivenessChanged(        
        std::move(p_is_responsive), 
        std::move(p_ack_timeout_ts));
      return true;
    }
  }
  return false;
}

// static
bool RenderInputRouterDelegateClientStubDispatch::AcceptWithResponder(
    RenderInputRouterDelegateClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderInputRouterDelegateClient>(message->header()->name)) {
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent: {
      break;
    }
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks: {
      break;
    }
    case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource: {
      break;
    }
    case messages::RenderInputRouterDelegateClient::kStateOnOverscrollTransfer: {
      break;
    }
    case messages::RenderInputRouterDelegateClient::kRendererInputResponsivenessChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderInputRouterDelegateClientValidationInfo[] = {
    { &internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool RenderInputRouterDelegateClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::input::mojom::RenderInputRouterDelegateClient::Name_,
    kRenderInputRouterDelegateClientValidationInfo);
}



}  // input::mojom


namespace mojo {


// static
bool StructTraits<::input::mojom::RenderInputRouterConfig::DataView, ::input::mojom::RenderInputRouterConfigPtr>::Read(
    ::input::mojom::RenderInputRouterConfig::DataView input,
    ::input::mojom::RenderInputRouterConfigPtr* output) {
  bool success = true;
  ::input::mojom::RenderInputRouterConfigPtr result(::input::mojom::RenderInputRouterConfig::New());
  
      if (success) {
        result->rir_client =
            input.TakeRirClient<decltype(result->rir_client)>();
      }
      if (success && !input.ReadGroupingId(&result->grouping_id))
        success = false;
      if (success)
        result->force_enable_zoom = input.force_enable_zoom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::input::mojom::TouchTransferState::DataView, ::input::mojom::TouchTransferStatePtr>::Read(
    ::input::mojom::TouchTransferState::DataView input,
    ::input::mojom::TouchTransferStatePtr* output) {
  bool success = true;
  ::input::mojom::TouchTransferStatePtr result(::input::mojom::TouchTransferState::New());
  
      if (success && !input.ReadDownTimeMs(&result->down_time_ms))
        success = false;
      if (success && !input.ReadRootWidgetFrameSinkId(&result->root_widget_frame_sink_id))
        success = false;
      if (success)
        result->web_contents_y_offset_pix = input.web_contents_y_offset_pix();
      if (success)
        result->dip_scale = input.dip_scale();
      if (success)
        result->browser_would_have_handled = input.browser_would_have_handled();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace input::mojom {


void RenderInputRouterDelegateInterceptorForTesting::StateOnTouchTransfer(TouchTransferStatePtr state) {
  GetForwardingInterface()->StateOnTouchTransfer(
    std::move(state)
    );
}
void RenderInputRouterDelegateInterceptorForTesting::ForceEnableZoomStateChanged(bool force_enable_zoom, const ::viz::FrameSinkId& frame_sink_id) {
  GetForwardingInterface()->ForceEnableZoomStateChanged(
    std::move(force_enable_zoom)
    , 
    std::move(frame_sink_id)
    );
}
void RenderInputRouterDelegateInterceptorForTesting::StopFlingingOnViz(const ::viz::FrameSinkId& frame_sink_id) {
  GetForwardingInterface()->StopFlingingOnViz(
    std::move(frame_sink_id)
    );
}
void RenderInputRouterDelegateInterceptorForTesting::RestartInputEventAckTimeoutIfNecessary(const ::viz::FrameSinkId& frame_sink_id) {
  GetForwardingInterface()->RestartInputEventAckTimeoutIfNecessary(
    std::move(frame_sink_id)
    );
}
void RenderInputRouterDelegateInterceptorForTesting::NotifyVisibilityChanged(const ::viz::FrameSinkId& frame_sink_id, bool is_hidden) {
  GetForwardingInterface()->NotifyVisibilityChanged(
    std::move(frame_sink_id)
    , 
    std::move(is_hidden)
    );
}
void RenderInputRouterDelegateInterceptorForTesting::ResetGestureDetection(const ::viz::FrameSinkId& root_widget_frame_sink_id) {
  GetForwardingInterface()->ResetGestureDetection(
    std::move(root_widget_frame_sink_id)
    );
}
RenderInputRouterDelegateAsyncWaiter::RenderInputRouterDelegateAsyncWaiter(
    RenderInputRouterDelegate* proxy) : proxy_(proxy) {}

RenderInputRouterDelegateAsyncWaiter::~RenderInputRouterDelegateAsyncWaiter() = default;





void RenderInputRouterDelegateClientInterceptorForTesting::NotifyObserversOfInputEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool dispatched_to_renderer) {
  GetForwardingInterface()->NotifyObserversOfInputEvent(
    std::move(event)
    , 
    std::move(dispatched_to_renderer)
    );
}
void RenderInputRouterDelegateClientInterceptorForTesting::NotifyObserversOfInputEventAcks(::blink::mojom::InputEventResultSource ack_source, ::blink::mojom::InputEventResultState ack_result, ::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->NotifyObserversOfInputEventAcks(
    std::move(ack_source)
    , 
    std::move(ack_result)
    , 
    std::move(event)
    );
}
void RenderInputRouterDelegateClientInterceptorForTesting::OnInvalidInputEventSource() {
  GetForwardingInterface()->OnInvalidInputEventSource();
}
void RenderInputRouterDelegateClientInterceptorForTesting::StateOnOverscrollTransfer(::blink::mojom::DidOverscrollParamsPtr overscroll) {
  GetForwardingInterface()->StateOnOverscrollTransfer(
    std::move(overscroll)
    );
}
void RenderInputRouterDelegateClientInterceptorForTesting::RendererInputResponsivenessChanged(bool is_responsive, std::optional<::base::TimeTicks> ack_timeout_ts) {
  GetForwardingInterface()->RendererInputResponsivenessChanged(
    std::move(is_responsive)
    , 
    std::move(ack_timeout_ts)
    );
}
RenderInputRouterDelegateClientAsyncWaiter::RenderInputRouterDelegateClientAsyncWaiter(
    RenderInputRouterDelegateClient* proxy) : proxy_(proxy) {}

RenderInputRouterDelegateClientAsyncWaiter::~RenderInputRouterDelegateClientAsyncWaiter() = default;







}  // input::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif