// components/input/render_input_router.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/input/render_input_router.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/input/render_input_router.mojom-params-data.h"
namespace input {
namespace mojom {

namespace internal {


// static
bool RenderInputRouterConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterConfig_Data* object =
      static_cast<const RenderInputRouterConfig_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->rir_client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->rir_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->grouping_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->grouping_id, validation_context))
    return false;

  return true;
}

RenderInputRouterConfig_Data::RenderInputRouterConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TouchTransferState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TouchTransferState_Data* object =
      static_cast<const TouchTransferState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->down_time_ms, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->down_time_ms, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_widget_frame_sink_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_widget_frame_sink_id, validation_context))
    return false;

  return true;
}

TouchTransferState_Data::TouchTransferState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data* object =
      static_cast<const RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data* object =
      static_cast<const RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegate_StopFlingingOnViz_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegate_StopFlingingOnViz_Params_Data* object =
      static_cast<const RenderInputRouterDelegate_StopFlingingOnViz_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegate_StopFlingingOnViz_Params_Data::RenderInputRouterDelegate_StopFlingingOnViz_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data* object =
      static_cast<const RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data::RenderInputRouterDelegate_RestartInputEventAckTimeoutIfNecessary_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data* object =
      static_cast<const RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data::RenderInputRouterDelegate_NotifyVisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegate_ResetGestureDetection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegate_ResetGestureDetection_Params_Data* object =
      static_cast<const RenderInputRouterDelegate_ResetGestureDetection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_widget_frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_widget_frame_sink_id, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegate_ResetGestureDetection_Params_Data::RenderInputRouterDelegate_ResetGestureDetection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data* object =
      static_cast<const RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data* object =
      static_cast<const RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data*>(data);


  if (!::blink::mojom::internal::InputEventResultSource_Data
        ::Validate(object->ack_source, validation_context))
    return false;


  if (!::blink::mojom::internal::InputEventResultState_Data
        ::Validate(object->ack_result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data* object =
      static_cast<const RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data*>(data);

  return true;
}

RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data* object =
      static_cast<const RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->overscroll, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data::RenderInputRouterDelegateClient_StateOnOverscrollTransfer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data* object =
      static_cast<const RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->ack_timeout_ts, validation_context))
    return false;

  return true;
}

RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data::RenderInputRouterDelegateClient_RendererInputResponsivenessChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace input