// components/feed/mojom/rss_link_reader.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/feed/mojom/rss_link_reader.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/feed/mojom/rss_link_reader.mojom-params-data.h"
#include "components/feed/mojom/rss_link_reader.mojom-shared-message-ids.h"

#include "components/feed/mojom/rss_link_reader.mojom-import-headers.h"
#include "components/feed/mojom/rss_link_reader.mojom-test-utils.h"


namespace feed::mojom {
RssLinks::RssLinks()
    : page_url(),
      links() {}

RssLinks::RssLinks(
    const ::GURL& page_url_in,
    std::vector<::GURL> links_in)
    : page_url(std::move(page_url_in)),
      links(std::move(links_in)) {}

RssLinks::~RssLinks() = default;

void RssLinks::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_url"), this->page_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "links"), this->links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RssLinks::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

RssLinkReader::IPCStableHashFunction RssLinkReader::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RssLinkReader>(message.name())) {
    case messages::RssLinkReader::kGetRssLinks: {
      return &RssLinkReader::GetRssLinks_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RssLinkReader::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RssLinkReader>(message.name())) {
      case messages::RssLinkReader::kGetRssLinks:
            return "Receive feed::mojom::RssLinkReader::GetRssLinks";
    }
  } else {
    switch (static_cast<messages::RssLinkReader>(message.name())) {
      case messages::RssLinkReader::kGetRssLinks:
            return "Receive reply feed::mojom::RssLinkReader::GetRssLinks";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RssLinkReader::GetRssLinks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x724552c5;  // IPCStableHash for feed::mojom::RssLinkReader::GetRssLinks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RssLinkReader_GetRssLinks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RssLinkReader_GetRssLinks_ForwardToCallback(
      RssLinkReader::GetRssLinksCallback callback
      ) : callback_(std::move(callback)) {
  }

  RssLinkReader_GetRssLinks_ForwardToCallback(const RssLinkReader_GetRssLinks_ForwardToCallback&) = delete;
  RssLinkReader_GetRssLinks_ForwardToCallback& operator=(const RssLinkReader_GetRssLinks_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RssLinkReader::GetRssLinksCallback callback_;
};

RssLinkReaderProxy::RssLinkReaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RssLinkReaderProxy::GetRssLinks(
    GetRssLinksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send feed::mojom::RssLinkReader::GetRssLinks");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RssLinkReader::kGetRssLinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::feed::mojom::internal::RssLinkReader_GetRssLinks_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RssLinkReader::Name_);
  message.set_method_name("GetRssLinks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RssLinkReader_GetRssLinks_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class RssLinkReader_GetRssLinks_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RssLinkReader::GetRssLinksCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RssLinkReader_GetRssLinks_ProxyToResponder> proxy(
        new RssLinkReader_GetRssLinks_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RssLinkReader_GetRssLinks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RssLinkReader_GetRssLinks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RssLinkReader_GetRssLinks_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RssLinkReader::GetRssLinksCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RssLinksPtr in_rss_links);
};

bool RssLinkReader_GetRssLinks_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RssLinkReader_GetRssLinks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RssLinkReader_GetRssLinks_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RssLinkReader.0
  bool success = true;
  RssLinksPtr p_rss_links{};
  RssLinkReader_GetRssLinks_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRssLinks(&p_rss_links))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RssLinkReader::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_rss_links));
  }
  return true;
}

void RssLinkReader_GetRssLinks_ProxyToResponder::Run(
    RssLinksPtr in_rss_links) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply feed::mojom::RssLinkReader::GetRssLinks", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rss_links"), in_rss_links,
                        "<value of type RssLinksPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RssLinkReader::kGetRssLinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::feed::mojom::internal::RssLinkReader_GetRssLinks_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rss_links)::BaseType> rss_links_fragment(
          params.message());
  
  mojo::internal::Serialize<::feed::mojom::RssLinksDataView>(
    in_rss_links,
    rss_links_fragment);

  params->rss_links.Set(
      rss_links_fragment.is_null() ? nullptr : rss_links_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rss_links.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rss_links in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RssLinkReader::Name_);
  message.set_method_name("GetRssLinks");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RssLinkReaderStubDispatch::Accept(
    RssLinkReader* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RssLinkReader>(message->header()->name)) {
    case messages::RssLinkReader::kGetRssLinks: {
      break;
    }
  }
  return false;
}

// static
bool RssLinkReaderStubDispatch::AcceptWithResponder(
    RssLinkReader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RssLinkReader>(message->header()->name)) {
    case messages::RssLinkReader::kGetRssLinks: {
      internal::RssLinkReader_GetRssLinks_Params_Data* params =
          reinterpret_cast<
              internal::RssLinkReader_GetRssLinks_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RssLinkReader.0
      bool success = true;
      RssLinkReader_GetRssLinks_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RssLinkReader::Name_, 0, false);
        return false;
      }
      auto callback =
          RssLinkReader_GetRssLinks_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRssLinks(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRssLinkReaderValidationInfo[] = {
    { &internal::RssLinkReader_GetRssLinks_Params_Data::Validate,
     &internal::RssLinkReader_GetRssLinks_ResponseParams_Data::Validate},
};

bool RssLinkReaderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::feed::mojom::RssLinkReader::Name_,
    kRssLinkReaderValidationInfo);
}

bool RssLinkReaderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::feed::mojom::RssLinkReader::Name_,
    kRssLinkReaderValidationInfo);
}


}  // feed::mojom


namespace mojo {


// static
bool StructTraits<::feed::mojom::RssLinks::DataView, ::feed::mojom::RssLinksPtr>::Read(
    ::feed::mojom::RssLinks::DataView input,
    ::feed::mojom::RssLinksPtr* output) {
  bool success = true;
  ::feed::mojom::RssLinksPtr result(::feed::mojom::RssLinks::New());
  
      if (success && !input.ReadPageUrl(&result->page_url))
        success = false;
      if (success && !input.ReadLinks(&result->links))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace feed::mojom {


void RssLinkReaderInterceptorForTesting::GetRssLinks(GetRssLinksCallback callback) {
  GetForwardingInterface()->GetRssLinks(std::move(callback));
}
RssLinkReaderAsyncWaiter::RssLinkReaderAsyncWaiter(
    RssLinkReader* proxy) : proxy_(proxy) {}

RssLinkReaderAsyncWaiter::~RssLinkReaderAsyncWaiter() = default;


void RssLinkReaderAsyncWaiter::GetRssLinks(
    RssLinksPtr* out_rss_links) {
  base::RunLoop loop;
  proxy_->GetRssLinks(
      base::BindOnce(
          [](base::RunLoop* loop,
             RssLinksPtr* out_rss_links
,
             RssLinksPtr rss_links) {*out_rss_links = std::move(rss_links);
            loop->Quit();
          },
          &loop,
          out_rss_links));
  loop.Run();
}

RssLinksPtr RssLinkReaderAsyncWaiter::GetRssLinks(
    ) {
  RssLinksPtr async_wait_result;
  GetRssLinks(&async_wait_result);
  return async_wait_result;
}






}  // feed::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif