// components/device_signals/core/common/mojom/system_signals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/device_signals/core/common/mojom/system_signals.mojom-shared-internal.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"


namespace device_signals::mojom {
class ExecutableMetadataDataView;

class FileSystemItemDataView;

class FileSystemItemRequestDataView;



}  // device_signals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device_signals::mojom::ExecutableMetadataDataView> {
  using Data = ::device_signals::mojom::internal::ExecutableMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_signals::mojom::FileSystemItemDataView> {
  using Data = ::device_signals::mojom::internal::FileSystemItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_signals::mojom::FileSystemItemRequestDataView> {
  using Data = ::device_signals::mojom::internal::FileSystemItemRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device_signals::mojom {


enum class PresenceValue : int32_t {
  
  kUnspecified = 0,
  
  kAccessDenied = 1,
  
  kNotFound = 2,
  
  kFound = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PresenceValue value);
inline bool IsKnownEnumValue(PresenceValue value) {
  return internal::PresenceValue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SystemSignalsServiceInterfaceBase {};

using SystemSignalsServicePtrDataView =
    mojo::InterfacePtrDataView<SystemSignalsServiceInterfaceBase>;
using SystemSignalsServiceRequestDataView =
    mojo::InterfaceRequestDataView<SystemSignalsServiceInterfaceBase>;
using SystemSignalsServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SystemSignalsServiceInterfaceBase>;
using SystemSignalsServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SystemSignalsServiceInterfaceBase>;


class ExecutableMetadataDataView {
 public:
  ExecutableMetadataDataView() = default;

  ExecutableMetadataDataView(
      internal::ExecutableMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_running() const {
    return data_->is_running;
  }
  inline void GetPublicKeysHashesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKeysHashes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>, UserType>(),
    "Attempting to read the optional `public_keys_hashes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPublicKeysHashes` instead "
    "of `ReadPublicKeysHashes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->public_keys_hashes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
        pointer, output, message_);
  }
  inline void GetProductNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProductName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `product_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProductName` instead "
    "of `ReadProductName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->product_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `version` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersion` instead "
    "of `ReadVersion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_os_verified() const {
    return data_->is_os_verified;
  }
  inline void GetSubjectNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubjectName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `subject_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubjectName` instead "
    "of `ReadSubjectName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subject_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ExecutableMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemItemDataView {
 public:
  FileSystemItemDataView() = default;

  FileSystemItemDataView(
      internal::FileSystemItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPresence(UserType* output) const {
    auto data_value = data_->presence;
    return mojo::internal::Deserialize<::device_signals::mojom::PresenceValue>(
        data_value, output);
  }
  PresenceValue presence() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device_signals::mojom::PresenceValue>(data_->presence));
  }
  inline void GetSha256HashDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSha256Hash(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ByteStringDataView, UserType>(),
    "Attempting to read the optional `sha256_hash` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSha256Hash` instead "
    "of `ReadSha256Hash if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sha256_hash.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetExecutableMetadataDataView(
      ExecutableMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExecutableMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device_signals::mojom::ExecutableMetadataDataView, UserType>(),
    "Attempting to read the optional `executable_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExecutableMetadata` instead "
    "of `ReadExecutableMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->executable_metadata.Get();
    return mojo::internal::Deserialize<::device_signals::mojom::ExecutableMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemItemRequestDataView {
 public:
  FileSystemItemRequestDataView() = default;

  FileSystemItemRequestDataView(
      internal::FileSystemItemRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  bool compute_sha256() const {
    return data_->compute_sha256;
  }
  bool compute_executable_metadata() const {
    return data_->compute_executable_metadata;
  }
 private:
  internal::FileSystemItemRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device_signals::mojom

#endif  // COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_DATA_VIEW_H_