// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/js/action_link.js";import"/strings.m.js";import{assert}from"chrome://resources/js/assert.js";import{addWebUiListener}from"chrome://resources/js/cr.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{appendParam,getRequiredElement}from"chrome://resources/js/util.js";let refreshCrashListId=undefined;function requestCrashes(){chrome.send("requestCrashList")}function formatBytes(bytes){const k=1024;const units=["B","KB","MB","GB","TB","PB"];let unitAmount=bytes;let unit=0;for(unit;unitAmount>=k&&unit<units.length-1;unit++){unitAmount/=k}const unitAmountLocalized=unitAmount.toLocaleString(undefined,{maximumFractionDigits:2});return`${unitAmountLocalized} ${units[unit]}`}var State;(function(State){State["NOT_UPLOADED"]="not_uploaded";State["PENDING"]="pending";State["PENDING_USER_REQUESTED"]="pending_user_requested";State["UPLOADED"]="uploaded"})(State||(State={}));function updateCrashList({enabled:enabled,dynamicBackend:dynamicBackend,manualUploads:manualUploads,crashes:crashes,version:version,os:os,isGoogleAccount:isGoogleAccount}){getRequiredElement("crashesCount").textContent=loadTimeData.getStringF("crashCountFormat",crashes.length.toLocaleString());const crashList=getRequiredElement("crashList");getRequiredElement("disabledMode").hidden=enabled;getRequiredElement("crashUploadStatus").hidden=!enabled||!dynamicBackend;const template=crashList.querySelector("template");assert(template);crashList.querySelectorAll(".crash-row").forEach((elm=>elm.remove()));const productName=loadTimeData.getString("shortProductName");for(const crash of crashes){if(crash.local_id===""){crash.local_id=productName}const clone=template.content.cloneNode(true);if(crash.state!==State.UPLOADED){const crashRow=clone.querySelector(".crash-row");assert(crashRow);crashRow.classList.add("not-uploaded")}const uploaded=crash.state===State.UPLOADED;const captureTime=clone.querySelector(".capture-time");assert(captureTime);captureTime.textContent=loadTimeData.getStringF("crashCaptureTimeFormat",crash.capture_time||crash.upload_time||"");const localIdCell=clone.querySelector(".local-id .value");assert(localIdCell);localIdCell.textContent=crash.local_id;let stateText="";switch(crash.state){case State.NOT_UPLOADED:stateText=loadTimeData.getString("crashStatusNotUploaded");break;case State.PENDING:stateText=loadTimeData.getString("crashStatusPending");break;case State.PENDING_USER_REQUESTED:stateText=loadTimeData.getString("crashStatusPendingUserRequested");break;case State.UPLOADED:stateText=loadTimeData.getString("crashStatusUploaded");break;default:continue}const statusCell=clone.querySelector(".status .value");assert(statusCell);statusCell.textContent=stateText;const uploadId=clone.querySelector(".upload-id");assert(uploadId);const uploadTime=clone.querySelector(".upload-time");assert(uploadTime);const sendNowButton=clone.querySelector(".send-now");assert(sendNowButton);const fileBugButton=clone.querySelector(".file-bug");assert(fileBugButton);if(uploaded){const uploadIdValue=uploadId.querySelector(".value");assert(uploadIdValue);if(isGoogleAccount){const crashLink=document.createElement("a");crashLink.href=`https://goto.google.com/crash/${crash.id}`;crashLink.target="_blank";crashLink.textContent=crash.id;uploadIdValue.appendChild(crashLink)}else{uploadIdValue.textContent=crash.id}const uploadTimeCell=uploadTime.querySelector(".value");assert(uploadTimeCell);uploadTimeCell.textContent=crash.upload_time||"";sendNowButton.remove();fileBugButton.onclick=()=>fileBug(crash.id,os,version)}else{uploadId.remove();uploadTime.remove();fileBugButton.remove();if(!manualUploads||crash.state===State.PENDING_USER_REQUESTED){sendNowButton.remove()}sendNowButton.onclick=_e=>{sendNowButton.disabled=true;chrome.send("requestSingleCrashUpload",[crash.local_id])}}const fileSize=clone.querySelector(".file-size");assert(fileSize);if(crash.file_size===undefined){fileSize.remove()}else{const fileSizeCell=fileSize.querySelector(".value");assert(fileSizeCell);fileSizeCell.textContent=formatBytes(crash.file_size)}crashList.appendChild(clone)}getRequiredElement("noCrashes").hidden=crashes.length!==0}function fileBug(crashId,os,version){const commentLines=["IMPORTANT: Your crash has already been automatically reported "+"to our crash system. Please file this bug only if you can provide "+"more information about it.","","","Chrome Version: "+version,"Operating System: "+os,"","URL (if applicable) where crash occurred:","","Can you reproduce this crash?","","What steps will reproduce this crash? (If it's not "+"reproducible, what were you doing just before the crash?)","1.","2.","3.","","****DO NOT CHANGE BELOW THIS LINE****","Crash ID: crash/"+crashId];const params={template:"Crash Report",comment:commentLines.join("\n"),labels:"Restrict-View-EditIssue,Stability-Crash,User-Submitted,Pri-3,Type-Bug"};let href="https://bugs.chromium.org/p/chromium/issues/entry";for(const param in params){href=appendParam(href,param,params[param])}window.open(href)}function requestCrashUpload(){chrome.send("requestCrashUpload");clearTimeout(refreshCrashListId);refreshCrashListId=setTimeout(requestCrashes,5e3)}function toggleDevDetails(e){getRequiredElement("crashList").classList.toggle("showing-dev-details",e.target.checked)}document.addEventListener("DOMContentLoaded",(function(){addWebUiListener("update-crash-list",updateCrashList);getRequiredElement("uploadCrashes").onclick=requestCrashUpload;getRequiredElement("showDevDetails").onclick=toggleDevDetails;requestCrashes()}));