// components/content_settings/core/common/content_settings.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SEND_VALIDATION_H_

#include "components/content_settings/core/common/content_settings.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings_enums.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"

#include "components/content_settings/core/common/content_settings.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::content_settings::mojom::ContentSetting, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content_settings::mojom::PatternPartsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::PatternPartsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::PatternParts_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scheme)::BaseType> scheme_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_scheme,
        scheme_fragment);

      fragment->scheme.Set(
          scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scheme.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in PatternParts struct");

      fragment->is_scheme_wildcard = Traits::is_scheme_wildcard(input);

      decltype(Traits::host(input)) in_host = Traits::host(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host)::BaseType> host_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_host,
        host_fragment);

      fragment->host.Set(
          host_fragment.is_null() ? nullptr : host_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host in PatternParts struct");

      fragment->has_domain_wildcard = Traits::has_domain_wildcard(input);

      decltype(Traits::port(input)) in_port = Traits::port(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->port)::BaseType> port_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_port,
        port_fragment);

      fragment->port.Set(
          port_fragment.is_null() ? nullptr : port_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->port.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null port in PatternParts struct");

      fragment->is_port_wildcard = Traits::is_port_wildcard(input);

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in PatternParts struct");

      fragment->is_path_wildcard = Traits::is_path_wildcard(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content_settings::mojom::ContentSettingsPatternDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::ContentSettingsPatternDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::ContentSettingsPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::parts(input)) in_parts = Traits::parts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parts)::BaseType> parts_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content_settings::mojom::PatternPartsDataView, send_validation>(
        in_parts,
        parts_fragment);

      fragment->parts.Set(
          parts_fragment.is_null() ? nullptr : parts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->parts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parts in ContentSettingsPattern struct");

      fragment->is_valid = Traits::is_valid(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content_settings::mojom::RuleMetaDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::RuleMetaDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::RuleMetaData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_modified,
        last_modified_fragment);

      fragment->last_modified.Set(
          last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_modified.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified in RuleMetaData struct");

      decltype(Traits::last_used(input)) in_last_used = Traits::last_used(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_used)::BaseType> last_used_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_used,
        last_used_fragment);

      fragment->last_used.Set(
          last_used_fragment.is_null() ? nullptr : last_used_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_used.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_used in RuleMetaData struct");

      decltype(Traits::last_visited(input)) in_last_visited = Traits::last_visited(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_visited)::BaseType> last_visited_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_visited,
        last_visited_fragment);

      fragment->last_visited.Set(
          last_visited_fragment.is_null() ? nullptr : last_visited_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_visited.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_visited in RuleMetaData struct");

      decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expiration)::BaseType> expiration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_expiration,
        expiration_fragment);

      fragment->expiration.Set(
          expiration_fragment.is_null() ? nullptr : expiration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->expiration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiration in RuleMetaData struct");

      
      mojo::internal::Serialize<::content_settings::mojom::SessionModel>(
        Traits::session_model(input),
        &fragment->session_model);

      decltype(Traits::lifetime(input)) in_lifetime = Traits::lifetime(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lifetime)::BaseType> lifetime_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_lifetime,
        lifetime_fragment);

      fragment->lifetime.Set(
          lifetime_fragment.is_null() ? nullptr : lifetime_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lifetime.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lifetime in RuleMetaData struct");

      
      mojo::internal::Serialize<::content_settings::mojom::TpcdMetadataRuleSource>(
        Traits::tpcd_metadata_rule_source(input),
        &fragment->tpcd_metadata_rule_source);

      
      mojo::internal::Serialize<::content_settings::mojom::TpcdMetadataCohort>(
        Traits::tpcd_metadata_cohort(input),
        &fragment->tpcd_metadata_cohort);

      fragment->decided_by_related_website_sets = Traits::decided_by_related_website_sets(input);

      decltype(Traits::rule_options(input)) in_rule_options = Traits::rule_options(input);
      mojo::internal::MessageFragment<decltype(fragment->rule_options)>
          rule_options_fragment(fragment.message());
      rule_options_fragment.Claim(&fragment->rule_options);
      
      mojo::internal::Serialize<::mojo_base::mojom::ValueDataView, send_validation>(
        in_rule_options,
        rule_options_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rule_options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rule_options in RuleMetaData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content_settings::mojom::ContentSettingPatternSourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::ContentSettingPatternSourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::ContentSettingPatternSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::primary_pattern(input)) in_primary_pattern = Traits::primary_pattern(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->primary_pattern)::BaseType> primary_pattern_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content_settings::mojom::ContentSettingsPatternDataView, send_validation>(
        in_primary_pattern,
        primary_pattern_fragment);

      fragment->primary_pattern.Set(
          primary_pattern_fragment.is_null() ? nullptr : primary_pattern_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->primary_pattern.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_pattern in ContentSettingPatternSource struct");

      decltype(Traits::secondary_pattern(input)) in_secondary_pattern = Traits::secondary_pattern(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->secondary_pattern)::BaseType> secondary_pattern_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content_settings::mojom::ContentSettingsPatternDataView, send_validation>(
        in_secondary_pattern,
        secondary_pattern_fragment);

      fragment->secondary_pattern.Set(
          secondary_pattern_fragment.is_null() ? nullptr : secondary_pattern_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->secondary_pattern.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null secondary_pattern in ContentSettingPatternSource struct");

      decltype(Traits::setting_value(input)) in_setting_value = Traits::setting_value(input);
      mojo::internal::MessageFragment<decltype(fragment->setting_value)>
          setting_value_fragment(fragment.message());
      setting_value_fragment.Claim(&fragment->setting_value);
      
      mojo::internal::Serialize<::mojo_base::mojom::ValueDataView, send_validation>(
        in_setting_value,
        setting_value_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->setting_value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null setting_value in ContentSettingPatternSource struct");

      decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metadata)::BaseType> metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content_settings::mojom::RuleMetaDataDataView, send_validation>(
        in_metadata,
        metadata_fragment);

      fragment->metadata.Set(
          metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->metadata.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in ContentSettingPatternSource struct");

      
      mojo::internal::Serialize<::content_settings::mojom::ProviderType>(
        Traits::source(input),
        &fragment->source);

      fragment->incognito = Traits::incognito(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content_settings::mojom::RendererContentSettingRulesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::RendererContentSettingRulesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::RendererContentSettingRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mixed_content_rules(input)) in_mixed_content_rules = Traits::mixed_content_rules(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mixed_content_rules)::BaseType>
          mixed_content_rules_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& mixed_content_rules_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>, send_validation>(
        in_mixed_content_rules,
        mixed_content_rules_fragment,
        &mixed_content_rules_validate_params);

      fragment->mixed_content_rules.Set(
          mixed_content_rules_fragment.is_null() ? nullptr : mixed_content_rules_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mixed_content_rules.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mixed_content_rules in RendererContentSettingRules struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SEND_VALIDATION_H_