// components/content_settings/core/common/content_settings.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/content_settings/core/common/content_settings.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings_enums.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"


namespace content_settings::mojom {
class PatternPartsDataView;

class ContentSettingsPatternDataView;

class RuleMetaDataDataView;

class ContentSettingPatternSourceDataView;

class RendererContentSettingRulesDataView;



}  // content_settings::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content_settings::mojom::PatternPartsDataView> {
  using Data = ::content_settings::mojom::internal::PatternParts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content_settings::mojom::ContentSettingsPatternDataView> {
  using Data = ::content_settings::mojom::internal::ContentSettingsPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content_settings::mojom::RuleMetaDataDataView> {
  using Data = ::content_settings::mojom::internal::RuleMetaData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content_settings::mojom::ContentSettingPatternSourceDataView> {
  using Data = ::content_settings::mojom::internal::ContentSettingPatternSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content_settings::mojom::RendererContentSettingRulesDataView> {
  using Data = ::content_settings::mojom::internal::RendererContentSettingRules_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content_settings::mojom {


enum class ContentSetting : int32_t {
  
  DEFAULT = 0,
  
  ALLOW = 1,
  
  BLOCK = 2,
  
  ASK = 3,
  
  SESSION_ONLY = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ContentSetting value);
inline bool IsKnownEnumValue(ContentSetting value) {
  return internal::ContentSetting_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PatternPartsDataView {
 public:
  PatternPartsDataView() = default;

  PatternPartsDataView(
      internal::PatternParts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_scheme_wildcard() const {
    return data_->is_scheme_wildcard;
  }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_domain_wildcard() const {
    return data_->has_domain_wildcard;
  }
  inline void GetPortDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPort(UserType* output) {
    
    auto* pointer = data_->port.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_port_wildcard() const {
    return data_->is_port_wildcard;
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_path_wildcard() const {
    return data_->is_path_wildcard;
  }
 private:
  internal::PatternParts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentSettingsPatternDataView {
 public:
  ContentSettingsPatternDataView() = default;

  ContentSettingsPatternDataView(
      internal::ContentSettingsPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPartsDataView(
      PatternPartsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParts(UserType* output) {
    
    auto* pointer = data_->parts.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::PatternPartsDataView>(
        pointer, output, message_);
  }
  bool is_valid() const {
    return data_->is_valid;
  }
 private:
  internal::ContentSettingsPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RuleMetaDataDataView {
 public:
  RuleMetaDataDataView() = default;

  RuleMetaDataDataView(
      internal::RuleMetaData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastModified(UserType* output) {
    
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastUsedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUsed(UserType* output) {
    
    auto* pointer = data_->last_used.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastVisitedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastVisited(UserType* output) {
    
    auto* pointer = data_->last_visited.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSessionModel(UserType* output) const {
    auto data_value = data_->session_model;
    return mojo::internal::Deserialize<::content_settings::mojom::SessionModel>(
        data_value, output);
  }
  ::content_settings::mojom::SessionModel session_model() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::SessionModel>(data_->session_model));
  }
  inline void GetLifetimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLifetime(UserType* output) {
    
    auto* pointer = data_->lifetime.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTpcdMetadataRuleSource(UserType* output) const {
    auto data_value = data_->tpcd_metadata_rule_source;
    return mojo::internal::Deserialize<::content_settings::mojom::TpcdMetadataRuleSource>(
        data_value, output);
  }
  ::content_settings::mojom::TpcdMetadataRuleSource tpcd_metadata_rule_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::TpcdMetadataRuleSource>(data_->tpcd_metadata_rule_source));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTpcdMetadataCohort(UserType* output) const {
    auto data_value = data_->tpcd_metadata_cohort;
    return mojo::internal::Deserialize<::content_settings::mojom::TpcdMetadataCohort>(
        data_value, output);
  }
  ::content_settings::mojom::TpcdMetadataCohort tpcd_metadata_cohort() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::TpcdMetadataCohort>(data_->tpcd_metadata_cohort));
  }
  bool decided_by_related_website_sets() const {
    return data_->decided_by_related_website_sets;
  }
  inline void GetRuleOptionsDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRuleOptions(UserType* output) {
    
    auto* pointer = !data_->rule_options.is_null() ? &data_->rule_options : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::RuleMetaData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentSettingPatternSourceDataView {
 public:
  ContentSettingPatternSourceDataView() = default;

  ContentSettingPatternSourceDataView(
      internal::ContentSettingPatternSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrimaryPatternDataView(
      ContentSettingsPatternDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryPattern(UserType* output) {
    
    auto* pointer = data_->primary_pattern.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::ContentSettingsPatternDataView>(
        pointer, output, message_);
  }
  inline void GetSecondaryPatternDataView(
      ContentSettingsPatternDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecondaryPattern(UserType* output) {
    
    auto* pointer = data_->secondary_pattern.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::ContentSettingsPatternDataView>(
        pointer, output, message_);
  }
  inline void GetSettingValueDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSettingValue(UserType* output) {
    
    auto* pointer = !data_->setting_value.is_null() ? &data_->setting_value : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      RuleMetaDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::RuleMetaDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::content_settings::mojom::ProviderType>(
        data_value, output);
  }
  ::content_settings::mojom::ProviderType source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::ProviderType>(data_->source));
  }
  bool incognito() const {
    return data_->incognito;
  }
 private:
  internal::ContentSettingPatternSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererContentSettingRulesDataView {
 public:
  RendererContentSettingRulesDataView() = default;

  RendererContentSettingRulesDataView(
      internal::RendererContentSettingRules_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMixedContentRulesDataView(
      mojo::ArrayDataView<ContentSettingPatternSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMixedContentRules(UserType* output) {
    
    auto* pointer = data_->mixed_content_rules.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RendererContentSettingRules_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // content_settings::mojom

#endif  // COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_DATA_VIEW_H_