// components/content_capture/common/content_capture.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/content_capture/common/content_capture.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/content_capture/common/content_capture.mojom-params-data.h"
#include "components/content_capture/common/content_capture.mojom-shared-message-ids.h"

#include "components/content_capture/common/content_capture.mojom-import-headers.h"
#include "components/content_capture/common/content_capture.mojom-test-utils.h"


namespace content_capture::mojom {
// The declaration includes the definition on other builds.

ContentCaptureReceiver::IPCStableHashFunction ContentCaptureReceiver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContentCaptureReceiver>(message.name())) {
    case messages::ContentCaptureReceiver::kDidCompleteBatchCaptureContent: {
      return &ContentCaptureReceiver::DidCompleteBatchCaptureContent_Sym::IPCStableHash;
    }
    case messages::ContentCaptureReceiver::kDidCaptureContent: {
      return &ContentCaptureReceiver::DidCaptureContent_Sym::IPCStableHash;
    }
    case messages::ContentCaptureReceiver::kDidUpdateContent: {
      return &ContentCaptureReceiver::DidUpdateContent_Sym::IPCStableHash;
    }
    case messages::ContentCaptureReceiver::kDidRemoveContent: {
      return &ContentCaptureReceiver::DidRemoveContent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContentCaptureReceiver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContentCaptureReceiver>(message.name())) {
      case messages::ContentCaptureReceiver::kDidCompleteBatchCaptureContent:
            return "Receive content_capture::mojom::ContentCaptureReceiver::DidCompleteBatchCaptureContent";
      case messages::ContentCaptureReceiver::kDidCaptureContent:
            return "Receive content_capture::mojom::ContentCaptureReceiver::DidCaptureContent";
      case messages::ContentCaptureReceiver::kDidUpdateContent:
            return "Receive content_capture::mojom::ContentCaptureReceiver::DidUpdateContent";
      case messages::ContentCaptureReceiver::kDidRemoveContent:
            return "Receive content_capture::mojom::ContentCaptureReceiver::DidRemoveContent";
    }
  } else {
    switch (static_cast<messages::ContentCaptureReceiver>(message.name())) {
      case messages::ContentCaptureReceiver::kDidCompleteBatchCaptureContent:
            return "Receive reply content_capture::mojom::ContentCaptureReceiver::DidCompleteBatchCaptureContent";
      case messages::ContentCaptureReceiver::kDidCaptureContent:
            return "Receive reply content_capture::mojom::ContentCaptureReceiver::DidCaptureContent";
      case messages::ContentCaptureReceiver::kDidUpdateContent:
            return "Receive reply content_capture::mojom::ContentCaptureReceiver::DidUpdateContent";
      case messages::ContentCaptureReceiver::kDidRemoveContent:
            return "Receive reply content_capture::mojom::ContentCaptureReceiver::DidRemoveContent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContentCaptureReceiver::DidCompleteBatchCaptureContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13839c74;  // IPCStableHash for content_capture::mojom::ContentCaptureReceiver::DidCompleteBatchCaptureContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentCaptureReceiver::DidCaptureContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff1dc6e6;  // IPCStableHash for content_capture::mojom::ContentCaptureReceiver::DidCaptureContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentCaptureReceiver::DidUpdateContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7c948e5;  // IPCStableHash for content_capture::mojom::ContentCaptureReceiver::DidUpdateContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentCaptureReceiver::DidRemoveContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0d006ad7;  // IPCStableHash for content_capture::mojom::ContentCaptureReceiver::DidRemoveContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ContentCaptureReceiverProxy::ContentCaptureReceiverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentCaptureReceiverProxy::DidCompleteBatchCaptureContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content_capture::mojom::ContentCaptureReceiver::DidCompleteBatchCaptureContent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentCaptureReceiver::kDidCompleteBatchCaptureContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_capture::mojom::internal::ContentCaptureReceiver_DidCompleteBatchCaptureContent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentCaptureReceiver::Name_);
  message.set_method_name("DidCompleteBatchCaptureContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContentCaptureReceiverProxy::DidCaptureContent(
    const ::content_capture::ContentCaptureData& in_data, bool in_first_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content_capture::mojom::ContentCaptureReceiver::DidCaptureContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const ::content_capture::ContentCaptureData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("first_data"), in_first_data,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentCaptureReceiver::kDidCaptureContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_capture::mojom::internal::ContentCaptureReceiver_DidCaptureContent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::content_capture::mojom::ContentCaptureDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ContentCaptureReceiver.DidCaptureContent request");

  params->first_data = in_first_data;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentCaptureReceiver::Name_);
  message.set_method_name("DidCaptureContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContentCaptureReceiverProxy::DidUpdateContent(
    const ::content_capture::ContentCaptureData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content_capture::mojom::ContentCaptureReceiver::DidUpdateContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const ::content_capture::ContentCaptureData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentCaptureReceiver::kDidUpdateContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_capture::mojom::internal::ContentCaptureReceiver_DidUpdateContent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::content_capture::mojom::ContentCaptureDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ContentCaptureReceiver.DidUpdateContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentCaptureReceiver::Name_);
  message.set_method_name("DidUpdateContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContentCaptureReceiverProxy::DidRemoveContent(
    const std::vector<int64_t>& in_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content_capture::mojom::ContentCaptureReceiver::DidRemoveContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ids"), in_ids,
                        "<value of type const std::vector<int64_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentCaptureReceiver::kDidRemoveContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_capture::mojom::internal::ContentCaptureReceiver_DidRemoveContent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ids)::BaseType>
      ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_ids,
    ids_fragment,
    &ids_validate_params);

  params->ids.Set(
      ids_fragment.is_null() ? nullptr : ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ids in ContentCaptureReceiver.DidRemoveContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentCaptureReceiver::Name_);
  message.set_method_name("DidRemoveContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ContentCaptureReceiverStubDispatch::Accept(
    ContentCaptureReceiver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContentCaptureReceiver>(message->header()->name)) {
    case messages::ContentCaptureReceiver::kDidCompleteBatchCaptureContent: {
      DCHECK(message->is_serialized());
      internal::ContentCaptureReceiver_DidCompleteBatchCaptureContent_Params_Data* params =
          reinterpret_cast<internal::ContentCaptureReceiver_DidCompleteBatchCaptureContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentCaptureReceiver.0
      bool success = true;
      ContentCaptureReceiver_DidCompleteBatchCaptureContent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentCaptureReceiver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCompleteBatchCaptureContent(        );
      return true;
    }
    case messages::ContentCaptureReceiver::kDidCaptureContent: {
      DCHECK(message->is_serialized());
      internal::ContentCaptureReceiver_DidCaptureContent_Params_Data* params =
          reinterpret_cast<internal::ContentCaptureReceiver_DidCaptureContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentCaptureReceiver.1
      bool success = true;
      ::content_capture::ContentCaptureData p_data{};
      bool p_first_data{};
      ContentCaptureReceiver_DidCaptureContent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success)
        p_first_data = input_data_view.first_data();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentCaptureReceiver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCaptureContent(        
        std::move(p_data), 
        std::move(p_first_data));
      return true;
    }
    case messages::ContentCaptureReceiver::kDidUpdateContent: {
      DCHECK(message->is_serialized());
      internal::ContentCaptureReceiver_DidUpdateContent_Params_Data* params =
          reinterpret_cast<internal::ContentCaptureReceiver_DidUpdateContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentCaptureReceiver.2
      bool success = true;
      ::content_capture::ContentCaptureData p_data{};
      ContentCaptureReceiver_DidUpdateContent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentCaptureReceiver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateContent(        
        std::move(p_data));
      return true;
    }
    case messages::ContentCaptureReceiver::kDidRemoveContent: {
      DCHECK(message->is_serialized());
      internal::ContentCaptureReceiver_DidRemoveContent_Params_Data* params =
          reinterpret_cast<internal::ContentCaptureReceiver_DidRemoveContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentCaptureReceiver.3
      bool success = true;
      std::vector<int64_t> p_ids{};
      ContentCaptureReceiver_DidRemoveContent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIds(&p_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentCaptureReceiver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidRemoveContent(        
        std::move(p_ids));
      return true;
    }
  }
  return false;
}

// static
bool ContentCaptureReceiverStubDispatch::AcceptWithResponder(
    ContentCaptureReceiver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContentCaptureReceiver>(message->header()->name)) {
    case messages::ContentCaptureReceiver::kDidCompleteBatchCaptureContent: {
      break;
    }
    case messages::ContentCaptureReceiver::kDidCaptureContent: {
      break;
    }
    case messages::ContentCaptureReceiver::kDidUpdateContent: {
      break;
    }
    case messages::ContentCaptureReceiver::kDidRemoveContent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContentCaptureReceiverValidationInfo[] = {
    { &internal::ContentCaptureReceiver_DidCompleteBatchCaptureContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentCaptureReceiver_DidCaptureContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentCaptureReceiver_DidUpdateContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentCaptureReceiver_DidRemoveContent_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContentCaptureReceiverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content_capture::mojom::ContentCaptureReceiver::Name_,
    kContentCaptureReceiverValidationInfo);
}

// The declaration includes the definition on other builds.

ContentCaptureSender::IPCStableHashFunction ContentCaptureSender::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContentCaptureSender>(message.name())) {
    case messages::ContentCaptureSender::kStartCapture: {
      return &ContentCaptureSender::StartCapture_Sym::IPCStableHash;
    }
    case messages::ContentCaptureSender::kStopCapture: {
      return &ContentCaptureSender::StopCapture_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContentCaptureSender::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContentCaptureSender>(message.name())) {
      case messages::ContentCaptureSender::kStartCapture:
            return "Receive content_capture::mojom::ContentCaptureSender::StartCapture";
      case messages::ContentCaptureSender::kStopCapture:
            return "Receive content_capture::mojom::ContentCaptureSender::StopCapture";
    }
  } else {
    switch (static_cast<messages::ContentCaptureSender>(message.name())) {
      case messages::ContentCaptureSender::kStartCapture:
            return "Receive reply content_capture::mojom::ContentCaptureSender::StartCapture";
      case messages::ContentCaptureSender::kStopCapture:
            return "Receive reply content_capture::mojom::ContentCaptureSender::StopCapture";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContentCaptureSender::StartCapture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2549ecbd;  // IPCStableHash for content_capture::mojom::ContentCaptureSender::StartCapture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentCaptureSender::StopCapture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5fe1e738;  // IPCStableHash for content_capture::mojom::ContentCaptureSender::StopCapture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ContentCaptureSenderProxy::ContentCaptureSenderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentCaptureSenderProxy::StartCapture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content_capture::mojom::ContentCaptureSender::StartCapture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentCaptureSender::kStartCapture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_capture::mojom::internal::ContentCaptureSender_StartCapture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentCaptureSender::Name_);
  message.set_method_name("StartCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContentCaptureSenderProxy::StopCapture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content_capture::mojom::ContentCaptureSender::StopCapture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentCaptureSender::kStopCapture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_capture::mojom::internal::ContentCaptureSender_StopCapture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentCaptureSender::Name_);
  message.set_method_name("StopCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ContentCaptureSenderStubDispatch::Accept(
    ContentCaptureSender* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContentCaptureSender>(message->header()->name)) {
    case messages::ContentCaptureSender::kStartCapture: {
      DCHECK(message->is_serialized());
      internal::ContentCaptureSender_StartCapture_Params_Data* params =
          reinterpret_cast<internal::ContentCaptureSender_StartCapture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentCaptureSender.0
      bool success = true;
      ContentCaptureSender_StartCapture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentCaptureSender::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartCapture(        );
      return true;
    }
    case messages::ContentCaptureSender::kStopCapture: {
      DCHECK(message->is_serialized());
      internal::ContentCaptureSender_StopCapture_Params_Data* params =
          reinterpret_cast<internal::ContentCaptureSender_StopCapture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentCaptureSender.1
      bool success = true;
      ContentCaptureSender_StopCapture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentCaptureSender::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopCapture(        );
      return true;
    }
  }
  return false;
}

// static
bool ContentCaptureSenderStubDispatch::AcceptWithResponder(
    ContentCaptureSender* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContentCaptureSender>(message->header()->name)) {
    case messages::ContentCaptureSender::kStartCapture: {
      break;
    }
    case messages::ContentCaptureSender::kStopCapture: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContentCaptureSenderValidationInfo[] = {
    { &internal::ContentCaptureSender_StartCapture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentCaptureSender_StopCapture_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContentCaptureSenderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content_capture::mojom::ContentCaptureSender::Name_,
    kContentCaptureSenderValidationInfo);
}



}  // content_capture::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content_capture::mojom {


void ContentCaptureReceiverInterceptorForTesting::DidCompleteBatchCaptureContent() {
  GetForwardingInterface()->DidCompleteBatchCaptureContent();
}
void ContentCaptureReceiverInterceptorForTesting::DidCaptureContent(const ::content_capture::ContentCaptureData& data, bool first_data) {
  GetForwardingInterface()->DidCaptureContent(
    std::move(data)
    , 
    std::move(first_data)
    );
}
void ContentCaptureReceiverInterceptorForTesting::DidUpdateContent(const ::content_capture::ContentCaptureData& data) {
  GetForwardingInterface()->DidUpdateContent(
    std::move(data)
    );
}
void ContentCaptureReceiverInterceptorForTesting::DidRemoveContent(const std::vector<int64_t>& ids) {
  GetForwardingInterface()->DidRemoveContent(
    std::move(ids)
    );
}
ContentCaptureReceiverAsyncWaiter::ContentCaptureReceiverAsyncWaiter(
    ContentCaptureReceiver* proxy) : proxy_(proxy) {}

ContentCaptureReceiverAsyncWaiter::~ContentCaptureReceiverAsyncWaiter() = default;





void ContentCaptureSenderInterceptorForTesting::StartCapture() {
  GetForwardingInterface()->StartCapture();
}
void ContentCaptureSenderInterceptorForTesting::StopCapture() {
  GetForwardingInterface()->StopCapture();
}
ContentCaptureSenderAsyncWaiter::ContentCaptureSenderAsyncWaiter(
    ContentCaptureSender* proxy) : proxy_(proxy) {}

ContentCaptureSenderAsyncWaiter::~ContentCaptureSenderAsyncWaiter() = default;







}  // content_capture::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif