// components/commerce/core/mojom/shopping_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/commerce/core/mojom/shopping_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "components/commerce/core/mojom/shared.mojom-shared.h"


namespace shopping_service::mojom {
class PricePointDataView;

class UrlInfoDataView;

class PriceInsightsInfoDataView;

class ProductSpecificationsDescriptionTextDataView;

class ProductSpecificationsOptionDataView;

class ProductSpecificationsDescriptionDataView;

class ProductSpecificationsValueDataView;

class ProductSpecificationsProductDataView;

class ProductSpecificationsFeatureStateDataView;

class ProductSpecificationsDataView;



}  // shopping_service::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::shopping_service::mojom::PricePointDataView> {
  using Data = ::shopping_service::mojom::internal::PricePoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::UrlInfoDataView> {
  using Data = ::shopping_service::mojom::internal::UrlInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::PriceInsightsInfoDataView> {
  using Data = ::shopping_service::mojom::internal::PriceInsightsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView> {
  using Data = ::shopping_service::mojom::internal::ProductSpecificationsDescriptionText_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::ProductSpecificationsOptionDataView> {
  using Data = ::shopping_service::mojom::internal::ProductSpecificationsOption_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::ProductSpecificationsDescriptionDataView> {
  using Data = ::shopping_service::mojom::internal::ProductSpecificationsDescription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::ProductSpecificationsValueDataView> {
  using Data = ::shopping_service::mojom::internal::ProductSpecificationsValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::ProductSpecificationsProductDataView> {
  using Data = ::shopping_service::mojom::internal::ProductSpecificationsProduct_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::ProductSpecificationsFeatureStateDataView> {
  using Data = ::shopping_service::mojom::internal::ProductSpecificationsFeatureState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shopping_service::mojom::ProductSpecificationsDataView> {
  using Data = ::shopping_service::mojom::internal::ProductSpecifications_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace shopping_service::mojom {


enum class UserFeedback : int32_t {
  
  kUnspecified = 0,
  
  kThumbsUp = 1,
  
  kThumbsDown = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, UserFeedback value);
inline bool IsKnownEnumValue(UserFeedback value) {
  return internal::UserFeedback_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PriceInsightsInfo_PriceBucket : int32_t {
  
  kUnknown = 0,
  
  kLow = 1,
  
  kTypical = 2,
  
  kHigh = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PriceInsightsInfo_PriceBucket value);
inline bool IsKnownEnumValue(PriceInsightsInfo_PriceBucket value) {
  return internal::PriceInsightsInfo_PriceBucket_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ShoppingServiceHandlerFactoryInterfaceBase {};

using ShoppingServiceHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<ShoppingServiceHandlerFactoryInterfaceBase>;
using ShoppingServiceHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<ShoppingServiceHandlerFactoryInterfaceBase>;
using ShoppingServiceHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ShoppingServiceHandlerFactoryInterfaceBase>;
using ShoppingServiceHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ShoppingServiceHandlerFactoryInterfaceBase>;
class ShoppingServiceHandlerInterfaceBase {};

using ShoppingServiceHandlerPtrDataView =
    mojo::InterfacePtrDataView<ShoppingServiceHandlerInterfaceBase>;
using ShoppingServiceHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ShoppingServiceHandlerInterfaceBase>;
using ShoppingServiceHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ShoppingServiceHandlerInterfaceBase>;
using ShoppingServiceHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ShoppingServiceHandlerInterfaceBase>;


class PricePointDataView {
 public:
  PricePointDataView() = default;

  PricePointDataView(
      internal::PricePoint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDate(UserType* output) {
    
    auto* pointer = data_->date.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  float price() const {
    return data_->price;
  }
  inline void GetFormattedPriceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormattedPrice(UserType* output) {
    
    auto* pointer = data_->formatted_price.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PricePoint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UrlInfoDataView {
 public:
  UrlInfoDataView() = default;

  UrlInfoDataView(
      internal::UrlInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFaviconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFaviconUrl(UserType* output) {
    
    auto* pointer = data_->favicon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetThumbnailUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThumbnailUrl(UserType* output) {
    
    auto* pointer = data_->thumbnail_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPreviewTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviewText(UserType* output) {
    
    auto* pointer = data_->previewText.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::UrlInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PriceInsightsInfoDataView {
 public:
  PriceInsightsInfoDataView() = default;

  PriceInsightsInfoDataView(
      internal::PriceInsightsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t cluster_id() const {
    return data_->cluster_id;
  }
  inline void GetTypicalLowPriceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTypicalLowPrice(UserType* output) {
    
    auto* pointer = data_->typical_low_price.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTypicalHighPriceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTypicalHighPrice(UserType* output) {
    
    auto* pointer = data_->typical_high_price.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCatalogAttributesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCatalogAttributes(UserType* output) {
    
    auto* pointer = data_->catalog_attributes.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetJackpotDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJackpot(UserType* output) {
    
    auto* pointer = data_->jackpot.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBucket(UserType* output) const {
    auto data_value = data_->bucket;
    return mojo::internal::Deserialize<::shopping_service::mojom::PriceInsightsInfo_PriceBucket>(
        data_value, output);
  }
  PriceInsightsInfo_PriceBucket bucket() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::shopping_service::mojom::PriceInsightsInfo_PriceBucket>(data_->bucket));
  }
  bool has_multiple_catalogs() const {
    return data_->has_multiple_catalogs;
  }
  inline void GetHistoryDataView(
      mojo::ArrayDataView<PricePointDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHistory(UserType* output) {
    
    auto* pointer = data_->history.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shopping_service::mojom::PricePointDataView>>(
        pointer, output, message_);
  }
  inline void GetLocaleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocale(UserType* output) {
    
    auto* pointer = data_->locale.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCurrencyCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrencyCode(UserType* output) {
    
    auto* pointer = data_->currency_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PriceInsightsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProductSpecificationsDescriptionTextDataView {
 public:
  ProductSpecificationsDescriptionTextDataView() = default;

  ProductSpecificationsDescriptionTextDataView(
      internal::ProductSpecificationsDescriptionText_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlsDataView(
      mojo::ArrayDataView<UrlInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrls(UserType* output) {
    
    auto* pointer = data_->urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shopping_service::mojom::UrlInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProductSpecificationsDescriptionText_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProductSpecificationsOptionDataView {
 public:
  ProductSpecificationsOptionDataView() = default;

  ProductSpecificationsOptionDataView(
      internal::ProductSpecificationsOption_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDescriptionsDataView(
      mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptions(UserType* output) {
    
    auto* pointer = data_->descriptions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProductSpecificationsOption_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProductSpecificationsDescriptionDataView {
 public:
  ProductSpecificationsDescriptionDataView() = default;

  ProductSpecificationsDescriptionDataView(
      internal::ProductSpecificationsDescription_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      mojo::ArrayDataView<ProductSpecificationsOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsOptionDataView>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAltTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAltText(UserType* output) {
    
    auto* pointer = data_->alt_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProductSpecificationsDescription_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProductSpecificationsValueDataView {
 public:
  ProductSpecificationsValueDataView() = default;

  ProductSpecificationsValueDataView(
      internal::ProductSpecificationsValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSpecificationDescriptionsDataView(
      mojo::ArrayDataView<ProductSpecificationsDescriptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpecificationDescriptions(UserType* output) {
    
    auto* pointer = data_->specification_descriptions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionDataView>>(
        pointer, output, message_);
  }
  inline void GetSummaryDataView(
      mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSummary(UserType* output) {
    
    auto* pointer = data_->summary.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProductSpecificationsValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProductSpecificationsProductDataView {
 public:
  ProductSpecificationsProductDataView() = default;

  ProductSpecificationsProductDataView(
      internal::ProductSpecificationsProduct_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t product_cluster_id() const {
    return data_->product_cluster_id;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageUrl(UserType* output) {
    
    auto* pointer = data_->image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetProductDimensionValuesDataView(
      mojo::MapDataView<uint64_t, ProductSpecificationsValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProductDimensionValues(UserType* output) {
    
    auto* pointer = data_->product_dimension_values.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint64_t, ::shopping_service::mojom::ProductSpecificationsValueDataView>>(
        pointer, output, message_);
  }
  inline void GetSummaryDataView(
      mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSummary(UserType* output) {
    
    auto* pointer = data_->summary.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>>(
        pointer, output, message_);
  }
  inline void GetBuyingOptionsUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyingOptionsUrl(UserType* output) {
    
    auto* pointer = data_->buying_options_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProductSpecificationsProduct_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProductSpecificationsFeatureStateDataView {
 public:
  ProductSpecificationsFeatureStateDataView() = default;

  ProductSpecificationsFeatureStateDataView(
      internal::ProductSpecificationsFeatureState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_syncing_tab_compare() const {
    return data_->is_syncing_tab_compare;
  }
  bool can_load_full_page_ui() const {
    return data_->can_load_full_page_ui;
  }
  bool can_manage_sets() const {
    return data_->can_manage_sets;
  }
  bool can_fetch_data() const {
    return data_->can_fetch_data;
  }
  bool is_allowed_for_enterprise() const {
    return data_->is_allowed_for_enterprise;
  }
  bool is_quality_logging_allowed() const {
    return data_->is_quality_logging_allowed;
  }
  bool is_signed_in() const {
    return data_->is_signed_in;
  }
 private:
  internal::ProductSpecificationsFeatureState_Data* data_ = nullptr;
};


class ProductSpecificationsDataView {
 public:
  ProductSpecificationsDataView() = default;

  ProductSpecificationsDataView(
      internal::ProductSpecifications_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProductDimensionMapDataView(
      mojo::MapDataView<uint64_t, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProductDimensionMap(UserType* output) {
    
    auto* pointer = data_->product_dimension_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint64_t, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetProductsDataView(
      mojo::ArrayDataView<ProductSpecificationsProductDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProducts(UserType* output) {
    
    auto* pointer = data_->products.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsProductDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProductSpecifications_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // shopping_service::mojom

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_DATA_VIEW_H_