// components/commerce/core/internals/mojom/commerce_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  BookmarkProductInfoSpec as commerce_shared_mojom_BookmarkProductInfoSpec,
  BookmarkProductInfo as commerce_shared_mojom_BookmarkProductInfo,
  ProductInfoSpec as commerce_shared_mojom_ProductInfoSpec,
  ProductInfo as commerce_shared_mojom_ProductInfo
} from './shared.mojom-webui.js';
import {
  UrlInfoSpec as shoppingService_mojom_UrlInfoSpec,
  UrlInfo as shoppingService_mojom_UrlInfo
} from './shopping_service.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type CommerceInternalsHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CommerceInternalsHandlerFactoryPendingReceiver>;

export class CommerceInternalsHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CommerceInternalsHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<CommerceInternalsHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|CommerceInternalsHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.mojom.CommerceInternalsHandlerFactory',
        scope);
  }
}

export interface CommerceInternalsHandlerFactoryInterface {
  createCommerceInternalsHandler(page: CommerceInternalsPageRemote, handler: CommerceInternalsHandlerPendingReceiver): void;
}

export class CommerceInternalsHandlerFactoryRemote implements CommerceInternalsHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CommerceInternalsHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CommerceInternalsHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CommerceInternalsHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CommerceInternalsHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createCommerceInternalsHandler(
      page: CommerceInternalsPageRemote,
      handler: CommerceInternalsHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CommerceInternalsHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CommerceInternalsHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommerceInternalsHandlerFactoryRemote, CommerceInternalsHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommerceInternalsHandlerFactoryRemote, CommerceInternalsHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CommerceInternalsHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CommerceInternalsHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsSpec.$,
        null,
        impl.createCommerceInternalsHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CommerceInternalsHandlerFactory {
  static get $interfaceName(): string {
    return "commerce.mojom.CommerceInternalsHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CommerceInternalsHandlerFactoryRemote {
    let remote = new CommerceInternalsHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CommerceInternalsHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CommerceInternalsHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommerceInternalsHandlerFactoryRemote, CommerceInternalsHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommerceInternalsHandlerFactoryRemote, CommerceInternalsHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createCommerceInternalsHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CommerceInternalsHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createCommerceInternalsHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsSpec.$,
        null,
        this.createCommerceInternalsHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CommerceInternalsHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CommerceInternalsHandlerPendingReceiver>;

export class CommerceInternalsHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CommerceInternalsHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<CommerceInternalsHandlerPendingReceiver>;
  constructor(handle: MojoHandle|CommerceInternalsHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.mojom.CommerceInternalsHandler',
        scope);
  }
}

export interface CommerceInternalsHandlerInterface {
  getIsShoppingListEligible(): Promise<{
        eligible: boolean, }>;
  resetPriceTrackingEmailPref(): void;
  getProductInfoForUrl(url: url_mojom_Url): Promise<{
        info: commerce_shared_mojom_ProductInfo, }>;
  getSubscriptionDetails(): Promise<{
        subscriptions: Subscription[], }>;
  getProductSpecificationsDetails(): Promise<{
        productSpecificationsSet: ProductSpecificationsSet[], }>;
  resetProductSpecifications(): void;
  getShoppingEligibilityDetails(): Promise<{
        details: ShoppingEligibilityDetails, }>;
}

export class CommerceInternalsHandlerRemote implements CommerceInternalsHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CommerceInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CommerceInternalsHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CommerceInternalsHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CommerceInternalsHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getIsShoppingListEligible(): Promise<{
        eligible: boolean, }> {
    return this.proxy.sendMessage(
        0,
        CommerceInternalsHandler_GetIsShoppingListEligible_ParamsSpec.$,
        CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  resetPriceTrackingEmailPref(): void {
    this.proxy.sendMessage(
        1,
        CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getProductInfoForUrl(
      url: url_mojom_Url): Promise<{
        info: commerce_shared_mojom_ProductInfo, }> {
    return this.proxy.sendMessage(
        2,
        CommerceInternalsHandler_GetProductInfoForUrl_ParamsSpec.$,
        CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  getSubscriptionDetails(): Promise<{
        subscriptions: Subscription[], }> {
    return this.proxy.sendMessage(
        3,
        CommerceInternalsHandler_GetSubscriptionDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getProductSpecificationsDetails(): Promise<{
        productSpecificationsSet: ProductSpecificationsSet[], }> {
    return this.proxy.sendMessage(
        4,
        CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  resetProductSpecifications(): void {
    this.proxy.sendMessage(
        5,
        CommerceInternalsHandler_ResetProductSpecifications_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getShoppingEligibilityDetails(): Promise<{
        details: ShoppingEligibilityDetails, }> {
    return this.proxy.sendMessage(
        6,
        CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CommerceInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CommerceInternalsHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommerceInternalsHandlerRemote, CommerceInternalsHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommerceInternalsHandlerRemote, CommerceInternalsHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CommerceInternalsHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CommerceInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CommerceInternalsHandler_GetIsShoppingListEligible_ParamsSpec.$,
        CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsSpec.$,
        impl.getIsShoppingListEligible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsSpec.$,
        null,
        impl.resetPriceTrackingEmailPref.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CommerceInternalsHandler_GetProductInfoForUrl_ParamsSpec.$,
        CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsSpec.$,
        impl.getProductInfoForUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CommerceInternalsHandler_GetSubscriptionDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsSpec.$,
        impl.getSubscriptionDetails.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsSpec.$,
        impl.getProductSpecificationsDetails.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CommerceInternalsHandler_ResetProductSpecifications_ParamsSpec.$,
        null,
        impl.resetProductSpecifications.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsSpec.$,
        impl.getShoppingEligibilityDetails.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CommerceInternalsHandler {
  static get $interfaceName(): string {
    return "commerce.mojom.CommerceInternalsHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CommerceInternalsHandlerRemote {
    let remote = new CommerceInternalsHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CommerceInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CommerceInternalsHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommerceInternalsHandlerRemote, CommerceInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommerceInternalsHandlerRemote, CommerceInternalsHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getIsShoppingListEligible: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resetPriceTrackingEmailPref: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProductInfoForUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSubscriptionDetails: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProductSpecificationsDetails: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resetProductSpecifications: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getShoppingEligibilityDetails: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CommerceInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getIsShoppingListEligible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CommerceInternalsHandler_GetIsShoppingListEligible_ParamsSpec.$,
        CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsSpec.$,
        this.getIsShoppingListEligible.createReceiverHandler(true /* expectsResponse */),
        false);
    this.resetPriceTrackingEmailPref =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsSpec.$,
        null,
        this.resetPriceTrackingEmailPref.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getProductInfoForUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CommerceInternalsHandler_GetProductInfoForUrl_ParamsSpec.$,
        CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsSpec.$,
        this.getProductInfoForUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getSubscriptionDetails =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CommerceInternalsHandler_GetSubscriptionDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsSpec.$,
        this.getSubscriptionDetails.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getProductSpecificationsDetails =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsSpec.$,
        this.getProductSpecificationsDetails.createReceiverHandler(true /* expectsResponse */),
        false);
    this.resetProductSpecifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CommerceInternalsHandler_ResetProductSpecifications_ParamsSpec.$,
        null,
        this.resetProductSpecifications.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getShoppingEligibilityDetails =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsSpec.$,
        CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsSpec.$,
        this.getShoppingEligibilityDetails.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CommerceInternalsPagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CommerceInternalsPagePendingReceiver>;

export class CommerceInternalsPagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CommerceInternalsPage> {

  handle: mojo.internal.interfaceSupport.Endpoint<CommerceInternalsPagePendingReceiver>;
  constructor(handle: MojoHandle|CommerceInternalsPagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.mojom.CommerceInternalsPage',
        scope);
  }
}

export interface CommerceInternalsPageInterface {
  onShoppingListEligibilityChanged(eligible: boolean): void;
}

export class CommerceInternalsPageRemote implements CommerceInternalsPageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CommerceInternalsPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CommerceInternalsPagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CommerceInternalsPagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CommerceInternalsPagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onShoppingListEligibilityChanged(
      eligible: boolean): void {
    this.proxy.sendMessage(
        0,
        CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsSpec.$,
        null,
        [
          eligible
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CommerceInternalsPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CommerceInternalsPageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommerceInternalsPageRemote, CommerceInternalsPagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommerceInternalsPageRemote, CommerceInternalsPagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CommerceInternalsPageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CommerceInternalsPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsSpec.$,
        null,
        impl.onShoppingListEligibilityChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CommerceInternalsPage {
  static get $interfaceName(): string {
    return "commerce.mojom.CommerceInternalsPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CommerceInternalsPageRemote {
    let remote = new CommerceInternalsPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CommerceInternalsPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CommerceInternalsPageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommerceInternalsPageRemote, CommerceInternalsPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommerceInternalsPageRemote, CommerceInternalsPagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onShoppingListEligibilityChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CommerceInternalsPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onShoppingListEligibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsSpec.$,
        null,
        this.onShoppingListEligibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const EligibilityDetailSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingEligibilityDetailsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SubscriptionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsSetSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetIsShoppingListEligible_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetProductInfoForUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetSubscriptionDetails_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_ResetProductSpecifications_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface EligibilityDetailMojoType {
  name: string;
  value: boolean;
  expectedValue: boolean;
}


export type EligibilityDetail = EligibilityDetailMojoType;
mojo.internal.Struct<EligibilityDetailMojoType>(
    EligibilityDetailSpec.$,
    'EligibilityDetail',
    [
      mojo.internal.StructField<EligibilityDetailMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityDetailMojoType, boolean>(
        'value', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityDetailMojoType, boolean>(
        'expectedValue', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ShoppingEligibilityDetailsMojoType {
  country: string;
  locale: string;
  details: EligibilityDetail[];
}


export type ShoppingEligibilityDetails = ShoppingEligibilityDetailsMojoType;
mojo.internal.Struct<ShoppingEligibilityDetailsMojoType>(
    ShoppingEligibilityDetailsSpec.$,
    'ShoppingEligibilityDetails',
    [
      mojo.internal.StructField<ShoppingEligibilityDetailsMojoType, string>(
        'country', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ShoppingEligibilityDetailsMojoType, string>(
        'locale', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ShoppingEligibilityDetailsMojoType, EligibilityDetail[]>(
        'details', 16,
        0,
        mojo.internal.Array(EligibilityDetailSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface SubscriptionMojoType {
  clusterId: bigint;
  productInfos: commerce_shared_mojom_BookmarkProductInfo[];
}


export type Subscription = SubscriptionMojoType;
mojo.internal.Struct<SubscriptionMojoType>(
    SubscriptionSpec.$,
    'Subscription',
    [
      mojo.internal.StructField<SubscriptionMojoType, bigint>(
        'clusterId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SubscriptionMojoType, commerce_shared_mojom_BookmarkProductInfo[]>(
        'productInfos', 8,
        0,
        mojo.internal.Array(commerce_shared_mojom_BookmarkProductInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ProductSpecificationsSetMojoType {
  uuid: string;
  name: string;
  creationTime: string;
  updateTime: string;
  urlInfos: shoppingService_mojom_UrlInfo[];
}


export type ProductSpecificationsSet = ProductSpecificationsSetMojoType;
mojo.internal.Struct<ProductSpecificationsSetMojoType>(
    ProductSpecificationsSetSpec.$,
    'ProductSpecificationsSet',
    [
      mojo.internal.StructField<ProductSpecificationsSetMojoType, string>(
        'uuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsSetMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsSetMojoType, string>(
        'creationTime', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsSetMojoType, string>(
        'updateTime', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsSetMojoType, shoppingService_mojom_UrlInfo[]>(
        'urlInfos', 32,
        0,
        mojo.internal.Array(shoppingService_mojom_UrlInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsMojoType {
  page: CommerceInternalsPageRemote;
  handler: CommerceInternalsHandlerPendingReceiver;
}


export type CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_Params = CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsMojoType>(
    CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsSpec.$,
    'CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_Params',
    [
      mojo.internal.StructField<CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsMojoType, CommerceInternalsPageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(CommerceInternalsPageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsMojoType, CommerceInternalsHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(CommerceInternalsHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CommerceInternalsHandler_GetIsShoppingListEligible_ParamsMojoType {
}


export type CommerceInternalsHandler_GetIsShoppingListEligible_Params = CommerceInternalsHandler_GetIsShoppingListEligible_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetIsShoppingListEligible_ParamsMojoType>(
    CommerceInternalsHandler_GetIsShoppingListEligible_ParamsSpec.$,
    'CommerceInternalsHandler_GetIsShoppingListEligible_Params',
    [
    ],
    [[0, 8],]);





export interface CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsMojoType {
  eligible: boolean;
}


export type CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParams = CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsMojoType>(
    CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsSpec.$,
    'CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParams',
    [
      mojo.internal.StructField<CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsMojoType, boolean>(
        'eligible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsMojoType {
}


export type CommerceInternalsHandler_ResetPriceTrackingEmailPref_Params = CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsMojoType>(
    CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsSpec.$,
    'CommerceInternalsHandler_ResetPriceTrackingEmailPref_Params',
    [
    ],
    [[0, 8],]);





export interface CommerceInternalsHandler_GetProductInfoForUrl_ParamsMojoType {
  url: url_mojom_Url;
}


export type CommerceInternalsHandler_GetProductInfoForUrl_Params = CommerceInternalsHandler_GetProductInfoForUrl_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetProductInfoForUrl_ParamsMojoType>(
    CommerceInternalsHandler_GetProductInfoForUrl_ParamsSpec.$,
    'CommerceInternalsHandler_GetProductInfoForUrl_Params',
    [
      mojo.internal.StructField<CommerceInternalsHandler_GetProductInfoForUrl_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsMojoType {
  info: commerce_shared_mojom_ProductInfo;
}


export type CommerceInternalsHandler_GetProductInfoForUrl_ResponseParams = CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsMojoType>(
    CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsSpec.$,
    'CommerceInternalsHandler_GetProductInfoForUrl_ResponseParams',
    [
      mojo.internal.StructField<CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsMojoType, commerce_shared_mojom_ProductInfo>(
        'info', 0,
        0,
        commerce_shared_mojom_ProductInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommerceInternalsHandler_GetSubscriptionDetails_ParamsMojoType {
}


export type CommerceInternalsHandler_GetSubscriptionDetails_Params = CommerceInternalsHandler_GetSubscriptionDetails_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetSubscriptionDetails_ParamsMojoType>(
    CommerceInternalsHandler_GetSubscriptionDetails_ParamsSpec.$,
    'CommerceInternalsHandler_GetSubscriptionDetails_Params',
    [
    ],
    [[0, 8],]);





export interface CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsMojoType {
  subscriptions: Subscription[];
}


export type CommerceInternalsHandler_GetSubscriptionDetails_ResponseParams = CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsMojoType>(
    CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsSpec.$,
    'CommerceInternalsHandler_GetSubscriptionDetails_ResponseParams',
    [
      mojo.internal.StructField<CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsMojoType, Subscription[]>(
        'subscriptions', 0,
        0,
        mojo.internal.Array(SubscriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsMojoType {
}


export type CommerceInternalsHandler_GetProductSpecificationsDetails_Params = CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsMojoType>(
    CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsSpec.$,
    'CommerceInternalsHandler_GetProductSpecificationsDetails_Params',
    [
    ],
    [[0, 8],]);





export interface CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsMojoType {
  productSpecificationsSet: ProductSpecificationsSet[];
}


export type CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParams = CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsMojoType>(
    CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsSpec.$,
    'CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParams',
    [
      mojo.internal.StructField<CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsMojoType, ProductSpecificationsSet[]>(
        'productSpecificationsSet', 0,
        0,
        mojo.internal.Array(ProductSpecificationsSetSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommerceInternalsHandler_ResetProductSpecifications_ParamsMojoType {
}


export type CommerceInternalsHandler_ResetProductSpecifications_Params = CommerceInternalsHandler_ResetProductSpecifications_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_ResetProductSpecifications_ParamsMojoType>(
    CommerceInternalsHandler_ResetProductSpecifications_ParamsSpec.$,
    'CommerceInternalsHandler_ResetProductSpecifications_Params',
    [
    ],
    [[0, 8],]);





export interface CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsMojoType {
}


export type CommerceInternalsHandler_GetShoppingEligibilityDetails_Params = CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsMojoType>(
    CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsSpec.$,
    'CommerceInternalsHandler_GetShoppingEligibilityDetails_Params',
    [
    ],
    [[0, 8],]);





export interface CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsMojoType {
  details: ShoppingEligibilityDetails;
}


export type CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParams = CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsMojoType;
mojo.internal.Struct<CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsMojoType>(
    CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsSpec.$,
    'CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParams',
    [
      mojo.internal.StructField<CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsMojoType, ShoppingEligibilityDetails>(
        'details', 0,
        0,
        ShoppingEligibilityDetailsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsMojoType {
  eligible: boolean;
}


export type CommerceInternalsPage_OnShoppingListEligibilityChanged_Params = CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsMojoType;
mojo.internal.Struct<CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsMojoType>(
    CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsSpec.$,
    'CommerceInternalsPage_OnShoppingListEligibilityChanged_Params',
    [
      mojo.internal.StructField<CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsMojoType, boolean>(
        'eligible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



