// components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-params-data.h"
namespace tabs_api {
namespace mojom {

NOINLINE static const char* AlertStateToStringHelper(AlertState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AlertState::kAudioMuting:
      return "kAudioMuting";
    case AlertState::kAudioRecording:
      return "kAudioRecording";
    case AlertState::kAudioPlaying:
      return "kAudioPlaying";
    case AlertState::kBluetoothConnected:
      return "kBluetoothConnected";
    case AlertState::kBluetoothScanActive:
      return "kBluetoothScanActive";
    case AlertState::kDesktopCapturing:
      return "kDesktopCapturing";
    case AlertState::kActorAccessing:
      return "kActorAccessing";
    case AlertState::kActorWaitingOnUser:
      return "kActorWaitingOnUser";
    case AlertState::kGlicAccessing:
      return "kGlicAccessing";
    case AlertState::kGlicSharing:
      return "kGlicSharing";
    case AlertState::kHidConnected:
      return "kHidConnected";
    case AlertState::kMediaRecording:
      return "kMediaRecording";
    case AlertState::kPipPlaying:
      return "kPipPlaying";
    case AlertState::kSerialConnected:
      return "kSerialConnected";
    case AlertState::kTabCapturing:
      return "kTabCapturing";
    case AlertState::kUsbConnected:
      return "kUsbConnected";
    case AlertState::kVideoRecording:
      return "kVideoRecording";
    case AlertState::kVrPresentingInHeadset:
      return "kVrPresentingInHeadset";
    default:
      return nullptr;
  }
}

std::string AlertStateToString(AlertState value) {
  const char *str = AlertStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AlertState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AlertState value) {
  return os << AlertStateToString(value);
}

NOINLINE static const char* NetworkStateToStringHelper(NetworkState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NetworkState::kNone:
      return "kNone";
    case NetworkState::kWaiting:
      return "kWaiting";
    case NetworkState::kLoading:
      return "kLoading";
    case NetworkState::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string NetworkStateToString(NetworkState value) {
  const char *str = NetworkStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NetworkState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NetworkState value) {
  return os << NetworkStateToString(value);
}

NOINLINE static const char* SplitTabVisualData_LayoutToStringHelper(SplitTabVisualData_Layout value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SplitTabVisualData_Layout::kVertical:
      return "kVertical";
    case SplitTabVisualData_Layout::kHorizontal:
      return "kHorizontal";
    default:
      return nullptr;
  }
}

std::string SplitTabVisualData_LayoutToString(SplitTabVisualData_Layout value) {
  const char *str = SplitTabVisualData_LayoutToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SplitTabVisualData_Layout value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SplitTabVisualData_Layout value) {
  return os << SplitTabVisualData_LayoutToString(value);
}

namespace internal {
// static
bool Data_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const Data_Data* object = static_cast<const Data_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case Data_Tag::kTab: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kTabStrip: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab_strip, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab_strip, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kPinnedTabs: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_pinned_tabs, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_pinned_tabs, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kUnpinnedTabs: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_unpinned_tabs, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_unpinned_tabs, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kTabGroup: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab_group, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab_group, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kSplitTab: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_split_tab, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_split_tab, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in Data");
      return false;
    }
  }
}


// static
bool Image_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Image_Data* object =
      static_cast<const Image_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data_url, validation_context))
    return false;

  return true;
}

Image_Data::Image_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Tab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tab_Data* object =
      static_cast<const Tab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicon, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->favicon, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_states, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs_api::mojom::internal::AlertState_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->alert_states, validation_context,
                                         &alert_states_validate_params)) {
    return false;
  }


  if (!::tabs_api::mojom::internal::NetworkState_Data
        ::Validate(object->network_state, validation_context))
    return false;

  return true;
}

Tab_Data::Tab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStrip_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStrip_Data* object =
      static_cast<const TabStrip_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

TabStrip_Data::TabStrip_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PinnedTabs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PinnedTabs_Data* object =
      static_cast<const PinnedTabs_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

PinnedTabs_Data::PinnedTabs_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnpinnedTabs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnpinnedTabs_Data* object =
      static_cast<const UnpinnedTabs_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

UnpinnedTabs_Data::UnpinnedTabs_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabGroup_Data* object =
      static_cast<const TabGroup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

TabGroup_Data::TabGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabGroupVisualData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabGroupVisualData_Data* object =
      static_cast<const TabGroupVisualData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }


  if (!::tab_groups::mojom::internal::Color_Data
        ::Validate(object->color, validation_context))
    return false;

  return true;
}

TabGroupVisualData_Data::TabGroupVisualData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SplitTab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SplitTab_Data* object =
      static_cast<const SplitTab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

SplitTab_Data::SplitTab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SplitTabVisualData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SplitTabVisualData_Data* object =
      static_cast<const SplitTabVisualData_Data*>(data);


  if (!::tabs_api::mojom::internal::SplitTabVisualData_Layout_Data
        ::Validate(object->layout, validation_context))
    return false;

  return true;
}

SplitTabVisualData_Data::SplitTabVisualData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Container_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Container_Data* object =
      static_cast<const Container_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children, validation_context,
                                         &children_validate_params)) {
    return false;
  }

  return true;
}

Container_Data::Container_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabCreatedContainer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabCreatedContainer_Data* object =
      static_cast<const TabCreatedContainer_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

TabCreatedContainer_Data::TabCreatedContainer_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tabs_api

namespace perfetto {

// static
void TraceFormatTraits<::tabs_api::mojom::AlertState>::WriteIntoTrace(
   perfetto::TracedValue context, ::tabs_api::mojom::AlertState value) {
  return std::move(context).WriteString(::tabs_api::mojom::AlertStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tabs_api::mojom::NetworkState>::WriteIntoTrace(
   perfetto::TracedValue context, ::tabs_api::mojom::NetworkState value) {
  return std::move(context).WriteString(::tabs_api::mojom::NetworkStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tabs_api::mojom::SplitTabVisualData_Layout>::WriteIntoTrace(
   perfetto::TracedValue context, ::tabs_api::mojom::SplitTabVisualData_Layout value) {
  return std::move(context).WriteString(::tabs_api::mojom::SplitTabVisualData_LayoutToString(value));
}

} // namespace perfetto