// components/browser_apis/tab_strip/tab_strip_api.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/browser_apis/tab_strip/tab_strip_api.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/browser_apis/tab_strip/tab_strip_api.mojom-params-data.h"
namespace tabs_api {
namespace mojom {

namespace internal {
// static
bool TabsEvent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabsEvent_Data* object = static_cast<const TabsEvent_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabsEvent_Tag::kTabsCreatedEvent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tabs_created_event, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tabs_created_event, validation_context))
        return false;
      return true;
    }
    case TabsEvent_Tag::kTabsClosedEvent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tabs_closed_event, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tabs_closed_event, validation_context))
        return false;
      return true;
    }
    case TabsEvent_Tag::kNodeMovedEvent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_node_moved_event, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_node_moved_event, validation_context))
        return false;
      return true;
    }
    case TabsEvent_Tag::kDataChangedEvent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data_changed_event, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_data_changed_event, validation_context))
        return false;
      return true;
    }
    case TabsEvent_Tag::kCollectionCreatedEvent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_collection_created_event, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_collection_created_event, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabsEvent");
      return false;
    }
  }
}
// static
bool TabStripService_GetTabs_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabStripService_GetTabs_ResponseParam_Result_Data* object = static_cast<const TabStripService_GetTabs_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabStripService_GetTabs_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case TabStripService_GetTabs_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabStripService_GetTabs_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool TabStripService_GetTab_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabStripService_GetTab_ResponseParam_Result_Data* object = static_cast<const TabStripService_GetTab_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabStripService_GetTab_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case TabStripService_GetTab_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabStripService_GetTab_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool TabStripService_CreateTabAt_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabStripService_CreateTabAt_ResponseParam_Result_Data* object = static_cast<const TabStripService_CreateTabAt_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabStripService_CreateTabAt_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case TabStripService_CreateTabAt_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabStripService_CreateTabAt_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool TabStripService_CloseTabs_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabStripService_CloseTabs_ResponseParam_Result_Data* object = static_cast<const TabStripService_CloseTabs_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabStripService_CloseTabs_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case TabStripService_CloseTabs_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabStripService_CloseTabs_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool TabStripService_ActivateTab_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabStripService_ActivateTab_ResponseParam_Result_Data* object = static_cast<const TabStripService_ActivateTab_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabStripService_ActivateTab_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case TabStripService_ActivateTab_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabStripService_ActivateTab_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool TabStripService_SetSelectedTabs_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabStripService_SetSelectedTabs_ResponseParam_Result_Data* object = static_cast<const TabStripService_SetSelectedTabs_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabStripService_SetSelectedTabs_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case TabStripService_SetSelectedTabs_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabStripService_SetSelectedTabs_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool TabStripService_MoveNode_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabStripService_MoveNode_ResponseParam_Result_Data* object = static_cast<const TabStripService_MoveNode_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabStripService_MoveNode_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case TabStripService_MoveNode_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabStripService_MoveNode_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool TabsSnapshot_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabsSnapshot_Data* object =
      static_cast<const TabsSnapshot_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_strip, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_strip, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TabsSnapshot_Data::TabsSnapshot_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_GetTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_GetTabs_Params_Data* object =
      static_cast<const TabStripService_GetTabs_Params_Data*>(data);

  return true;
}

TabStripService_GetTabs_Params_Data::TabStripService_GetTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_GetTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_GetTabs_ResponseParams_Data* object =
      static_cast<const TabStripService_GetTabs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TabStripService_GetTabs_ResponseParams_Data::TabStripService_GetTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_GetTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_GetTab_Params_Data* object =
      static_cast<const TabStripService_GetTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

TabStripService_GetTab_Params_Data::TabStripService_GetTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_GetTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_GetTab_ResponseParams_Data* object =
      static_cast<const TabStripService_GetTab_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TabStripService_GetTab_ResponseParams_Data::TabStripService_GetTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_CreateTabAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_CreateTabAt_Params_Data* object =
      static_cast<const TabStripService_CreateTabAt_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->pos, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

TabStripService_CreateTabAt_Params_Data::TabStripService_CreateTabAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_CreateTabAt_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_CreateTabAt_ResponseParams_Data* object =
      static_cast<const TabStripService_CreateTabAt_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TabStripService_CreateTabAt_ResponseParams_Data::TabStripService_CreateTabAt_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_CloseTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_CloseTabs_Params_Data* object =
      static_cast<const TabStripService_CloseTabs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

TabStripService_CloseTabs_Params_Data::TabStripService_CloseTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_CloseTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_CloseTabs_ResponseParams_Data* object =
      static_cast<const TabStripService_CloseTabs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TabStripService_CloseTabs_ResponseParams_Data::TabStripService_CloseTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_ActivateTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_ActivateTab_Params_Data* object =
      static_cast<const TabStripService_ActivateTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

TabStripService_ActivateTab_Params_Data::TabStripService_ActivateTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_ActivateTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_ActivateTab_ResponseParams_Data* object =
      static_cast<const TabStripService_ActivateTab_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TabStripService_ActivateTab_ResponseParams_Data::TabStripService_ActivateTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_SetSelectedTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_SetSelectedTabs_Params_Data* object =
      static_cast<const TabStripService_SetSelectedTabs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selection_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selection, validation_context,
                                         &selection_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_to_activate, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_to_activate, validation_context))
    return false;

  return true;
}

TabStripService_SetSelectedTabs_Params_Data::TabStripService_SetSelectedTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_SetSelectedTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_SetSelectedTabs_ResponseParams_Data* object =
      static_cast<const TabStripService_SetSelectedTabs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TabStripService_SetSelectedTabs_ResponseParams_Data::TabStripService_SetSelectedTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_MoveNode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_MoveNode_Params_Data* object =
      static_cast<const TabStripService_MoveNode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

TabStripService_MoveNode_Params_Data::TabStripService_MoveNode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripService_MoveNode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripService_MoveNode_ResponseParams_Data* object =
      static_cast<const TabStripService_MoveNode_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TabStripService_MoveNode_ResponseParams_Data::TabStripService_MoveNode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabsObserver_OnTabEvents_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabsObserver_OnTabEvents_Params_Data* object =
      static_cast<const TabsObserver_OnTabEvents_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->events, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& events_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->events, validation_context,
                                         &events_validate_params)) {
    return false;
  }

  return true;
}

TabsObserver_OnTabEvents_Params_Data::TabsObserver_OnTabEvents_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tabs_api