// components/autofill/core/common/mojom/autofill_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_DATA_VIEW_H_
#define COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace autofill::mojom {
class FrameTokenDataView;

class FrameTokenWithPredecessorDataView;

class FormRendererIdDataView;

class FieldRendererIdDataView;

class SelectOptionDataView;

class AutocompleteParsingResultDataView;

class FormFieldDataDataView;

class FormFieldData_FillDataDataView;

class ButtonTitleInfoDataView;

class FormDataDataView;

class FormFieldDataPredictionsDataView;

class FormDataPredictionsDataView;

class PasswordAndMetadataDataView;

class PasswordFormFillDataDataView;

class PasswordFormGenerationDataDataView;

class PasswordGenerationUIDataDataView;

class TriggeringFieldDataView;

class PasswordSuggestionRequestDataView;

class ParsingResultDataView;



}  // autofill::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::autofill::mojom::FrameTokenDataView> {
  using Data = ::autofill::mojom::internal::FrameToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FrameTokenWithPredecessorDataView> {
  using Data = ::autofill::mojom::internal::FrameTokenWithPredecessor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormRendererIdDataView> {
  using Data = ::autofill::mojom::internal::FormRendererId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FieldRendererIdDataView> {
  using Data = ::autofill::mojom::internal::FieldRendererId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::SelectOptionDataView> {
  using Data = ::autofill::mojom::internal::SelectOption_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::AutocompleteParsingResultDataView> {
  using Data = ::autofill::mojom::internal::AutocompleteParsingResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormFieldDataDataView> {
  using Data = ::autofill::mojom::internal::FormFieldData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormFieldData_FillDataDataView> {
  using Data = ::autofill::mojom::internal::FormFieldData_FillData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::ButtonTitleInfoDataView> {
  using Data = ::autofill::mojom::internal::ButtonTitleInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormDataDataView> {
  using Data = ::autofill::mojom::internal::FormData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormFieldDataPredictionsDataView> {
  using Data = ::autofill::mojom::internal::FormFieldDataPredictions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormDataPredictionsDataView> {
  using Data = ::autofill::mojom::internal::FormDataPredictions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordAndMetadataDataView> {
  using Data = ::autofill::mojom::internal::PasswordAndMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordFormFillDataDataView> {
  using Data = ::autofill::mojom::internal::PasswordFormFillData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordFormGenerationDataDataView> {
  using Data = ::autofill::mojom::internal::PasswordFormGenerationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordGenerationUIDataDataView> {
  using Data = ::autofill::mojom::internal::PasswordGenerationUIData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::TriggeringFieldDataView> {
  using Data = ::autofill::mojom::internal::TriggeringField_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordSuggestionRequestDataView> {
  using Data = ::autofill::mojom::internal::PasswordSuggestionRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::ParsingResultDataView> {
  using Data = ::autofill::mojom::internal::ParsingResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace autofill::mojom {


enum class FormControlType : int32_t {
  
  kContentEditable = 0,
  
  kInputCheckbox = 1,
  
  kInputEmail = 2,
  
  kInputMonth = 3,
  
  kInputNumber = 4,
  
  kInputPassword = 5,
  
  kInputRadio = 6,
  
  kInputSearch = 7,
  
  kInputTelephone = 8,
  
  kInputText = 9,
  
  kInputUrl = 10,
  
  kSelectOne = 11,
  
  kTextArea = 14,
  
  kInputDate = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

 std::ostream& operator<<(std::ostream& os, FormControlType value);
inline bool IsKnownEnumValue(FormControlType value) {
  return internal::FormControlType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HtmlFieldMode : int32_t {
  
  kNone = 0,
  
  kBilling = 1,
  
  kShipping = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, HtmlFieldMode value);
inline bool IsKnownEnumValue(HtmlFieldMode value) {
  return internal::HtmlFieldMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HtmlFieldType : int32_t {
  
  kUnspecified = 0,
  
  kName = 1,
  
  kHonorificPrefix = 2,
  
  kGivenName = 3,
  
  kAdditionalName = 4,
  
  kFamilyName = 5,
  
  kOrganization = 6,
  
  kStreetAddress = 7,
  
  kAddressLine1 = 8,
  
  kAddressLine2 = 9,
  
  kAddressLine3 = 10,
  
  kAddressLevel1 = 11,
  
  kAddressLevel2 = 12,
  
  kAddressLevel3 = 13,
  
  kCountryCode = 14,
  
  kCountryName = 15,
  
  kPostalCode = 16,
  
  kCreditCardNameFull = 18,
  
  kCreditCardNameFirst = 19,
  
  kCreditCardNameLast = 20,
  
  kCreditCardNumber = 21,
  
  kCreditCardExp = 22,
  
  kCreditCardExpMonth = 23,
  
  kCreditCardExpYear = 24,
  
  kCreditCardVerificationCode = 25,
  
  kCreditCardType = 26,
  
  kTel = 27,
  
  kTelCountryCode = 28,
  
  kTelNational = 29,
  
  kTelAreaCode = 30,
  
  kTelLocal = 31,
  
  kTelLocalPrefix = 32,
  
  kTelLocalSuffix = 33,
  
  kTelExtension = 34,
  
  kEmail = 35,
  
  kBirthdateDay = 36,
  
  kBirthdateMonth = 37,
  
  kBirthdateYear = 38,
  
  kTransactionAmount = 39,
  
  kTransactionCurrency = 40,
  
  kAdditionalNameInitial = 41,
  
  kCreditCardExpDate2DigitYear = 42,
  
  kCreditCardExpDate4DigitYear = 43,
  
  kCreditCardExp2DigitYear = 44,
  
  kCreditCardExp4DigitYear = 45,
  
  kOneTimeCode = 47,
  
  kMerchantPromoCode = 48,
  
  kIban = 49,
  
  kUnrecognized = 50,
  kMinValue = 0,
  kMaxValue = 50,
};

 std::ostream& operator<<(std::ostream& os, HtmlFieldType value);
inline bool IsKnownEnumValue(HtmlFieldType value) {
  return internal::HtmlFieldType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubmissionIndicatorEvent : int32_t {
  
  NONE = 0,
  
  HTML_FORM_SUBMISSION = 1,
  
  SAME_DOCUMENT_NAVIGATION = 2,
  
  XHR_SUCCEEDED = 3,
  
  FRAME_DETACHED = 4,
  
  PROBABLE_FORM_SUBMISSION = 10,
  
  CHANGE_PASSWORD_FORM_CLEARED = 11,
  
  DOM_MUTATION_AFTER_AUTOFILL = 12,
  kMinValue = 0,
  kMaxValue = 12,
};

 std::ostream& operator<<(std::ostream& os, SubmissionIndicatorEvent value);
inline bool IsKnownEnumValue(SubmissionIndicatorEvent value) {
  return internal::SubmissionIndicatorEvent_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubmissionSource : int32_t {
  
  NONE = 0,
  
  SAME_DOCUMENT_NAVIGATION = 1,
  
  XHR_SUCCEEDED = 2,
  
  FRAME_DETACHED = 3,
  
  PROBABLY_FORM_SUBMITTED = 4,
  
  FORM_SUBMISSION = 5,
  
  DOM_MUTATION_AFTER_AUTOFILL = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, SubmissionSource value);
inline bool IsKnownEnumValue(SubmissionSource value) {
  return internal::SubmissionSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FocusedFieldType : int32_t {
  
  kUnknown = 0,
  
  kUnfillableElement = 1,
  
  kFillableTextArea = 2,
  
  kFillableSearchField = 3,
  
  kFillableNonSearchField = 4,
  
  kFillableWebauthnTaggedField = 5,
  
  kFillableUsernameField = 6,
  
  kFillablePasswordField = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, FocusedFieldType value);
inline bool IsKnownEnumValue(FocusedFieldType value) {
  return internal::FocusedFieldType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ButtonTitleType : int32_t {
  
  NONE = 0,
  
  BUTTON_ELEMENT_SUBMIT_TYPE = 1,
  
  BUTTON_ELEMENT_BUTTON_TYPE = 2,
  
  INPUT_ELEMENT_SUBMIT_TYPE = 3,
  
  INPUT_ELEMENT_BUTTON_TYPE = 4,
  
  HYPERLINK = 5,
  
  DIV = 6,
  
  SPAN = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, ButtonTitleType value);
inline bool IsKnownEnumValue(ButtonTitleType value) {
  return internal::ButtonTitleType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubmissionReadinessState : int32_t {
  
  kNoInformation = 0,
  
  kError = 1,
  
  kNoUsernameField = 2,
  
  kFieldBetweenUsernameAndPassword = 3,
  
  kFieldAfterPasswordField = 4,
  
  kEmptyFields = 5,
  
  kMoreThanTwoFields = 6,
  
  kTwoFields = 7,
  
  kNoPasswordField = 8,
  
  kLikelyHasCaptcha = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

 std::ostream& operator<<(std::ostream& os, SubmissionReadinessState value);
inline bool IsKnownEnumValue(SubmissionReadinessState value) {
  return internal::SubmissionReadinessState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutofillSuggestionAvailability : int32_t {
  
  kNoSuggestions = 0,
  
  kAutofillAvailable = 1,
  
  kAutocompleteAvailable = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AutofillSuggestionAvailability value);
inline bool IsKnownEnumValue(AutofillSuggestionAvailability value) {
  return internal::AutofillSuggestionAvailability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ActionPersistence : int32_t {
  
  kFill = 0,
  
  kPreview = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ActionPersistence value);
inline bool IsKnownEnumValue(ActionPersistence value) {
  return internal::ActionPersistence_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FormActionType : int32_t {
  
  kFill = 0,
  
  kUndo = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, FormActionType value);
inline bool IsKnownEnumValue(FormActionType value) {
  return internal::FormActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FieldActionType : int32_t {
  
  kReplaceAll = 0,
  
  kReplaceSelection = 1,
  
  kSelectAll = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FieldActionType value);
inline bool IsKnownEnumValue(FieldActionType value) {
  return internal::FieldActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutofillSuggestionTriggerSource : int32_t {
  
  kUnspecified = 0,
  
  kFormControlElementClicked = 1,
  
  kTextareaFocusedWithoutClick = 2,
  
  kContentEditableClicked = 3,
  
  kTextFieldValueChanged = 4,
  
  kTextFieldDidReceiveKeyDown = 5,
  
  kOpenTextDataListChooser = 6,
  
  kPasswordManager = 8,
  
  kiOS = 9,
  
  kManualFallbackPasswords = 12,
  
  kManualFallbackPlusAddresses = 13,
  
  kComposeDialogLostFocus = 15,
  
  kComposeDelayedProactiveNudge = 16,
  
  kPasswordManagerProcessedFocusedField = 17,
  
  kPlusAddressUpdatedInBrowserProcess = 19,
  
  kProactivePasswordRecovery = 20,
  kMinValue = 0,
  kMaxValue = 20,
};

 std::ostream& operator<<(std::ostream& os, AutofillSuggestionTriggerSource value);
inline bool IsKnownEnumValue(AutofillSuggestionTriggerSource value) {
  return internal::AutofillSuggestionTriggerSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FormFieldData_CheckStatus : int32_t {
  
  kNotCheckable = 0,
  
  kCheckableButUnchecked = 1,
  
  kChecked = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FormFieldData_CheckStatus value);
inline bool IsKnownEnumValue(FormFieldData_CheckStatus value) {
  return internal::FormFieldData_CheckStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FormFieldData_RoleAttribute : int32_t {
  
  kPresentation = 0,
  
  kOther = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, FormFieldData_RoleAttribute value);
inline bool IsKnownEnumValue(FormFieldData_RoleAttribute value) {
  return internal::FormFieldData_RoleAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FormFieldData_LabelSource : int32_t {
  
  kUnknown = 0,
  
  kLabelTag = 1,
  
  kPTag = 2,
  
  kDivTable = 3,
  
  kTdTag = 4,
  
  kDdTag = 5,
  
  kLiTag = 6,
  
  kPlaceHolder = 7,
  
  kAriaLabel = 8,
  
  kCombined = 9,
  
  kValue = 10,
  
  kForId = 11,
  
  kForName = 12,
  
  kForShadowHostId = 13,
  
  kForShadowHostName = 14,
  
  kOverlayingLabel = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

 std::ostream& operator<<(std::ostream& os, FormFieldData_LabelSource value);
inline bool IsKnownEnumValue(FormFieldData_LabelSource value) {
  return internal::FormFieldData_LabelSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FrameTokenDataView {
 public:
  FrameTokenDataView() = default;

  FrameTokenDataView(
      internal::FrameToken_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool is_local() const {
    return data_->is_local;
  }
 private:
  internal::FrameToken_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameTokenWithPredecessorDataView {
 public:
  FrameTokenWithPredecessorDataView() = default;

  FrameTokenWithPredecessorDataView(
      internal::FrameTokenWithPredecessor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  int32_t predecessor() const {
    return data_->predecessor;
  }
 private:
  internal::FrameTokenWithPredecessor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormRendererIdDataView {
 public:
  FormRendererIdDataView() = default;

  FormRendererIdDataView(
      internal::FormRendererId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::FormRendererId_Data* data_ = nullptr;
};


class FieldRendererIdDataView {
 public:
  FieldRendererIdDataView() = default;

  FieldRendererIdDataView(
      internal::FieldRendererId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::FieldRendererId_Data* data_ = nullptr;
};


class SelectOptionDataView {
 public:
  SelectOptionDataView() = default;

  SelectOptionDataView(
      internal::SelectOption_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectOption_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutocompleteParsingResultDataView {
 public:
  AutocompleteParsingResultDataView() = default;

  AutocompleteParsingResultDataView(
      internal::AutocompleteParsingResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSectionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSection(UserType* output) {
    
    auto* pointer = data_->section.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::autofill::mojom::HtmlFieldMode>(
        data_value, output);
  }
  HtmlFieldMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::HtmlFieldMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFieldType(UserType* output) const {
    auto data_value = data_->field_type;
    return mojo::internal::Deserialize<::autofill::mojom::HtmlFieldType>(
        data_value, output);
  }
  HtmlFieldType field_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::HtmlFieldType>(data_->field_type));
  }
  bool webauthn() const {
    return data_->webauthn;
  }
  bool webidentity() const {
    return data_->webidentity;
  }
 private:
  internal::AutocompleteParsingResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormFieldDataDataView {
 public:
  FormFieldDataDataView() = default;

  FormFieldDataDataView(
      internal::FormFieldData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIdAttributeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdAttribute(UserType* output) {
    
    auto* pointer = data_->id_attribute.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameAttributeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameAttribute(UserType* output) {
    
    auto* pointer = data_->name_attribute.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSelectedTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedText(UserType* output) {
    
    auto* pointer = data_->selected_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormControlType(UserType* output) const {
    auto data_value = data_->form_control_type;
    return mojo::internal::Deserialize<::autofill::mojom::FormControlType>(
        data_value, output);
  }
  FormControlType form_control_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::FormControlType>(data_->form_control_type));
  }
  inline void GetAutocompleteAttributeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAutocompleteAttribute(UserType* output) {
    
    auto* pointer = data_->autocomplete_attribute.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParsedAutocompleteDataView(
      AutocompleteParsingResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsedAutocomplete(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::autofill::mojom::AutocompleteParsingResultDataView, UserType>(),
    "Attempting to read the optional `parsed_autocomplete` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParsedAutocomplete` instead "
    "of `ReadParsedAutocomplete if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parsed_autocomplete.Get();
    return mojo::internal::Deserialize<::autofill::mojom::AutocompleteParsingResultDataView>(
        pointer, output, message_);
  }
  inline void GetPatternDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPattern(UserType* output) {
    
    auto* pointer = data_->pattern.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetPlaceholderDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlaceholder(UserType* output) {
    
    auto* pointer = data_->placeholder.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetCssClassesDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCssClasses(UserType* output) {
    
    auto* pointer = data_->css_classes.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAriaLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAriaLabel(UserType* output) {
    
    auto* pointer = data_->aria_label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAriaDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAriaDescription(UserType* output) {
    
    auto* pointer = data_->aria_description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNonceDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererId(UserType* output) {
    
    auto* pointer = data_->renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetHostFormIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostFormId(UserType* output) {
    
    auto* pointer = data_->host_form_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
  uint32_t properties_mask() const {
    return data_->properties_mask;
  }
  int32_t form_control_ax_id() const {
    return data_->form_control_ax_id;
  }
  uint64_t max_length() const {
    return data_->max_length;
  }
  bool is_user_edited() const {
    return data_->is_user_edited;
  }
  bool is_autofilled() const {
    return data_->is_autofilled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCheckStatus(UserType* output) const {
    auto data_value = data_->check_status;
    return mojo::internal::Deserialize<::autofill::mojom::FormFieldData_CheckStatus>(
        data_value, output);
  }
  FormFieldData_CheckStatus check_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::FormFieldData_CheckStatus>(data_->check_status));
  }
  bool is_focusable() const {
    return data_->is_focusable;
  }
  bool is_visible() const {
    return data_->is_visible;
  }
  bool should_autocomplete() const {
    return data_->should_autocomplete;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRole(UserType* output) const {
    auto data_value = data_->role;
    return mojo::internal::Deserialize<::autofill::mojom::FormFieldData_RoleAttribute>(
        data_value, output);
  }
  FormFieldData_RoleAttribute role() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::FormFieldData_RoleAttribute>(data_->role));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTextDirection(UserType* output) const {
    auto data_value = data_->text_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }
  ::mojo_base::mojom::TextDirection text_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::TextDirection>(data_->text_direction));
  }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  bool is_readonly() const {
    return data_->is_readonly;
  }
  inline void GetUserInputDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserInput(UserType* output) {
    
    auto* pointer = data_->user_input.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool allows_writing_suggestions() const {
    return data_->allows_writing_suggestions;
  }
  inline void GetOptionsDataView(
      mojo::ArrayDataView<SelectOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::SelectOptionDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLabelSource(UserType* output) const {
    auto data_value = data_->label_source;
    return mojo::internal::Deserialize<::autofill::mojom::FormFieldData_LabelSource>(
        data_value, output);
  }
  FormFieldData_LabelSource label_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::FormFieldData_LabelSource>(data_->label_source));
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetDatalistOptionsDataView(
      mojo::ArrayDataView<SelectOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDatalistOptions(UserType* output) {
    
    auto* pointer = data_->datalist_options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::SelectOptionDataView>>(
        pointer, output, message_);
  }
  bool force_override() const {
    return data_->force_override;
  }
 private:
  internal::FormFieldData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormFieldData_FillDataDataView {
 public:
  FormFieldData_FillDataDataView() = default;

  FormFieldData_FillDataDataView(
      internal::FormFieldData_FillData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererId(UserType* output) {
    
    auto* pointer = data_->renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetHostFormIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostFormId(UserType* output) {
    
    auto* pointer = data_->host_form_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
  bool is_autofilled() const {
    return data_->is_autofilled;
  }
  bool force_override() const {
    return data_->force_override;
  }
 private:
  internal::FormFieldData_FillData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ButtonTitleInfoDataView {
 public:
  ButtonTitleInfoDataView() = default;

  ButtonTitleInfoDataView(
      internal::ButtonTitleInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::autofill::mojom::ButtonTitleType>(
        data_value, output);
  }
  ButtonTitleType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::ButtonTitleType>(data_->type));
  }
 private:
  internal::ButtonTitleInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormDataDataView {
 public:
  FormDataDataView() = default;

  FormDataDataView(
      internal::FormData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdAttributeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdAttribute(UserType* output) {
    
    auto* pointer = data_->id_attribute.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameAttributeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameAttribute(UserType* output) {
    
    auto* pointer = data_->name_attribute.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetButtonTitlesDataView(
      mojo::ArrayDataView<ButtonTitleInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadButtonTitles(UserType* output) {
    
    auto* pointer = data_->button_titles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::ButtonTitleInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetActionDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool is_action_empty() const {
    return data_->is_action_empty;
  }
  inline void GetRendererIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererId(UserType* output) {
    
    auto* pointer = data_->renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetChildFramesDataView(
      mojo::ArrayDataView<FrameTokenWithPredecessorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildFrames(UserType* output) {
    
    auto* pointer = data_->child_frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FrameTokenWithPredecessorDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSubmissionEvent(UserType* output) const {
    auto data_value = data_->submission_event;
    return mojo::internal::Deserialize<::autofill::mojom::SubmissionIndicatorEvent>(
        data_value, output);
  }
  SubmissionIndicatorEvent submission_event() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::SubmissionIndicatorEvent>(data_->submission_event));
  }
  inline void GetFieldsDataView(
      mojo::ArrayDataView<FormFieldDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFields(UserType* output) {
    
    auto* pointer = data_->fields.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FormFieldDataDataView>>(
        pointer, output, message_);
  }
  inline void GetUsernamePredictionsDataView(
      mojo::ArrayDataView<FieldRendererIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernamePredictions(UserType* output) {
    
    auto* pointer = data_->username_predictions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FieldRendererIdDataView>>(
        pointer, output, message_);
  }
  bool is_gaia_with_skip_save_password_form() const {
    return data_->is_gaia_with_skip_save_password_form;
  }
  bool likely_contains_captcha() const {
    return data_->likely_contains_captcha;
  }
 private:
  internal::FormData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormFieldDataPredictionsDataView {
 public:
  FormFieldDataPredictionsDataView() = default;

  FormFieldDataPredictionsDataView(
      internal::FormFieldDataPredictions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostFormSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostFormSignature(UserType* output) {
    
    auto* pointer = data_->host_form_signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHeuristicTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeuristicType(UserType* output) {
    
    auto* pointer = data_->heuristic_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServerTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `server_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServerType` instead "
    "of `ReadServerType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->server_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHtmlTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHtmlType(UserType* output) {
    
    auto* pointer = data_->html_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOverallTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverallType(UserType* output) {
    
    auto* pointer = data_->overall_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAttributeTypesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributeTypes(UserType* output) {
    
    auto* pointer = data_->attribute_types.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFormatStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormatString(UserType* output) {
    
    auto* pointer = data_->format_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParseableNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseableName(UserType* output) {
    
    auto* pointer = data_->parseable_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParseableLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseableLabel(UserType* output) {
    
    auto* pointer = data_->parseable_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSectionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSection(UserType* output) {
    
    auto* pointer = data_->section.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t rank() const {
    return data_->rank;
  }
  uint32_t rank_in_signature_group() const {
    return data_->rank_in_signature_group;
  }
  uint32_t rank_in_host_form() const {
    return data_->rank_in_host_form;
  }
  uint32_t rank_in_host_form_signature_group() const {
    return data_->rank_in_host_form_signature_group;
  }
 private:
  internal::FormFieldDataPredictions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormDataPredictionsDataView {
 public:
  FormDataPredictionsDataView() = default;

  FormDataPredictionsDataView(
      internal::FormDataPredictions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      FormDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormDataDataView>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAlternativeSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlternativeSignature(UserType* output) {
    
    auto* pointer = data_->alternative_signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFieldsDataView(
      mojo::ArrayDataView<FormFieldDataPredictionsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFields(UserType* output) {
    
    auto* pointer = data_->fields.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FormFieldDataPredictionsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FormDataPredictions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordAndMetadataDataView {
 public:
  PasswordAndMetadataDataView() = default;

  PasswordAndMetadataDataView(
      internal::PasswordAndMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUsernameValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernameValue(UserType* output) {
    
    auto* pointer = data_->username_value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetPasswordValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordValue(UserType* output) {
    
    auto* pointer = data_->password_value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRealmDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRealm(UserType* output) {
    
    auto* pointer = data_->realm.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool uses_account_store() const {
    return data_->uses_account_store;
  }
  bool is_grouped_affiliation() const {
    return data_->is_grouped_affiliation;
  }
 private:
  internal::PasswordAndMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordFormFillDataDataView {
 public:
  PasswordFormFillDataDataView() = default;

  PasswordFormFillDataDataView(
      internal::PasswordFormFillData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFormRendererIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormRendererId(UserType* output) {
    
    auto* pointer = data_->form_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUsernameElementRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernameElementRendererId(UserType* output) {
    
    auto* pointer = data_->username_element_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetPasswordElementRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordElementRendererId(UserType* output) {
    
    auto* pointer = data_->password_element_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetPreferredLoginDataView(
      PasswordAndMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreferredLogin(UserType* output) {
    
    auto* pointer = data_->preferred_login.Get();
    return mojo::internal::Deserialize<::autofill::mojom::PasswordAndMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetAdditionalLoginsDataView(
      mojo::ArrayDataView<PasswordAndMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalLogins(UserType* output) {
    
    auto* pointer = data_->additional_logins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::PasswordAndMetadataDataView>>(
        pointer, output, message_);
  }
  bool wait_for_username() const {
    return data_->wait_for_username;
  }
  inline void GetSuggestionBannedFieldsDataView(
      mojo::ArrayDataView<FieldRendererIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestionBannedFields(UserType* output) {
    
    auto* pointer = data_->suggestion_banned_fields.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FieldRendererIdDataView>>(
        pointer, output, message_);
  }
  bool notify_browser_of_successful_filling() const {
    return data_->notify_browser_of_successful_filling;
  }
 private:
  internal::PasswordFormFillData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordFormGenerationDataDataView {
 public:
  PasswordFormGenerationDataDataView() = default;

  PasswordFormGenerationDataDataView(
      internal::PasswordFormGenerationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNewPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->new_password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetConfirmationPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfirmationPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->confirmation_password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::PasswordFormGenerationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordGenerationUIDataDataView {
 public:
  PasswordGenerationUIDataDataView() = default;

  PasswordGenerationUIDataDataView(
      internal::PasswordGenerationUIData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  int32_t max_length() const {
    return data_->max_length;
  }
  inline void GetGenerationElementDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerationElement(UserType* output) {
    
    auto* pointer = data_->generation_element.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetGenerationElementIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerationElementId(UserType* output) {
    
    auto* pointer = data_->generation_element_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  bool is_generation_element_password_type() const {
    return data_->is_generation_element_password_type;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTextDirection(UserType* output) const {
    auto data_value = data_->text_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }
  ::mojo_base::mojom::TextDirection text_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::TextDirection>(data_->text_direction));
  }
  inline void GetFormDataDataView(
      FormDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormData(UserType* output) {
    
    auto* pointer = data_->form_data.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormDataDataView>(
        pointer, output, message_);
  }
  bool generation_rejected() const {
    return data_->generation_rejected;
  }
 private:
  internal::PasswordGenerationUIData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TriggeringFieldDataView {
 public:
  TriggeringFieldDataView() = default;

  TriggeringFieldDataView(
      internal::TriggeringField_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggerSource(UserType* output) const {
    auto data_value = data_->trigger_source;
    return mojo::internal::Deserialize<::autofill::mojom::AutofillSuggestionTriggerSource>(
        data_value, output);
  }
  AutofillSuggestionTriggerSource trigger_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::AutofillSuggestionTriggerSource>(data_->trigger_source));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTextDirection(UserType* output) const {
    auto data_value = data_->text_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }
  ::mojo_base::mojom::TextDirection text_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::TextDirection>(data_->text_direction));
  }
  inline void GetTypedUsernameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTypedUsername(UserType* output) {
    
    auto* pointer = data_->typed_username.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool show_webauthn_credentials() const {
    return data_->show_webauthn_credentials;
  }
  bool show_identity_credentials() const {
    return data_->show_identity_credentials;
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
 private:
  internal::TriggeringField_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordSuggestionRequestDataView {
 public:
  PasswordSuggestionRequestDataView() = default;

  PasswordSuggestionRequestDataView(
      internal::PasswordSuggestionRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFieldDataView(
      TriggeringFieldDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadField(UserType* output) {
    
    auto* pointer = data_->field.Get();
    return mojo::internal::Deserialize<::autofill::mojom::TriggeringFieldDataView>(
        pointer, output, message_);
  }
  inline void GetFormDataDataView(
      FormDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormData(UserType* output) {
    
    auto* pointer = data_->form_data.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormDataDataView>(
        pointer, output, message_);
  }
  uint64_t username_field_index() const {
    return data_->username_field_index;
  }
  uint64_t password_field_index() const {
    return data_->password_field_index;
  }
 private:
  internal::PasswordSuggestionRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParsingResultDataView {
 public:
  ParsingResultDataView() = default;

  ParsingResultDataView(
      internal::ParsingResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUsernameRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernameRendererId(UserType* output) {
    
    auto* pointer = data_->username_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetNewPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->new_password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetConfirmPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfirmPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->confirm_password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::ParsingResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // autofill::mojom

#endif  // COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_DATA_VIEW_H_