// components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace autofill_ml_internals::mojom {
class SelectOptionDataView;

class MlFieldPredictionLogDataView;

class MlPredictionLogDataView;



}  // autofill_ml_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::autofill_ml_internals::mojom::SelectOptionDataView> {
  using Data = ::autofill_ml_internals::mojom::internal::SelectOption_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill_ml_internals::mojom::MlFieldPredictionLogDataView> {
  using Data = ::autofill_ml_internals::mojom::internal::MlFieldPredictionLog_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill_ml_internals::mojom::MlPredictionLogDataView> {
  using Data = ::autofill_ml_internals::mojom::internal::MlPredictionLog_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace autofill_ml_internals::mojom {


enum class OptimizationTarget : int32_t {
  
  kUnknown = 0,
  
  kAutofill = 1,
  
  kPassword = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, OptimizationTarget value);
inline bool IsKnownEnumValue(OptimizationTarget value) {
  return internal::OptimizationTarget_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;


class SelectOptionDataView {
 public:
  SelectOptionDataView() = default;

  SelectOptionDataView(
      internal::SelectOption_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectOption_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MlFieldPredictionLogDataView {
 public:
  MlFieldPredictionLogDataView() = default;

  MlFieldPredictionLogDataView(
      internal::MlFieldPredictionLog_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPlaceholderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlaceholder(UserType* output) {
    
    auto* pointer = data_->placeholder.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAutocompleteDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAutocomplete(UserType* output) {
    
    auto* pointer = data_->autocomplete.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFormControlTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormControlType(UserType* output) {
    
    auto* pointer = data_->form_control_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectOptionsDataView(
      mojo::ArrayDataView<SelectOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectOptions(UserType* output) {
    
    auto* pointer = data_->select_options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill_ml_internals::mojom::SelectOptionDataView>>(
        pointer, output, message_);
  }
  inline void GetProbabilitiesDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProbabilities(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `probabilities` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProbabilities` instead "
    "of `ReadProbabilities if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->probabilities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetTokenizedFieldRepresentationDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTokenizedFieldRepresentation(UserType* output) {
    
    auto* pointer = data_->tokenized_field_representation.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MlFieldPredictionLog_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MlPredictionLogDataView {
 public:
  MlPredictionLogDataView() = default;

  MlPredictionLogDataView(
      internal::MlPredictionLog_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFormSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormSignature(UserType* output) {
    
    auto* pointer = data_->form_signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFormUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormUrl(UserType* output) {
    
    auto* pointer = data_->form_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetModelOutputTypesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelOutputTypes(UserType* output) {
    
    auto* pointer = data_->model_output_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetFieldPredictionsDataView(
      mojo::ArrayDataView<MlFieldPredictionLogDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldPredictions(UserType* output) {
    
    auto* pointer = data_->field_predictions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill_ml_internals::mojom::MlFieldPredictionLogDataView>>(
        pointer, output, message_);
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetEndTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndTime(UserType* output) {
    
    auto* pointer = data_->end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOptimizationTarget(UserType* output) const {
    auto data_value = data_->optimization_target;
    return mojo::internal::Deserialize<::autofill_ml_internals::mojom::OptimizationTarget>(
        data_value, output);
  }
  OptimizationTarget optimization_target() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill_ml_internals::mojom::OptimizationTarget>(data_->optimization_target));
  }
 private:
  internal::MlPredictionLog_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // autofill_ml_internals::mojom

#endif  // COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_DATA_VIEW_H_