// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.cc.template is used to generate vector_icons.cc. Edit the former
// rather than the latter.

// Some of the icons in this target are passed over Mojo and thus rely on having
// a unique ID, so make sure there's a prefix that won't be reused elsewhere.
#define VECTOR_ICON_ID_PREFIX "chromeos_ui::"

#include "chromeos/ui/vector_icons/vector_icons.h"

#include "components/vector_icons/cc_macros.h"
#include "ui/gfx/vector_icon_types.h"

#define DECLARE_VECTOR_COMMAND(x) using gfx::x;
DECLARE_VECTOR_COMMANDS

namespace chromeos {

VECTOR_ICON_REP_TEMPLATE(kAssistantPath, CANVAS_DIMENSIONS, 192,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
CIRCLE, 172, 60, 12,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xEA, 0x43, 0x35,
CIRCLE, 136, 88, 24,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x05,
CIRCLE, 136, 148, 28,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
CIRCLE, 56, 64, 48)
VECTOR_ICON_TEMPLATE_CC(kAssistantRepList, kAssistantIcon, {kAssistantPath})
VECTOR_ICON_REP_TEMPLATE(kCalculatePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 6.25, 7.72,
H_LINE_TO, 11.25,
V_LINE_TO, 9.22,
H_LINE_TO, 6.25,
V_LINE_TO, 7.72,
CLOSE,
MOVE_TO, 18, 15.75,
H_LINE_TO, 13,
V_LINE_TO, 17.25,
H_LINE_TO, 18,
V_LINE_TO, 15.75,
CLOSE,
MOVE_TO, 13, 13.25,
H_LINE_TO, 18,
V_LINE_TO, 14.75,
H_LINE_TO, 13,
V_LINE_TO, 13.25,
CLOSE,
MOVE_TO, 8, 18,
H_LINE_TO, 9.5,
V_LINE_TO, 16,
H_LINE_TO, 11.5,
V_LINE_TO, 14.5,
H_LINE_TO, 9.5,
V_LINE_TO, 12.5,
H_LINE_TO, 8,
V_LINE_TO, 14.5,
H_LINE_TO, 6,
V_LINE_TO, 16,
H_LINE_TO, 8,
V_LINE_TO, 18,
CLOSE,
MOVE_TO, 15.5, 9.54,
LINE_TO, 14.09, 10.95,
LINE_TO, 13.03, 9.89,
LINE_TO, 14.44, 8.47,
LINE_TO, 13.03, 7.06,
LINE_TO, 14.09, 6,
LINE_TO, 15.5, 7.41,
LINE_TO, 16.91, 6,
LINE_TO, 17.97, 7.06,
LINE_TO, 16.56, 8.47,
LINE_TO, 17.97, 9.89,
LINE_TO, 16.91, 10.95,
LINE_TO, 15.5, 9.54,
CLOSE,
MOVE_TO, 5, 3,
H_LINE_TO, 19,
CUBIC_TO, 20.1, 3, 21, 3.9, 21, 5,
V_LINE_TO, 19,
CUBIC_TO, 21, 20.1, 20.1, 21, 19, 21,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 21, 3, 20.1, 3, 19,
V_LINE_TO, 5,
CUBIC_TO, 3, 3.9, 3.9, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 19,
H_LINE_TO, 19,
V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 19,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCalculateRepList, kCalculateIcon, {kCalculatePath})
VECTOR_ICON_REP_TEMPLATE(kConversionPathPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19, 15,
CUBIC_TO, 17.7, 15, 16.6, 15.84, 16.18, 17,
H_LINE_TO, 11,
CUBIC_TO, 9.9, 17, 9, 16.1, 9, 15,
CUBIC_TO, 9, 13.9, 9.9, 13, 11, 13,
H_LINE_TO, 13,
CUBIC_TO, 15.21, 13, 17, 11.21, 17, 9,
CUBIC_TO, 17, 6.79, 15.21, 5, 13, 5,
H_LINE_TO, 7.82,
CUBIC_TO, 7.4, 3.84, 6.3, 3, 5, 3,
CUBIC_TO, 3.34, 3, 2, 4.34, 2, 6,
CUBIC_TO, 2, 7.66, 3.34, 9, 5, 9,
CUBIC_TO, 6.3, 9, 7.4, 8.16, 7.82, 7,
H_LINE_TO, 13,
CUBIC_TO, 14.1, 7, 15, 7.9, 15, 9,
CUBIC_TO, 15, 10.1, 14.1, 11, 13, 11,
H_LINE_TO, 11,
CUBIC_TO, 8.79, 11, 7, 12.79, 7, 15,
CUBIC_TO, 7, 17.21, 8.79, 19, 11, 19,
H_LINE_TO, 16.18,
CUBIC_TO, 16.59, 20.16, 17.69, 21, 19, 21,
CUBIC_TO, 20.66, 21, 22, 19.66, 22, 18,
CUBIC_TO, 22, 16.34, 20.66, 15, 19, 15,
CLOSE,
MOVE_TO, 5, 7,
CUBIC_TO, 4.45, 7, 4, 6.55, 4, 6,
CUBIC_TO, 4, 5.45, 4.45, 5, 5, 5,
CUBIC_TO, 5.55, 5, 6, 5.45, 6, 6,
CUBIC_TO, 6, 6.55, 5.55, 7, 5, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kConversionPathRepList, kConversionPathIcon, {kConversionPathPath})
VECTOR_ICON_REP_TEMPLATE(kDictionaryPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.5, 11.79,
R_H_LINE_TO, 0.88,
R_LINE_TO, 0.46, -1.29,
R_H_LINE_TO, 2.06,
R_LINE_TO, 0.46, 1.29,
R_H_LINE_TO, 0.9,
LINE_TO, 6.33, 6.71,
R_H_LINE_TO, -0.91,
CLOSE,
MOVE_TO, 5.11, 9.77,
R_LINE_TO, 0.75, -2.12,
R_H_LINE_TO, 0.04,
R_LINE_TO, 0.75, 2.13,
CLOSE,
R_MOVE_TO, 6.65, -1.81,
V_LINE_TO, 6.38,
R_CUBIC_TO, 0.43, -0.14, 0.88, -0.24, 1.33, -0.3,
R_CUBIC_TO, 0.46, -0.06, 0.93, -0.09, 1.42, -0.09,
R_CUBIC_TO, 0.32, 0, 0.64, 0.02, 0.97, 0.05,
R_CUBIC_TO, 0.33, 0.04, 0.67, 0.09, 1.03, 0.16,
V_LINE_TO, 7.73,
R_ARC_TO, 11.87, 11.87, 0, 0, 0, -1.1, -0.21,
R_ARC_TO, 7.39, 7.39, 0, 0, 0, -0.89, -0.06,
R_CUBIC_TO, -0.47, 0, -0.94, 0.04, -1.39, 0.13,
R_CUBIC_TO, -0.46, 0.09, -0.91, 0.21, -1.35, 0.38,
CLOSE,
R_MOVE_TO, 0, 4.92,
R_V_LINE_TO, -1.58,
R_CUBIC_TO, 0.39, -0.12, 0.81, -0.23, 1.25, -0.3,
R_ARC_TO, 9.16, 9.16, 0, 0, 1, 1.5, -0.11,
R_CUBIC_TO, 0.38, 0, 0.73, 0.02, 1.05, 0.06,
R_CUBIC_TO, 0.33, 0.04, 0.65, 0.1, 0.95, 0.17,
R_V_LINE_TO, 1.54,
R_ARC_TO, 11.73, 11.73, 0, 0, 0, -1.1, -0.21,
R_ARC_TO, 6.68, 6.68, 0, 0, 0, -0.89, -0.06,
R_CUBIC_TO, -0.47, 0, -0.94, 0.04, -1.39, 0.13,
R_CUBIC_TO, -0.46, 0.08, -0.91, 0.21, -1.35, 0.38,
CLOSE,
R_MOVE_TO, 0, -2.46,
V_LINE_TO, 8.83,
R_ARC_TO, 9.45, 9.45, 0, 0, 1, 1.36, -0.31,
R_CUBIC_TO, 0.47, -0.07, 0.93, -0.1, 1.39, -0.1,
R_CUBIC_TO, 0.38, 0, 0.73, 0.02, 1.05, 0.06,
R_CUBIC_TO, 0.33, 0.04, 0.65, 0.1, 0.95, 0.17,
R_V_LINE_TO, 1.54,
R_ARC_TO, 7.19, 7.19, 0, 0, 0, -1.03, -0.21,
R_ARC_TO, 7.42, 7.42, 0, 0, 0, -2.31, 0.06,
R_ARC_TO, 9.42, 9.42, 0, 0, 0, -1.41, 0.38,
CLOSE,
MOVE_TO, 5.5, 14,
R_CUBIC_TO, 0.65, 0, 1.29, 0.08, 1.92, 0.25,
R_CUBIC_TO, 0.63, 0.17, 1.23, 0.38, 1.83, 0.63,
V_LINE_TO, 5.42,
R_ARC_TO, 7.79, 7.79, 0, 0, 0, -1.81, -0.69,
ARC_TO, 8.15, 8.15, 0, 0, 0, 5.5, 4.5,
R_CUBIC_TO, -0.52, 0, -1.02, 0.05, -1.53, 0.14,
R_ARC_TO, 6.44, 6.44, 0, 0, 0, -1.47, 0.45,
V_LINE_TO, 14.5,
R_CUBIC_TO, 0.48, -0.18, 0.98, -0.31, 1.48, -0.39,
CUBIC_TO, 4.48, 14.04, 4.98, 14, 5.5, 14,
CLOSE,
R_MOVE_TO, 5.25, 0.88,
R_ARC_TO, 9.92, 9.92, 0, 0, 1, 1.83, -0.64,
ARC_TO, 8.08, 8.08, 0, 0, 1, 14.5, 14,
R_CUBIC_TO, 0.52, 0, 1.02, 0.03, 1.53, 0.09,
R_CUBIC_TO, 0.51, 0.06, 1, 0.2, 1.47, 0.41,
V_LINE_TO, 5.08,
R_CUBIC_TO, -0.48, -0.18, -0.98, -0.32, -1.48, -0.43,
ARC_TO, 7.32, 7.32, 0, 0, 0, 14.5, 4.5,
R_CUBIC_TO, -0.67, 0, -1.31, 0.08, -1.94, 0.23,
R_ARC_TO, 7.79, 7.79, 0, 0, 0, -1.81, 0.69,
CLOSE,
MOVE_TO, 10, 17,
R_ARC_TO, 10.62, 10.62, 0, 0, 0, -2.14, -1.08,
ARC_TO, 6.74, 6.74, 0, 0, 0, 5.5, 15.5,
R_CUBIC_TO, -0.53, 0, -1.05, 0.05, -1.58, 0.16,
R_ARC_TO, 7.82, 7.82, 0, 0, 0, -1.52, 0.47,
R_ARC_TO, 0.97, 0.97, 0, 0, 1, -0.95, -0.07,
R_ARC_TO, 0.91, 0.91, 0, 0, 1, -0.45, -0.82,
V_LINE_TO, 4.75,
R_CUBIC_TO, 0, -0.19, 0.05, -0.37, 0.16, -0.54,
R_CUBIC_TO, 0.11, -0.16, 0.25, -0.29, 0.43, -0.37,
ARC_TO, 9.82, 9.82, 0, 0, 1, 3.5, 3.21,
R_ARC_TO, 9.73, 9.73, 0, 0, 1, 4.32, 0.07,
R_CUBIC_TO, 0.75, 0.19, 1.48, 0.47, 2.18, 0.84,
R_ARC_TO, 10.63, 10.63, 0, 0, 1, 2.19, -0.83,
ARC_TO, 9.13, 9.13, 0, 0, 1, 14.5, 3,
R_CUBIC_TO, 0.68, 0, 1.35, 0.07, 2, 0.21,
R_CUBIC_TO, 0.65, 0.14, 1.29, 0.35, 1.92, 0.63,
R_CUBIC_TO, 0.18, 0.09, 0.32, 0.21, 0.44, 0.38,
R_CUBIC_TO, 0.11, 0.17, 0.17, 0.35, 0.17, 0.54,
R_V_LINE_TO, 10.48,
R_CUBIC_TO, 0, 0.35, -0.11, 0.63, -0.32, 0.83,
R_CUBIC_TO, -0.22, 0.21, -0.44, 0.26, -0.68, 0.14,
R_ARC_TO, 7.5, 7.5, 0, 0, 0, -1.72, -0.54,
R_ARC_TO, 9.54, 9.54, 0, 0, 0, -1.8, -0.17,
R_CUBIC_TO, -0.82, 0, -1.6, 0.14, -2.35, 0.42,
R_CUBIC_TO, -0.75, 0.28, -1.46, 0.64, -2.14, 1.08,
CLOSE,
MOVE_TO, 5.88, 9.69,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDictionaryRepList, kDictionaryIcon, {kDictionaryPath})
VECTOR_ICON_REP_TEMPLATE(kEditorMenuElaboratePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 3.89, 18.31,
R_V_LINE_TO, -1.73,
R_H_LINE_TO, 12.23,
R_V_LINE_TO, 1.73,
CLOSE,
MOVE_TO, 10, 15.08,
R_LINE_TO, -3.13, -3.13,
R_LINE_TO, 1.17, -1.17,
R_LINE_TO, 1.14, 1.15,
V_LINE_TO, 8.08,
LINE_TO, 8.04, 9.22,
LINE_TO, 6.87, 8.06,
LINE_TO, 10, 4.93,
R_LINE_TO, 3.13, 3.13,
R_LINE_TO, -1.17, 1.17,
R_LINE_TO, -1.14, -1.14,
R_V_LINE_TO, 3.84,
R_LINE_TO, 1.14, -1.14,
R_LINE_TO, 1.17, 1.17,
CLOSE,
MOVE_TO, 3.89, 3.42,
R_V_LINE_TO, -1.73,
R_H_LINE_TO, 12.23,
R_V_LINE_TO, 1.73,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditorMenuElaborateRepList, kEditorMenuElaborateIcon, {kEditorMenuElaboratePath})
VECTOR_ICON_REP_TEMPLATE(kEditorMenuEmojifyPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 12.71, 9.29,
R_CUBIC_TO, 0.36, 0, 0.67, -0.13, 0.92, -0.38,
CUBIC_TO_SHORTHAND, 14, 8.36, 14, 8,
R_CUBIC_TO, 0, -0.36, -0.12, -0.66, -0.37, -0.91,
R_ARC_TO, 1.24, 1.24, 0, 0, 0, -0.91, -0.37,
R_CUBIC_TO, -0.36, 0, -0.66, 0.13, -0.91, 0.38,
R_CUBIC_TO, -0.25, 0.25, -0.37, 0.56, -0.37, 0.91,
R_CUBIC_TO, 0, 0.36, 0.13, 0.66, 0.38, 0.91,
R_CUBIC_TO, 0.25, 0.25, 0.55, 0.38, 0.91, 0.38,
CLOSE,
R_MOVE_TO, -5.42, 0,
R_CUBIC_TO, 0.36, 0, 0.66, -0.13, 0.91, -0.38,
R_CUBIC_TO, 0.25, -0.25, 0.37, -0.56, 0.37, -0.91,
R_CUBIC_TO, 0, -0.35, -0.12, -0.66, -0.37, -0.91,
R_CUBIC_TO, -0.25, -0.25, -0.55, -0.37, -0.91, -0.37,
R_CUBIC_TO, -0.36, 0, -0.66, 0.13, -0.91, 0.38,
CUBIC_TO_SHORTHAND, 6, 7.64, 6, 8,
R_CUBIC_TO, 0, 0.36, 0.13, 0.66, 0.38, 0.91,
R_CUBIC_TO, 0.25, 0.25, 0.56, 0.38, 0.91, 0.38,
CLOSE,
MOVE_TO, 10, 14,
R_CUBIC_TO, 0.85, 0, 1.63, -0.22, 2.33, -0.66,
R_ARC_TO, 4.61, 4.61, 0, 0, 0, 1.66, -1.79,
H_LINE_TO, 6.02,
R_CUBIC_TO, 0.4, 0.75, 0.95, 1.35, 1.66, 1.79,
R_CUBIC_TO, 0.7, 0.44, 1.48, 0.66, 2.33, 0.66,
CLOSE,
R_MOVE_TO, 0, 4.17,
R_ARC_TO, 7.96, 7.96, 0, 0, 1, -3.17, -0.64,
R_ARC_TO, 8.25, 8.25, 0, 0, 1, -2.61, -1.75,
R_ARC_TO, 8.25, 8.25, 0, 0, 1, -1.75, -2.61,
R_ARC_TO, 7.97, 7.97, 0, 0, 1, -0.64, -3.18,
R_CUBIC_TO, 0, -1.12, 0.21, -2.18, 0.64, -3.17,
R_ARC_TO, 8.29, 8.29, 0, 0, 1, 1.75, -2.6,
R_ARC_TO, 8.25, 8.25, 0, 0, 1, 2.61, -1.75,
R_ARC_TO, 7.97, 7.97, 0, 0, 1, 3.18, -0.64,
R_CUBIC_TO, 1.13, 0, 2.18, 0.21, 3.17, 0.64,
R_ARC_TO, 8.29, 8.29, 0, 0, 1, 2.6, 1.75,
R_ARC_TO, 8.26, 8.26, 0, 0, 1, 1.75, 2.6,
R_CUBIC_TO, 0.43, 0.99, 0.64, 2.05, 0.64, 3.17,
R_ARC_TO, 7.96, 7.96, 0, 0, 1, -0.64, 3.17,
R_ARC_TO, 8.25, 8.25, 0, 0, 1, -1.75, 2.61,
R_ARC_TO, 8.26, 8.26, 0, 0, 1, -2.6, 1.75,
R_ARC_TO, 7.93, 7.93, 0, 0, 1, -3.17, 0.64,
CLOSE,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, 0, 6.44,
R_CUBIC_TO, 1.79, 0, 3.31, -0.63, 4.56, -1.88,
CUBIC_TO_SHORTHAND, 16.44, 11.79, 16.44, 10,
R_CUBIC_TO, 0, -1.78, -0.63, -3.3, -1.88, -4.56,
CUBIC_TO, 13.31, 4.19, 11.79, 3.56, 10, 3.56,
R_CUBIC_TO, -1.78, 0, -3.3, 0.63, -4.56, 1.88,
CUBIC_TO, 4.19, 6.7, 3.56, 8.22, 3.56, 10,
R_CUBIC_TO, 0, 1.79, 0.63, 3.31, 1.88, 4.56,
CUBIC_TO_SHORTHAND, 8.22, 16.44, 10, 16.44,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditorMenuEmojifyRepList, kEditorMenuEmojifyIcon, {kEditorMenuEmojifyPath})
VECTOR_ICON_REP_TEMPLATE(kEditorMenuFormalizePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 3.56, 17.18,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.5,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -0.5, -1.22,
V_LINE_TO, 6.57,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.5, -1.22,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, 1.22, -0.51,
R_H_LINE_TO, 3.29,
V_LINE_TO, 3.42,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.51, -1.22,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, 1.23, -0.5,
R_H_LINE_TO, 2.85,
R_CUBIC_TO, 0.48, 0, 0.89, 0.17, 1.22, 0.51,
R_CUBIC_TO, 0.34, 0.34, 0.5, 0.74, 0.5, 1.22,
R_V_LINE_TO, 1.42,
R_H_LINE_TO, 3.29,
R_CUBIC_TO, 0.48, 0, 0.89, 0.17, 1.22, 0.51,
R_CUBIC_TO, 0.34, 0.34, 0.5, 0.75, 0.5, 1.22,
R_V_LINE_TO, 8.88,
R_CUBIC_TO, 0, 0.48, -0.17, 0.89, -0.5, 1.22,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -1.22, 0.5,
CLOSE,
R_MOVE_TO, 0, -1.73,
H_LINE_TO, 16.44,
V_LINE_TO, 6.57,
H_LINE_TO, 3.56,
CLOSE,
MOVE_TO, 8.57, 4.84,
R_H_LINE_TO, 2.85,
V_LINE_TO, 3.43,
H_LINE_TO, 8.57,
CLOSE,
MOVE_TO, 3.56, 15.46,
V_LINE_TO, 6.57,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditorMenuFormalizeRepList, kEditorMenuFormalizeIcon, {kEditorMenuFormalizePath})
VECTOR_ICON_REP_TEMPLATE(kEditorMenuPenSparkPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 5.4, 9.98,
R_CUBIC_TO, 0, -1.28, -0.45, -2.36, -1.34, -3.25,
CUBIC_TO, 3.17, 5.84, 2.09, 5.39, 0.81, 5.39,
R_CUBIC_TO, 1.28, 0, 2.37, -0.45, 3.25, -1.34,
R_CUBIC_TO, 0.89, -0.89, 1.34, -1.97, 1.34, -3.25,
R_CUBIC_TO, 0, 1.28, 0.45, 2.36, 1.34, 3.25,
R_CUBIC_TO, 0.89, 0.89, 1.98, 1.34, 3.25, 1.34,
R_CUBIC_TO, -1.28, 0, -2.36, 0.45, -3.25, 1.34,
R_CUBIC_TO, -0.89, 0.89, -1.33, 1.97, -1.33, 3.25,
CLOSE,
R_MOVE_TO, 0.01, 5.62,
R_H_LINE_TO, 0.98,
R_LINE_TO, 7.74, -7.74,
R_LINE_TO, -0.5, -0.52,
R_LINE_TO, -0.48, -0.46,
R_LINE_TO, -7.74, 7.74,
CLOSE,
R_MOVE_TO, -1.57, 1.57,
V_LINE_TO, 13.96,
R_LINE_TO, 10.43, -10.43,
R_CUBIC_TO, 0.31, -0.31, 0.68, -0.46, 1.11, -0.46,
R_CUBIC_TO, 0.43, 0, 0.8, 0.15, 1.11, 0.46,
R_LINE_TO, 1, 0.99,
R_ARC_TO, 1.5, 1.5, 0, 0, 1, 0.47, 1.12,
R_CUBIC_TO, 0, 0.44, -0.15, 0.81, -0.46, 1.11,
LINE_TO, 7.04, 17.18,
CLOSE,
MOVE_TO, 16.34, 5.59,
R_LINE_TO, -0.98, -0.94,
CLOSE,
R_MOVE_TO, -2.21, 2.27,
R_LINE_TO, -0.5, -0.52,
R_LINE_TO, -0.48, -0.46,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditorMenuPenSparkRepList, kEditorMenuPenSparkIcon, {kEditorMenuPenSparkPath})
VECTOR_ICON_REP_TEMPLATE(kEditorMenuProofreadPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 11.33, 17.17,
LINE_TO, 7.73, 13.54,
R_LINE_TO, 1.21, -1.21,
R_LINE_TO, 2.4, 2.42,
R_LINE_TO, 4.54, -4.54,
R_LINE_TO, 1.21, 1.21,
R_LINE_TO, -5.75, 5.75,
CLOSE,
MOVE_TO, 2.9, 12,
R_LINE_TO, 3.77, -10,
R_H_LINE_TO, 1.96,
R_LINE_TO, 3.79, 10,
H_LINE_TO, 10.5,
R_LINE_TO, -0.85, -2.54,
R_H_LINE_TO, -3.98,
LINE_TO, 4.75, 12,
H_LINE_TO, 2.9,
CLOSE,
R_MOVE_TO, 3.29, -4.02,
R_H_LINE_TO, 2.9,
LINE_TO, 7.67, 3.94,
R_H_LINE_TO, -0.08,
LINE_TO, 6.19, 7.98,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kEditorMenuProofreadRepList, kEditorMenuProofreadIcon, {kEditorMenuProofreadPath})
VECTOR_ICON_REP_TEMPLATE(kEditorMenuRephrasePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 7.5, 5.16,
LINE_TO, 5.84, 3.5,
R_LINE_TO, 1.66, -1.66,
LINE_TO, 9.16, 3.5,
LINE_TO, 7.5, 5.16,
CLOSE,
R_MOVE_TO, 9, 9.5,
LINE_TO, 14.84, 13,
R_LINE_TO, 1.66, -1.66,
LINE_TO, 18.17, 13,
R_LINE_TO, -1.66, 1.67,
CLOSE,
MOVE_TO, 4.44, 18.05,
R_LINE_TO, -2.48, -2.5,
R_ARC_TO, 0.82, 0.82, 0, 0, 1, -0.26, -0.6,
R_CUBIC_TO, 0, -0.23, 0.09, -0.43, 0.27, -0.61,
R_LINE_TO, 7.06, -7.06,
R_ARC_TO, 2.52, 2.52, 0, 0, 1, 1.85, -0.77,
R_CUBIC_TO, 0.73, 0, 1.35, 0.26, 1.86, 0.77,
R_CUBIC_TO, 0.51, 0.51, 0.77, 1.13, 0.77, 1.86,
R_ARC_TO, 2.52, 2.52, 0, 0, 1, -0.77, 1.86,
R_LINE_TO, -7.06, 7.06,
R_ARC_TO, 0.86, 0.86, 0, 0, 1, -0.62, 0.27,
R_ARC_TO, 0.84, 0.84, 0, 0, 1, -0.61, -0.26,
CLOSE,
R_MOVE_TO, 11.08, -9.99,
R_ARC_TO, 3.44, 3.44, 0, 0, 0, -1.04, -2.52,
R_ARC_TO, 3.44, 3.44, 0, 0, 0, -2.52, -1.04,
R_CUBIC_TO, 0.99, 0, 1.83, -0.35, 2.53, -1.04,
R_CUBIC_TO, 0.7, -0.69, 1.05, -1.54, 1.05, -2.53,
R_CUBIC_TO, 0, 0.99, 0.35, 1.84, 1.04, 2.53,
R_CUBIC_TO, 0.7, 0.7, 1.54, 1.04, 2.53, 1.04,
R_CUBIC_TO, -0.99, 0, -1.84, 0.35, -2.53, 1.05,
R_ARC_TO, 3.44, 3.44, 0, 0, 0, -1.04, 2.53,
CLOSE,
R_MOVE_TO, -5.56, 3.26,
R_LINE_TO, -0.32, -0.32,
R_LINE_TO, -0.32, -0.32,
R_LINE_TO, -0.32, -0.32,
R_LINE_TO, -0.32, -0.32,
R_LINE_TO, 0.64, 0.64,
R_LINE_TO, 0.63, 0.64,
CLOSE,
R_MOVE_TO, -4.9, 4.9,
R_LINE_TO, 4.9, -4.9,
R_LINE_TO, -1.27, -1.28,
R_LINE_TO, -4.9, 4.9,
R_LINE_TO, 1.28, 1.27,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditorMenuRephraseRepList, kEditorMenuRephraseIcon, {kEditorMenuRephrasePath})
VECTOR_ICON_REP_TEMPLATE(kEditorMenuShortenPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 9.18, 18.16,
V_LINE_TO, 16.06,
LINE_TO, 7.99, 17.25,
R_LINE_TO, -1.17, -1.18,
LINE_TO, 10, 12.89,
R_LINE_TO, 3.18, 3.18,
R_LINE_TO, -1.17, 1.18,
R_LINE_TO, -1.19, -1.2,
R_V_LINE_TO, 2.11,
CLOSE,
MOVE_TO, 4, 11.93,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 12,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 0, -2.5,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 12,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 6, -2.47,
LINE_TO, 6.82, 3.77,
R_LINE_TO, 1.17, -1.18,
R_LINE_TO, 1.19, 1.21,
V_LINE_TO, 1.7,
R_H_LINE_TO, 1.65,
R_V_LINE_TO, 2.11,
R_LINE_TO, 1.19, -1.21,
R_LINE_TO, 1.17, 1.18,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditorMenuShortenRepList, kEditorMenuShortenIcon, {kEditorMenuShortenPath})
VECTOR_ICON_REP_TEMPLATE(kEnterprisePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 16, 17,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 4, 6,
R_H_LINE_TO, -8,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
V_LINE_TO, 9,
R_H_LINE_TO, 8,
R_V_LINE_TO, 10,
CLOSE,
MOVE_TO, 8, 7,
R_H_LINE_TO, 2,
V_LINE_TO, 5,
H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
V_LINE_TO, 9,
H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
MOVE_TO, 4, 7,
R_H_LINE_TO, 2,
V_LINE_TO, 5,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
V_LINE_TO, 9,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 8, -12,
V_LINE_TO, 3,
H_LINE_TO, 2,
R_V_LINE_TO, 18,
R_H_LINE_TO, 20,
V_LINE_TO, 7,
H_LINE_TO, 12,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kEnterprise12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 8, 9,
R_H_LINE_TO, 1,
V_LINE_TO, 8,
H_LINE_TO, 8,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 1,
V_LINE_TO, 6,
H_LINE_TO, 8,
R_V_LINE_TO, 1,
CLOSE,
MOVE_TO, 4, 4,
R_H_LINE_TO, 1,
V_LINE_TO, 3,
H_LINE_TO, 4,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 5,
H_LINE_TO, 4,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 7,
H_LINE_TO, 4,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 9,
H_LINE_TO, 4,
R_V_LINE_TO, 1,
CLOSE,
MOVE_TO, 2, 4,
R_H_LINE_TO, 1,
V_LINE_TO, 3,
H_LINE_TO, 2,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 5,
H_LINE_TO, 2,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 7,
H_LINE_TO, 2,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 9,
H_LINE_TO, 2,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 4, -6,
V_LINE_TO, 2,
H_LINE_TO, 1,
R_V_LINE_TO, 9,
R_H_LINE_TO, 10,
V_LINE_TO, 4,
H_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 4, 6,
H_LINE_TO, 6,
V_LINE_TO, 9,
R_H_LINE_TO, 1,
V_LINE_TO, 8,
H_LINE_TO, 6,
V_LINE_TO, 7,
R_H_LINE_TO, 1,
V_LINE_TO, 6,
H_LINE_TO, 6,
V_LINE_TO, 5,
R_H_LINE_TO, 4,
R_V_LINE_TO, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEnterpriseRepList, kEnterpriseIcon, {kEnterprisePath}, {kEnterprise12Path})
VECTOR_ICON_REP_TEMPLATE(kFiletypeArchivePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 5,
H_LINE_TO, 8,
V_LINE_TO, 7,
H_LINE_TO, 10,
V_LINE_TO, 9,
H_LINE_TO, 8,
V_LINE_TO, 11,
H_LINE_TO, 10,
V_LINE_TO, 13,
H_LINE_TO, 12,
V_LINE_TO, 11,
H_LINE_TO, 10,
V_LINE_TO, 9,
H_LINE_TO, 12,
V_LINE_TO, 7,
H_LINE_TO, 10,
V_LINE_TO, 5,
CLOSE,
NEW_PATH,
MOVE_TO, 5, 3,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 3, 17, 3.9, 17, 5,
V_LINE_TO, 15,
CUBIC_TO, 17, 16.1, 16.1, 17, 15, 17,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 17, 3, 16.1, 3, 15,
V_LINE_TO, 5,
CUBIC_TO, 3, 3.9, 3.9, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 15,
H_LINE_TO, 15,
V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeArchiveRepList, kFiletypeArchiveIcon, {kFiletypeArchivePath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeAudioPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 16, 15,
CUBIC_TO, 16, 15.55, 15.55, 16, 15, 16,
H_LINE_TO, 14,
V_LINE_TO, 13,
H_LINE_TO, 16,
V_LINE_TO, 15,
CLOSE,
MOVE_TO, 6, 16,
H_LINE_TO, 5,
CUBIC_TO, 4.45, 16, 4, 15.55, 4, 15,
V_LINE_TO, 13,
H_LINE_TO, 6,
V_LINE_TO, 16,
CLOSE,
MOVE_TO, 2, 9,
V_LINE_TO, 15,
CUBIC_TO, 2, 16.66, 3.34, 18, 5, 18,
H_LINE_TO, 8,
V_LINE_TO, 11,
H_LINE_TO, 4,
V_LINE_TO, 9,
CUBIC_TO, 4, 5.13, 6.13, 4, 10, 4,
CUBIC_TO, 13.87, 4, 16, 5.13, 16, 9,
V_LINE_TO, 11,
H_LINE_TO, 12,
V_LINE_TO, 18,
H_LINE_TO, 15,
CUBIC_TO, 16.66, 18, 18, 16.66, 18, 15,
V_LINE_TO, 9,
CUBIC_TO, 18, 4.03, 14.97, 2, 10, 2,
CUBIC_TO, 5.03, 2, 2, 4.03, 2, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeAudioRepList, kFiletypeAudioIcon, {kFiletypeAudioPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeChartPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 14, 11,
H_LINE_TO, 12,
V_LINE_TO, 14,
H_LINE_TO, 14,
V_LINE_TO, 11,
CLOSE,
NEW_PATH,
MOVE_TO, 9, 7,
H_LINE_TO, 11,
V_LINE_TO, 14,
H_LINE_TO, 9,
V_LINE_TO, 7,
CLOSE,
NEW_PATH,
MOVE_TO, 8, 9,
H_LINE_TO, 6,
V_LINE_TO, 14,
H_LINE_TO, 8,
V_LINE_TO, 9,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 15, 15,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 15,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeChartRepList, kFiletypeChartIcon, {kFiletypeChartPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeExcelPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 6.5, 7,
H_LINE_TO, 8.5,
LINE_TO, 10, 8.8,
LINE_TO, 11.5, 7,
H_LINE_TO, 13.5,
LINE_TO, 11, 10,
LINE_TO, 13.5, 13,
H_LINE_TO, 11.5,
LINE_TO, 10, 11.2,
LINE_TO, 8.5, 13,
H_LINE_TO, 6.5,
LINE_TO, 9, 10,
LINE_TO, 6.5, 7,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 15, 5,
V_LINE_TO, 15,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeExcelRepList, kFiletypeExcelIcon, {kFiletypeExcelPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeFolderPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 16, 5,
H_LINE_TO, 12,
LINE_TO, 10, 3,
H_LINE_TO, 4,
CUBIC_TO, 2.9, 3, 2.01, 3.9, 2.01, 5,
LINE_TO, 2, 15,
CUBIC_TO, 2, 16.1, 2.9, 17, 4, 17,
H_LINE_TO, 16,
CUBIC_TO, 17.1, 17, 18, 16.1, 18, 15,
V_LINE_TO, 7,
CUBIC_TO, 18, 5.9, 17.1, 5, 16, 5,
CLOSE,
MOVE_TO, 16, 15,
H_LINE_TO, 4,
V_LINE_TO, 7,
H_LINE_TO, 16,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeFolderRepList, kFiletypeFolderIcon, {kFiletypeFolderPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGdocPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 7, 7,
H_LINE_TO, 13,
V_LINE_TO, 9,
H_LINE_TO, 7,
V_LINE_TO, 7,
CLOSE,
NEW_PATH,
MOVE_TO, 11, 10,
H_LINE_TO, 7,
V_LINE_TO, 12,
H_LINE_TO, 11,
V_LINE_TO, 10,
CLOSE,
NEW_PATH,
MOVE_TO, 5, 3,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 3, 17, 3.9, 17, 5,
V_LINE_TO, 15,
CUBIC_TO, 17, 16.1, 16.1, 17, 15, 17,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 17, 3, 16.1, 3, 15,
V_LINE_TO, 5,
CUBIC_TO, 3, 3.9, 3.9, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 15,
H_LINE_TO, 15,
V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGdocRepList, kFiletypeGdocIcon, {kFiletypeGdocPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGdrawPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 10,
H_LINE_TO, 13.5,
V_LINE_TO, 13.5,
H_LINE_TO, 10,
V_LINE_TO, 10,
CLOSE,
NEW_PATH,
MOVE_TO, 10.5, 8.5,
CUBIC_TO, 10.5, 9.6, 9.6, 10.5, 8.5, 10.5,
CUBIC_TO, 7.4, 10.5, 6.5, 9.6, 6.5, 8.5,
CUBIC_TO, 6.5, 7.4, 7.4, 6.5, 8.5, 6.5,
CUBIC_TO, 9.6, 6.5, 10.5, 7.4, 10.5, 8.5,
CLOSE,
NEW_PATH,
MOVE_TO, 5, 3,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 3, 17, 3.9, 17, 5,
V_LINE_TO, 15,
CUBIC_TO, 17, 16.1, 16.1, 17, 15, 17,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 17, 3, 16.1, 3, 15,
V_LINE_TO, 5,
CUBIC_TO, 3, 3.9, 3.9, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 15,
H_LINE_TO, 15,
V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGdrawRepList, kFiletypeGdrawIcon, {kFiletypeGdrawPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGenericPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 5, 2,
CUBIC_TO, 4.45, 2, 4, 2.45, 4, 3,
V_LINE_TO, 17,
CUBIC_TO, 4, 17.55, 4.45, 18, 5, 18,
H_LINE_TO, 15,
CUBIC_TO, 15.55, 18, 16, 17.55, 16, 17,
V_LINE_TO, 7,
LINE_TO, 11, 2,
H_LINE_TO, 5,
CLOSE,
MOVE_TO, 10, 8,
V_LINE_TO, 4,
H_LINE_TO, 6,
V_LINE_TO, 16,
H_LINE_TO, 14,
V_LINE_TO, 8,
H_LINE_TO, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGenericRepList, kFiletypeGenericIcon, {kFiletypeGenericPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGformPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 9, 7,
H_LINE_TO, 14,
V_LINE_TO, 9,
H_LINE_TO, 9,
V_LINE_TO, 7,
CLOSE,
NEW_PATH,
MOVE_TO, 14, 10,
H_LINE_TO, 9,
V_LINE_TO, 12,
H_LINE_TO, 14,
V_LINE_TO, 10,
CLOSE,
NEW_PATH,
MOVE_TO, 6, 7,
H_LINE_TO, 8,
V_LINE_TO, 9,
H_LINE_TO, 6,
V_LINE_TO, 7,
CLOSE,
NEW_PATH,
MOVE_TO, 8, 10,
H_LINE_TO, 6,
V_LINE_TO, 12,
H_LINE_TO, 8,
V_LINE_TO, 10,
CLOSE,
NEW_PATH,
MOVE_TO, 5, 3,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 3, 17, 3.9, 17, 5,
V_LINE_TO, 15,
CUBIC_TO, 17, 16.1, 16.1, 17, 15, 17,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 17, 3, 16.1, 3, 15,
V_LINE_TO, 5,
CUBIC_TO, 3, 3.9, 3.9, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 15,
H_LINE_TO, 15,
V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGformRepList, kFiletypeGformIcon, {kFiletypeGformPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGmaillayoutPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 6.4, 13.21,
R_H_LINE_TO, 1.12,
V_LINE_TO, 9.66,
LINE_TO, 10, 11.43,
R_LINE_TO, 2.46, -1.77,
R_V_LINE_TO, 3.55,
R_H_LINE_TO, 1.05,
R_ARC_TO, 0.7, 0.7, 0, 0, 0, 0.43, -0.14,
R_ARC_TO, 0.43, 0.43, 0, 0, 0, 0.18, -0.37,
V_LINE_TO, 7.6,
R_ARC_TO, 0.7, 0.7, 0, 0, 0, -0.27, -0.57,
R_ARC_TO, 0.95, 0.95, 0, 0, 0, -0.62, -0.23,
R_LINE_TO, -0.3, 0.03,
R_ARC_TO, 0.71, 0.71, 0, 0, 0, -0.26, 0.13,
R_LINE_TO, -2.69, 2.2,
R_LINE_TO, -2.61, -2.13,
R_ARC_TO, 1.19, 1.19, 0, 0, 0, -0.29, -0.16,
R_ARC_TO, 0.93, 0.93, 0, 0, 0, -0.33, -0.06,
R_ARC_TO, 0.91, 0.91, 0, 0, 0, -0.62, 0.22,
R_ARC_TO, 0.7, 0.7, 0, 0, 0, -0.25, 0.56,
R_V_LINE_TO, 5.08,
R_CUBIC_TO, 0, 0.14, 0.05, 0.26, 0.15, 0.37,
R_CUBIC_TO, 0.11, 0.11, 0.23, 0.17, 0.37, 0.17,
CLOSE,
MOVE_TO, 4.93, 17,
R_CUBIC_TO, -0.54, 0, -1, -0.19, -1.37, -0.56,
ARC_TO, 1.86, 1.86, 0, 0, 1, 3, 15.07,
V_LINE_TO, 4.93,
R_CUBIC_TO, 0, -0.54, 0.19, -1, 0.56, -1.37,
CUBIC_TO, 3.94, 3.2, 4.4, 3, 4.93, 3,
R_H_LINE_TO, 10.14,
R_CUBIC_TO, 0.54, 0, 1, 0.19, 1.37, 0.56,
R_CUBIC_TO, 0.37, 0.38, 0.56, 0.83, 0.56, 1.37,
R_V_LINE_TO, 10.14,
R_CUBIC_TO, 0, 0.54, -0.19, 1, -0.56, 1.37,
R_CUBIC_TO, -0.38, 0.37, -0.83, 0.56, -1.37, 0.56,
H_LINE_TO, 4.93,
CLOSE,
R_MOVE_TO, 0, -1.93,
R_H_LINE_TO, 10.14,
V_LINE_TO, 4.93,
H_LINE_TO, 4.93,
R_V_LINE_TO, 10.14,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGmaillayoutRepList, kFiletypeGmaillayoutIcon, {kFiletypeGmaillayoutPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGmapPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10.18, 13.79,
CUBIC_TO, 12.07, 11.61, 13, 9.97, 13, 8.97,
CUBIC_TO, 13, 7.33, 11.66, 6, 10, 6,
CUBIC_TO, 8.34, 6, 7, 7.33, 7, 8.97,
CUBIC_TO, 7, 9.97, 7.93, 11.61, 9.82, 13.79,
LINE_TO, 10, 14,
LINE_TO, 10.18, 13.79,
CLOSE,
MOVE_TO, 10, 10,
CUBIC_TO, 10.55, 10, 11, 9.55, 11, 9,
CUBIC_TO, 11, 8.45, 10.55, 8, 10, 8,
CUBIC_TO, 9.45, 8, 9, 8.45, 9, 9,
CUBIC_TO, 9, 9.55, 9.45, 10, 10, 10,
CLOSE,
NEW_PATH,
MOVE_TO, 5, 3,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 3, 17, 3.9, 17, 5,
V_LINE_TO, 15,
CUBIC_TO, 17, 16.1, 16.1, 17, 15, 17,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 17, 3, 16.1, 3, 15,
V_LINE_TO, 5,
CUBIC_TO, 3, 3.9, 3.9, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 5,
V_LINE_TO, 15,
H_LINE_TO, 15,
V_LINE_TO, 5,
H_LINE_TO, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGmapRepList, kFiletypeGmapIcon, {kFiletypeGmapPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGsheetPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 5, 3,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 3, 17, 3.9, 17, 5,
V_LINE_TO, 15,
CUBIC_TO, 17, 16.1, 16.1, 17, 15, 17,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 17, 3, 16.1, 3, 15,
V_LINE_TO, 5,
CUBIC_TO, 3, 3.9, 3.9, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 15,
H_LINE_TO, 15,
V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 15,
CLOSE,
MOVE_TO, 10, 6,
H_LINE_TO, 8,
V_LINE_TO, 8,
H_LINE_TO, 6,
V_LINE_TO, 10,
H_LINE_TO, 8,
V_LINE_TO, 14,
H_LINE_TO, 10,
V_LINE_TO, 10,
H_LINE_TO, 14,
V_LINE_TO, 8,
H_LINE_TO, 10,
V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGsheetRepList, kFiletypeGsheetIcon, {kFiletypeGsheetPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGsitePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 14, 7,
H_LINE_TO, 6,
V_LINE_TO, 9,
H_LINE_TO, 14,
V_LINE_TO, 7,
CLOSE,
NEW_PATH,
MOVE_TO, 6, 10,
H_LINE_TO, 10,
V_LINE_TO, 13,
H_LINE_TO, 6,
V_LINE_TO, 10,
CLOSE,
NEW_PATH,
MOVE_TO, 14, 10,
H_LINE_TO, 11,
V_LINE_TO, 13,
H_LINE_TO, 14,
V_LINE_TO, 10,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 5, 15,
V_LINE_TO, 5,
H_LINE_TO, 15,
V_LINE_TO, 15,
H_LINE_TO, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGsiteRepList, kFiletypeGsiteIcon, {kFiletypeGsitePath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGslidesPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 14, 7,
H_LINE_TO, 6,
V_LINE_TO, 13,
H_LINE_TO, 14,
V_LINE_TO, 7,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 15, 15,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 15,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGslidesRepList, kFiletypeGslidesIcon, {kFiletypeGslidesPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeGtablePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 8, 9,
LINE_TO, 6, 11,
V_LINE_TO, 13.5,
LINE_TO, 8, 11.5,
LINE_TO, 10, 13.5,
LINE_TO, 14, 9.51,
V_LINE_TO, 7.01,
LINE_TO, 10, 11,
LINE_TO, 8, 9,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 15, 5,
V_LINE_TO, 15,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeGtableRepList, kFiletypeGtableIcon, {kFiletypeGtablePath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeImagePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 15, 15,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 15,
V_LINE_TO, 15,
CLOSE,
MOVE_TO, 11.33, 9,
LINE_TO, 9.5, 12,
LINE_TO, 8, 10.6,
LINE_TO, 6, 14,
H_LINE_TO, 14,
LINE_TO, 11.33, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeImageRepList, kFiletypeImageIcon, {kFiletypeImagePath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeLinuxPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 8.34, 7.81,
CUBIC_TO, 8.34, 8.28, 7.97, 8.66, 7.52, 8.66,
CUBIC_TO, 7.06, 8.66, 6.69, 8.28, 6.69, 7.81,
CUBIC_TO, 6.69, 7.34, 7.06, 6.96, 7.52, 6.96,
CUBIC_TO, 7.97, 6.96, 8.34, 7.34, 8.34, 7.81,
CLOSE,
NEW_PATH,
MOVE_TO, 12.48, 8.66,
CUBIC_TO, 12.94, 8.66, 13.31, 8.28, 13.31, 7.81,
CUBIC_TO, 13.31, 7.34, 12.94, 6.96, 12.48, 6.96,
CUBIC_TO, 12.03, 6.96, 11.66, 7.34, 11.66, 7.81,
CUBIC_TO, 11.66, 8.28, 12.03, 8.66, 12.48, 8.66,
CLOSE,
NEW_PATH,
MOVE_TO, 9.83, 9.12,
CUBIC_TO, 9.93, 9.08, 10.05, 9.08, 10.15, 9.12,
LINE_TO, 11.29, 9.63,
CUBIC_TO, 11.48, 9.72, 11.57, 9.96, 11.48, 10.16,
CUBIC_TO, 11.47, 10.2, 11.44, 10.23, 11.41, 10.26,
LINE_TO, 10.29, 11.51,
CUBIC_TO, 10.14, 11.67, 9.89, 11.68, 9.73, 11.54,
CUBIC_TO, 9.73, 11.53, 9.72, 11.52, 9.71, 11.51,
LINE_TO, 8.58, 10.26,
CUBIC_TO, 8.44, 10.1, 8.45, 9.85, 8.61, 9.7,
CUBIC_TO, 8.64, 9.67, 8.68, 9.65, 8.71, 9.63,
LINE_TO, 9.83, 9.12,
CLOSE,
NEW_PATH,
MOVE_TO, 10, 17.22,
CUBIC_TO, 9.93, 17.22, 9.86, 17.27, 9.8, 17.32,
CUBIC_TO, 9.77, 17.34, 9.75, 17.36, 9.72, 17.38,
CUBIC_TO, 9.69, 17.7, 9.45, 18, 8.07, 18,
CUBIC_TO, 6.38, 18, 6.39, 17.65, 6.42, 17.18,
CUBIC_TO, 6.42, 17.13, 6.43, 17.07, 6.43, 17.01,
CUBIC_TO, 6.43, 16.93, 6.44, 16.85, 6.47, 16.79,
CUBIC_TO, 4.51, 15.97, 3.26, 14.33, 3.22, 11.46,
CUBIC_TO, 3.02, 11.56, 2.79, 11.58, 2.53, 11.48,
CUBIC_TO, 1.79, 11.2, 1.96, 10.27, 2.23, 9.45,
CUBIC_TO, 2.46, 8.76, 3.22, 8.26, 3.6, 8.16,
CUBIC_TO, 4.48, 4.7, 6.54, 2, 10, 2,
CUBIC_TO, 13.51, 2, 15.58, 4.59, 16.43, 8.17,
CUBIC_TO, 16.82, 8.29, 17.55, 8.78, 17.77, 9.45,
CUBIC_TO, 18.04, 10.27, 18.21, 11.2, 17.47, 11.48,
CUBIC_TO, 17.21, 11.58, 16.98, 11.56, 16.79, 11.46,
CUBIC_TO, 16.75, 14.34, 15.49, 15.98, 13.53, 16.79,
CUBIC_TO, 13.56, 16.86, 13.57, 16.93, 13.57, 17.01,
CUBIC_TO, 13.57, 17.07, 13.58, 17.13, 13.58, 17.18,
CUBIC_TO, 13.61, 17.65, 13.62, 18, 11.93, 18,
CUBIC_TO, 10.54, 18, 10.31, 17.7, 10.28, 17.37,
CUBIC_TO, 10.26, 17.35, 10.23, 17.34, 10.21, 17.32,
CUBIC_TO, 10.14, 17.27, 10.07, 17.22, 10, 17.22,
CLOSE,
MOVE_TO, 10, 15.56,
CUBIC_TO, 13.66, 15.56, 14.98, 13.96, 14.98, 10.41,
CUBIC_TO, 14.98, 7.47, 13.78, 4.76, 11.79, 4.31,
CUBIC_TO, 11.46, 4.24, 11.19, 4.61, 10.9, 4.99,
CUBIC_TO, 10.63, 5.36, 10.35, 5.74, 10, 5.74,
CUBIC_TO, 9.65, 5.74, 9.34, 5.34, 9.05, 4.97,
CUBIC_TO, 8.77, 4.59, 8.5, 4.24, 8.21, 4.31,
CUBIC_TO, 6.22, 4.82, 5.02, 7.62, 5.02, 10.41,
CUBIC_TO, 5.02, 13.76, 6.34, 15.56, 10, 15.56,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeLinuxRepList, kFiletypeLinuxIcon, {kFiletypeLinuxPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypePdfPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 6, 8.5,
CUBIC_TO, 6, 8.48, 6, 8.47, 6, 8.45,
CUBIC_TO, 6.03, 8.2, 6.24, 8, 6.5, 8,
H_LINE_TO, 7.9,
CUBIC_TO, 8.18, 8, 8.4, 8.22, 8.4, 8.5,
V_LINE_TO, 9.9,
CUBIC_TO, 8.4, 10.18, 8.18, 10.4, 7.9, 10.4,
H_LINE_TO, 6.8,
V_LINE_TO, 12,
H_LINE_TO, 6,
V_LINE_TO, 8.5,
CLOSE,
MOVE_TO, 6.8, 8.8,
V_LINE_TO, 9.6,
H_LINE_TO, 7.6,
V_LINE_TO, 8.8,
H_LINE_TO, 6.8,
CLOSE,
NEW_PATH,
MOVE_TO, 9.3, 8,
CUBIC_TO, 9.02, 8, 8.8, 8.22, 8.8, 8.5,
V_LINE_TO, 12,
H_LINE_TO, 10.7,
CUBIC_TO, 10.98, 12, 11.2, 11.78, 11.2, 11.5,
V_LINE_TO, 8.5,
CUBIC_TO, 11.2, 8.22, 10.98, 8, 10.7, 8,
H_LINE_TO, 9.3,
CLOSE,
MOVE_TO, 10.4, 8.8,
H_LINE_TO, 9.6,
V_LINE_TO, 11.2,
H_LINE_TO, 10.4,
V_LINE_TO, 8.8,
CLOSE,
NEW_PATH,
MOVE_TO, 11.6, 8.4,
CUBIC_TO, 11.6, 8.18, 11.78, 8, 12, 8,
H_LINE_TO, 14,
V_LINE_TO, 8.8,
H_LINE_TO, 12.4,
V_LINE_TO, 9.6,
H_LINE_TO, 13.2,
V_LINE_TO, 10.4,
H_LINE_TO, 12.4,
V_LINE_TO, 12,
H_LINE_TO, 11.6,
LINE_TO, 11.6, 8.4,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 15, 15,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 15,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypePdfRepList, kFiletypePdfIcon, {kFiletypePdfPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypePptPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 11, 11.5,
CUBIC_TO, 12.1, 11.5, 13, 10.62, 13, 9.5,
V_LINE_TO, 9,
CUBIC_TO, 13, 8.45, 12.78, 7.95, 12.42, 7.59,
CUBIC_TO, 12.06, 7.22, 11.56, 7, 11, 7,
H_LINE_TO, 7,
V_LINE_TO, 13,
H_LINE_TO, 8.5,
V_LINE_TO, 11.5,
H_LINE_TO, 11,
CLOSE,
MOVE_TO, 11, 8.5,
CUBIC_TO, 11.28, 8.5, 11.5, 8.72, 11.5, 9,
V_LINE_TO, 9.5,
CUBIC_TO, 11.5, 9.78, 11.29, 10, 11, 10,
LINE_TO, 11, 10,
LINE_TO, 11, 10,
H_LINE_TO, 8.5,
V_LINE_TO, 8.5,
H_LINE_TO, 11,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 15, 5,
V_LINE_TO, 15,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypePptRepList, kFiletypePptIcon, {kFiletypePptPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeScriptPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 5, 11,
V_LINE_TO, 15,
H_LINE_TO, 15,
V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 9,
H_LINE_TO, 9.71,
LINE_TO, 7.76, 7.13,
LINE_TO, 8.91, 6,
LINE_TO, 13, 10,
LINE_TO, 8.91, 14,
LINE_TO, 7.76, 12.87,
LINE_TO, 9.63, 11,
H_LINE_TO, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeScriptRepList, kFiletypeScriptIcon, {kFiletypeScriptPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeSharedPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10.5, 10,
CUBIC_TO, 10.5, 9.18, 11.18, 8.5, 12, 8.5,
CUBIC_TO, 12.83, 8.5, 13.5, 9.18, 13.5, 10,
CUBIC_TO, 13.5, 10.83, 12.83, 11.5, 12, 11.5,
CUBIC_TO, 11.18, 11.5, 10.5, 10.83, 10.5, 10,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 13.33,
V_LINE_TO, 14,
H_LINE_TO, 9,
V_LINE_TO, 13.33,
CUBIC_TO, 9, 12.45, 11, 12, 12, 12,
CUBIC_TO, 13, 12, 15, 12.45, 15, 13.33,
CLOSE,
NEW_PATH,
MOVE_TO, 16, 5,
H_LINE_TO, 12,
LINE_TO, 10, 3,
H_LINE_TO, 4,
CUBIC_TO, 2.9, 3, 2.01, 3.9, 2.01, 5,
LINE_TO, 2, 15,
CUBIC_TO, 2, 16.1, 2.9, 17, 4, 17,
H_LINE_TO, 16,
CUBIC_TO, 17.1, 17, 18, 16.1, 18, 15,
V_LINE_TO, 7,
CUBIC_TO, 18, 5.9, 17.1, 5, 16, 5,
CLOSE,
MOVE_TO, 4, 15,
V_LINE_TO, 7,
H_LINE_TO, 16,
V_LINE_TO, 15,
H_LINE_TO, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeSharedRepList, kFiletypeSharedIcon, {kFiletypeSharedPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeSitesPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 4, 3,
H_LINE_TO, 16,
CUBIC_TO, 17.1, 3, 18, 3.9, 18, 5,
V_LINE_TO, 15,
CUBIC_TO, 18, 16.1, 17.1, 17, 16, 17,
H_LINE_TO, 4,
CUBIC_TO, 2.9, 17, 2, 16.1, 2, 15,
V_LINE_TO, 5,
CUBIC_TO, 2, 3.9, 2.9, 3, 4, 3,
CLOSE,
MOVE_TO, 4, 7,
V_LINE_TO, 10,
H_LINE_TO, 11,
V_LINE_TO, 7,
H_LINE_TO, 4,
CLOSE,
MOVE_TO, 13, 7,
V_LINE_TO, 15,
H_LINE_TO, 16,
V_LINE_TO, 7,
H_LINE_TO, 13,
CLOSE,
MOVE_TO, 11, 15,
V_LINE_TO, 12,
H_LINE_TO, 4,
V_LINE_TO, 15,
H_LINE_TO, 11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeSitesRepList, kFiletypeSitesIcon, {kFiletypeSitesPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeTeamDrivePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10.5, 7.5,
CUBIC_TO, 10.5, 6.95, 10.95, 6.5, 11.5, 6.5,
CUBIC_TO, 12.05, 6.5, 12.5, 6.95, 12.5, 7.5,
CUBIC_TO, 12.5, 8.05, 12.05, 8.5, 11.5, 8.5,
CUBIC_TO, 10.95, 8.5, 10.5, 8.05, 10.5, 7.5,
CLOSE,
NEW_PATH,
MOVE_TO, 14, 11,
H_LINE_TO, 12,
V_LINE_TO, 10.33,
CUBIC_TO, 12, 9.81, 11.77, 9.36, 11.39, 9,
CUBIC_TO, 11.43, 9, 11.47, 9, 11.5, 9,
CUBIC_TO, 12.33, 9, 14, 9.45, 14, 10.33,
V_LINE_TO, 11,
CLOSE,
NEW_PATH,
MOVE_TO, 6, 11,
H_LINE_TO, 11,
V_LINE_TO, 10.33,
CUBIC_TO, 11, 9.45, 9.33, 9, 8.5, 9,
CUBIC_TO, 7.67, 9, 6, 9.45, 6, 10.33,
V_LINE_TO, 11,
CLOSE,
NEW_PATH,
MOVE_TO, 8.5, 6.5,
CUBIC_TO, 7.95, 6.5, 7.5, 6.95, 7.5, 7.5,
CUBIC_TO, 7.5, 8.05, 7.95, 8.5, 8.5, 8.5,
CUBIC_TO, 9.05, 8.5, 9.5, 8.05, 9.5, 7.5,
CUBIC_TO, 9.5, 6.95, 9.05, 6.5, 8.5, 6.5,
CLOSE,
NEW_PATH,
MOVE_TO, 3, 4,
CUBIC_TO, 3, 2.9, 3.9, 2, 5, 2,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 2, 17, 2.9, 17, 4,
V_LINE_TO, 16,
CUBIC_TO, 17, 17.1, 16.1, 18, 15, 18,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 18, 3, 17.1, 3, 16,
V_LINE_TO, 4,
CLOSE,
MOVE_TO, 15, 16,
H_LINE_TO, 5,
V_LINE_TO, 15,
H_LINE_TO, 15,
V_LINE_TO, 16,
CLOSE,
MOVE_TO, 15, 13,
H_LINE_TO, 5,
V_LINE_TO, 4,
H_LINE_TO, 15,
V_LINE_TO, 13,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeTeamDriveRepList, kFiletypeTeamDriveIcon, {kFiletypeTeamDrivePath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeTiniPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10.76, 10.36,
CUBIC_TO, 10.76, 10.71, 10.48, 11, 10.14, 11,
CUBIC_TO, 9.8, 11, 9.52, 10.71, 9.52, 10.36,
CUBIC_TO, 9.52, 10.01, 9.8, 9.72, 10.14, 9.72,
CUBIC_TO, 10.48, 9.72, 10.76, 10.01, 10.76, 10.36,
CLOSE,
NEW_PATH,
MOVE_TO, 13.86, 11,
CUBIC_TO, 14.2, 11, 14.48, 10.71, 14.48, 10.36,
CUBIC_TO, 14.48, 10.01, 14.2, 9.72, 13.86, 9.72,
CUBIC_TO, 13.52, 9.72, 13.24, 10.01, 13.24, 10.36,
CUBIC_TO, 13.24, 10.71, 13.52, 11, 13.86, 11,
CLOSE,
NEW_PATH,
MOVE_TO, 11.87, 11.34,
CUBIC_TO, 11.95, 11.31, 12.04, 11.31, 12.11, 11.34,
LINE_TO, 12.96, 11.73,
CUBIC_TO, 13.11, 11.79, 13.18, 11.97, 13.11, 12.12,
CUBIC_TO, 13.1, 12.15, 13.08, 12.17, 13.06, 12.2,
LINE_TO, 12.21, 13.13,
CUBIC_TO, 12.1, 13.25, 11.92, 13.26, 11.8, 13.15,
CUBIC_TO, 11.79, 13.15, 11.79, 13.14, 11.78, 13.13,
LINE_TO, 10.94, 12.19,
CUBIC_TO, 10.83, 12.07, 10.84, 11.89, 10.96, 11.78,
CUBIC_TO, 10.98, 11.75, 11.01, 11.74, 11.03, 11.72,
LINE_TO, 11.87, 11.34,
CLOSE,
NEW_PATH,
MOVE_TO, 15, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
V_LINE_TO, 15,
CUBIC_TO, 3, 16.1, 3.9, 17, 5, 17,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 17, 17, 16.1, 17, 15,
V_LINE_TO, 5,
CUBIC_TO, 17, 3.9, 16.1, 3, 15, 3,
CLOSE,
MOVE_TO, 7.25, 15,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 15,
V_LINE_TO, 7.15,
CUBIC_TO, 14.22, 6.43, 13.23, 6, 12, 6,
CUBIC_TO, 9.4, 6, 7.86, 8.03, 7.2, 10.62,
CUBIC_TO, 6.92, 10.7, 6.34, 11.07, 6.17, 11.59,
CUBIC_TO, 5.97, 12.21, 5.84, 12.9, 6.4, 13.11,
CUBIC_TO, 6.59, 13.18, 6.76, 13.17, 6.91, 13.09,
CUBIC_TO, 6.92, 13.83, 7.04, 14.46, 7.25, 15,
CLOSE,
MOVE_TO, 8.96, 15,
H_LINE_TO, 15,
V_LINE_TO, 9.14,
CUBIC_TO, 14.59, 8.41, 14.03, 7.89, 13.34, 7.74,
CUBIC_TO, 13.1, 7.68, 12.89, 7.96, 12.68, 8.24,
CUBIC_TO, 12.47, 8.52, 12.26, 8.81, 12, 8.81,
CUBIC_TO, 11.74, 8.81, 11.51, 8.51, 11.29, 8.23,
CUBIC_TO, 11.08, 7.95, 10.87, 7.68, 10.66, 7.74,
CUBIC_TO, 9.16, 8.11, 8.27, 10.22, 8.27, 12.31,
CUBIC_TO, 8.27, 13.45, 8.47, 14.36, 8.96, 15,
CLOSE,
NEW_PATH,
MOVE_TO, 10.55, 18,
LINE_TO, 10.52, 18,
H_LINE_TO, 10.58,
LINE_TO, 10.55, 18,
CLOSE,
NEW_PATH,
MOVE_TO, 13.45, 18,
LINE_TO, 13.42, 18,
H_LINE_TO, 13.48,
LINE_TO, 13.45, 18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeTiniRepList, kFiletypeTiniIcon, {kFiletypeTiniPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeVideoPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 16, 4,
H_LINE_TO, 14,
LINE_TO, 15, 7,
H_LINE_TO, 13,
LINE_TO, 12, 4,
H_LINE_TO, 10,
LINE_TO, 11, 7,
H_LINE_TO, 9,
LINE_TO, 8, 4,
H_LINE_TO, 6,
LINE_TO, 7, 7,
H_LINE_TO, 5,
LINE_TO, 4, 4,
CUBIC_TO, 3, 4, 2, 5.01, 2, 6,
V_LINE_TO, 15,
CUBIC_TO, 2, 16, 2.9, 17, 4, 17,
H_LINE_TO, 16,
CUBIC_TO, 17.1, 17.05, 18, 16.13, 18, 15,
V_LINE_TO, 6,
CUBIC_TO, 18, 5.01, 17, 4, 16, 4,
CLOSE,
MOVE_TO, 16, 15,
H_LINE_TO, 4,
V_LINE_TO, 9,
H_LINE_TO, 16,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeVideoRepList, kFiletypeVideoIcon, {kFiletypeVideoPath})
VECTOR_ICON_REP_TEMPLATE(kFiletypeWordPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 6.25, 7,
H_LINE_TO, 7.75,
LINE_TO, 8.5, 10,
LINE_TO, 9.25, 7,
H_LINE_TO, 10.75,
LINE_TO, 11.5, 10,
LINE_TO, 12.25, 7,
H_LINE_TO, 13.75,
LINE_TO, 12.25, 13,
H_LINE_TO, 10.75,
LINE_TO, 10, 10,
LINE_TO, 9.25, 13,
H_LINE_TO, 7.75,
LINE_TO, 6.25, 7,
CLOSE,
NEW_PATH,
MOVE_TO, 5, 3,
H_LINE_TO, 15,
CUBIC_TO, 16.1, 3, 17, 3.9, 17, 5,
V_LINE_TO, 15,
CUBIC_TO, 17, 16.1, 16.1, 17, 15, 17,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 17, 3, 16.1, 3, 15,
V_LINE_TO, 5,
CUBIC_TO, 3, 3.9, 3.9, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 15,
H_LINE_TO, 15,
V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFiletypeWordRepList, kFiletypeWordIcon, {kFiletypeWordPath})
VECTOR_ICON_REP_TEMPLATE(kFloatWindowPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 6,
R_CUBIC_TO, 1.65, 0, 3, -1.35, 3, -3,
R_CUBIC_TO, 0, -1.65, -1.35, -3, -3, -3,
R_CUBIC_TO, -1.65, 0, -3, 1.35, -3, 3,
R_CUBIC_TO, 0, 1.65, 1.35, 3, 3, 3,
CLOSE,
R_MOVE_TO, 0, 3,
R_CUBIC_TO, -1.65, 0, -3, 1.35, -3, 3,
R_CUBIC_TO, 0, 1.65, 1.35, 3, 3, 3,
R_CUBIC_TO, 1.65, 0, 3, -1.35, 3, -3,
R_CUBIC_TO, 0, -1.65, -1.35, -3, -3, -3,
CLOSE,
R_MOVE_TO, 0, 9,
R_CUBIC_TO, -1.65, 0, -3, 1.35, -3, 3,
R_CUBIC_TO, 0, 1.65, 1.35, 3, 3, 3,
R_CUBIC_TO, 1.65, 0, 3, -1.35, 3, -3,
R_CUBIC_TO, 0, -1.65, -1.35, -3, -3, -3,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kFloatWindow12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 6, 3,
R_CUBIC_TO, 0.83, 0, 1.5, -0.67, 1.5, -1.5,
CUBIC_TO_SHORTHAND, 6.83, 0, 6, 0,
CUBIC_TO_SHORTHAND, 4.5, 0.68, 4.5, 1.5,
CUBIC_TO_SHORTHAND, 5.18, 3, 6, 3,
CLOSE,
R_MOVE_TO, 0, 1.5,
R_CUBIC_TO, -0.82, 0, -1.5, 0.68, -1.5, 1.5,
CUBIC_TO_SHORTHAND, 5.18, 7.5, 6, 7.5,
CUBIC_TO_SHORTHAND, 7.5, 6.83, 7.5, 6,
CUBIC_TO_SHORTHAND, 6.83, 4.5, 6, 4.5,
CLOSE,
MOVE_TO, 6, 9,
R_CUBIC_TO, -0.82, 0, -1.5, 0.68, -1.5, 1.5,
CUBIC_TO_SHORTHAND, 5.18, 12, 6, 12,
R_CUBIC_TO, 0.82, 0, 1.5, -0.67, 1.5, -1.5,
CUBIC_TO_SHORTHAND, 6.83, 9, 6, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFloatWindowRepList, kFloatWindowIcon, {kFloatWindowPath}, {kFloatWindow12Path})
VECTOR_ICON_REP_TEMPLATE(kGameDashboardGamepadPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 4.65, 19,
CUBIC_TO, 3.8, 19, 3.12, 18.68, 2.63, 18.05,
CUBIC_TO, 2.12, 17.42, 1.93, 16.68, 2.05, 15.83,
LINE_TO, 3.1, 8.5,
CUBIC_TO, 3.25, 7.48, 3.7, 6.65, 4.44, 5.99,
CUBIC_TO, 5.18, 5.33, 6.07, 5, 7.1, 5,
H_LINE_TO, 16.9,
CUBIC_TO, 17.93, 5, 18.82, 5.33, 19.56, 5.99,
CUBIC_TO, 20.3, 6.65, 20.75, 7.48, 20.9, 8.5,
LINE_TO, 21.95, 15.83,
CUBIC_TO, 22.08, 16.68, 21.9, 17.42, 21.4, 18.05,
CUBIC_TO, 20.9, 18.68, 20.22, 19, 19.38, 19,
CUBIC_TO, 19.01, 19, 18.67, 18.94, 18.36, 18.81,
CUBIC_TO, 18.05, 18.69, 17.78, 18.5, 17.52, 18.25,
LINE_TO, 15.33, 16.05,
H_LINE_TO, 8.7,
LINE_TO, 6.5, 18.25,
CUBIC_TO, 6.25, 18.5, 5.97, 18.69, 5.66, 18.81,
CUBIC_TO, 5.35, 18.94, 5.02, 19, 4.65, 19,
CLOSE,
MOVE_TO, 5.07, 16.7,
LINE_TO, 7.83, 13.95,
H_LINE_TO, 16.2,
LINE_TO, 18.95, 16.7,
CUBIC_TO, 18.98, 16.73, 19.13, 16.8, 19.4, 16.9,
CUBIC_TO, 19.57, 16.9, 19.7, 16.84, 19.81, 16.73,
CUBIC_TO, 19.92, 16.61, 19.96, 16.47, 19.92, 16.3,
LINE_TO, 18.83, 8.75,
CUBIC_TO, 18.76, 8.28, 18.55, 7.89, 18.19, 7.58,
CUBIC_TO, 17.83, 7.26, 17.4, 7.1, 16.9, 7.1,
H_LINE_TO, 7.13,
CUBIC_TO, 6.62, 7.1, 6.2, 7.26, 5.84, 7.58,
CUBIC_TO, 5.48, 7.89, 5.27, 8.28, 5.2, 8.75,
LINE_TO, 4.1, 16.3,
CUBIC_TO, 4.07, 16.47, 4.1, 16.61, 4.21, 16.73,
CUBIC_TO, 4.32, 16.84, 4.46, 16.9, 4.62, 16.9,
CUBIC_TO, 4.69, 16.9, 4.84, 16.83, 5.07, 16.7,
CLOSE,
MOVE_TO, 16.95, 13.02,
CUBIC_TO, 17.23, 13.02, 17.48, 12.92, 17.69, 12.71,
CUBIC_TO, 17.9, 12.5, 18, 12.26, 18, 11.97,
CUBIC_TO, 18, 11.69, 17.9, 11.45, 17.69, 11.24,
CUBIC_TO, 17.48, 11.03, 17.23, 10.92, 16.95, 10.92,
CUBIC_TO, 16.67, 10.92, 16.42, 11.03, 16.21, 11.24,
CUBIC_TO, 16, 11.45, 15.9, 11.69, 15.9, 11.97,
CUBIC_TO, 15.9, 12.26, 16, 12.5, 16.21, 12.71,
CUBIC_TO, 16.42, 12.92, 16.67, 13.02, 16.95, 13.02,
CLOSE,
MOVE_TO, 14.95, 10.1,
CUBIC_TO, 15.23, 10.1, 15.48, 10, 15.69, 9.79,
CUBIC_TO, 15.9, 9.58, 16, 9.33, 16, 9.05,
CUBIC_TO, 16, 8.77, 15.9, 8.52, 15.69, 8.31,
CUBIC_TO, 15.48, 8.1, 15.23, 8, 14.95, 8,
CUBIC_TO, 14.67, 8, 14.42, 8.1, 14.21, 8.31,
CUBIC_TO, 14, 8.52, 13.9, 8.77, 13.9, 9.05,
CUBIC_TO, 13.9, 9.33, 14, 9.58, 14.21, 9.79,
CUBIC_TO, 14.42, 10, 14.67, 10.1, 14.95, 10.1,
CLOSE,
MOVE_TO, 7.77, 13.05,
H_LINE_TO, 9.3,
V_LINE_TO, 11.3,
H_LINE_TO, 11.05,
V_LINE_TO, 9.75,
H_LINE_TO, 9.3,
V_LINE_TO, 8,
H_LINE_TO, 7.77,
V_LINE_TO, 9.75,
H_LINE_TO, 6.03,
V_LINE_TO, 11.3,
H_LINE_TO, 7.77,
V_LINE_TO, 13.05,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kGameDashboardGamepadRepList, kGameDashboardGamepadIcon, {kGameDashboardGamepadPath})
VECTOR_ICON_REP_TEMPLATE(kInfoSparkPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 11, 17,
V_LINE_TO, 11,
H_LINE_TO, 13,
V_LINE_TO, 17,
H_LINE_TO, 11,
CLOSE,
MOVE_TO, 12, 10,
CUBIC_TO, 11.72, 10, 11.48, 9.91, 11.28, 9.73,
CUBIC_TO, 11.09, 9.53, 11, 9.28, 11, 9,
CUBIC_TO, 11, 8.72, 11.09, 8.48, 11.28, 8.3,
CUBIC_TO, 11.48, 8.1, 11.72, 8, 12, 8,
CUBIC_TO, 12.28, 8, 12.52, 8.1, 12.7, 8.3,
CUBIC_TO, 12.9, 8.48, 13, 8.72, 13, 9,
CUBIC_TO, 13, 9.28, 12.9, 9.53, 12.7, 9.73,
CUBIC_TO, 12.52, 9.91, 12.28, 10, 12, 10,
CLOSE,
MOVE_TO, 19.85, 10.5,
LINE_TO, 21.5, 8.85,
CUBIC_TO, 21.67, 9.35, 21.79, 9.87, 21.88, 10.4,
CUBIC_TO, 21.96, 10.92, 22, 11.45, 22, 12,
CUBIC_TO, 22, 13.38, 21.73, 14.68, 21.2, 15.9,
CUBIC_TO, 20.68, 17.12, 19.98, 18.18, 19.08, 19.08,
CUBIC_TO, 18.18, 19.98, 17.12, 20.69, 15.9, 21.23,
CUBIC_TO, 14.68, 21.74, 13.38, 22, 12, 22,
CUBIC_TO, 10.62, 22, 9.32, 21.74, 8.1, 21.23,
CUBIC_TO, 6.88, 20.69, 5.83, 19.98, 4.93, 19.08,
CUBIC_TO, 4.03, 18.18, 3.31, 17.12, 2.78, 15.9,
CUBIC_TO, 2.26, 14.68, 2, 13.38, 2, 12,
CUBIC_TO, 2, 10.62, 2.26, 9.32, 2.78, 8.1,
CUBIC_TO, 3.31, 6.88, 4.03, 5.83, 4.93, 4.93,
CUBIC_TO, 5.83, 4.03, 6.88, 3.32, 8.1, 2.8,
CUBIC_TO, 9.32, 2.27, 10.62, 2, 12, 2,
CUBIC_TO, 12.55, 2, 13.08, 2.04, 13.6, 2.13,
CUBIC_TO, 14.13, 2.21, 14.65, 2.33, 15.15, 2.5,
LINE_TO, 13.5, 4.15,
CUBIC_TO, 13.25, 4.1, 13, 4.07, 12.75, 4.05,
CUBIC_TO, 12.52, 4.02, 12.27, 4, 12, 4,
CUBIC_TO, 9.77, 4, 7.88, 4.78, 6.33, 6.33,
CUBIC_TO, 4.78, 7.88, 4, 9.77, 4, 12,
CUBIC_TO, 4, 14.23, 4.78, 16.13, 6.33, 17.68,
CUBIC_TO, 7.88, 19.23, 9.77, 20, 12, 20,
CUBIC_TO, 14.23, 20, 16.13, 19.23, 17.68, 17.68,
CUBIC_TO, 19.23, 16.13, 20, 14.23, 20, 12,
CUBIC_TO, 20, 11.73, 19.98, 11.48, 19.95, 11.25,
CUBIC_TO, 19.93, 11, 19.9, 10.75, 19.85, 10.5,
CLOSE,
MOVE_TO, 17.5, 12,
CUBIC_TO, 17.5, 10.47, 16.97, 9.17, 15.9, 8.1,
CUBIC_TO, 14.83, 7.03, 13.53, 6.5, 12, 6.5,
CUBIC_TO, 13.53, 6.5, 14.83, 5.97, 15.9, 4.9,
CUBIC_TO, 16.97, 3.83, 17.5, 2.53, 17.5, 1,
CUBIC_TO, 17.5, 2.53, 18.03, 3.83, 19.1, 4.9,
CUBIC_TO, 20.17, 5.97, 21.47, 6.5, 23, 6.5,
CUBIC_TO, 21.47, 6.5, 20.17, 7.03, 19.1, 8.1,
CUBIC_TO, 18.03, 9.17, 17.5, 10.47, 17.5, 12,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kInfoSparkRepList, kInfoSparkIcon, {kInfoSparkPath})
VECTOR_ICON_REP_TEMPLATE(kKeyboardShortcutsPath, CANVAS_DIMENSIONS, 192,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 96, 96, 88,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
ROUND_RECT, 39, 63, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
ROUND_RECT, 63, 63, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
ROUND_RECT, 63, 87, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
ROUND_RECT, 87, 63, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
ROUND_RECT, 87, 87, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
ROUND_RECT, 135, 111, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x8A, 0xB4, 0xF8,
ROUND_RECT, 39, 87, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
ROUND_RECT, 40, 111, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x8A, 0xB4, 0xF8,
ROUND_RECT, 64, 111, 65, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
ROUND_RECT, 111, 63, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
ROUND_RECT, 135, 63, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x8A, 0xB4, 0xF8,
ROUND_RECT, 111, 87, 18, 18, 9,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x8A, 0xB4, 0xF8,
ROUND_RECT, 135, 87, 18, 18, 9)
VECTOR_ICON_TEMPLATE_CC(kKeyboardShortcutsRepList, kKeyboardShortcutsIcon, {kKeyboardShortcutsPath})
VECTOR_ICON_REP_TEMPLATE(kMahiOutlinesPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 7.75, 14.5,
V_LINE_TO, 13.15,
H_LINE_TO, 16.3,
V_LINE_TO, 14.5,
H_LINE_TO, 7.75,
CLOSE,
MOVE_TO, 7.75, 10.68,
V_LINE_TO, 9.32,
H_LINE_TO, 16.3,
V_LINE_TO, 10.68,
H_LINE_TO, 7.75,
CLOSE,
MOVE_TO, 7.75, 6.85,
V_LINE_TO, 5.5,
H_LINE_TO, 16.3,
V_LINE_TO, 6.85,
H_LINE_TO, 7.75,
CLOSE,
MOVE_TO, 5.05, 15.18,
CUBIC_TO, 4.68, 15.18, 4.36, 15.04, 4.09, 14.78,
CUBIC_TO, 3.83, 14.52, 3.7, 14.2, 3.7, 13.83,
CUBIC_TO, 3.7, 13.45, 3.83, 13.13, 4.09, 12.87,
CUBIC_TO, 4.36, 12.61, 4.68, 12.48, 5.05, 12.48,
CUBIC_TO, 5.43, 12.48, 5.74, 12.61, 6.01, 12.87,
CUBIC_TO, 6.27, 13.13, 6.4, 13.45, 6.4, 13.83,
CUBIC_TO, 6.4, 14.2, 6.27, 14.52, 6.01, 14.78,
CUBIC_TO, 5.74, 15.04, 5.43, 15.18, 5.05, 15.18,
CLOSE,
MOVE_TO, 5.05, 11.35,
CUBIC_TO, 4.68, 11.35, 4.36, 11.22, 4.09, 10.96,
CUBIC_TO, 3.83, 10.69, 3.7, 10.38, 3.7, 10,
CUBIC_TO, 3.7, 9.63, 3.83, 9.31, 4.09, 9.04,
CUBIC_TO, 4.36, 8.78, 4.68, 8.65, 5.05, 8.65,
CUBIC_TO, 5.43, 8.65, 5.74, 8.78, 6.01, 9.04,
CUBIC_TO, 6.27, 9.31, 6.4, 9.63, 6.4, 10,
CUBIC_TO, 6.4, 10.38, 6.27, 10.69, 6.01, 10.96,
CUBIC_TO, 5.74, 11.22, 5.43, 11.35, 5.05, 11.35,
CLOSE,
MOVE_TO, 5.05, 7.53,
CUBIC_TO, 4.68, 7.53, 4.36, 7.39, 4.09, 7.13,
CUBIC_TO, 3.83, 6.87, 3.7, 6.55, 3.7, 6.18,
CUBIC_TO, 3.7, 5.8, 3.83, 5.48, 4.09, 5.22,
CUBIC_TO, 4.36, 4.96, 4.68, 4.83, 5.05, 4.83,
CUBIC_TO, 5.43, 4.83, 5.74, 4.96, 6.01, 5.22,
CUBIC_TO, 6.27, 5.48, 6.4, 5.8, 6.4, 6.18,
CUBIC_TO, 6.4, 6.55, 6.27, 6.87, 6.01, 7.13,
CUBIC_TO, 5.74, 7.39, 5.43, 7.53, 5.05, 7.53,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMahiOutlinesRepList, kMahiOutlinesIcon, {kMahiOutlinesPath})
VECTOR_ICON_REP_TEMPLATE(kMahiSimplifyPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.56, 15.44,
CUBIC_TO, 3.08, 14.83, 2.69, 14.15, 2.42, 13.4,
CUBIC_TO, 2.14, 12.65, 2, 11.85, 2, 11,
CUBIC_TO, 2, 9.06, 2.68, 7.4, 4.04, 6.04,
CUBIC_TO, 5.4, 4.68, 7.06, 4, 9, 4,
CUBIC_TO, 9.03, 4, 9.05, 4, 9.06, 4,
CUBIC_TO, 9.08, 4, 9.1, 4, 9.13, 4,
LINE_TO, 7.94, 2.81,
LINE_TO, 9, 1.75,
LINE_TO, 12, 4.75,
LINE_TO, 9, 7.75,
LINE_TO, 7.94, 6.69,
LINE_TO, 9.13, 5.5,
CUBIC_TO, 9.1, 5.5, 9.08, 5.5, 9.06, 5.5,
CUBIC_TO, 9.05, 5.5, 9.03, 5.5, 9, 5.5,
CUBIC_TO, 7.47, 5.5, 6.17, 6.03, 5.1, 7.1,
CUBIC_TO, 4.03, 8.17, 3.5, 9.47, 3.5, 11,
CUBIC_TO, 3.5, 11.63, 3.6, 12.22, 3.79, 12.79,
CUBIC_TO, 4, 13.36, 4.28, 13.88, 4.65, 14.35,
LINE_TO, 3.56, 15.44,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
MOVE_TO, 7, 16,
V_LINE_TO, 14.5,
H_LINE_TO, 13.19,
V_LINE_TO, 16,
H_LINE_TO, 7,
CLOSE,
MOVE_TO, 7, 13.42,
V_LINE_TO, 12,
H_LINE_TO, 16.63,
V_LINE_TO, 13.42,
H_LINE_TO, 7,
CLOSE,
MOVE_TO, 7, 10.84,
V_LINE_TO, 9.5,
H_LINE_TO, 13.19,
V_LINE_TO, 10.84,
H_LINE_TO, 7,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
MOVE_TO, 15.5, 11,
CUBIC_TO, 15.5, 10.03, 15.16, 9.2, 14.48, 8.52,
CUBIC_TO, 13.8, 7.84, 12.97, 7.5, 12, 7.5,
CUBIC_TO, 12.97, 7.5, 13.8, 7.16, 14.48, 6.48,
CUBIC_TO, 15.16, 5.8, 15.5, 4.97, 15.5, 4,
CUBIC_TO, 15.5, 4.97, 15.84, 5.8, 16.52, 6.48,
CUBIC_TO, 17.2, 7.16, 18.03, 7.5, 19, 7.5,
CUBIC_TO, 18.03, 7.5, 17.2, 7.84, 16.52, 8.52,
CUBIC_TO, 15.84, 9.2, 15.5, 10.03, 15.5, 11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMahiSimplifyRepList, kMahiSimplifyIcon, {kMahiSimplifyPath})
VECTOR_ICON_REP_TEMPLATE(kMahiSparkPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 14.4,
CUBIC_TO, 8, 13.51, 7.83, 12.68, 7.5, 11.92,
CUBIC_TO, 7.17, 11.14, 6.71, 10.46, 6.12, 9.88,
CUBIC_TO, 5.54, 9.29, 4.86, 8.83, 4.08, 8.5,
CUBIC_TO, 3.32, 8.17, 2.49, 8, 1.6, 8,
CUBIC_TO, 2.49, 8, 3.32, 7.83, 4.08, 7.5,
CUBIC_TO, 4.86, 7.17, 5.54, 6.71, 6.12, 6.13,
CUBIC_TO, 6.71, 5.54, 7.17, 4.86, 7.5, 4.08,
CUBIC_TO, 7.83, 3.31, 8, 2.48, 8, 1.6,
CUBIC_TO, 8, 2.48, 8.17, 3.31, 8.5, 4.08,
CUBIC_TO, 8.83, 4.86, 9.29, 5.54, 9.87, 6.13,
CUBIC_TO, 10.46, 6.71, 11.14, 7.17, 11.92, 7.5,
CUBIC_TO, 12.69, 7.83, 13.52, 8, 14.4, 8,
CUBIC_TO, 13.52, 8, 12.69, 8.17, 11.92, 8.5,
CUBIC_TO, 11.14, 8.83, 10.46, 9.29, 9.87, 9.88,
CUBIC_TO, 9.29, 10.46, 8.83, 11.14, 8.5, 11.92,
CUBIC_TO, 8.17, 12.68, 8, 13.51, 8, 14.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMahiSparkRepList, kMahiSparkIcon, {kMahiSparkPath})
VECTOR_ICON_REP_TEMPLATE(kMahiSummarizePath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 4.08, 12.6,
CUBIC_TO, 4.26, 12.6, 4.42, 12.54, 4.54, 12.41,
CUBIC_TO, 4.68, 12.28, 4.75, 12.11, 4.75, 11.93,
CUBIC_TO, 4.75, 11.74, 4.68, 11.58, 4.54, 11.46,
CUBIC_TO, 4.42, 11.32, 4.26, 11.25, 4.08, 11.25,
CUBIC_TO, 3.89, 11.25, 3.73, 11.32, 3.59, 11.46,
CUBIC_TO, 3.46, 11.58, 3.4, 11.74, 3.4, 11.93,
CUBIC_TO, 3.4, 12.11, 3.46, 12.28, 3.59, 12.41,
CUBIC_TO, 3.73, 12.54, 3.89, 12.6, 4.08, 12.6,
CLOSE,
MOVE_TO, 4.08, 9.68,
CUBIC_TO, 4.26, 9.68, 4.42, 9.61, 4.54, 9.49,
CUBIC_TO, 4.68, 9.35, 4.75, 9.19, 4.75, 9,
CUBIC_TO, 4.75, 8.81, 4.68, 8.66, 4.54, 8.53,
CUBIC_TO, 4.42, 8.39, 4.26, 8.32, 4.08, 8.32,
CUBIC_TO, 3.89, 8.32, 3.73, 8.39, 3.59, 8.53,
CUBIC_TO, 3.46, 8.66, 3.4, 8.81, 3.4, 9,
CUBIC_TO, 3.4, 9.19, 3.46, 9.35, 3.59, 9.49,
CUBIC_TO, 3.73, 9.61, 3.89, 9.68, 4.08, 9.68,
CLOSE,
MOVE_TO, 4.08, 6.75,
CUBIC_TO, 4.26, 6.75, 4.42, 6.69, 4.54, 6.56,
CUBIC_TO, 4.68, 6.43, 4.75, 6.26, 4.75, 6.08,
CUBIC_TO, 4.75, 5.89, 4.68, 5.73, 4.54, 5.61,
CUBIC_TO, 4.42, 5.47, 4.26, 5.4, 4.08, 5.4,
CUBIC_TO, 3.89, 5.4, 3.73, 5.47, 3.59, 5.61,
CUBIC_TO, 3.46, 5.73, 3.4, 5.89, 3.4, 6.08,
CUBIC_TO, 3.4, 6.26, 3.46, 6.43, 3.59, 6.56,
CUBIC_TO, 3.73, 6.69, 3.89, 6.75, 4.08, 6.75,
CLOSE,
MOVE_TO, 6.1, 12.6,
H_LINE_TO, 10.6,
V_LINE_TO, 11.25,
H_LINE_TO, 6.1,
V_LINE_TO, 12.6,
CLOSE,
MOVE_TO, 6.1, 9.68,
H_LINE_TO, 9.7,
V_LINE_TO, 8.32,
H_LINE_TO, 6.1,
V_LINE_TO, 9.68,
CLOSE,
MOVE_TO, 2.05, 15.3,
CUBIC_TO, 1.68, 15.3, 1.36, 15.17, 1.09, 14.91,
CUBIC_TO, 0.83, 14.63, 0.7, 14.31, 0.7, 13.95,
V_LINE_TO, 4.05,
CUBIC_TO, 0.7, 3.69, 0.83, 3.38, 1.09, 3.11,
CUBIC_TO, 1.36, 2.84, 1.68, 2.7, 2.05, 2.7,
H_LINE_TO, 7.9,
CUBIC_TO, 7.9, 2.91, 7.9, 3.13, 7.9, 3.36,
CUBIC_TO, 7.9, 3.58, 7.9, 3.81, 7.9, 4.05,
H_LINE_TO, 2.05,
V_LINE_TO, 13.95,
H_LINE_TO, 11.95,
V_LINE_TO, 8.1,
CUBIC_TO, 12.19, 8.1, 12.42, 8.1, 12.64, 8.1,
CUBIC_TO, 12.87, 8.1, 13.09, 8.1, 13.3, 8.1,
V_LINE_TO, 13.95,
CUBIC_TO, 13.3, 14.31, 13.17, 14.63, 12.91, 14.91,
CUBIC_TO, 12.64, 15.17, 12.33, 15.3, 11.95, 15.3,
H_LINE_TO, 2.05,
CLOSE,
MOVE_TO, 11.05, 9,
CUBIC_TO, 11.05, 7.88, 10.66, 6.92, 9.87, 6.13,
CUBIC_TO, 9.08, 5.34, 8.13, 4.95, 7, 4.95,
CUBIC_TO, 8.13, 4.95, 9.08, 4.56, 9.87, 3.77,
CUBIC_TO, 10.66, 2.98, 11.05, 2.03, 11.05, 0.9,
CUBIC_TO, 11.05, 2.03, 11.44, 2.98, 12.23, 3.77,
CUBIC_TO, 13.02, 4.56, 13.98, 4.95, 15.1, 4.95,
CUBIC_TO, 13.98, 4.95, 13.02, 5.34, 12.23, 6.13,
CUBIC_TO, 11.44, 6.92, 11.05, 7.88, 11.05, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMahiSummarizeRepList, kMahiSummarizeIcon, {kMahiSummarizePath})
VECTOR_ICON_REP_TEMPLATE(kNotificationAssistantPath, CANVAS_DIMENSIONS, 96,
CIRCLE, 86, 30, 6,
NEW_PATH,
CIRCLE, 68, 44, 12,
NEW_PATH,
CIRCLE, 68, 74, 14,
NEW_PATH,
CIRCLE, 28, 32, 24)
VECTOR_ICON_TEMPLATE_CC(kNotificationAssistantRepList, kNotificationAssistantIcon, {kNotificationAssistantPath})
VECTOR_ICON_REP_TEMPLATE(kNotificationSupervisedUserPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 15.72, 7.94,
R_LINE_TO, -4.5, -4.63,
R_CUBIC_TO, -0.2, -0.21, -0.46, -0.31, -0.72, -0.31,
R_CUBIC_TO, -0.26, 0, -0.52, 0.1, -0.72, 0.31,
R_LINE_TO, -4.5, 4.63,
R_CUBIC_TO, -0.33, 0.34, -0.37, 0.87, -0.11, 1.26,
R_LINE_TO, 4.72, 7.09,
R_CUBIC_TO, -0.2, 0.42, -0.62, 0.71, -1.11, 0.71,
R_CUBIC_TO, -0.62, 0, -1.15, -0.46, -1.24, -1.07,
ARC_TO, 2.25, 2.25, 0, 0, 0, 5.32, 14,
R_CUBIC_TO, -0.87, 0, -1.68, 0.51, -2.04, 1.31,
R_LINE_TO, 0.91, 0.42,
R_CUBIC_TO, 0.19, -0.44, 0.64, -0.73, 1.13, -0.73,
R_CUBIC_TO, 0.62, 0, 1.15, 0.46, 1.24, 1.07,
ARC_TO, 2.25, 2.25, 0, 0, 0, 8.78, 18,
R_CUBIC_TO, 0.69, 0, 1.3, -0.32, 1.71, -0.81,
R_LINE_TO, 5.33, -7.99,
R_CUBIC_TO, 0.27, -0.39, 0.23, -0.92, -0.1, -1.26,
CLOSE,
R_MOVE_TO, -5.22, 7.45,
LINE_TO, 6, 8.63,
LINE_TO, 10.5, 4,
R_LINE_TO, 4.49, 4.65,
R_LINE_TO, -4.49, 6.74,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationSupervisedUserRepList, kNotificationSupervisedUserIcon, {kNotificationSupervisedUserPath})
VECTOR_ICON_REP_TEMPLATE(kPersonPinCirclePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 11,
CUBIC_TO, 13.33, 11, 16, 11.67, 16, 13,
V_LINE_TO, 13.16,
CUBIC_TO, 15.03, 14.28, 13.6, 15, 12, 15,
CUBIC_TO, 10.4, 15, 8.97, 14.28, 8, 13.16,
V_LINE_TO, 13,
CUBIC_TO, 8, 11.67, 10.67, 11, 12, 11,
CLOSE,
MOVE_TO, 12, 10,
CUBIC_TO, 10.9, 10, 10, 9.1, 10, 8,
CUBIC_TO, 10, 6.9, 10.9, 6, 12, 6,
CUBIC_TO, 13.1, 6, 14, 6.9, 14, 8,
CUBIC_TO, 14, 9.1, 13.1, 10, 12, 10,
CLOSE,
MOVE_TO, 18, 10.2,
CUBIC_TO, 18, 6.57, 15.35, 4, 12, 4,
CUBIC_TO, 8.65, 4, 6, 6.57, 6, 10.2,
CUBIC_TO, 6, 12.54, 7.95, 15.64, 12, 19.34,
CUBIC_TO, 16.05, 15.64, 18, 12.54, 18, 10.2,
CLOSE,
MOVE_TO, 12, 2,
CUBIC_TO, 16.2, 2, 20, 5.22, 20, 10.2,
CUBIC_TO, 20, 13.52, 17.33, 17.45, 12, 22,
CUBIC_TO, 6.67, 17.45, 4, 13.52, 4, 10.2,
CUBIC_TO, 4, 5.22, 7.8, 2, 12, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPersonPinCircleRepList, kPersonPinCircleIcon, {kPersonPinCirclePath})
VECTOR_ICON_REP_TEMPLATE(kRedeemPath, MOVE_TO, 7, 34.15,
V_LINE_TO, 39,
R_H_LINE_TO, 34,
R_V_LINE_TO, -4.85,
CLOSE,
MOVE_TO, 7, 12,
R_H_LINE_TO, 6.25,
R_QUADRATIC_TO, -0.25, -0.45, -0.4, -1.12,
R_QUADRATIC_TO, -0.15, -0.67, -0.15, -1.23,
R_QUADRATIC_TO, 0, -2.35, 1.65, -4,
QUADRATIC_TO_SHORTHAND, 18.3, 4,
R_QUADRATIC_TO, 1.55, 0, 2.85, 0.78,
QUADRATIC_TO_SHORTHAND, 23.2, 6.75,
R_LINE_TO, 0.85, 1.3,
R_LINE_TO, 0.8, -1.3,
R_QUADRATIC_TO, 0.8, -1.25, 2.05, -2,
QUADRATIC_TO, 28.15, 4, 29.6, 4,
R_QUADRATIC_TO, 2.4, 0, 4.05, 1.63,
QUADRATIC_TO_SHORTHAND, 35.3, 9.65,
R_QUADRATIC_TO, 0, 0.55, -0.12, 1.1,
QUADRATIC_TO_SHORTHAND, 34.8, 12,
H_LINE_TO, 41,
R_QUADRATIC_TO, 1.2, 0, 2.1, 0.9,
R_QUADRATIC_TO, 0.9, 0.9, 0.9, 2.1,
R_V_LINE_TO, 24,
R_QUADRATIC_TO, 0, 1.2, -0.9, 2.1,
R_QUADRATIC_TO, -0.9, 0.9, -2.1, 0.9,
H_LINE_TO, 7,
R_QUADRATIC_TO, -1.2, 0, -2.1, -0.9,
QUADRATIC_TO, 4, 40.2, 4, 39,
V_LINE_TO, 15,
R_QUADRATIC_TO, 0, -1.2, 0.9, -2.1,
R_QUADRATIC_TO, 0.9, -0.9, 2.1, -0.9,
CLOSE,
R_MOVE_TO, 0, 16.8,
R_H_LINE_TO, 34,
V_LINE_TO, 15,
H_LINE_TO, 28.55,
R_LINE_TO, 5, 6.95,
R_LINE_TO, -2.4, 1.8,
R_LINE_TO, -7.15, -9.9,
R_LINE_TO, -7.15, 9.9,
R_LINE_TO, -2.4, -1.8,
R_LINE_TO, 5, -6.95,
H_LINE_TO, 7,
CLOSE,
R_MOVE_TO, 11.35, -16.5,
R_QUADRATIC_TO, 1.1, 0, 1.88, -0.77,
QUADRATIC_TO, 21, 10.75, 21, 9.65,
R_QUADRATIC_TO, 0, -1.1, -0.77, -1.87,
QUADRATIC_TO, 19.45, 7, 18.35, 7,
R_QUADRATIC_TO, -1.1, 0, -1.87, 0.78,
QUADRATIC_TO, 15.7, 8.55, 15.7, 9.65,
R_QUADRATIC_TO, 0, 1.1, 0.78, 1.88,
R_QUADRATIC_TO, 0.78, 0.78, 1.88, 0.78,
CLOSE,
R_MOVE_TO, 11.25, 0,
R_QUADRATIC_TO, 1.15, 0, 1.93, -0.77,
R_QUADRATIC_TO, 0.78, -0.77, 0.78, -1.87,
R_QUADRATIC_TO, 0, -1.1, -0.77, -1.87,
QUADRATIC_TO, 30.75, 7, 29.6, 7,
R_QUADRATIC_TO, -1.05, 0, -1.82, 0.78,
QUADRATIC_TO, 27, 8.55, 27, 9.65,
R_QUADRATIC_TO, 0, 1.1, 0.78, 1.88,
R_QUADRATIC_TO, 0.78, 0.78, 1.83, 0.78,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kRedeemRepList, kRedeemIcon, {kRedeemPath})
VECTOR_ICON_REP_TEMPLATE(kScreenshotPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 15, 5,
H_LINE_TO, 17,
V_LINE_TO, 3,
H_LINE_TO, 15,
V_LINE_TO, 5,
CLOSE,
MOVE_TO, 13, 5,
V_LINE_TO, 3,
H_LINE_TO, 11,
V_LINE_TO, 5,
H_LINE_TO, 13,
CLOSE,
MOVE_TO, 9, 5,
V_LINE_TO, 3,
H_LINE_TO, 3,
V_LINE_TO, 9,
H_LINE_TO, 5,
V_LINE_TO, 5,
H_LINE_TO, 9,
CLOSE,
MOVE_TO, 5, 11,
H_LINE_TO, 3,
V_LINE_TO, 13,
H_LINE_TO, 5,
V_LINE_TO, 11,
CLOSE,
MOVE_TO, 5, 15,
H_LINE_TO, 3,
V_LINE_TO, 17,
H_LINE_TO, 5,
V_LINE_TO, 15,
CLOSE,
MOVE_TO, 3, 19,
V_LINE_TO, 21,
H_LINE_TO, 5,
V_LINE_TO, 19,
H_LINE_TO, 3,
CLOSE,
MOVE_TO, 7, 19,
V_LINE_TO, 21,
H_LINE_TO, 9,
V_LINE_TO, 19,
H_LINE_TO, 7,
CLOSE,
MOVE_TO, 11, 19,
V_LINE_TO, 21,
H_LINE_TO, 13,
V_LINE_TO, 19,
H_LINE_TO, 11,
CLOSE,
MOVE_TO, 15, 19,
V_LINE_TO, 21,
H_LINE_TO, 21,
V_LINE_TO, 15,
H_LINE_TO, 19,
V_LINE_TO, 19,
H_LINE_TO, 15,
CLOSE,
MOVE_TO, 19, 13,
H_LINE_TO, 21,
V_LINE_TO, 11,
H_LINE_TO, 19,
V_LINE_TO, 13,
CLOSE,
MOVE_TO, 19, 9,
H_LINE_TO, 21,
V_LINE_TO, 7,
H_LINE_TO, 19,
V_LINE_TO, 9,
CLOSE,
MOVE_TO, 21, 5,
V_LINE_TO, 3,
H_LINE_TO, 19,
V_LINE_TO, 5,
H_LINE_TO, 21,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kScreenshotRepList, kScreenshotIcon, {kScreenshotPath})
VECTOR_ICON_REP_TEMPLATE(kSentimentVerySatisfiedPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11.99, 2,
CUBIC_TO, 6.47, 2, 2, 6.47, 2, 12,
CUBIC_TO, 2, 17.53, 6.47, 22, 11.99, 22,
CUBIC_TO, 17.51, 22, 22, 17.53, 22, 12,
CUBIC_TO, 22, 6.47, 17.52, 2, 11.99, 2,
CLOSE,
MOVE_TO, 12, 20,
CUBIC_TO, 7.58, 20, 4, 16.42, 4, 12,
CUBIC_TO, 4, 7.58, 7.58, 4, 12, 4,
CUBIC_TO, 16.42, 4, 20, 7.58, 20, 12,
CUBIC_TO, 20, 16.42, 16.42, 20, 12, 20,
CLOSE,
MOVE_TO, 13, 9.94,
LINE_TO, 14.06, 11,
LINE_TO, 15.12, 9.94,
LINE_TO, 16.18, 11,
LINE_TO, 17.24, 9.94,
LINE_TO, 15.12, 7.82,
LINE_TO, 13, 9.94,
CLOSE,
MOVE_TO, 8.88, 9.94,
LINE_TO, 9.94, 11,
LINE_TO, 11, 9.94,
LINE_TO, 8.88, 7.82,
LINE_TO, 6.76, 9.94,
LINE_TO, 7.82, 11,
LINE_TO, 8.88, 9.94,
V_LINE_TO, 9.94,
CLOSE,
MOVE_TO, 12, 17.5,
CUBIC_TO, 14.33, 17.5, 16.31, 16.04, 17.11, 14,
H_LINE_TO, 6.89,
CUBIC_TO, 7.69, 16.04, 9.67, 17.5, 12, 17.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSentimentVerySatisfiedRepList, kSentimentVerySatisfiedIcon, {kSentimentVerySatisfiedPath})
VECTOR_ICON_REP_TEMPLATE(kStraightenPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20, 6,
H_LINE_TO, 4,
CUBIC_TO, 2.9, 6, 2, 6.9, 2, 8,
V_LINE_TO, 16,
CUBIC_TO, 2, 17.1, 2.9, 18, 4, 18,
H_LINE_TO, 20,
CUBIC_TO, 21.1, 18, 22, 17.1, 22, 16,
V_LINE_TO, 8,
CUBIC_TO, 22, 6.9, 21.1, 6, 20, 6,
CLOSE,
MOVE_TO, 20, 16,
H_LINE_TO, 4,
V_LINE_TO, 8,
H_LINE_TO, 7,
V_LINE_TO, 12,
H_LINE_TO, 9,
V_LINE_TO, 8,
H_LINE_TO, 11,
V_LINE_TO, 12,
H_LINE_TO, 13,
V_LINE_TO, 8,
H_LINE_TO, 15,
V_LINE_TO, 12,
H_LINE_TO, 17,
V_LINE_TO, 8,
H_LINE_TO, 20,
V_LINE_TO, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStraightenRepList, kStraightenIcon, {kStraightenPath})
VECTOR_ICON_REP_TEMPLATE(kTextPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 13, 4,
H_LINE_TO, 3,
R_V_LINE_TO, 2,
R_H_LINE_TO, 4,
R_V_LINE_TO, 10,
R_H_LINE_TO, 2,
V_LINE_TO, 6,
R_H_LINE_TO, 4,
V_LINE_TO, 4,
CLOSE,
MOVE_TO, 11, 8,
R_H_LINE_TO, 6,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
R_V_LINE_TO, 6,
R_H_LINE_TO, -2,
R_V_LINE_TO, -6,
R_H_LINE_TO, -2,
V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTextRepList, kTextIcon, {kTextPath})
VECTOR_ICON_REP_TEMPLATE(kTimerPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 15, 3,
H_LINE_TO, 9,
V_LINE_TO, 1,
H_LINE_TO, 15,
V_LINE_TO, 3,
CLOSE,
MOVE_TO, 11, 14,
H_LINE_TO, 13,
V_LINE_TO, 8,
H_LINE_TO, 11,
V_LINE_TO, 14,
CLOSE,
MOVE_TO, 21, 13.01,
CUBIC_TO, 21, 17.98, 16.98, 22.01, 12, 22.01,
CUBIC_TO, 7.02, 22.01, 3, 17.98, 3, 13.01,
CUBIC_TO, 3, 8.04, 7.03, 4.01, 12, 4.01,
CUBIC_TO, 14.12, 4.01, 16.07, 4.75, 17.62, 5.99,
LINE_TO, 19.04, 4.57,
CUBIC_TO, 19.55, 4.99, 20.02, 5.47, 20.45, 5.98,
LINE_TO, 19.03, 7.4,
CUBIC_TO, 20.26, 8.93, 21, 10.89, 21, 13.01,
CLOSE,
MOVE_TO, 19, 13.01,
CUBIC_TO, 19, 9.14, 15.87, 6.01, 12, 6.01,
CUBIC_TO, 8.13, 6.01, 5, 9.14, 5, 13.01,
CUBIC_TO, 5, 16.88, 8.13, 20.01, 12, 20.01,
CUBIC_TO, 15.87, 20.01, 19, 16.88, 19, 13.01,
V_LINE_TO, 13.01,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTimerRepList, kTimerIcon, {kTimerPath})
VECTOR_ICON_REP_TEMPLATE(kTranslatePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12.87, 15.07,
LINE_TO, 10.33, 12.56,
LINE_TO, 10.36, 12.53,
CUBIC_TO, 12.1, 10.59, 13.34, 8.36, 14.07, 6,
H_LINE_TO, 17,
V_LINE_TO, 4,
H_LINE_TO, 10,
V_LINE_TO, 2,
H_LINE_TO, 8,
V_LINE_TO, 4,
H_LINE_TO, 1,
V_LINE_TO, 5.99,
H_LINE_TO, 12.17,
CUBIC_TO, 11.5, 7.92, 10.44, 9.75, 9, 11.35,
CUBIC_TO, 8.07, 10.32, 7.3, 9.19, 6.69, 8,
H_LINE_TO, 4.69,
CUBIC_TO, 5.42, 9.63, 6.42, 11.17, 7.67, 12.56,
LINE_TO, 2.58, 17.58,
LINE_TO, 4, 19,
LINE_TO, 9, 14,
LINE_TO, 12.11, 17.11,
LINE_TO, 12.87, 15.07,
CLOSE,
MOVE_TO, 18.5, 10,
H_LINE_TO, 16.5,
LINE_TO, 12, 22,
H_LINE_TO, 14,
LINE_TO, 15.12, 19,
H_LINE_TO, 19.87,
LINE_TO, 21, 22,
H_LINE_TO, 23,
LINE_TO, 18.5, 10,
CLOSE,
MOVE_TO, 15.88, 17,
LINE_TO, 17.5, 12.67,
LINE_TO, 19.12, 17,
H_LINE_TO, 15.88,
V_LINE_TO, 17,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTranslateRepList, kTranslateIcon, {kTranslatePath})
VECTOR_ICON_REP_TEMPLATE(kUnfloatButtonPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 1, 12,
V_LINE_TO, 1,
H_LINE_TO, 12,
V_LINE_TO, 4,
H_LINE_TO, 6.12,
LINE_TO, 14.06, 11.94,
LINE_TO, 11.94, 14.06,
LINE_TO, 4, 6.12,
V_LINE_TO, 12,
H_LINE_TO, 1,
CLOSE,
NEW_PATH,
MOVE_TO, 1, 15,
V_LINE_TO, 22,
CUBIC_TO, 1, 22.55, 1.45, 23, 2, 23,
H_LINE_TO, 22,
CUBIC_TO, 22.55, 23, 23, 22.55, 23, 22,
V_LINE_TO, 2,
CUBIC_TO, 23, 1.45, 22.55, 1, 22, 1,
H_LINE_TO, 15,
V_LINE_TO, 4,
H_LINE_TO, 20,
V_LINE_TO, 20,
H_LINE_TO, 4,
V_LINE_TO, 15,
H_LINE_TO, 1,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kUnfloatButton12Path, CANVAS_DIMENSIONS, 12,
NEW_PATH,
MOVE_TO, 8, 3,
H_LINE_TO, 9,
V_LINE_TO, 9,
H_LINE_TO, 3,
V_LINE_TO, 8,
H_LINE_TO, 1,
V_LINE_TO, 11,
H_LINE_TO, 11,
V_LINE_TO, 1,
H_LINE_TO, 8,
V_LINE_TO, 3,
CLOSE,
NEW_PATH,
MOVE_TO, 3, 4.41,
V_LINE_TO, 6,
H_LINE_TO, 1,
V_LINE_TO, 1,
H_LINE_TO, 6,
V_LINE_TO, 3,
H_LINE_TO, 4.41,
LINE_TO, 6.71, 5.29,
LINE_TO, 5.29, 6.71,
LINE_TO, 3, 4.41,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUnfloatButtonRepList, kUnfloatButtonIcon, {kUnfloatButtonPath}, {kUnfloatButton12Path})
VECTOR_ICON_REP_TEMPLATE(kWindowControlBackPath, CANVAS_DIMENSIONS, 24,
FLIPS_IN_RTL,
MOVE_TO, 6.83, 10,
H_LINE_TO, 23,
R_V_LINE_TO, 3,
H_LINE_TO, 6.83,
LINE_TO, 15, 20.96,
LINE_TO, 12.86, 23,
LINE_TO, 4.93, 15.25,
LINE_TO, 1, 11.5,
R_LINE_TO, 5, -4.77,
LINE_TO, 12.86, 0,
LINE_TO, 15, 2.05,
LINE_TO, 6.83, 10,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kWindowControlBack12Path, CANVAS_DIMENSIONS, 12,
FLIPS_IN_RTL,
MOVE_TO, 4.92, 5,
H_LINE_TO, 11,
R_V_LINE_TO, 2,
H_LINE_TO, 4.92,
LINE_TO, 8, 9.75,
LINE_TO, 6.6, 11,
LINE_TO, 1, 6,
R_LINE_TO, 0.7, -0.62,
LINE_TO, 6.6, 1,
LINE_TO, 8, 2.25,
LINE_TO, 4.92, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlBackRepList, kWindowControlBackIcon, {kWindowControlBackPath}, {kWindowControlBack12Path})
VECTOR_ICON_REP_TEMPLATE(kWindowControlBottomSnappedPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 15.83, 9.33,
LINE_TO, 12, 13.45,
LINE_TO, 8.18, 9.33,
LINE_TO, 7, 10.6,
LINE_TO, 12, 16,
LINE_TO, 17, 10.6,
LINE_TO, 15.83, 9.33,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlBottomSnappedRepList, kWindowControlBottomSnappedIcon, {kWindowControlBottomSnappedPath})
VECTOR_ICON_REP_TEMPLATE(kWindowControlDezoomPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 14, 0,
R_H_LINE_TO, 4,
R_V_LINE_TO, 6,
R_H_LINE_TO, 6,
R_V_LINE_TO, 4,
H_LINE_TO, 14,
V_LINE_TO, 0,
CLOSE,
MOVE_TO, 0, 14,
R_H_LINE_TO, 10,
R_V_LINE_TO, 10,
H_LINE_TO, 6,
R_V_LINE_TO, -6,
H_LINE_TO, 0,
R_V_LINE_TO, -4,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kWindowControlDezoom12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 7, 0,
LINE_TO, 9, 0,
LINE_TO, 9, 3,
LINE_TO, 12, 3,
LINE_TO, 12, 5,
LINE_TO, 7, 5,
LINE_TO, 7, 0,
CLOSE,
MOVE_TO, 0, 7,
LINE_TO, 5, 7,
LINE_TO, 5, 12,
LINE_TO, 3, 12,
LINE_TO, 3, 9,
LINE_TO, 0, 9,
LINE_TO, 0, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlDezoomRepList, kWindowControlDezoomIcon, {kWindowControlDezoomPath}, {kWindowControlDezoom12Path})
VECTOR_ICON_REP_TEMPLATE(kWindowControlFloatPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 4, 18,
V_LINE_TO, 6,
R_H_LINE_TO, 16,
R_V_LINE_TO, 3,
R_H_LINE_TO, 3,
V_LINE_TO, 5,
R_ARC_TO, 2, 2, 0, 0, 0, -2, -2,
H_LINE_TO, 3,
R_ARC_TO, 2, 2, 0, 0, 0, -2, 2,
R_V_LINE_TO, 14,
R_ARC_TO, 2, 2, 0, 0, 0, 2, 2,
R_H_LINE_TO, 10,
R_V_LINE_TO, -3,
H_LINE_TO, 4,
CLOSE,
NEW_PATH,
MOVE_TO, 16, 14,
R_ARC_TO, 2, 2, 0, 0, 1, 2, -2,
R_H_LINE_TO, 3,
R_ARC_TO, 2, 2, 0, 0, 1, 2, 2,
R_V_LINE_TO, 5,
R_ARC_TO, 2, 2, 0, 0, 1, -2, 2,
R_H_LINE_TO, -3,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
R_V_LINE_TO, -5,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kWindowControlFloat12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 9, 3,
H_LINE_TO, 3,
R_V_LINE_TO, 6,
R_H_LINE_TO, 4,
R_V_LINE_TO, 2,
H_LINE_TO, 1,
V_LINE_TO, 1,
R_H_LINE_TO, 10,
R_V_LINE_TO, 5,
H_LINE_TO, 9,
V_LINE_TO, 3,
CLOSE,
NEW_PATH,
MOVE_TO, 11, 7,
H_LINE_TO, 8,
R_V_LINE_TO, 4,
R_H_LINE_TO, 3,
V_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlFloatRepList, kWindowControlFloatIcon, {kWindowControlFloatPath}, {kWindowControlFloat12Path})
VECTOR_ICON_REP_TEMPLATE(kWindowControlLeftSnappedPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 15, 2.05,
LINE_TO, 5.29, 11.5,
LINE_TO, 15, 20.96,
LINE_TO, 12.86, 23,
LINE_TO, 4.93, 15.25,
LINE_TO, 1, 11.5,
R_LINE_TO, 5, -4.77,
LINE_TO, 12.86, 0,
LINE_TO, 15, 2.05,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kWindowControlLeftSnapped12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 1, 6,
R_LINE_TO, 5.6, 5,
LINE_TO, 8, 9.75,
LINE_TO, 3.8, 6,
LINE_TO, 8, 2.25,
LINE_TO, 6.6, 1,
LINE_TO, 1.7, 5.38,
LINE_TO, 1, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlLeftSnappedRepList, kWindowControlLeftSnappedIcon, {kWindowControlLeftSnappedPath}, {kWindowControlLeftSnapped12Path})
VECTOR_ICON_REP_TEMPLATE(kWindowControlRightSnappedPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 9, 2.05,
R_LINE_TO, 9.71, 9.46,
LINE_TO, 9, 20.96,
LINE_TO, 11.14, 23,
R_LINE_TO, 7.93, -7.75,
LINE_TO, 23, 11.5,
R_LINE_TO, -5, -4.77,
LINE_TO, 11.14, 0,
LINE_TO, 9, 2.05,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kWindowControlRightSnapped12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 11, 6,
R_LINE_TO, -5.6, 5,
LINE_TO, 4, 9.75,
LINE_TO, 8.2, 6,
LINE_TO, 4, 2.25,
LINE_TO, 5.4, 1,
R_LINE_TO, 4.9, 4.38,
LINE_TO, 11, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlRightSnappedRepList, kWindowControlRightSnappedIcon, {kWindowControlRightSnappedPath}, {kWindowControlRightSnapped12Path})
VECTOR_ICON_REP_TEMPLATE(kWindowControlTopSnappedPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 8.18, 16,
LINE_TO, 12, 11.88,
LINE_TO, 15.83, 16,
LINE_TO, 17, 14.73,
LINE_TO, 12, 9.33,
LINE_TO, 7, 14.73,
LINE_TO, 8.18, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlTopSnappedRepList, kWindowControlTopSnappedIcon, {kWindowControlTopSnappedPath})
VECTOR_ICON_REP_TEMPLATE(kWindowControlUnfloatPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 10, 3,
H_LINE_TO, 1,
R_V_LINE_TO, 9,
R_H_LINE_TO, 3,
V_LINE_TO, 8.12,
R_LINE_TO, 4.94, 4.94,
R_LINE_TO, 2.12, -2.12,
LINE_TO, 6.12, 6,
H_LINE_TO, 10,
V_LINE_TO, 3,
CLOSE,
MOVE_TO, 1, 19,
R_V_LINE_TO, -4,
R_H_LINE_TO, 3,
R_V_LINE_TO, 3,
R_H_LINE_TO, 9,
R_V_LINE_TO, 3,
H_LINE_TO, 3,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
CLOSE,
MOVE_TO, 23, 9,
V_LINE_TO, 5,
R_ARC_TO, 2, 2, 0, 0, 0, -2, -2,
R_H_LINE_TO, -8,
R_V_LINE_TO, 3,
R_H_LINE_TO, 7,
R_V_LINE_TO, 3,
R_H_LINE_TO, 3,
CLOSE,
MOVE_TO, 18, 12,
R_ARC_TO, 2, 2, 0, 0, 0, -2, 2,
R_V_LINE_TO, 5,
R_ARC_TO, 2, 2, 0, 0, 0, 2, 2,
R_H_LINE_TO, 3,
R_ARC_TO, 2, 2, 0, 0, 0, 2, -2,
R_V_LINE_TO, -5,
R_ARC_TO, 2, 2, 0, 0, 0, -2, -2,
R_H_LINE_TO, -3,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kWindowControlUnfloat12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 8, 7,
R_H_LINE_TO, 3,
R_V_LINE_TO, 4,
H_LINE_TO, 8,
V_LINE_TO, 7,
CLOSE,
MOVE_TO, 3, 3,
R_H_LINE_TO, 3,
V_LINE_TO, 1,
H_LINE_TO, 1,
R_V_LINE_TO, 5,
R_H_LINE_TO, 2,
V_LINE_TO, 3,
CLOSE,
MOVE_TO, 3, 7,
H_LINE_TO, 1,
R_V_LINE_TO, 4,
R_H_LINE_TO, 6,
V_LINE_TO, 9,
H_LINE_TO, 3,
V_LINE_TO, 7,
CLOSE,
MOVE_TO, 9, 3,
H_LINE_TO, 7,
V_LINE_TO, 1,
R_H_LINE_TO, 4,
R_V_LINE_TO, 5,
H_LINE_TO, 9,
V_LINE_TO, 3,
CLOSE,
NEW_PATH,
R_MOVE_TO, 5.29, 6.71,
R_LINE_TO, -4, -4,
R_LINE_TO, 1.41, -1.41,
R_LINE_TO, 4, 4,
R_LINE_TO, -1.41, 1.41,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlUnfloatRepList, kWindowControlUnfloatIcon, {kWindowControlUnfloatPath}, {kWindowControlUnfloat12Path})
VECTOR_ICON_REP_TEMPLATE(kWindowControlZoomPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 14, 0,
R_H_LINE_TO, 10,
R_V_LINE_TO, 10,
R_H_LINE_TO, -4,
V_LINE_TO, 4,
H_LINE_TO, 14,
V_LINE_TO, 0,
CLOSE,
MOVE_TO, 0, 14,
R_H_LINE_TO, 4,
R_V_LINE_TO, 6,
R_H_LINE_TO, 6,
R_V_LINE_TO, 4,
H_LINE_TO, 0,
V_LINE_TO, 14,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kWindowControlZoom12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 7, 0,
R_H_LINE_TO, 5,
R_V_LINE_TO, 5,
R_H_LINE_TO, -2,
V_LINE_TO, 2,
H_LINE_TO, 7,
V_LINE_TO, 0,
CLOSE,
MOVE_TO, 0, 7,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
R_H_LINE_TO, 3,
R_V_LINE_TO, 2,
H_LINE_TO, 0,
V_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowControlZoomRepList, kWindowControlZoomIcon, {kWindowControlZoomPath}, {kWindowControlZoom12Path})

}  // namespace chromeos
