// chrome/services/file_util/public/mojom/single_file_extractor.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SINGLE_FILE_EXTRACTOR_MOJOM_PARAMS_DATA_H_
#define CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SINGLE_FILE_EXTRACTOR_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace chrome::mojom {
namespace internal {
class  SingleFileExtractor_Extract_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> src_file;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> dst_file;
  mojo::internal::Interface_Data listener;

 private:
  friend class mojo::internal::MessageFragment<SingleFileExtractor_Extract_Params_Data>;

  SingleFileExtractor_Extract_Params_Data();
  ~SingleFileExtractor_Extract_Params_Data() = delete;
};
static_assert(sizeof(SingleFileExtractor_Extract_Params_Data) == 32,
              "Bad sizeof(SingleFileExtractor_Extract_Params_Data)");
class  SingleFileExtractor_Extract_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SingleFileExtractor_Extract_ResponseParams_Data>;

  SingleFileExtractor_Extract_ResponseParams_Data();
  ~SingleFileExtractor_Extract_ResponseParams_Data() = delete;
};
static_assert(sizeof(SingleFileExtractor_Extract_ResponseParams_Data) == 16,
              "Bad sizeof(SingleFileExtractor_Extract_ResponseParams_Data)");
class  SingleFileExtractorListener_OnProgress_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t total_bytes;
  uint64_t progress_bytes;

 private:
  friend class mojo::internal::MessageFragment<SingleFileExtractorListener_OnProgress_Params_Data>;

  SingleFileExtractorListener_OnProgress_Params_Data();
  ~SingleFileExtractorListener_OnProgress_Params_Data() = delete;
};
static_assert(sizeof(SingleFileExtractorListener_OnProgress_Params_Data) == 24,
              "Bad sizeof(SingleFileExtractorListener_OnProgress_Params_Data)");

}  // namespace internal


class SingleFileExtractor_Extract_ParamsDataView {
 public:
  SingleFileExtractor_Extract_ParamsDataView() = default;

  SingleFileExtractor_Extract_ParamsDataView(
      internal::SingleFileExtractor_Extract_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrcFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcFile(UserType* output) {
    
    auto* pointer = data_->src_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetDstFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDstFile(UserType* output) {
    
    auto* pointer = data_->dst_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::chrome::mojom::SingleFileExtractorListenerInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::SingleFileExtractor_Extract_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SingleFileExtractor_Extract_ResponseParamsDataView {
 public:
  SingleFileExtractor_Extract_ResponseParamsDataView() = default;

  SingleFileExtractor_Extract_ResponseParamsDataView(
      internal::SingleFileExtractor_Extract_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::chrome::file_util::mojom::ExtractionResult>(
        data_value, output);
  }
  ::chrome::file_util::mojom::ExtractionResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::file_util::mojom::ExtractionResult>(data_->result));
  }
 private:
  internal::SingleFileExtractor_Extract_ResponseParams_Data* data_ = nullptr;
};


class SingleFileExtractorListener_OnProgress_ParamsDataView {
 public:
  SingleFileExtractorListener_OnProgress_ParamsDataView() = default;

  SingleFileExtractorListener_OnProgress_ParamsDataView(
      internal::SingleFileExtractorListener_OnProgress_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t total_bytes() const {
    return data_->total_bytes;
  }
  uint64_t progress_bytes() const {
    return data_->progress_bytes;
  }
 private:
  internal::SingleFileExtractorListener_OnProgress_Params_Data* data_ = nullptr;
};

inline void SingleFileExtractor_Extract_ParamsDataView::GetSrcFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->src_file.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}
inline void SingleFileExtractor_Extract_ParamsDataView::GetDstFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->dst_file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}







}  // chrome::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SINGLE_FILE_EXTRACTOR_MOJOM_PARAMS_DATA_H_