// chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-params-data.h"
namespace chrome {
namespace mojom {

namespace internal {


// static
bool SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data* object =
      static_cast<const SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->zip_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->zip_file, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& password_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->password, validation_context,
                                         &password_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->temp_file_getter, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->temp_file_getter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data::SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data* object =
      static_cast<const SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->results, validation_context))
    return false;

  return true;
}

SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data::SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data* object =
      static_cast<const SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dmg_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dmg_file, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->temp_file_getter, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->temp_file_getter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data::SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data* object =
      static_cast<const SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->results, validation_context))
    return false;

  return true;
}

SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data::SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data* object =
      static_cast<const SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rar_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rar_file, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& password_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->password, validation_context,
                                         &password_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->temp_file_getter, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->temp_file_getter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data::SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data* object =
      static_cast<const SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->results, validation_context))
    return false;

  return true;
}

SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data::SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data* object =
      static_cast<const SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seven_zip_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seven_zip_file, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->temp_file_getter, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->temp_file_getter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data::SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data* object =
      static_cast<const SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->results, validation_context))
    return false;

  return true;
}

SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data::SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TemporaryFileGetter_RequestTemporaryFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TemporaryFileGetter_RequestTemporaryFile_Params_Data* object =
      static_cast<const TemporaryFileGetter_RequestTemporaryFile_Params_Data*>(data);

  return true;
}

TemporaryFileGetter_RequestTemporaryFile_Params_Data::TemporaryFileGetter_RequestTemporaryFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data* object =
      static_cast<const TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->temp_file, validation_context))
    return false;

  return true;
}

TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data::TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome