// chrome/common/search/search.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/search/search.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/search/search.mojom-params-data.h"
#include "chrome/common/search/search.mojom-shared-message-ids.h"

#include "chrome/common/search/search.mojom-import-headers.h"
#include "chrome/common/search/search.mojom-test-utils.h"
#include "chrome/common/search/instant_mojom_traits.h"


namespace search::mojom {
// The declaration includes the definition on other builds.

EmbeddedSearchConnector::IPCStableHashFunction EmbeddedSearchConnector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EmbeddedSearchConnector>(message.name())) {
    case messages::EmbeddedSearchConnector::kConnect: {
      return &EmbeddedSearchConnector::Connect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EmbeddedSearchConnector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EmbeddedSearchConnector>(message.name())) {
      case messages::EmbeddedSearchConnector::kConnect:
            return "Receive search::mojom::EmbeddedSearchConnector::Connect";
    }
  } else {
    switch (static_cast<messages::EmbeddedSearchConnector>(message.name())) {
      case messages::EmbeddedSearchConnector::kConnect:
            return "Receive reply search::mojom::EmbeddedSearchConnector::Connect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EmbeddedSearchConnector::Connect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc719c21d;  // IPCStableHash for search::mojom::EmbeddedSearchConnector::Connect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

EmbeddedSearchConnectorProxy::EmbeddedSearchConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedSearchConnectorProxy::Connect(
    ::mojo::PendingAssociatedReceiver<EmbeddedSearch> in_embedded_search, ::mojo::PendingAssociatedRemote<EmbeddedSearchClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearchConnector::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedded_search"), in_embedded_search,
                        "<value of type ::mojo::PendingAssociatedReceiver<EmbeddedSearch>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<EmbeddedSearchClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearchConnector::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearchConnector_Connect_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::search::mojom::EmbeddedSearchAssociatedRequestDataView>(
    in_embedded_search,
    &params->embedded_search,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->embedded_search)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid embedded_search in EmbeddedSearchConnector.Connect request");

  
  mojo::internal::Serialize<::search::mojom::EmbeddedSearchClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in EmbeddedSearchConnector.Connect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearchConnector::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool EmbeddedSearchConnectorStubDispatch::Accept(
    EmbeddedSearchConnector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EmbeddedSearchConnector>(message->header()->name)) {
    case messages::EmbeddedSearchConnector::kConnect: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearchConnector_Connect_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearchConnector_Connect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearchConnector.0
      bool success = true;
      ::mojo::PendingAssociatedReceiver<EmbeddedSearch> p_embedded_search{};
      ::mojo::PendingAssociatedRemote<EmbeddedSearchClient> p_client{};
      EmbeddedSearchConnector_Connect_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_embedded_search =
            input_data_view.TakeEmbeddedSearch<decltype(p_embedded_search)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearchConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_embedded_search), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedSearchConnectorStubDispatch::AcceptWithResponder(
    EmbeddedSearchConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EmbeddedSearchConnector>(message->header()->name)) {
    case messages::EmbeddedSearchConnector::kConnect: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEmbeddedSearchConnectorValidationInfo[] = {
    { &internal::EmbeddedSearchConnector_Connect_Params_Data::Validate,
     nullptr /* no response */},
};

bool EmbeddedSearchConnectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::search::mojom::EmbeddedSearchConnector::Name_,
    kEmbeddedSearchConnectorValidationInfo);
}

// The declaration includes the definition on other builds.

EmbeddedSearch::IPCStableHashFunction EmbeddedSearch::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EmbeddedSearch>(message.name())) {
    case messages::EmbeddedSearch::kFocusOmnibox: {
      return &EmbeddedSearch::FocusOmnibox_Sym::IPCStableHash;
    }
    case messages::EmbeddedSearch::kDeleteMostVisitedItem: {
      return &EmbeddedSearch::DeleteMostVisitedItem_Sym::IPCStableHash;
    }
    case messages::EmbeddedSearch::kUndoAllMostVisitedDeletions: {
      return &EmbeddedSearch::UndoAllMostVisitedDeletions_Sym::IPCStableHash;
    }
    case messages::EmbeddedSearch::kUndoMostVisitedDeletion: {
      return &EmbeddedSearch::UndoMostVisitedDeletion_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EmbeddedSearch::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EmbeddedSearch>(message.name())) {
      case messages::EmbeddedSearch::kFocusOmnibox:
            return "Receive search::mojom::EmbeddedSearch::FocusOmnibox";
      case messages::EmbeddedSearch::kDeleteMostVisitedItem:
            return "Receive search::mojom::EmbeddedSearch::DeleteMostVisitedItem";
      case messages::EmbeddedSearch::kUndoAllMostVisitedDeletions:
            return "Receive search::mojom::EmbeddedSearch::UndoAllMostVisitedDeletions";
      case messages::EmbeddedSearch::kUndoMostVisitedDeletion:
            return "Receive search::mojom::EmbeddedSearch::UndoMostVisitedDeletion";
    }
  } else {
    switch (static_cast<messages::EmbeddedSearch>(message.name())) {
      case messages::EmbeddedSearch::kFocusOmnibox:
            return "Receive reply search::mojom::EmbeddedSearch::FocusOmnibox";
      case messages::EmbeddedSearch::kDeleteMostVisitedItem:
            return "Receive reply search::mojom::EmbeddedSearch::DeleteMostVisitedItem";
      case messages::EmbeddedSearch::kUndoAllMostVisitedDeletions:
            return "Receive reply search::mojom::EmbeddedSearch::UndoAllMostVisitedDeletions";
      case messages::EmbeddedSearch::kUndoMostVisitedDeletion:
            return "Receive reply search::mojom::EmbeddedSearch::UndoMostVisitedDeletion";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EmbeddedSearch::FocusOmnibox_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4237ade4;  // IPCStableHash for search::mojom::EmbeddedSearch::FocusOmnibox
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedSearch::DeleteMostVisitedItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1a8b30b;  // IPCStableHash for search::mojom::EmbeddedSearch::DeleteMostVisitedItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedSearch::UndoAllMostVisitedDeletions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe2f86f33;  // IPCStableHash for search::mojom::EmbeddedSearch::UndoAllMostVisitedDeletions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedSearch::UndoMostVisitedDeletion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81bde113;  // IPCStableHash for search::mojom::EmbeddedSearch::UndoMostVisitedDeletion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

EmbeddedSearchProxy::EmbeddedSearchProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedSearchProxy::FocusOmnibox(
    int32_t in_page_seq_no, bool in_focus) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearch::FocusOmnibox", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_seq_no"), in_page_seq_no,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus"), in_focus,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearch::kFocusOmnibox), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearch_FocusOmnibox_Params_Data> params(
          message);
  params.Allocate();

  params->page_seq_no = in_page_seq_no;

  params->focus = in_focus;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearch::Name_);
  message.set_method_name("FocusOmnibox");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedSearchProxy::DeleteMostVisitedItem(
    int32_t in_page_seq_no, const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearch::DeleteMostVisitedItem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_seq_no"), in_page_seq_no,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearch::kDeleteMostVisitedItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearch_DeleteMostVisitedItem_Params_Data> params(
          message);
  params.Allocate();

  params->page_seq_no = in_page_seq_no;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in EmbeddedSearch.DeleteMostVisitedItem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearch::Name_);
  message.set_method_name("DeleteMostVisitedItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedSearchProxy::UndoAllMostVisitedDeletions(
    int32_t in_page_seq_no) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearch::UndoAllMostVisitedDeletions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_seq_no"), in_page_seq_no,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearch::kUndoAllMostVisitedDeletions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data> params(
          message);
  params.Allocate();

  params->page_seq_no = in_page_seq_no;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearch::Name_);
  message.set_method_name("UndoAllMostVisitedDeletions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedSearchProxy::UndoMostVisitedDeletion(
    int32_t in_page_seq_no, const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearch::UndoMostVisitedDeletion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_seq_no"), in_page_seq_no,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearch::kUndoMostVisitedDeletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearch_UndoMostVisitedDeletion_Params_Data> params(
          message);
  params.Allocate();

  params->page_seq_no = in_page_seq_no;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in EmbeddedSearch.UndoMostVisitedDeletion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearch::Name_);
  message.set_method_name("UndoMostVisitedDeletion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool EmbeddedSearchStubDispatch::Accept(
    EmbeddedSearch* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EmbeddedSearch>(message->header()->name)) {
    case messages::EmbeddedSearch::kFocusOmnibox: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearch_FocusOmnibox_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearch_FocusOmnibox_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearch.0
      bool success = true;
      int32_t p_page_seq_no{};
      bool p_focus{};
      EmbeddedSearch_FocusOmnibox_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_page_seq_no = input_data_view.page_seq_no();
      if (success)
        p_focus = input_data_view.focus();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearch::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusOmnibox(        
        std::move(p_page_seq_no), 
        std::move(p_focus));
      return true;
    }
    case messages::EmbeddedSearch::kDeleteMostVisitedItem: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearch_DeleteMostVisitedItem_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearch_DeleteMostVisitedItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearch.1
      bool success = true;
      int32_t p_page_seq_no{};
      ::GURL p_url{};
      EmbeddedSearch_DeleteMostVisitedItem_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_page_seq_no = input_data_view.page_seq_no();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearch::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteMostVisitedItem(        
        std::move(p_page_seq_no), 
        std::move(p_url));
      return true;
    }
    case messages::EmbeddedSearch::kUndoAllMostVisitedDeletions: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearch.2
      bool success = true;
      int32_t p_page_seq_no{};
      EmbeddedSearch_UndoAllMostVisitedDeletions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_page_seq_no = input_data_view.page_seq_no();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearch::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UndoAllMostVisitedDeletions(        
        std::move(p_page_seq_no));
      return true;
    }
    case messages::EmbeddedSearch::kUndoMostVisitedDeletion: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearch_UndoMostVisitedDeletion_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearch_UndoMostVisitedDeletion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearch.3
      bool success = true;
      int32_t p_page_seq_no{};
      ::GURL p_url{};
      EmbeddedSearch_UndoMostVisitedDeletion_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_page_seq_no = input_data_view.page_seq_no();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearch::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UndoMostVisitedDeletion(        
        std::move(p_page_seq_no), 
        std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedSearchStubDispatch::AcceptWithResponder(
    EmbeddedSearch* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EmbeddedSearch>(message->header()->name)) {
    case messages::EmbeddedSearch::kFocusOmnibox: {
      break;
    }
    case messages::EmbeddedSearch::kDeleteMostVisitedItem: {
      break;
    }
    case messages::EmbeddedSearch::kUndoAllMostVisitedDeletions: {
      break;
    }
    case messages::EmbeddedSearch::kUndoMostVisitedDeletion: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEmbeddedSearchValidationInfo[] = {
    { &internal::EmbeddedSearch_FocusOmnibox_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedSearch_DeleteMostVisitedItem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedSearch_UndoMostVisitedDeletion_Params_Data::Validate,
     nullptr /* no response */},
};

bool EmbeddedSearchRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::search::mojom::EmbeddedSearch::Name_,
    kEmbeddedSearchValidationInfo);
}

// The declaration includes the definition on other builds.

EmbeddedSearchClient::IPCStableHashFunction EmbeddedSearchClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EmbeddedSearchClient>(message.name())) {
    case messages::EmbeddedSearchClient::kSetPageSequenceNumber: {
      return &EmbeddedSearchClient::SetPageSequenceNumber_Sym::IPCStableHash;
    }
    case messages::EmbeddedSearchClient::kFocusChanged: {
      return &EmbeddedSearchClient::FocusChanged_Sym::IPCStableHash;
    }
    case messages::EmbeddedSearchClient::kMostVisitedInfoChanged: {
      return &EmbeddedSearchClient::MostVisitedInfoChanged_Sym::IPCStableHash;
    }
    case messages::EmbeddedSearchClient::kSetInputInProgress: {
      return &EmbeddedSearchClient::SetInputInProgress_Sym::IPCStableHash;
    }
    case messages::EmbeddedSearchClient::kThemeChanged: {
      return &EmbeddedSearchClient::ThemeChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EmbeddedSearchClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EmbeddedSearchClient>(message.name())) {
      case messages::EmbeddedSearchClient::kSetPageSequenceNumber:
            return "Receive search::mojom::EmbeddedSearchClient::SetPageSequenceNumber";
      case messages::EmbeddedSearchClient::kFocusChanged:
            return "Receive search::mojom::EmbeddedSearchClient::FocusChanged";
      case messages::EmbeddedSearchClient::kMostVisitedInfoChanged:
            return "Receive search::mojom::EmbeddedSearchClient::MostVisitedInfoChanged";
      case messages::EmbeddedSearchClient::kSetInputInProgress:
            return "Receive search::mojom::EmbeddedSearchClient::SetInputInProgress";
      case messages::EmbeddedSearchClient::kThemeChanged:
            return "Receive search::mojom::EmbeddedSearchClient::ThemeChanged";
    }
  } else {
    switch (static_cast<messages::EmbeddedSearchClient>(message.name())) {
      case messages::EmbeddedSearchClient::kSetPageSequenceNumber:
            return "Receive reply search::mojom::EmbeddedSearchClient::SetPageSequenceNumber";
      case messages::EmbeddedSearchClient::kFocusChanged:
            return "Receive reply search::mojom::EmbeddedSearchClient::FocusChanged";
      case messages::EmbeddedSearchClient::kMostVisitedInfoChanged:
            return "Receive reply search::mojom::EmbeddedSearchClient::MostVisitedInfoChanged";
      case messages::EmbeddedSearchClient::kSetInputInProgress:
            return "Receive reply search::mojom::EmbeddedSearchClient::SetInputInProgress";
      case messages::EmbeddedSearchClient::kThemeChanged:
            return "Receive reply search::mojom::EmbeddedSearchClient::ThemeChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EmbeddedSearchClient::SetPageSequenceNumber_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd8f9c2c;  // IPCStableHash for search::mojom::EmbeddedSearchClient::SetPageSequenceNumber
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedSearchClient::FocusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee742121;  // IPCStableHash for search::mojom::EmbeddedSearchClient::FocusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedSearchClient::MostVisitedInfoChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8027e599;  // IPCStableHash for search::mojom::EmbeddedSearchClient::MostVisitedInfoChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedSearchClient::SetInputInProgress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f36cfe6;  // IPCStableHash for search::mojom::EmbeddedSearchClient::SetInputInProgress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedSearchClient::ThemeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e96fc11;  // IPCStableHash for search::mojom::EmbeddedSearchClient::ThemeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

EmbeddedSearchClientProxy::EmbeddedSearchClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedSearchClientProxy::SetPageSequenceNumber(
    int32_t in_page_seq_no) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearchClient::SetPageSequenceNumber", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_seq_no"), in_page_seq_no,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearchClient::kSetPageSequenceNumber), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearchClient_SetPageSequenceNumber_Params_Data> params(
          message);
  params.Allocate();

  params->page_seq_no = in_page_seq_no;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearchClient::Name_);
  message.set_method_name("SetPageSequenceNumber");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedSearchClientProxy::FocusChanged(
    ::OmniboxFocusState in_new_focus_state, ::OmniboxFocusChangeReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearchClient::FocusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_focus_state"), in_new_focus_state,
                        "<value of type ::OmniboxFocusState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::OmniboxFocusChangeReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearchClient::kFocusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearchClient_FocusChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::search::mojom::OmniboxFocusState>(
    in_new_focus_state,
    &params->new_focus_state);

  
  mojo::internal::Serialize<::search::mojom::OmniboxFocusChangeReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearchClient::Name_);
  message.set_method_name("FocusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedSearchClientProxy::MostVisitedInfoChanged(
    const ::InstantMostVisitedInfo& in_most_visited_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearchClient::MostVisitedInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("most_visited_info"), in_most_visited_info,
                        "<value of type const ::InstantMostVisitedInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearchClient::kMostVisitedInfoChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->most_visited_info)::BaseType> most_visited_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::search::mojom::InstantMostVisitedInfoDataView>(
    in_most_visited_info,
    most_visited_info_fragment);

  params->most_visited_info.Set(
      most_visited_info_fragment.is_null() ? nullptr : most_visited_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->most_visited_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null most_visited_info in EmbeddedSearchClient.MostVisitedInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearchClient::Name_);
  message.set_method_name("MostVisitedInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedSearchClientProxy::SetInputInProgress(
    bool in_input_in_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearchClient::SetInputInProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_in_progress"), in_input_in_progress,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearchClient::kSetInputInProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearchClient_SetInputInProgress_Params_Data> params(
          message);
  params.Allocate();

  params->input_in_progress = in_input_in_progress;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearchClient::Name_);
  message.set_method_name("SetInputInProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedSearchClientProxy::ThemeChanged(
    const ::NtpTheme& in_theme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send search::mojom::EmbeddedSearchClient::ThemeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme"), in_theme,
                        "<value of type const ::NtpTheme&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedSearchClient::kThemeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::search::mojom::internal::EmbeddedSearchClient_ThemeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme)::BaseType> theme_fragment(
          params.message());
  
  mojo::internal::Serialize<::search::mojom::NtpThemeDataView>(
    in_theme,
    theme_fragment);

  params->theme.Set(
      theme_fragment.is_null() ? nullptr : theme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->theme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null theme in EmbeddedSearchClient.ThemeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedSearchClient::Name_);
  message.set_method_name("ThemeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool EmbeddedSearchClientStubDispatch::Accept(
    EmbeddedSearchClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EmbeddedSearchClient>(message->header()->name)) {
    case messages::EmbeddedSearchClient::kSetPageSequenceNumber: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearchClient_SetPageSequenceNumber_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearchClient_SetPageSequenceNumber_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearchClient.0
      bool success = true;
      int32_t p_page_seq_no{};
      EmbeddedSearchClient_SetPageSequenceNumber_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_page_seq_no = input_data_view.page_seq_no();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearchClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageSequenceNumber(        
        std::move(p_page_seq_no));
      return true;
    }
    case messages::EmbeddedSearchClient::kFocusChanged: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearchClient_FocusChanged_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearchClient_FocusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearchClient.1
      bool success = true;
      ::OmniboxFocusState p_new_focus_state{};
      ::OmniboxFocusChangeReason p_reason{};
      EmbeddedSearchClient_FocusChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewFocusState(&p_new_focus_state))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearchClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusChanged(        
        std::move(p_new_focus_state), 
        std::move(p_reason));
      return true;
    }
    case messages::EmbeddedSearchClient::kMostVisitedInfoChanged: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearchClient.2
      bool success = true;
      ::InstantMostVisitedInfo p_most_visited_info{};
      EmbeddedSearchClient_MostVisitedInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMostVisitedInfo(&p_most_visited_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearchClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MostVisitedInfoChanged(        
        std::move(p_most_visited_info));
      return true;
    }
    case messages::EmbeddedSearchClient::kSetInputInProgress: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearchClient_SetInputInProgress_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearchClient_SetInputInProgress_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearchClient.3
      bool success = true;
      bool p_input_in_progress{};
      EmbeddedSearchClient_SetInputInProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_input_in_progress = input_data_view.input_in_progress();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearchClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInputInProgress(        
        std::move(p_input_in_progress));
      return true;
    }
    case messages::EmbeddedSearchClient::kThemeChanged: {
      DCHECK(message->is_serialized());
      internal::EmbeddedSearchClient_ThemeChanged_Params_Data* params =
          reinterpret_cast<internal::EmbeddedSearchClient_ThemeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedSearchClient.4
      bool success = true;
      ::NtpTheme p_theme{};
      EmbeddedSearchClient_ThemeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTheme(&p_theme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedSearchClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ThemeChanged(        
        std::move(p_theme));
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedSearchClientStubDispatch::AcceptWithResponder(
    EmbeddedSearchClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EmbeddedSearchClient>(message->header()->name)) {
    case messages::EmbeddedSearchClient::kSetPageSequenceNumber: {
      break;
    }
    case messages::EmbeddedSearchClient::kFocusChanged: {
      break;
    }
    case messages::EmbeddedSearchClient::kMostVisitedInfoChanged: {
      break;
    }
    case messages::EmbeddedSearchClient::kSetInputInProgress: {
      break;
    }
    case messages::EmbeddedSearchClient::kThemeChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEmbeddedSearchClientValidationInfo[] = {
    { &internal::EmbeddedSearchClient_SetPageSequenceNumber_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedSearchClient_FocusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedSearchClient_SetInputInProgress_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedSearchClient_ThemeChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool EmbeddedSearchClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::search::mojom::EmbeddedSearchClient::Name_,
    kEmbeddedSearchClientValidationInfo);
}



}  // search::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace search::mojom {


void EmbeddedSearchConnectorInterceptorForTesting::Connect(::mojo::PendingAssociatedReceiver<EmbeddedSearch> embedded_search, ::mojo::PendingAssociatedRemote<EmbeddedSearchClient> client) {
  GetForwardingInterface()->Connect(
    std::move(embedded_search)
    , 
    std::move(client)
    );
}
EmbeddedSearchConnectorAsyncWaiter::EmbeddedSearchConnectorAsyncWaiter(
    EmbeddedSearchConnector* proxy) : proxy_(proxy) {}

EmbeddedSearchConnectorAsyncWaiter::~EmbeddedSearchConnectorAsyncWaiter() = default;





void EmbeddedSearchInterceptorForTesting::FocusOmnibox(int32_t page_seq_no, bool focus) {
  GetForwardingInterface()->FocusOmnibox(
    std::move(page_seq_no)
    , 
    std::move(focus)
    );
}
void EmbeddedSearchInterceptorForTesting::DeleteMostVisitedItem(int32_t page_seq_no, const ::GURL& url) {
  GetForwardingInterface()->DeleteMostVisitedItem(
    std::move(page_seq_no)
    , 
    std::move(url)
    );
}
void EmbeddedSearchInterceptorForTesting::UndoAllMostVisitedDeletions(int32_t page_seq_no) {
  GetForwardingInterface()->UndoAllMostVisitedDeletions(
    std::move(page_seq_no)
    );
}
void EmbeddedSearchInterceptorForTesting::UndoMostVisitedDeletion(int32_t page_seq_no, const ::GURL& url) {
  GetForwardingInterface()->UndoMostVisitedDeletion(
    std::move(page_seq_no)
    , 
    std::move(url)
    );
}
EmbeddedSearchAsyncWaiter::EmbeddedSearchAsyncWaiter(
    EmbeddedSearch* proxy) : proxy_(proxy) {}

EmbeddedSearchAsyncWaiter::~EmbeddedSearchAsyncWaiter() = default;





void EmbeddedSearchClientInterceptorForTesting::SetPageSequenceNumber(int32_t page_seq_no) {
  GetForwardingInterface()->SetPageSequenceNumber(
    std::move(page_seq_no)
    );
}
void EmbeddedSearchClientInterceptorForTesting::FocusChanged(::OmniboxFocusState new_focus_state, ::OmniboxFocusChangeReason reason) {
  GetForwardingInterface()->FocusChanged(
    std::move(new_focus_state)
    , 
    std::move(reason)
    );
}
void EmbeddedSearchClientInterceptorForTesting::MostVisitedInfoChanged(const ::InstantMostVisitedInfo& most_visited_info) {
  GetForwardingInterface()->MostVisitedInfoChanged(
    std::move(most_visited_info)
    );
}
void EmbeddedSearchClientInterceptorForTesting::SetInputInProgress(bool input_in_progress) {
  GetForwardingInterface()->SetInputInProgress(
    std::move(input_in_progress)
    );
}
void EmbeddedSearchClientInterceptorForTesting::ThemeChanged(const ::NtpTheme& theme) {
  GetForwardingInterface()->ThemeChanged(
    std::move(theme)
    );
}
EmbeddedSearchClientAsyncWaiter::EmbeddedSearchClientAsyncWaiter(
    EmbeddedSearchClient* proxy) : proxy_(proxy) {}

EmbeddedSearchClientAsyncWaiter::~EmbeddedSearchClientAsyncWaiter() = default;







}  // search::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif