// chrome/common/search/search.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/search/search.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/search/search.mojom-params-data.h"
namespace search {
namespace mojom {

namespace internal {


// static
bool EmbeddedSearchConnector_Connect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearchConnector_Connect_Params_Data* object =
      static_cast<const EmbeddedSearchConnector_Connect_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->embedded_search, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->embedded_search,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

EmbeddedSearchConnector_Connect_Params_Data::EmbeddedSearchConnector_Connect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearch_FocusOmnibox_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearch_FocusOmnibox_Params_Data* object =
      static_cast<const EmbeddedSearch_FocusOmnibox_Params_Data*>(data);

  return true;
}

EmbeddedSearch_FocusOmnibox_Params_Data::EmbeddedSearch_FocusOmnibox_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearch_DeleteMostVisitedItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearch_DeleteMostVisitedItem_Params_Data* object =
      static_cast<const EmbeddedSearch_DeleteMostVisitedItem_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

EmbeddedSearch_DeleteMostVisitedItem_Params_Data::EmbeddedSearch_DeleteMostVisitedItem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data* object =
      static_cast<const EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data*>(data);

  return true;
}

EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data::EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearch_UndoMostVisitedDeletion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearch_UndoMostVisitedDeletion_Params_Data* object =
      static_cast<const EmbeddedSearch_UndoMostVisitedDeletion_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

EmbeddedSearch_UndoMostVisitedDeletion_Params_Data::EmbeddedSearch_UndoMostVisitedDeletion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearchClient_SetPageSequenceNumber_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearchClient_SetPageSequenceNumber_Params_Data* object =
      static_cast<const EmbeddedSearchClient_SetPageSequenceNumber_Params_Data*>(data);

  return true;
}

EmbeddedSearchClient_SetPageSequenceNumber_Params_Data::EmbeddedSearchClient_SetPageSequenceNumber_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearchClient_FocusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearchClient_FocusChanged_Params_Data* object =
      static_cast<const EmbeddedSearchClient_FocusChanged_Params_Data*>(data);


  if (!::search::mojom::internal::OmniboxFocusState_Data
        ::Validate(object->new_focus_state, validation_context))
    return false;


  if (!::search::mojom::internal::OmniboxFocusChangeReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

EmbeddedSearchClient_FocusChanged_Params_Data::EmbeddedSearchClient_FocusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data* object =
      static_cast<const EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->most_visited_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->most_visited_info, validation_context))
    return false;

  return true;
}

EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data::EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearchClient_SetInputInProgress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearchClient_SetInputInProgress_Params_Data* object =
      static_cast<const EmbeddedSearchClient_SetInputInProgress_Params_Data*>(data);

  return true;
}

EmbeddedSearchClient_SetInputInProgress_Params_Data::EmbeddedSearchClient_SetInputInProgress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedSearchClient_ThemeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedSearchClient_ThemeChanged_Params_Data* object =
      static_cast<const EmbeddedSearchClient_ThemeChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->theme, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->theme, validation_context))
    return false;

  return true;
}

EmbeddedSearchClient_ThemeChanged_Params_Data::EmbeddedSearchClient_ThemeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace search