// chrome/common/renderer_configuration.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/renderer_configuration.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/renderer_configuration.mojom-params-data.h"
namespace chrome {
namespace mojom {

NOINLINE static const char* ResumeBlockedRequestsTriggerToStringHelper(ResumeBlockedRequestsTrigger value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResumeBlockedRequestsTrigger::kObservedFreshCookies:
      return "kObservedFreshCookies";
    case ResumeBlockedRequestsTrigger::kCookieRefreshFetchSuccess:
      return "kCookieRefreshFetchSuccess";
    case ResumeBlockedRequestsTrigger::kCookieRefreshFetchFailure:
      return "kCookieRefreshFetchFailure";
    case ResumeBlockedRequestsTrigger::kTimeout:
      return "kTimeout";
    case ResumeBlockedRequestsTrigger::kShutdownOrSessionTermination:
      return "kShutdownOrSessionTermination";
    case ResumeBlockedRequestsTrigger::kCookieAlreadyFresh:
      return "kCookieAlreadyFresh";
    case ResumeBlockedRequestsTrigger::kRendererDisconnected:
      return "kRendererDisconnected";
    case ResumeBlockedRequestsTrigger::kThrottlingRequestsPaused:
      return "kThrottlingRequestsPaused";
    default:
      return nullptr;
  }
}

std::string ResumeBlockedRequestsTriggerToString(ResumeBlockedRequestsTrigger value) {
  const char *str = ResumeBlockedRequestsTriggerToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResumeBlockedRequestsTrigger value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResumeBlockedRequestsTrigger value) {
  return os << ResumeBlockedRequestsTriggerToString(value);
}

namespace internal {


// static
bool BoundSessionThrottlerParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BoundSessionThrottlerParams_Data* object =
      static_cast<const BoundSessionThrottlerParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& domain_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_expiry_date, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie_expiry_date, validation_context))
    return false;

  return true;
}

BoundSessionThrottlerParams_Data::BoundSessionThrottlerParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DynamicParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DynamicParams_Data* object =
      static_cast<const DynamicParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bound_session_throttler_params, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bound_session_throttler_params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bound_session_throttler_params, validation_context,
                                         &bound_session_throttler_params_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allowed_domains_for_apps, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& allowed_domains_for_apps_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->allowed_domains_for_apps, validation_context,
                                         &allowed_domains_for_apps_validate_params)) {
    return false;
  }

  return true;
}

DynamicParams_Data::DynamicParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StaticParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StaticParams_Data* object =
      static_cast<const StaticParams_Data*>(data);

  return true;
}

StaticParams_Data::StaticParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data* object =
      static_cast<const BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->untrusted_request_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->untrusted_request_url, validation_context))
    return false;

  return true;
}

BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data* object =
      static_cast<const BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data*>(data);


  if (!::chrome::mojom::internal::ResumeBlockedRequestsTrigger_Data
        ::Validate(object->resume_trigger, validation_context))
    return false;

  return true;
}

BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererConfiguration_SetInitialConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RendererConfiguration_SetInitialConfiguration_Params_Data* object =
      static_cast<const RendererConfiguration_SetInitialConfiguration_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->chromeos_listener,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->content_settings_manager,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->bound_session_request_throttled_handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RendererConfiguration_SetInitialConfiguration_Params_Data::RendererConfiguration_SetInitialConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererConfiguration_SetConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RendererConfiguration_SetConfiguration_Params_Data* object =
      static_cast<const RendererConfiguration_SetConfiguration_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

RendererConfiguration_SetConfiguration_Params_Data::RendererConfiguration_SetConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data* object =
      static_cast<const RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data::RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::ResumeBlockedRequestsTrigger>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::ResumeBlockedRequestsTrigger value) {
  return std::move(context).WriteString(::chrome::mojom::ResumeBlockedRequestsTriggerToString(value));
}

} // namespace perfetto