// chrome/common/media/webrtc_logging.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_SEND_VALIDATION_H_
#define CHROME_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_SEND_VALIDATION_H_

#include "chrome/common/media/webrtc_logging.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "chrome/common/media/webrtc_logging.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::WebRtcLoggingMessageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::WebRtcLoggingMessageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::WebRtcLoggingMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in WebRtcLoggingMessage struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType> data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_data,
        data_fragment);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in WebRtcLoggingMessage struct");
  }
};

}  // namespace mojo::internal

#endif  // CHROME_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_SEND_VALIDATION_H_