// chrome/common/mac/app_shim.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_MAC_APP_SHIM_MOJOM_H_
#define CHROME_COMMON_MAC_APP_SHIM_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/mac/app_shim.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/mac/app_shim.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/mac/app_shim.mojom-forward.h"  // IWYU pragma: export
#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-forward.h"
#include "components/remote_cocoa/common/application.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/url.mojom.h"
#include "components/metrics/public/mojom/histogram_fetcher.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/common/mac/app_shim_mojom_traits.h"




namespace chrome::mojom {

class AppShimProxy;

template <typename ImplRefTraits>
class AppShimStub;

class AppShimRequestValidator;
class AppShimResponseValidator;


class AppShim
    : public AppShimInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.AppShim";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AppShimInterfaceBase;
  using Proxy_ = AppShimProxy;

  template <typename ImplRefTraits>
  using Stub_ = AppShimStub<ImplRefTraits>;

  using RequestValidator_ = AppShimRequestValidator;
  using ResponseValidator_ = AppShimResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateRemoteCocoaApplicationMinVersion = 0,
    kCreateCommandDispatcherForWidgetMinVersion = 0,
    kSetUserAttentionMinVersion = 0,
    kSetBadgeLabelMinVersion = 0,
    kUpdateProfileMenuMinVersion = 0,
    kUpdateApplicationDockMenuMinVersion = 0,
    kBindNotificationProviderMinVersion = 0,
    kRequestNotificationPermissionMinVersion = 0,
    kBindChildHistogramFetcherFactoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateRemoteCocoaApplication_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateCommandDispatcherForWidget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserAttention_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBadgeLabel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateProfileMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateApplicationDockMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindNotificationProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestNotificationPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindChildHistogramFetcherFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AppShim() = default;

  virtual void CreateRemoteCocoaApplication(::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> application) = 0;

  virtual void CreateCommandDispatcherForWidget(uint64_t widget_id) = 0;

  virtual void SetUserAttention(AppShimAttentionType attention_type) = 0;

  virtual void SetBadgeLabel(const std::string& badge_label) = 0;

  virtual void UpdateProfileMenu(std::vector<ProfileMenuItemPtr> profile_menu_items) = 0;

  virtual void UpdateApplicationDockMenu(std::vector<ApplicationDockMenuItemPtr> dock_menu_items) = 0;

  virtual void BindNotificationProvider(::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationProvider> provider) = 0;

  using RequestNotificationPermissionCallback = base::OnceCallback<void(::mac_notifications::mojom::RequestPermissionResult)>;
  using RequestNotificationPermissionMojoCallback = base::OnceCallback<void(::mac_notifications::mojom::RequestPermissionResult)>;

  virtual void RequestNotificationPermission(RequestNotificationPermissionCallback callback) = 0;

  virtual void BindChildHistogramFetcherFactory(::mojo::PendingReceiver<::metrics::mojom::ChildHistogramFetcherFactory> receiver) = 0;
};

class AppShimHostProxy;

template <typename ImplRefTraits>
class AppShimHostStub;

class AppShimHostRequestValidator;


class AppShimHost
    : public AppShimHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.AppShimHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AppShimHostInterfaceBase;
  using Proxy_ = AppShimHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AppShimHostStub<ImplRefTraits>;

  using RequestValidator_ = AppShimHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFocusAppMinVersion = 0,
    kReopenAppMinVersion = 0,
    kFilesOpenedMinVersion = 0,
    kProfileSelectedFromMenuMinVersion = 0,
    kOpenAppSettingsMinVersion = 0,
    kUrlsOpenedMinVersion = 0,
    kOpenAppWithOverrideUrlMinVersion = 0,
    kEnableAccessibilitySupportMinVersion = 0,
    kApplicationWillTerminateMinVersion = 0,
    kNotificationPermissionStatusChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FocusApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReopenApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FilesOpened_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProfileSelectedFromMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenAppSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UrlsOpened_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenAppWithOverrideUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableAccessibilitySupport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ApplicationWillTerminate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotificationPermissionStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AppShimHost() = default;

  virtual void FocusApp() = 0;

  virtual void ReopenApp() = 0;

  virtual void FilesOpened(const std::vector<::base::FilePath>& files) = 0;

  virtual void ProfileSelectedFromMenu(const ::base::FilePath& profile_path) = 0;

  virtual void OpenAppSettings() = 0;

  virtual void UrlsOpened(const std::vector<::GURL>& urls) = 0;

  virtual void OpenAppWithOverrideUrl(const ::GURL& override_url) = 0;

  virtual void EnableAccessibilitySupport(AppShimScreenReaderSupportMode mode) = 0;

  virtual void ApplicationWillTerminate() = 0;

  virtual void NotificationPermissionStatusChanged(::mac_notifications::mojom::PermissionStatus status) = 0;
};

class AppShimHostBootstrapProxy;

template <typename ImplRefTraits>
class AppShimHostBootstrapStub;

class AppShimHostBootstrapRequestValidator;
class AppShimHostBootstrapResponseValidator;


class AppShimHostBootstrap
    : public AppShimHostBootstrapInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.AppShimHostBootstrap";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AppShimHostBootstrapInterfaceBase;
  using Proxy_ = AppShimHostBootstrapProxy;

  template <typename ImplRefTraits>
  using Stub_ = AppShimHostBootstrapStub<ImplRefTraits>;

  using RequestValidator_ = AppShimHostBootstrapRequestValidator;
  using ResponseValidator_ = AppShimHostBootstrapResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnShimConnectedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnShimConnected_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AppShimHostBootstrap() = default;

  using OnShimConnectedCallback = base::OnceCallback<void(AppShimLaunchResult, ::variations::VariationsCommandLine, ::mojo::PendingReceiver<AppShim>)>;
  using OnShimConnectedMojoCallback = base::OnceCallback<void(AppShimLaunchResult, ::variations::VariationsCommandLine, ::mojo::PendingReceiver<AppShim>)>;

  virtual void OnShimConnected(::mojo::PendingReceiver<AppShimHost> host_receiver, AppShimInfoPtr app_shim_info, OnShimConnectedCallback callback) = 0;
};



class  AppShimProxy
    : public AppShim {
 public:
  using InterfaceType = AppShim;

  explicit AppShimProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateRemoteCocoaApplication(::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> application) final;
  
  void CreateCommandDispatcherForWidget(uint64_t widget_id) final;
  
  void SetUserAttention(AppShimAttentionType attention_type) final;
  
  void SetBadgeLabel(const std::string& badge_label) final;
  
  void UpdateProfileMenu(std::vector<ProfileMenuItemPtr> profile_menu_items) final;
  
  void UpdateApplicationDockMenu(std::vector<ApplicationDockMenuItemPtr> dock_menu_items) final;
  
  void BindNotificationProvider(::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationProvider> provider) final;
  
  void RequestNotificationPermission(RequestNotificationPermissionCallback callback) final;
  
  void BindChildHistogramFetcherFactory(::mojo::PendingReceiver<::metrics::mojom::ChildHistogramFetcherFactory> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AppShimHostProxy
    : public AppShimHost {
 public:
  using InterfaceType = AppShimHost;

  explicit AppShimHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FocusApp() final;
  
  void ReopenApp() final;
  
  void FilesOpened(const std::vector<::base::FilePath>& files) final;
  
  void ProfileSelectedFromMenu(const ::base::FilePath& profile_path) final;
  
  void OpenAppSettings() final;
  
  void UrlsOpened(const std::vector<::GURL>& urls) final;
  
  void OpenAppWithOverrideUrl(const ::GURL& override_url) final;
  
  void EnableAccessibilitySupport(AppShimScreenReaderSupportMode mode) final;
  
  void ApplicationWillTerminate() final;
  
  void NotificationPermissionStatusChanged(::mac_notifications::mojom::PermissionStatus status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AppShimHostBootstrapProxy
    : public AppShimHostBootstrap {
 public:
  using InterfaceType = AppShimHostBootstrap;

  explicit AppShimHostBootstrapProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnShimConnected(::mojo::PendingReceiver<AppShimHost> host_receiver, AppShimInfoPtr app_shim_info, OnShimConnectedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AppShimStubDispatch {
 public:
  static bool Accept(AppShim* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AppShim* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AppShim>>
class AppShimStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AppShimStub() = default;
  ~AppShimStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AppShimStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AppShimStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AppShimHostStubDispatch {
 public:
  static bool Accept(AppShimHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AppShimHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AppShimHost>>
class AppShimHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AppShimHostStub() = default;
  ~AppShimHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AppShimHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AppShimHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AppShimHostBootstrapStubDispatch {
 public:
  static bool Accept(AppShimHostBootstrap* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AppShimHostBootstrap* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AppShimHostBootstrap>>
class AppShimHostBootstrapStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AppShimHostBootstrapStub() = default;
  ~AppShimHostBootstrapStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AppShimHostBootstrapStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AppShimHostBootstrapStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AppShimRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AppShimHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AppShimHostBootstrapRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AppShimResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AppShimHostBootstrapResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  FeatureState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FeatureState, T>::value>;
  using DataView = FeatureStateDataView;
  using Data_ = internal::FeatureState_Data;

  template <typename... Args>
  static FeatureStatePtr New(Args&&... args) {
    return FeatureStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FeatureStatePtr From(const U& u) {
    return mojo::TypeConverter<FeatureStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FeatureState>::Convert(*this);
  }


  FeatureState();

  FeatureState(
      const std::string& field_trial_states,
      const std::string& field_trial_params,
      const std::string& enable_features,
      const std::string& disable_features);


  ~FeatureState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FeatureStatePtr>
  FeatureStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FeatureState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FeatureState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FeatureState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FeatureState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FeatureState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FeatureState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FeatureState_UnserializedMessageContext<
            UserType, FeatureState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FeatureState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FeatureState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FeatureState_UnserializedMessageContext<
            UserType, FeatureState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FeatureState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string field_trial_states;
  
  std::string field_trial_params;
  
  std::string enable_features;
  
  std::string disable_features;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FeatureState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FeatureState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FeatureState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FeatureState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  ProfileMenuItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProfileMenuItem, T>::value>;
  using DataView = ProfileMenuItemDataView;
  using Data_ = internal::ProfileMenuItem_Data;

  template <typename... Args>
  static ProfileMenuItemPtr New(Args&&... args) {
    return ProfileMenuItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProfileMenuItemPtr From(const U& u) {
    return mojo::TypeConverter<ProfileMenuItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProfileMenuItem>::Convert(*this);
  }


  ProfileMenuItem();

  ProfileMenuItem(
      const ::std::u16string& name,
      const ::gfx::ImageSkia& icon,
      uint32_t menu_index,
      bool active,
      const ::base::FilePath& profile_path);


  ~ProfileMenuItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProfileMenuItemPtr>
  ProfileMenuItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProfileMenuItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProfileMenuItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProfileMenuItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProfileMenuItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProfileMenuItem_UnserializedMessageContext<
            UserType, ProfileMenuItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProfileMenuItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProfileMenuItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProfileMenuItem_UnserializedMessageContext<
            UserType, ProfileMenuItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProfileMenuItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  ::gfx::ImageSkia icon;
  
  uint32_t menu_index;
  
  bool active;
  
  ::base::FilePath profile_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProfileMenuItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProfileMenuItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProfileMenuItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProfileMenuItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ApplicationDockMenuItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ApplicationDockMenuItem, T>::value>;
  using DataView = ApplicationDockMenuItemDataView;
  using Data_ = internal::ApplicationDockMenuItem_Data;

  template <typename... Args>
  static ApplicationDockMenuItemPtr New(Args&&... args) {
    return ApplicationDockMenuItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ApplicationDockMenuItemPtr From(const U& u) {
    return mojo::TypeConverter<ApplicationDockMenuItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ApplicationDockMenuItem>::Convert(*this);
  }


  ApplicationDockMenuItem();

  ApplicationDockMenuItem(
      const ::std::u16string& name,
      const ::GURL& url);


  ~ApplicationDockMenuItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ApplicationDockMenuItemPtr>
  ApplicationDockMenuItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ApplicationDockMenuItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ApplicationDockMenuItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ApplicationDockMenuItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ApplicationDockMenuItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ApplicationDockMenuItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ApplicationDockMenuItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ApplicationDockMenuItem_UnserializedMessageContext<
            UserType, ApplicationDockMenuItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ApplicationDockMenuItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ApplicationDockMenuItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ApplicationDockMenuItem_UnserializedMessageContext<
            UserType, ApplicationDockMenuItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ApplicationDockMenuItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ApplicationDockMenuItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ApplicationDockMenuItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ApplicationDockMenuItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ApplicationDockMenuItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AppShimInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AppShimInfo, T>::value>;
  using DataView = AppShimInfoDataView;
  using Data_ = internal::AppShimInfo_Data;

  template <typename... Args>
  static AppShimInfoPtr New(Args&&... args) {
    return AppShimInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AppShimInfoPtr From(const U& u) {
    return mojo::TypeConverter<AppShimInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AppShimInfo>::Convert(*this);
  }


  AppShimInfo();

  AppShimInfo(
      const ::base::FilePath& profile_path,
      const std::string& app_id,
      const ::GURL& app_url,
      AppShimLaunchType launch_type,
      std::vector<::base::FilePath> files,
      AppShimLoginItemRestoreState login_item_restore_state,
      std::vector<::GURL> urls,
      ::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationActionHandler> notification_action_handler);

AppShimInfo(const AppShimInfo&) = delete;
AppShimInfo& operator=(const AppShimInfo&) = delete;

  ~AppShimInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AppShimInfoPtr>
  AppShimInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AppShimInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AppShimInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AppShimInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AppShimInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AppShimInfo_UnserializedMessageContext<
            UserType, AppShimInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AppShimInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AppShimInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AppShimInfo_UnserializedMessageContext<
            UserType, AppShimInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AppShimInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath profile_path;
  
  std::string app_id;
  
  ::GURL app_url;
  
  AppShimLaunchType launch_type;
  
  std::vector<::base::FilePath> files;
  
  AppShimLoginItemRestoreState login_item_restore_state;
  
  std::vector<::GURL> urls;
  
  ::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationActionHandler> notification_action_handler;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AppShimInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AppShimInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AppShimInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AppShimInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ProfileMenuItemPtr ProfileMenuItem::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(icon),
      mojo::Clone(menu_index),
      mojo::Clone(active),
      mojo::Clone(profile_path)
  );
}

template <typename T, ProfileMenuItem::EnableIfSame<T>*>
bool ProfileMenuItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  if (!mojo::Equals(this->menu_index, other_struct.menu_index))
    return false;
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  if (!mojo::Equals(this->profile_path, other_struct.profile_path))
    return false;
  return true;
}

template <typename T, ProfileMenuItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  if (lhs.menu_index < rhs.menu_index)
    return true;
  if (rhs.menu_index < lhs.menu_index)
    return false;
  if (lhs.active < rhs.active)
    return true;
  if (rhs.active < lhs.active)
    return false;
  if (lhs.profile_path < rhs.profile_path)
    return true;
  if (rhs.profile_path < lhs.profile_path)
    return false;
  return false;
}
template <typename StructPtrType>
ApplicationDockMenuItemPtr ApplicationDockMenuItem::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(url)
  );
}

template <typename T, ApplicationDockMenuItem::EnableIfSame<T>*>
bool ApplicationDockMenuItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, ApplicationDockMenuItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
AppShimInfoPtr AppShimInfo::Clone() const {
  return New(
      mojo::Clone(profile_path),
      mojo::Clone(app_id),
      mojo::Clone(app_url),
      mojo::Clone(launch_type),
      mojo::Clone(files),
      mojo::Clone(login_item_restore_state),
      mojo::Clone(urls),
      mojo::Clone(notification_action_handler)
  );
}

template <typename T, AppShimInfo::EnableIfSame<T>*>
bool AppShimInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->profile_path, other_struct.profile_path))
    return false;
  if (!mojo::Equals(this->app_id, other_struct.app_id))
    return false;
  if (!mojo::Equals(this->app_url, other_struct.app_url))
    return false;
  if (!mojo::Equals(this->launch_type, other_struct.launch_type))
    return false;
  if (!mojo::Equals(this->files, other_struct.files))
    return false;
  if (!mojo::Equals(this->login_item_restore_state, other_struct.login_item_restore_state))
    return false;
  if (!mojo::Equals(this->urls, other_struct.urls))
    return false;
  if (!mojo::Equals(this->notification_action_handler, other_struct.notification_action_handler))
    return false;
  return true;
}

template <typename T, AppShimInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.profile_path < rhs.profile_path)
    return true;
  if (rhs.profile_path < lhs.profile_path)
    return false;
  if (lhs.app_id < rhs.app_id)
    return true;
  if (rhs.app_id < lhs.app_id)
    return false;
  if (lhs.app_url < rhs.app_url)
    return true;
  if (rhs.app_url < lhs.app_url)
    return false;
  if (lhs.launch_type < rhs.launch_type)
    return true;
  if (rhs.launch_type < lhs.launch_type)
    return false;
  if (lhs.files < rhs.files)
    return true;
  if (rhs.files < lhs.files)
    return false;
  if (lhs.login_item_restore_state < rhs.login_item_restore_state)
    return true;
  if (rhs.login_item_restore_state < lhs.login_item_restore_state)
    return false;
  if (lhs.urls < rhs.urls)
    return true;
  if (rhs.urls < lhs.urls)
    return false;
  if (lhs.notification_action_handler < rhs.notification_action_handler)
    return true;
  if (rhs.notification_action_handler < lhs.notification_action_handler)
    return false;
  return false;
}
template <typename StructPtrType>
FeatureStatePtr FeatureState::Clone() const {
  return New(
      mojo::Clone(field_trial_states),
      mojo::Clone(field_trial_params),
      mojo::Clone(enable_features),
      mojo::Clone(disable_features)
  );
}

template <typename T, FeatureState::EnableIfSame<T>*>
bool FeatureState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->field_trial_states, other_struct.field_trial_states))
    return false;
  if (!mojo::Equals(this->field_trial_params, other_struct.field_trial_params))
    return false;
  if (!mojo::Equals(this->enable_features, other_struct.enable_features))
    return false;
  if (!mojo::Equals(this->disable_features, other_struct.disable_features))
    return false;
  return true;
}

template <typename T, FeatureState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.field_trial_states < rhs.field_trial_states)
    return true;
  if (rhs.field_trial_states < lhs.field_trial_states)
    return false;
  if (lhs.field_trial_params < rhs.field_trial_params)
    return true;
  if (rhs.field_trial_params < lhs.field_trial_params)
    return false;
  if (lhs.enable_features < rhs.enable_features)
    return true;
  if (rhs.enable_features < lhs.enable_features)
    return false;
  if (lhs.disable_features < rhs.disable_features)
    return true;
  if (rhs.disable_features < lhs.disable_features)
    return false;
  return false;
}


}  // chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::chrome::mojom::ProfileMenuItem::DataView,
                                         ::chrome::mojom::ProfileMenuItemPtr> {
  static bool IsNull(const ::chrome::mojom::ProfileMenuItemPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::ProfileMenuItemPtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::ProfileMenuItem::name)& name(
      const ::chrome::mojom::ProfileMenuItemPtr& input) {
    return input->name;
  }

  static  decltype(::chrome::mojom::ProfileMenuItem::icon)& icon(
       ::chrome::mojom::ProfileMenuItemPtr& input) {
    return input->icon;
  }

  static decltype(::chrome::mojom::ProfileMenuItem::menu_index) menu_index(
      const ::chrome::mojom::ProfileMenuItemPtr& input) {
    return input->menu_index;
  }

  static decltype(::chrome::mojom::ProfileMenuItem::active) active(
      const ::chrome::mojom::ProfileMenuItemPtr& input) {
    return input->active;
  }

  static const decltype(::chrome::mojom::ProfileMenuItem::profile_path)& profile_path(
      const ::chrome::mojom::ProfileMenuItemPtr& input) {
    return input->profile_path;
  }

  static bool Read(::chrome::mojom::ProfileMenuItem::DataView input, ::chrome::mojom::ProfileMenuItemPtr* output);
};


template <>
struct  StructTraits<::chrome::mojom::ApplicationDockMenuItem::DataView,
                                         ::chrome::mojom::ApplicationDockMenuItemPtr> {
  static bool IsNull(const ::chrome::mojom::ApplicationDockMenuItemPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::ApplicationDockMenuItemPtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::ApplicationDockMenuItem::name)& name(
      const ::chrome::mojom::ApplicationDockMenuItemPtr& input) {
    return input->name;
  }

  static const decltype(::chrome::mojom::ApplicationDockMenuItem::url)& url(
      const ::chrome::mojom::ApplicationDockMenuItemPtr& input) {
    return input->url;
  }

  static bool Read(::chrome::mojom::ApplicationDockMenuItem::DataView input, ::chrome::mojom::ApplicationDockMenuItemPtr* output);
};


template <>
struct  StructTraits<::chrome::mojom::AppShimInfo::DataView,
                                         ::chrome::mojom::AppShimInfoPtr> {
  static bool IsNull(const ::chrome::mojom::AppShimInfoPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::AppShimInfoPtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::AppShimInfo::profile_path)& profile_path(
      const ::chrome::mojom::AppShimInfoPtr& input) {
    return input->profile_path;
  }

  static const decltype(::chrome::mojom::AppShimInfo::app_id)& app_id(
      const ::chrome::mojom::AppShimInfoPtr& input) {
    return input->app_id;
  }

  static const decltype(::chrome::mojom::AppShimInfo::app_url)& app_url(
      const ::chrome::mojom::AppShimInfoPtr& input) {
    return input->app_url;
  }

  static decltype(::chrome::mojom::AppShimInfo::launch_type) launch_type(
      const ::chrome::mojom::AppShimInfoPtr& input) {
    return input->launch_type;
  }

  static const decltype(::chrome::mojom::AppShimInfo::files)& files(
      const ::chrome::mojom::AppShimInfoPtr& input) {
    return input->files;
  }

  static decltype(::chrome::mojom::AppShimInfo::login_item_restore_state) login_item_restore_state(
      const ::chrome::mojom::AppShimInfoPtr& input) {
    return input->login_item_restore_state;
  }

  static const decltype(::chrome::mojom::AppShimInfo::urls)& urls(
      const ::chrome::mojom::AppShimInfoPtr& input) {
    return input->urls;
  }

  static  decltype(::chrome::mojom::AppShimInfo::notification_action_handler)& notification_action_handler(
       ::chrome::mojom::AppShimInfoPtr& input) {
    return input->notification_action_handler;
  }

  static bool Read(::chrome::mojom::AppShimInfo::DataView input, ::chrome::mojom::AppShimInfoPtr* output);
};


template <>
struct  StructTraits<::chrome::mojom::FeatureState::DataView,
                                         ::chrome::mojom::FeatureStatePtr> {
  static bool IsNull(const ::chrome::mojom::FeatureStatePtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::FeatureStatePtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::FeatureState::field_trial_states)& field_trial_states(
      const ::chrome::mojom::FeatureStatePtr& input) {
    return input->field_trial_states;
  }

  static const decltype(::chrome::mojom::FeatureState::field_trial_params)& field_trial_params(
      const ::chrome::mojom::FeatureStatePtr& input) {
    return input->field_trial_params;
  }

  static const decltype(::chrome::mojom::FeatureState::enable_features)& enable_features(
      const ::chrome::mojom::FeatureStatePtr& input) {
    return input->enable_features;
  }

  static const decltype(::chrome::mojom::FeatureState::disable_features)& disable_features(
      const ::chrome::mojom::FeatureStatePtr& input) {
    return input->disable_features;
  }

  static bool Read(::chrome::mojom::FeatureState::DataView input, ::chrome::mojom::FeatureStatePtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_MAC_APP_SHIM_MOJOM_H_