// chrome/common/mac/app_shim.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_MAC_APP_SHIM_MOJOM_TEST_UTILS_H_
#define CHROME_COMMON_MAC_APP_SHIM_MOJOM_TEST_UTILS_H_

#include "chrome/common/mac/app_shim.mojom.h"


namespace chrome::mojom {


class  AppShimInterceptorForTesting : public AppShim {
  virtual AppShim* GetForwardingInterface() = 0;
  void CreateRemoteCocoaApplication(::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> application) override;
  void CreateCommandDispatcherForWidget(uint64_t widget_id) override;
  void SetUserAttention(AppShimAttentionType attention_type) override;
  void SetBadgeLabel(const std::string& badge_label) override;
  void UpdateProfileMenu(std::vector<ProfileMenuItemPtr> profile_menu_items) override;
  void UpdateApplicationDockMenu(std::vector<ApplicationDockMenuItemPtr> dock_menu_items) override;
  void BindNotificationProvider(::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationProvider> provider) override;
  void RequestNotificationPermission(RequestNotificationPermissionCallback callback) override;
  void BindChildHistogramFetcherFactory(::mojo::PendingReceiver<::metrics::mojom::ChildHistogramFetcherFactory> receiver) override;
};
class  AppShimAsyncWaiter {
 public:
  explicit AppShimAsyncWaiter(AppShim* proxy);

  AppShimAsyncWaiter(const AppShimAsyncWaiter&) = delete;
  AppShimAsyncWaiter& operator=(const AppShimAsyncWaiter&) = delete;

  ~AppShimAsyncWaiter();
  void RequestNotificationPermission(
      ::mac_notifications::mojom::RequestPermissionResult* out_result);
  ::mac_notifications::mojom::RequestPermissionResult RequestNotificationPermission();

 private:
  AppShim* const proxy_;
};


class  AppShimHostInterceptorForTesting : public AppShimHost {
  virtual AppShimHost* GetForwardingInterface() = 0;
  void FocusApp() override;
  void ReopenApp() override;
  void FilesOpened(const std::vector<::base::FilePath>& files) override;
  void ProfileSelectedFromMenu(const ::base::FilePath& profile_path) override;
  void OpenAppSettings() override;
  void UrlsOpened(const std::vector<::GURL>& urls) override;
  void OpenAppWithOverrideUrl(const ::GURL& override_url) override;
  void EnableAccessibilitySupport(AppShimScreenReaderSupportMode mode) override;
  void ApplicationWillTerminate() override;
  void NotificationPermissionStatusChanged(::mac_notifications::mojom::PermissionStatus status) override;
};
class  AppShimHostAsyncWaiter {
 public:
  explicit AppShimHostAsyncWaiter(AppShimHost* proxy);

  AppShimHostAsyncWaiter(const AppShimHostAsyncWaiter&) = delete;
  AppShimHostAsyncWaiter& operator=(const AppShimHostAsyncWaiter&) = delete;

  ~AppShimHostAsyncWaiter();

 private:
  AppShimHost* const proxy_;
};


class  AppShimHostBootstrapInterceptorForTesting : public AppShimHostBootstrap {
  virtual AppShimHostBootstrap* GetForwardingInterface() = 0;
  void OnShimConnected(::mojo::PendingReceiver<AppShimHost> host_receiver, AppShimInfoPtr app_shim_info, OnShimConnectedCallback callback) override;
};
class  AppShimHostBootstrapAsyncWaiter {
 public:
  explicit AppShimHostBootstrapAsyncWaiter(AppShimHostBootstrap* proxy);

  AppShimHostBootstrapAsyncWaiter(const AppShimHostBootstrapAsyncWaiter&) = delete;
  AppShimHostBootstrapAsyncWaiter& operator=(const AppShimHostBootstrapAsyncWaiter&) = delete;

  ~AppShimHostBootstrapAsyncWaiter();
  void OnShimConnected(
      ::mojo::PendingReceiver<AppShimHost> host_receiver, AppShimInfoPtr app_shim_info, AppShimLaunchResult* out_launch_result, ::variations::VariationsCommandLine* out_feature_state, ::mojo::PendingReceiver<AppShim>* out_app_shim_receiver);
  

 private:
  AppShimHostBootstrap* const proxy_;
};




}  // chrome::mojom

#endif  // CHROME_COMMON_MAC_APP_SHIM_MOJOM_TEST_UTILS_H_