// chrome/common/mac/app_shim.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_MAC_APP_SHIM_MOJOM_SEND_VALIDATION_H_
#define CHROME_COMMON_MAC_APP_SHIM_MOJOM_SEND_VALIDATION_H_

#include "chrome/common/mac/app_shim.mojom-shared-internal.h"
#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/metrics/public/mojom/histogram_fetcher.mojom-shared.h"

#include "chrome/common/mac/app_shim.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::chrome::mojom::AppShimLaunchType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::chrome::mojom::AppShimLaunchResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::chrome::mojom::AppShimAttentionType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::chrome::mojom::AppShimLoginItemRestoreState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::chrome::mojom::AppShimScreenReaderSupportMode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::ProfileMenuItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::ProfileMenuItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::ProfileMenuItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ProfileMenuItem struct");

      decltype(Traits::icon(input)) in_icon = Traits::icon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icon)::BaseType> icon_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView, send_validation>(
        in_icon,
        icon_fragment);

      fragment->icon.Set(
          icon_fragment.is_null() ? nullptr : icon_fragment.data());

      fragment->menu_index = Traits::menu_index(input);

      fragment->active = Traits::active(input);

      decltype(Traits::profile_path(input)) in_profile_path = Traits::profile_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->profile_path)::BaseType> profile_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_profile_path,
        profile_path_fragment);

      fragment->profile_path.Set(
          profile_path_fragment.is_null() ? nullptr : profile_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->profile_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null profile_path in ProfileMenuItem struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::ApplicationDockMenuItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::ApplicationDockMenuItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::ApplicationDockMenuItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ApplicationDockMenuItem struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ApplicationDockMenuItem struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::AppShimInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::AppShimInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::AppShimInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::profile_path(input)) in_profile_path = Traits::profile_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->profile_path)::BaseType> profile_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_profile_path,
        profile_path_fragment);

      fragment->profile_path.Set(
          profile_path_fragment.is_null() ? nullptr : profile_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->profile_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null profile_path in AppShimInfo struct");

      decltype(Traits::app_id(input)) in_app_id = Traits::app_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->app_id)::BaseType> app_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_app_id,
        app_id_fragment);

      fragment->app_id.Set(
          app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->app_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null app_id in AppShimInfo struct");

      decltype(Traits::app_url(input)) in_app_url = Traits::app_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->app_url)::BaseType> app_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_app_url,
        app_url_fragment);

      fragment->app_url.Set(
          app_url_fragment.is_null() ? nullptr : app_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->app_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null app_url in AppShimInfo struct");

      
      mojo::internal::Serialize<::chrome::mojom::AppShimLaunchType>(
        Traits::launch_type(input),
        &fragment->launch_type);

      decltype(Traits::files(input)) in_files = Traits::files(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->files)::BaseType>
          files_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>, send_validation>(
        in_files,
        files_fragment,
        &files_validate_params);

      fragment->files.Set(
          files_fragment.is_null() ? nullptr : files_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->files.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null files in AppShimInfo struct");

      
      mojo::internal::Serialize<::chrome::mojom::AppShimLoginItemRestoreState>(
        Traits::login_item_restore_state(input),
        &fragment->login_item_restore_state);

      decltype(Traits::urls(input)) in_urls = Traits::urls(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->urls)::BaseType>
          urls_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>, send_validation>(
        in_urls,
        urls_fragment,
        &urls_validate_params);

      fragment->urls.Set(
          urls_fragment.is_null() ? nullptr : urls_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->urls.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null urls in AppShimInfo struct");

      decltype(Traits::notification_action_handler(input)) in_notification_action_handler = Traits::notification_action_handler(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::mac_notifications::mojom::MacNotificationActionHandlerInterfaceBase>>(
        in_notification_action_handler,
        &fragment->notification_action_handler,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->notification_action_handler)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid notification_action_handler in AppShimInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::FeatureStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::FeatureStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::FeatureState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::field_trial_states(input)) in_field_trial_states = Traits::field_trial_states(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->field_trial_states)::BaseType> field_trial_states_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_field_trial_states,
        field_trial_states_fragment);

      fragment->field_trial_states.Set(
          field_trial_states_fragment.is_null() ? nullptr : field_trial_states_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->field_trial_states.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field_trial_states in FeatureState struct");

      decltype(Traits::field_trial_params(input)) in_field_trial_params = Traits::field_trial_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->field_trial_params)::BaseType> field_trial_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_field_trial_params,
        field_trial_params_fragment);

      fragment->field_trial_params.Set(
          field_trial_params_fragment.is_null() ? nullptr : field_trial_params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->field_trial_params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field_trial_params in FeatureState struct");

      decltype(Traits::enable_features(input)) in_enable_features = Traits::enable_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->enable_features)::BaseType> enable_features_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_enable_features,
        enable_features_fragment);

      fragment->enable_features.Set(
          enable_features_fragment.is_null() ? nullptr : enable_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->enable_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enable_features in FeatureState struct");

      decltype(Traits::disable_features(input)) in_disable_features = Traits::disable_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->disable_features)::BaseType> disable_features_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_disable_features,
        disable_features_fragment);

      fragment->disable_features.Set(
          disable_features_fragment.is_null() ? nullptr : disable_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->disable_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null disable_features in FeatureState struct");
  }
};

}  // namespace mojo::internal

#endif  // CHROME_COMMON_MAC_APP_SHIM_MOJOM_SEND_VALIDATION_H_