// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   chrome/common/extensions/api/experimental_actor.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#ifndef CHROME_COMMON_EXTENSIONS_API_EXPERIMENTAL_ACTOR_H__
#define CHROME_COMMON_EXTENSIONS_API_EXPERIMENTAL_ACTOR_H__

#include <stdint.h>

#include <map>
#include <memory>
#include <optional>
#include <string>
#include <vector>

#include "base/values.h"

namespace extensions {
namespace api {
namespace experimental_actor {

//
// Functions
//

namespace StopTask {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  int task_id;


 private:
  Params();
};

namespace Results {

base::Value::List Create();
}  // namespace Results

}  // namespace StopTask

namespace CreateTask {

namespace Results {

base::Value::List Create(int task_id);
}  // namespace Results

}  // namespace CreateTask

namespace PerformActions {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  std::vector<uint8_t> actions_proto;


 private:
  Params();
};

namespace Results {

base::Value::List Create(const std::vector<uint8_t>& data);
}  // namespace Results

}  // namespace PerformActions

namespace RequestTabObservation {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  int tab_id;


 private:
  Params();
};

namespace Results {

base::Value::List Create(const std::vector<uint8_t>& data);
}  // namespace Results

}  // namespace RequestTabObservation

}  // namespace experimental_actor
}  // namespace api
}  // namespace extensions

#endif  // CHROME_COMMON_EXTENSIONS_API_EXPERIMENTAL_ACTOR_H__
