// chrome/common/chrome_render_frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/chrome_render_frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/chrome_render_frame.mojom-params-data.h"
#include "chrome/common/chrome_render_frame.mojom-shared-message-ids.h"

#include "chrome/common/chrome_render_frame.mojom-import-headers.h"
#include "chrome/common/chrome_render_frame.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

ChromeRenderFrame::IPCStableHashFunction ChromeRenderFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChromeRenderFrame>(message.name())) {
    case messages::ChromeRenderFrame::kSetWindowFeatures: {
      return &ChromeRenderFrame::SetWindowFeatures_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kRequestReloadImageForContextNode: {
      return &ChromeRenderFrame::RequestReloadImageForContextNode_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kRequestBitmapForContextNode: {
      return &ChromeRenderFrame::RequestBitmapForContextNode_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kRequestBitmapForContextNodeWithBoundsHint: {
      return &ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHint_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kRequestBoundsHintForAllImages: {
      return &ChromeRenderFrame::RequestBoundsHintForAllImages_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kRequestImageForContextNode: {
      return &ChromeRenderFrame::RequestImageForContextNode_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kExecuteWebUIJavaScript: {
      return &ChromeRenderFrame::ExecuteWebUIJavaScript_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kGetMediaFeedURL: {
      return &ChromeRenderFrame::GetMediaFeedURL_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kLoadBlockedPlugins: {
      return &ChromeRenderFrame::LoadBlockedPlugins_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kSetShouldDeferMediaLoad: {
      return &ChromeRenderFrame::SetShouldDeferMediaLoad_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kInvokeTool: {
      return &ChromeRenderFrame::InvokeTool_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kStartActorJournal: {
      return &ChromeRenderFrame::StartActorJournal_Sym::IPCStableHash;
    }
    case messages::ChromeRenderFrame::kCreatePageStabilityMonitor: {
      return &ChromeRenderFrame::CreatePageStabilityMonitor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChromeRenderFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChromeRenderFrame>(message.name())) {
      case messages::ChromeRenderFrame::kSetWindowFeatures:
            return "Receive chrome::mojom::ChromeRenderFrame::SetWindowFeatures";
      case messages::ChromeRenderFrame::kRequestReloadImageForContextNode:
            return "Receive chrome::mojom::ChromeRenderFrame::RequestReloadImageForContextNode";
      case messages::ChromeRenderFrame::kRequestBitmapForContextNode:
            return "Receive chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNode";
      case messages::ChromeRenderFrame::kRequestBitmapForContextNodeWithBoundsHint:
            return "Receive chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHint";
      case messages::ChromeRenderFrame::kRequestBoundsHintForAllImages:
            return "Receive chrome::mojom::ChromeRenderFrame::RequestBoundsHintForAllImages";
      case messages::ChromeRenderFrame::kRequestImageForContextNode:
            return "Receive chrome::mojom::ChromeRenderFrame::RequestImageForContextNode";
      case messages::ChromeRenderFrame::kExecuteWebUIJavaScript:
            return "Receive chrome::mojom::ChromeRenderFrame::ExecuteWebUIJavaScript";
      case messages::ChromeRenderFrame::kGetMediaFeedURL:
            return "Receive chrome::mojom::ChromeRenderFrame::GetMediaFeedURL";
      case messages::ChromeRenderFrame::kLoadBlockedPlugins:
            return "Receive chrome::mojom::ChromeRenderFrame::LoadBlockedPlugins";
      case messages::ChromeRenderFrame::kSetShouldDeferMediaLoad:
            return "Receive chrome::mojom::ChromeRenderFrame::SetShouldDeferMediaLoad";
      case messages::ChromeRenderFrame::kInvokeTool:
            return "Receive chrome::mojom::ChromeRenderFrame::InvokeTool";
      case messages::ChromeRenderFrame::kStartActorJournal:
            return "Receive chrome::mojom::ChromeRenderFrame::StartActorJournal";
      case messages::ChromeRenderFrame::kCreatePageStabilityMonitor:
            return "Receive chrome::mojom::ChromeRenderFrame::CreatePageStabilityMonitor";
    }
  } else {
    switch (static_cast<messages::ChromeRenderFrame>(message.name())) {
      case messages::ChromeRenderFrame::kSetWindowFeatures:
            return "Receive reply chrome::mojom::ChromeRenderFrame::SetWindowFeatures";
      case messages::ChromeRenderFrame::kRequestReloadImageForContextNode:
            return "Receive reply chrome::mojom::ChromeRenderFrame::RequestReloadImageForContextNode";
      case messages::ChromeRenderFrame::kRequestBitmapForContextNode:
            return "Receive reply chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNode";
      case messages::ChromeRenderFrame::kRequestBitmapForContextNodeWithBoundsHint:
            return "Receive reply chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHint";
      case messages::ChromeRenderFrame::kRequestBoundsHintForAllImages:
            return "Receive reply chrome::mojom::ChromeRenderFrame::RequestBoundsHintForAllImages";
      case messages::ChromeRenderFrame::kRequestImageForContextNode:
            return "Receive reply chrome::mojom::ChromeRenderFrame::RequestImageForContextNode";
      case messages::ChromeRenderFrame::kExecuteWebUIJavaScript:
            return "Receive reply chrome::mojom::ChromeRenderFrame::ExecuteWebUIJavaScript";
      case messages::ChromeRenderFrame::kGetMediaFeedURL:
            return "Receive reply chrome::mojom::ChromeRenderFrame::GetMediaFeedURL";
      case messages::ChromeRenderFrame::kLoadBlockedPlugins:
            return "Receive reply chrome::mojom::ChromeRenderFrame::LoadBlockedPlugins";
      case messages::ChromeRenderFrame::kSetShouldDeferMediaLoad:
            return "Receive reply chrome::mojom::ChromeRenderFrame::SetShouldDeferMediaLoad";
      case messages::ChromeRenderFrame::kInvokeTool:
            return "Receive reply chrome::mojom::ChromeRenderFrame::InvokeTool";
      case messages::ChromeRenderFrame::kStartActorJournal:
            return "Receive reply chrome::mojom::ChromeRenderFrame::StartActorJournal";
      case messages::ChromeRenderFrame::kCreatePageStabilityMonitor:
            return "Receive reply chrome::mojom::ChromeRenderFrame::CreatePageStabilityMonitor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChromeRenderFrame::SetWindowFeatures_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x038235bf;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::SetWindowFeatures
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::RequestReloadImageForContextNode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x934dc344;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::RequestReloadImageForContextNode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::RequestBitmapForContextNode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2963fba;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x83129243;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::RequestBoundsHintForAllImages_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1298b190;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::RequestBoundsHintForAllImages
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::RequestImageForContextNode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2574fef;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::RequestImageForContextNode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::ExecuteWebUIJavaScript_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe85fbb31;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::ExecuteWebUIJavaScript
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::GetMediaFeedURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b302d56;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::GetMediaFeedURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::LoadBlockedPlugins_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b05b50e;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::LoadBlockedPlugins
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::SetShouldDeferMediaLoad_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd58a545b;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::SetShouldDeferMediaLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::InvokeTool_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67e97d7b;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::InvokeTool
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::StartActorJournal_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa4ca0773;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::StartActorJournal
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChromeRenderFrame::CreatePageStabilityMonitor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ea60b30;  // IPCStableHash for chrome::mojom::ChromeRenderFrame::CreatePageStabilityMonitor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ChromeRenderFrame_RequestBitmapForContextNode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChromeRenderFrame_RequestBitmapForContextNode_ForwardToCallback(
      ChromeRenderFrame::RequestBitmapForContextNodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChromeRenderFrame_RequestBitmapForContextNode_ForwardToCallback(const ChromeRenderFrame_RequestBitmapForContextNode_ForwardToCallback&) = delete;
  ChromeRenderFrame_RequestBitmapForContextNode_ForwardToCallback& operator=(const ChromeRenderFrame_RequestBitmapForContextNode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChromeRenderFrame::RequestBitmapForContextNodeCallback callback_;
};

class ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ForwardToCallback(
      ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHintCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ForwardToCallback(const ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ForwardToCallback&) = delete;
  ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ForwardToCallback& operator=(const ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHintCallback callback_;
};

class ChromeRenderFrame_RequestBoundsHintForAllImages_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChromeRenderFrame_RequestBoundsHintForAllImages_ForwardToCallback(
      ChromeRenderFrame::RequestBoundsHintForAllImagesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChromeRenderFrame_RequestBoundsHintForAllImages_ForwardToCallback(const ChromeRenderFrame_RequestBoundsHintForAllImages_ForwardToCallback&) = delete;
  ChromeRenderFrame_RequestBoundsHintForAllImages_ForwardToCallback& operator=(const ChromeRenderFrame_RequestBoundsHintForAllImages_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChromeRenderFrame::RequestBoundsHintForAllImagesCallback callback_;
};

class ChromeRenderFrame_RequestImageForContextNode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChromeRenderFrame_RequestImageForContextNode_ForwardToCallback(
      ChromeRenderFrame::RequestImageForContextNodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChromeRenderFrame_RequestImageForContextNode_ForwardToCallback(const ChromeRenderFrame_RequestImageForContextNode_ForwardToCallback&) = delete;
  ChromeRenderFrame_RequestImageForContextNode_ForwardToCallback& operator=(const ChromeRenderFrame_RequestImageForContextNode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChromeRenderFrame::RequestImageForContextNodeCallback callback_;
};

class ChromeRenderFrame_GetMediaFeedURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChromeRenderFrame_GetMediaFeedURL_ForwardToCallback(
      ChromeRenderFrame::GetMediaFeedURLCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChromeRenderFrame_GetMediaFeedURL_ForwardToCallback(const ChromeRenderFrame_GetMediaFeedURL_ForwardToCallback&) = delete;
  ChromeRenderFrame_GetMediaFeedURL_ForwardToCallback& operator=(const ChromeRenderFrame_GetMediaFeedURL_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChromeRenderFrame::GetMediaFeedURLCallback callback_;
};

class ChromeRenderFrame_InvokeTool_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChromeRenderFrame_InvokeTool_ForwardToCallback(
      ChromeRenderFrame::InvokeToolCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChromeRenderFrame_InvokeTool_ForwardToCallback(const ChromeRenderFrame_InvokeTool_ForwardToCallback&) = delete;
  ChromeRenderFrame_InvokeTool_ForwardToCallback& operator=(const ChromeRenderFrame_InvokeTool_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChromeRenderFrame::InvokeToolCallback callback_;
};

ChromeRenderFrameProxy::ChromeRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChromeRenderFrameProxy::SetWindowFeatures(
    ::blink::mojom::WindowFeaturesPtr in_window_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ChromeRenderFrame::SetWindowFeatures", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_features"), in_window_features,
                        "<value of type ::blink::mojom::WindowFeaturesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kSetWindowFeatures), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_SetWindowFeatures_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_features)::BaseType> window_features_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WindowFeaturesDataView>(
    in_window_features,
    window_features_fragment);

  params->window_features.Set(
      window_features_fragment.is_null() ? nullptr : window_features_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->window_features.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null window_features in ChromeRenderFrame.SetWindowFeatures request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("SetWindowFeatures");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChromeRenderFrameProxy::RequestReloadImageForContextNode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::ChromeRenderFrame::RequestReloadImageForContextNode");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestReloadImageForContextNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestReloadImageForContextNode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChromeRenderFrameProxy::RequestBitmapForContextNode(
    RequestBitmapForContextNodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNode");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestBitmapForContextNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestBitmapForContextNode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestBitmapForContextNode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChromeRenderFrame_RequestBitmapForContextNode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChromeRenderFrameProxy::RequestBitmapForContextNodeWithBoundsHint(
    RequestBitmapForContextNodeWithBoundsHintCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHint");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestBitmapForContextNodeWithBoundsHint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestBitmapForContextNodeWithBoundsHint");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChromeRenderFrameProxy::RequestBoundsHintForAllImages(
    RequestBoundsHintForAllImagesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::ChromeRenderFrame::RequestBoundsHintForAllImages");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestBoundsHintForAllImages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestBoundsHintForAllImages");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChromeRenderFrame_RequestBoundsHintForAllImages_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChromeRenderFrameProxy::RequestImageForContextNode(
    int32_t in_image_min_area_pixels, const ::gfx::Size& in_image_max_size_pixels, ImageFormat in_image_format, int32_t in_quality, RequestImageForContextNodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ChromeRenderFrame::RequestImageForContextNode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_min_area_pixels"), in_image_min_area_pixels,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_max_size_pixels"), in_image_max_size_pixels,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_format"), in_image_format,
                        "<value of type ImageFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quality"), in_quality,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestImageForContextNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestImageForContextNode_Params_Data> params(
          message);
  params.Allocate();

  params->image_min_area_pixels = in_image_min_area_pixels;
  mojo::internal::MessageFragment<
      typename decltype(params->image_max_size_pixels)::BaseType> image_max_size_pixels_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_image_max_size_pixels,
    image_max_size_pixels_fragment);

  params->image_max_size_pixels.Set(
      image_max_size_pixels_fragment.is_null() ? nullptr : image_max_size_pixels_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_max_size_pixels.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_max_size_pixels in ChromeRenderFrame.RequestImageForContextNode request");

  
  mojo::internal::Serialize<::chrome::mojom::ImageFormat>(
    in_image_format,
    &params->image_format);

  params->quality = in_quality;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestImageForContextNode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChromeRenderFrame_RequestImageForContextNode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChromeRenderFrameProxy::ExecuteWebUIJavaScript(
    const ::std::u16string& in_javascript) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ChromeRenderFrame::ExecuteWebUIJavaScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kExecuteWebUIJavaScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_javascript,
    javascript_fragment);

  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->javascript.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null javascript in ChromeRenderFrame.ExecuteWebUIJavaScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("ExecuteWebUIJavaScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChromeRenderFrameProxy::GetMediaFeedURL(
    GetMediaFeedURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::ChromeRenderFrame::GetMediaFeedURL");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kGetMediaFeedURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_GetMediaFeedURL_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("GetMediaFeedURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChromeRenderFrame_GetMediaFeedURL_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChromeRenderFrameProxy::LoadBlockedPlugins(
    const std::string& in_identifier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ChromeRenderFrame::LoadBlockedPlugins", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identifier"), in_identifier,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kLoadBlockedPlugins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_LoadBlockedPlugins_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identifier)::BaseType> identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_identifier,
    identifier_fragment);

  params->identifier.Set(
      identifier_fragment.is_null() ? nullptr : identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identifier in ChromeRenderFrame.LoadBlockedPlugins request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("LoadBlockedPlugins");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChromeRenderFrameProxy::SetShouldDeferMediaLoad(
    bool in_should_defer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ChromeRenderFrame::SetShouldDeferMediaLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_defer"), in_should_defer,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kSetShouldDeferMediaLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data> params(
          message);
  params.Allocate();

  params->should_defer = in_should_defer;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("SetShouldDeferMediaLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChromeRenderFrameProxy::InvokeTool(
    ::actor::mojom::ToolInvocationPtr in_request, InvokeToolCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ChromeRenderFrame::InvokeTool", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::actor::mojom::ToolInvocationPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kInvokeTool), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_InvokeTool_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::mojom::ToolInvocationDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in ChromeRenderFrame.InvokeTool request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("InvokeTool");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChromeRenderFrame_InvokeTool_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChromeRenderFrameProxy::StartActorJournal(
    ::mojo::PendingAssociatedRemote<::actor::mojom::JournalClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ChromeRenderFrame::StartActorJournal", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::actor::mojom::JournalClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kStartActorJournal), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_StartActorJournal_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::actor::mojom::JournalClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in ChromeRenderFrame.StartActorJournal request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("StartActorJournal");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChromeRenderFrameProxy::CreatePageStabilityMonitor(
    ::mojo::PendingReceiver<::actor::mojom::PageStabilityMonitor> in_monitor, const ::actor::TaskId& in_task_id, bool in_supports_paint_stability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ChromeRenderFrame::CreatePageStabilityMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("monitor"), in_monitor,
                        "<value of type ::mojo::PendingReceiver<::actor::mojom::PageStabilityMonitor>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_id"), in_task_id,
                        "<value of type const ::actor::TaskId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supports_paint_stability"), in_supports_paint_stability,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kCreatePageStabilityMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::actor::mojom::PageStabilityMonitorInterfaceBase>>(
    in_monitor,
    &params->monitor,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->monitor)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid monitor in ChromeRenderFrame.CreatePageStabilityMonitor request");
  mojo::internal::MessageFragment<
      typename decltype(params->task_id)::BaseType> task_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::mojom::TaskIdDataView>(
    in_task_id,
    task_id_fragment);

  params->task_id.Set(
      task_id_fragment.is_null() ? nullptr : task_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->task_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null task_id in ChromeRenderFrame.CreatePageStabilityMonitor request");

  params->supports_paint_stability = in_supports_paint_stability;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("CreatePageStabilityMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ChromeRenderFrame_RequestBitmapForContextNode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChromeRenderFrame::RequestBitmapForContextNodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChromeRenderFrame_RequestBitmapForContextNode_ProxyToResponder> proxy(
        new ChromeRenderFrame_RequestBitmapForContextNode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChromeRenderFrame_RequestBitmapForContextNode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChromeRenderFrame_RequestBitmapForContextNode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChromeRenderFrame_RequestBitmapForContextNode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChromeRenderFrame::RequestBitmapForContextNodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::SkBitmap& in_bitmap);
};

bool ChromeRenderFrame_RequestBitmapForContextNode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChromeRenderFrame.2
  bool success = true;
  ::SkBitmap p_bitmap{};
  ChromeRenderFrame_RequestBitmapForContextNode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBitmap(&p_bitmap))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChromeRenderFrame::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bitmap));
  }
  return true;
}

void ChromeRenderFrame_RequestBitmapForContextNode_ProxyToResponder::Run(
    const ::SkBitmap& in_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestBitmapForContextNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_bitmap,
    bitmap_fragment);

  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestBitmapForContextNode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHintCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ProxyToResponder> proxy(
        new ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHintCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::SkBitmap& in_bitmap, const ::gfx::Rect& in_bounds);
};

bool ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChromeRenderFrame.3
  bool success = true;
  ::SkBitmap p_bitmap{};
  ::gfx::Rect p_bounds{};
  ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBitmap(&p_bitmap))
    success = false;
  if (success && !input_data_view.ReadBounds(&p_bounds))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChromeRenderFrame::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bitmap), 
std::move(p_bounds));
  }
  return true;
}

void ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ProxyToResponder::Run(
    const ::SkBitmap& in_bitmap, const ::gfx::Rect& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::ChromeRenderFrame::RequestBitmapForContextNodeWithBoundsHint", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type const ::SkBitmap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestBitmapForContextNodeWithBoundsHint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_bitmap,
    bitmap_fragment);

  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestBitmapForContextNodeWithBoundsHint");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ChromeRenderFrame_RequestBoundsHintForAllImages_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChromeRenderFrame::RequestBoundsHintForAllImagesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChromeRenderFrame_RequestBoundsHintForAllImages_ProxyToResponder> proxy(
        new ChromeRenderFrame_RequestBoundsHintForAllImages_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChromeRenderFrame_RequestBoundsHintForAllImages_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChromeRenderFrame_RequestBoundsHintForAllImages_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChromeRenderFrame_RequestBoundsHintForAllImages_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChromeRenderFrame::RequestBoundsHintForAllImagesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::gfx::Rect>& in_all_bounds);
};

bool ChromeRenderFrame_RequestBoundsHintForAllImages_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChromeRenderFrame.4
  bool success = true;
  std::vector<::gfx::Rect> p_all_bounds{};
  ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAllBounds(&p_all_bounds))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChromeRenderFrame::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_all_bounds));
  }
  return true;
}

void ChromeRenderFrame_RequestBoundsHintForAllImages_ProxyToResponder::Run(
    const std::vector<::gfx::Rect>& in_all_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::ChromeRenderFrame::RequestBoundsHintForAllImages", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("all_bounds"), in_all_bounds,
                        "<value of type const std::vector<::gfx::Rect>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestBoundsHintForAllImages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->all_bounds)::BaseType>
      all_bounds_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& all_bounds_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
    in_all_bounds,
    all_bounds_fragment,
    &all_bounds_validate_params);

  params->all_bounds.Set(
      all_bounds_fragment.is_null() ? nullptr : all_bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->all_bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null all_bounds in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestBoundsHintForAllImages");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ChromeRenderFrame_RequestImageForContextNode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChromeRenderFrame::RequestImageForContextNodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChromeRenderFrame_RequestImageForContextNode_ProxyToResponder> proxy(
        new ChromeRenderFrame_RequestImageForContextNode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChromeRenderFrame_RequestImageForContextNode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChromeRenderFrame_RequestImageForContextNode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChromeRenderFrame_RequestImageForContextNode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChromeRenderFrame::RequestImageForContextNodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_image_data, const ::gfx::Size& in_original_size, const ::gfx::Size& in_downscaled_size, const std::string& in_encoded_extension, std::vector<::lens::mojom::LatencyLogPtr> in_log_data);
};

bool ChromeRenderFrame_RequestImageForContextNode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChromeRenderFrame.5
  bool success = true;
  std::vector<uint8_t> p_image_data{};
  ::gfx::Size p_original_size{};
  ::gfx::Size p_downscaled_size{};
  std::string p_encoded_extension{};
  std::vector<::lens::mojom::LatencyLogPtr> p_log_data{};
  ChromeRenderFrame_RequestImageForContextNode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImageData(&p_image_data))
    success = false;
  if (success && !input_data_view.ReadOriginalSize(&p_original_size))
    success = false;
  if (success && !input_data_view.ReadDownscaledSize(&p_downscaled_size))
    success = false;
  if (success && !input_data_view.ReadEncodedExtension(&p_encoded_extension))
    success = false;
  if (success && !input_data_view.ReadLogData(&p_log_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChromeRenderFrame::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_image_data), 
std::move(p_original_size), 
std::move(p_downscaled_size), 
std::move(p_encoded_extension), 
std::move(p_log_data));
  }
  return true;
}

void ChromeRenderFrame_RequestImageForContextNode_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_image_data, const ::gfx::Size& in_original_size, const ::gfx::Size& in_downscaled_size, const std::string& in_encoded_extension, std::vector<::lens::mojom::LatencyLogPtr> in_log_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::ChromeRenderFrame::RequestImageForContextNode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_data"), in_image_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_size"), in_original_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("downscaled_size"), in_downscaled_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoded_extension"), in_encoded_extension,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_data"), in_log_data,
                        "<value of type std::vector<::lens::mojom::LatencyLogPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kRequestImageForContextNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image_data)::BaseType>
      image_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& image_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_image_data,
    image_data_fragment,
    &image_data_validate_params);

  params->image_data.Set(
      image_data_fragment.is_null() ? nullptr : image_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_data in ");
  mojo::internal::MessageFragment<
      typename decltype(params->original_size)::BaseType> original_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_original_size,
    original_size_fragment);

  params->original_size.Set(
      original_size_fragment.is_null() ? nullptr : original_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->original_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null original_size in ");
  mojo::internal::MessageFragment<
      typename decltype(params->downscaled_size)::BaseType> downscaled_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_downscaled_size,
    downscaled_size_fragment);

  params->downscaled_size.Set(
      downscaled_size_fragment.is_null() ? nullptr : downscaled_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->downscaled_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null downscaled_size in ");
  mojo::internal::MessageFragment<
      typename decltype(params->encoded_extension)::BaseType> encoded_extension_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_encoded_extension,
    encoded_extension_fragment);

  params->encoded_extension.Set(
      encoded_extension_fragment.is_null() ? nullptr : encoded_extension_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->encoded_extension.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null encoded_extension in ");
  mojo::internal::MessageFragment<
      typename decltype(params->log_data)::BaseType>
      log_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& log_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::LatencyLogDataView>>(
    in_log_data,
    log_data_fragment,
    &log_data_validate_params);

  params->log_data.Set(
      log_data_fragment.is_null() ? nullptr : log_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->log_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null log_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("RequestImageForContextNode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ChromeRenderFrame_GetMediaFeedURL_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChromeRenderFrame::GetMediaFeedURLCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChromeRenderFrame_GetMediaFeedURL_ProxyToResponder> proxy(
        new ChromeRenderFrame_GetMediaFeedURL_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChromeRenderFrame_GetMediaFeedURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChromeRenderFrame_GetMediaFeedURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChromeRenderFrame_GetMediaFeedURL_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChromeRenderFrame::GetMediaFeedURLCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::GURL>& in_url);
};

bool ChromeRenderFrame_GetMediaFeedURL_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChromeRenderFrame.7
  bool success = true;
  std::optional<::GURL> p_url{};
  ChromeRenderFrame_GetMediaFeedURL_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChromeRenderFrame::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url));
  }
  return true;
}

void ChromeRenderFrame_GetMediaFeedURL_ProxyToResponder::Run(
    const std::optional<::GURL>& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::ChromeRenderFrame::GetMediaFeedURL", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kGetMediaFeedURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("GetMediaFeedURL");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ChromeRenderFrame_InvokeTool_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChromeRenderFrame::InvokeToolCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChromeRenderFrame_InvokeTool_ProxyToResponder> proxy(
        new ChromeRenderFrame_InvokeTool_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChromeRenderFrame_InvokeTool_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChromeRenderFrame_InvokeTool_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChromeRenderFrame_InvokeTool_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChromeRenderFrame::InvokeToolCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::actor::mojom::ActionResultPtr in_result);
};

bool ChromeRenderFrame_InvokeTool_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChromeRenderFrame_InvokeTool_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChromeRenderFrame_InvokeTool_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChromeRenderFrame.10
  bool success = true;
  ::actor::mojom::ActionResultPtr p_result{};
  ChromeRenderFrame_InvokeTool_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChromeRenderFrame::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ChromeRenderFrame_InvokeTool_ProxyToResponder::Run(
    ::actor::mojom::ActionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::ChromeRenderFrame::InvokeTool", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::actor::mojom::ActionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChromeRenderFrame::kInvokeTool), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ChromeRenderFrame_InvokeTool_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::mojom::ActionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChromeRenderFrame::Name_);
  message.set_method_name("InvokeTool");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ChromeRenderFrameStubDispatch::Accept(
    ChromeRenderFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChromeRenderFrame>(message->header()->name)) {
    case messages::ChromeRenderFrame::kSetWindowFeatures: {
      DCHECK(message->is_serialized());
      internal::ChromeRenderFrame_SetWindowFeatures_Params_Data* params =
          reinterpret_cast<internal::ChromeRenderFrame_SetWindowFeatures_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChromeRenderFrame.0
      bool success = true;
      ::blink::mojom::WindowFeaturesPtr p_window_features{};
      ChromeRenderFrame_SetWindowFeatures_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowFeatures(&p_window_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowFeatures(        
        std::move(p_window_features));
      return true;
    }
    case messages::ChromeRenderFrame::kRequestReloadImageForContextNode: {
      DCHECK(message->is_serialized());
      internal::ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data* params =
          reinterpret_cast<internal::ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChromeRenderFrame.1
      bool success = true;
      ChromeRenderFrame_RequestReloadImageForContextNode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestReloadImageForContextNode(        );
      return true;
    }
    case messages::ChromeRenderFrame::kRequestBitmapForContextNode: {
      break;
    }
    case messages::ChromeRenderFrame::kRequestBitmapForContextNodeWithBoundsHint: {
      break;
    }
    case messages::ChromeRenderFrame::kRequestBoundsHintForAllImages: {
      break;
    }
    case messages::ChromeRenderFrame::kRequestImageForContextNode: {
      break;
    }
    case messages::ChromeRenderFrame::kExecuteWebUIJavaScript: {
      DCHECK(message->is_serialized());
      internal::ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data* params =
          reinterpret_cast<internal::ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChromeRenderFrame.6
      bool success = true;
      ::std::u16string p_javascript{};
      ChromeRenderFrame_ExecuteWebUIJavaScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteWebUIJavaScript(        
        std::move(p_javascript));
      return true;
    }
    case messages::ChromeRenderFrame::kGetMediaFeedURL: {
      break;
    }
    case messages::ChromeRenderFrame::kLoadBlockedPlugins: {
      DCHECK(message->is_serialized());
      internal::ChromeRenderFrame_LoadBlockedPlugins_Params_Data* params =
          reinterpret_cast<internal::ChromeRenderFrame_LoadBlockedPlugins_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChromeRenderFrame.8
      bool success = true;
      std::string p_identifier{};
      ChromeRenderFrame_LoadBlockedPlugins_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentifier(&p_identifier))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadBlockedPlugins(        
        std::move(p_identifier));
      return true;
    }
    case messages::ChromeRenderFrame::kSetShouldDeferMediaLoad: {
      DCHECK(message->is_serialized());
      internal::ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data* params =
          reinterpret_cast<internal::ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChromeRenderFrame.9
      bool success = true;
      bool p_should_defer{};
      ChromeRenderFrame_SetShouldDeferMediaLoad_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_should_defer = input_data_view.should_defer();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetShouldDeferMediaLoad(        
        std::move(p_should_defer));
      return true;
    }
    case messages::ChromeRenderFrame::kInvokeTool: {
      break;
    }
    case messages::ChromeRenderFrame::kStartActorJournal: {
      DCHECK(message->is_serialized());
      internal::ChromeRenderFrame_StartActorJournal_Params_Data* params =
          reinterpret_cast<internal::ChromeRenderFrame_StartActorJournal_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChromeRenderFrame.11
      bool success = true;
      ::mojo::PendingAssociatedRemote<::actor::mojom::JournalClient> p_client{};
      ChromeRenderFrame_StartActorJournal_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartActorJournal(        
        std::move(p_client));
      return true;
    }
    case messages::ChromeRenderFrame::kCreatePageStabilityMonitor: {
      DCHECK(message->is_serialized());
      internal::ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data* params =
          reinterpret_cast<internal::ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChromeRenderFrame.12
      bool success = true;
      ::mojo::PendingReceiver<::actor::mojom::PageStabilityMonitor> p_monitor{};
      ::actor::TaskId p_task_id{};
      bool p_supports_paint_stability{};
      ChromeRenderFrame_CreatePageStabilityMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_monitor =
            input_data_view.TakeMonitor<decltype(p_monitor)>();
      }
      if (success && !input_data_view.ReadTaskId(&p_task_id))
        success = false;
      if (success)
        p_supports_paint_stability = input_data_view.supports_paint_stability();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageStabilityMonitor(        
        std::move(p_monitor), 
        std::move(p_task_id), 
        std::move(p_supports_paint_stability));
      return true;
    }
  }
  return false;
}

// static
bool ChromeRenderFrameStubDispatch::AcceptWithResponder(
    ChromeRenderFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChromeRenderFrame>(message->header()->name)) {
    case messages::ChromeRenderFrame::kSetWindowFeatures: {
      break;
    }
    case messages::ChromeRenderFrame::kRequestReloadImageForContextNode: {
      break;
    }
    case messages::ChromeRenderFrame::kRequestBitmapForContextNode: {
      internal::ChromeRenderFrame_RequestBitmapForContextNode_Params_Data* params =
          reinterpret_cast<
              internal::ChromeRenderFrame_RequestBitmapForContextNode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChromeRenderFrame.2
      bool success = true;
      ChromeRenderFrame_RequestBitmapForContextNode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 2, false);
        return false;
      }
      auto callback =
          ChromeRenderFrame_RequestBitmapForContextNode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestBitmapForContextNode(std::move(callback));
      return true;
    }
    case messages::ChromeRenderFrame::kRequestBitmapForContextNodeWithBoundsHint: {
      internal::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data* params =
          reinterpret_cast<
              internal::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChromeRenderFrame.3
      bool success = true;
      ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 3, false);
        return false;
      }
      auto callback =
          ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestBitmapForContextNodeWithBoundsHint(std::move(callback));
      return true;
    }
    case messages::ChromeRenderFrame::kRequestBoundsHintForAllImages: {
      internal::ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data* params =
          reinterpret_cast<
              internal::ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChromeRenderFrame.4
      bool success = true;
      ChromeRenderFrame_RequestBoundsHintForAllImages_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 4, false);
        return false;
      }
      auto callback =
          ChromeRenderFrame_RequestBoundsHintForAllImages_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestBoundsHintForAllImages(std::move(callback));
      return true;
    }
    case messages::ChromeRenderFrame::kRequestImageForContextNode: {
      internal::ChromeRenderFrame_RequestImageForContextNode_Params_Data* params =
          reinterpret_cast<
              internal::ChromeRenderFrame_RequestImageForContextNode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChromeRenderFrame.5
      bool success = true;
      int32_t p_image_min_area_pixels{};
      ::gfx::Size p_image_max_size_pixels{};
      ImageFormat p_image_format{};
      int32_t p_quality{};
      ChromeRenderFrame_RequestImageForContextNode_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_image_min_area_pixels = input_data_view.image_min_area_pixels();
      if (success && !input_data_view.ReadImageMaxSizePixels(&p_image_max_size_pixels))
        success = false;
      if (success && !input_data_view.ReadImageFormat(&p_image_format))
        success = false;
      if (success)
        p_quality = input_data_view.quality();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 5, false);
        return false;
      }
      auto callback =
          ChromeRenderFrame_RequestImageForContextNode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestImageForContextNode(        
        std::move(p_image_min_area_pixels), 
        std::move(p_image_max_size_pixels), 
        std::move(p_image_format), 
        std::move(p_quality), std::move(callback));
      return true;
    }
    case messages::ChromeRenderFrame::kExecuteWebUIJavaScript: {
      break;
    }
    case messages::ChromeRenderFrame::kGetMediaFeedURL: {
      internal::ChromeRenderFrame_GetMediaFeedURL_Params_Data* params =
          reinterpret_cast<
              internal::ChromeRenderFrame_GetMediaFeedURL_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChromeRenderFrame.7
      bool success = true;
      ChromeRenderFrame_GetMediaFeedURL_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 7, false);
        return false;
      }
      auto callback =
          ChromeRenderFrame_GetMediaFeedURL_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMediaFeedURL(std::move(callback));
      return true;
    }
    case messages::ChromeRenderFrame::kLoadBlockedPlugins: {
      break;
    }
    case messages::ChromeRenderFrame::kSetShouldDeferMediaLoad: {
      break;
    }
    case messages::ChromeRenderFrame::kInvokeTool: {
      internal::ChromeRenderFrame_InvokeTool_Params_Data* params =
          reinterpret_cast<
              internal::ChromeRenderFrame_InvokeTool_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChromeRenderFrame.10
      bool success = true;
      ::actor::mojom::ToolInvocationPtr p_request{};
      ChromeRenderFrame_InvokeTool_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChromeRenderFrame::Name_, 10, false);
        return false;
      }
      auto callback =
          ChromeRenderFrame_InvokeTool_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InvokeTool(        
        std::move(p_request), std::move(callback));
      return true;
    }
    case messages::ChromeRenderFrame::kStartActorJournal: {
      break;
    }
    case messages::ChromeRenderFrame::kCreatePageStabilityMonitor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kChromeRenderFrameValidationInfo[] = {
    { &internal::ChromeRenderFrame_SetWindowFeatures_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChromeRenderFrame_RequestBitmapForContextNode_Params_Data::Validate,
     &internal::ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data::Validate},
    { &internal::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data::Validate,
     &internal::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data::Validate},
    { &internal::ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data::Validate,
     &internal::ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data::Validate},
    { &internal::ChromeRenderFrame_RequestImageForContextNode_Params_Data::Validate,
     &internal::ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data::Validate},
    { &internal::ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChromeRenderFrame_GetMediaFeedURL_Params_Data::Validate,
     &internal::ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data::Validate},
    { &internal::ChromeRenderFrame_LoadBlockedPlugins_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChromeRenderFrame_InvokeTool_Params_Data::Validate,
     &internal::ChromeRenderFrame_InvokeTool_ResponseParams_Data::Validate},
    { &internal::ChromeRenderFrame_StartActorJournal_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data::Validate,
     nullptr /* no response */},
};

bool ChromeRenderFrameRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::ChromeRenderFrame::Name_,
    kChromeRenderFrameValidationInfo);
}

bool ChromeRenderFrameResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::ChromeRenderFrame::Name_,
    kChromeRenderFrameValidationInfo);
}


}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void ChromeRenderFrameInterceptorForTesting::SetWindowFeatures(::blink::mojom::WindowFeaturesPtr window_features) {
  GetForwardingInterface()->SetWindowFeatures(
    std::move(window_features)
    );
}
void ChromeRenderFrameInterceptorForTesting::RequestReloadImageForContextNode() {
  GetForwardingInterface()->RequestReloadImageForContextNode();
}
void ChromeRenderFrameInterceptorForTesting::RequestBitmapForContextNode(RequestBitmapForContextNodeCallback callback) {
  GetForwardingInterface()->RequestBitmapForContextNode(std::move(callback));
}
void ChromeRenderFrameInterceptorForTesting::RequestBitmapForContextNodeWithBoundsHint(RequestBitmapForContextNodeWithBoundsHintCallback callback) {
  GetForwardingInterface()->RequestBitmapForContextNodeWithBoundsHint(std::move(callback));
}
void ChromeRenderFrameInterceptorForTesting::RequestBoundsHintForAllImages(RequestBoundsHintForAllImagesCallback callback) {
  GetForwardingInterface()->RequestBoundsHintForAllImages(std::move(callback));
}
void ChromeRenderFrameInterceptorForTesting::RequestImageForContextNode(int32_t image_min_area_pixels, const ::gfx::Size& image_max_size_pixels, ImageFormat image_format, int32_t quality, RequestImageForContextNodeCallback callback) {
  GetForwardingInterface()->RequestImageForContextNode(
    std::move(image_min_area_pixels)
    , 
    std::move(image_max_size_pixels)
    , 
    std::move(image_format)
    , 
    std::move(quality)
    , std::move(callback));
}
void ChromeRenderFrameInterceptorForTesting::ExecuteWebUIJavaScript(const ::std::u16string& javascript) {
  GetForwardingInterface()->ExecuteWebUIJavaScript(
    std::move(javascript)
    );
}
void ChromeRenderFrameInterceptorForTesting::GetMediaFeedURL(GetMediaFeedURLCallback callback) {
  GetForwardingInterface()->GetMediaFeedURL(std::move(callback));
}
void ChromeRenderFrameInterceptorForTesting::LoadBlockedPlugins(const std::string& identifier) {
  GetForwardingInterface()->LoadBlockedPlugins(
    std::move(identifier)
    );
}
void ChromeRenderFrameInterceptorForTesting::SetShouldDeferMediaLoad(bool should_defer) {
  GetForwardingInterface()->SetShouldDeferMediaLoad(
    std::move(should_defer)
    );
}
void ChromeRenderFrameInterceptorForTesting::InvokeTool(::actor::mojom::ToolInvocationPtr request, InvokeToolCallback callback) {
  GetForwardingInterface()->InvokeTool(
    std::move(request)
    , std::move(callback));
}
void ChromeRenderFrameInterceptorForTesting::StartActorJournal(::mojo::PendingAssociatedRemote<::actor::mojom::JournalClient> client) {
  GetForwardingInterface()->StartActorJournal(
    std::move(client)
    );
}
void ChromeRenderFrameInterceptorForTesting::CreatePageStabilityMonitor(::mojo::PendingReceiver<::actor::mojom::PageStabilityMonitor> monitor, const ::actor::TaskId& task_id, bool supports_paint_stability) {
  GetForwardingInterface()->CreatePageStabilityMonitor(
    std::move(monitor)
    , 
    std::move(task_id)
    , 
    std::move(supports_paint_stability)
    );
}
ChromeRenderFrameAsyncWaiter::ChromeRenderFrameAsyncWaiter(
    ChromeRenderFrame* proxy) : proxy_(proxy) {}

ChromeRenderFrameAsyncWaiter::~ChromeRenderFrameAsyncWaiter() = default;


void ChromeRenderFrameAsyncWaiter::RequestBitmapForContextNode(
    ::SkBitmap* out_bitmap) {
  base::RunLoop loop;
  proxy_->RequestBitmapForContextNode(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::SkBitmap* out_bitmap
,
             const ::SkBitmap& bitmap) {*out_bitmap = std::move(bitmap);
            loop->Quit();
          },
          &loop,
          out_bitmap));
  loop.Run();
}

::SkBitmap ChromeRenderFrameAsyncWaiter::RequestBitmapForContextNode(
    ) {
  ::SkBitmap async_wait_result;
  RequestBitmapForContextNode(&async_wait_result);
  return async_wait_result;
}

void ChromeRenderFrameAsyncWaiter::RequestBitmapForContextNodeWithBoundsHint(
    ::SkBitmap* out_bitmap, ::gfx::Rect* out_bounds) {
  base::RunLoop loop;
  proxy_->RequestBitmapForContextNodeWithBoundsHint(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::SkBitmap* out_bitmap
,
             ::gfx::Rect* out_bounds
,
             const ::SkBitmap& bitmap,
             const ::gfx::Rect& bounds) {*out_bitmap = std::move(bitmap);*out_bounds = std::move(bounds);
            loop->Quit();
          },
          &loop,
          out_bitmap,
          out_bounds));
  loop.Run();
}



void ChromeRenderFrameAsyncWaiter::RequestBoundsHintForAllImages(
    std::vector<::gfx::Rect>* out_all_bounds) {
  base::RunLoop loop;
  proxy_->RequestBoundsHintForAllImages(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::gfx::Rect>* out_all_bounds
,
             const std::vector<::gfx::Rect>& all_bounds) {*out_all_bounds = std::move(all_bounds);
            loop->Quit();
          },
          &loop,
          out_all_bounds));
  loop.Run();
}

std::vector<::gfx::Rect> ChromeRenderFrameAsyncWaiter::RequestBoundsHintForAllImages(
    ) {
  std::vector<::gfx::Rect> async_wait_result;
  RequestBoundsHintForAllImages(&async_wait_result);
  return async_wait_result;
}

void ChromeRenderFrameAsyncWaiter::RequestImageForContextNode(
    int32_t image_min_area_pixels, const ::gfx::Size& image_max_size_pixels, ImageFormat image_format, int32_t quality, std::vector<uint8_t>* out_image_data, ::gfx::Size* out_original_size, ::gfx::Size* out_downscaled_size, std::string* out_encoded_extension, std::vector<::lens::mojom::LatencyLogPtr>* out_log_data) {
  base::RunLoop loop;
  proxy_->RequestImageForContextNode(
      std::move(image_min_area_pixels),
      std::move(image_max_size_pixels),
      std::move(image_format),
      std::move(quality),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<uint8_t>* out_image_data
,
             ::gfx::Size* out_original_size
,
             ::gfx::Size* out_downscaled_size
,
             std::string* out_encoded_extension
,
             std::vector<::lens::mojom::LatencyLogPtr>* out_log_data
,
             const std::vector<uint8_t>& image_data,
             const ::gfx::Size& original_size,
             const ::gfx::Size& downscaled_size,
             const std::string& encoded_extension,
             std::vector<::lens::mojom::LatencyLogPtr> log_data) {*out_image_data = std::move(image_data);*out_original_size = std::move(original_size);*out_downscaled_size = std::move(downscaled_size);*out_encoded_extension = std::move(encoded_extension);*out_log_data = std::move(log_data);
            loop->Quit();
          },
          &loop,
          out_image_data,
          out_original_size,
          out_downscaled_size,
          out_encoded_extension,
          out_log_data));
  loop.Run();
}



void ChromeRenderFrameAsyncWaiter::GetMediaFeedURL(
    std::optional<::GURL>* out_url) {
  base::RunLoop loop;
  proxy_->GetMediaFeedURL(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::GURL>* out_url
,
             const std::optional<::GURL>& url) {*out_url = std::move(url);
            loop->Quit();
          },
          &loop,
          out_url));
  loop.Run();
}

std::optional<::GURL> ChromeRenderFrameAsyncWaiter::GetMediaFeedURL(
    ) {
  std::optional<::GURL> async_wait_result;
  GetMediaFeedURL(&async_wait_result);
  return async_wait_result;
}

void ChromeRenderFrameAsyncWaiter::InvokeTool(
    ::actor::mojom::ToolInvocationPtr request, ::actor::mojom::ActionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->InvokeTool(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::actor::mojom::ActionResultPtr* out_result
,
             ::actor::mojom::ActionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::actor::mojom::ActionResultPtr ChromeRenderFrameAsyncWaiter::InvokeTool(
    ::actor::mojom::ToolInvocationPtr request) {
  ::actor::mojom::ActionResultPtr async_wait_result;
  InvokeTool(std::move(request),&async_wait_result);
  return async_wait_result;
}






}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif