// chrome/browser/ui/webui_browser/extensions_bar.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui_browser/extensions_bar.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui_browser/extensions_bar.mojom-params-data.h"
namespace extensions_bar {
namespace mojom {

namespace internal {


// static
bool ExtensionActionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionActionInfo_Data* object =
      static_cast<const ExtensionActionInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accessible_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& accessible_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->accessible_name, validation_context,
                                         &accessible_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tooltip, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tooltip_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tooltip, validation_context,
                                         &tooltip_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_url_for_icon, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data_url_for_icon, validation_context))
    return false;

  return true;
}

ExtensionActionInfo_Data::ExtensionActionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ExecuteUserAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ExecuteUserAction_Params_Data* object =
      static_cast<const PageHandler_ExecuteUserAction_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ExecuteUserAction_Params_Data::PageHandler_ExecuteUserAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowContextMenu_Params_Data* object =
      static_cast<const PageHandler_ShowContextMenu_Params_Data*>(data);


  if (!::ui::mojom::internal::MenuSourceType_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ShowContextMenu_Params_Data::PageHandler_ShowContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ToggleExtensionsMenuFromWebUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ToggleExtensionsMenuFromWebUI_Params_Data* object =
      static_cast<const PageHandler_ToggleExtensionsMenuFromWebUI_Params_Data*>(data);

  return true;
}

PageHandler_ToggleExtensionsMenuFromWebUI_Params_Data::PageHandler_ToggleExtensionsMenuFromWebUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ActionsAddedOrUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ActionsAddedOrUpdated_Params_Data* object =
      static_cast<const Page_ActionsAddedOrUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& actions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->actions, validation_context,
                                         &actions_validate_params)) {
    return false;
  }

  return true;
}

Page_ActionsAddedOrUpdated_Params_Data::Page_ActionsAddedOrUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ActionRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ActionRemoved_Params_Data* object =
      static_cast<const Page_ActionRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

Page_ActionRemoved_Params_Data::Page_ActionRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ActionPoppedOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ActionPoppedOut_Params_Data* object =
      static_cast<const Page_ActionPoppedOut_Params_Data*>(data);

  return true;
}

Page_ActionPoppedOut_Params_Data::Page_ActionPoppedOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ActionPoppedOut_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ActionPoppedOut_ResponseParams_Data* object =
      static_cast<const Page_ActionPoppedOut_ResponseParams_Data*>(data);

  return true;
}

Page_ActionPoppedOut_ResponseParams_Data::Page_ActionPoppedOut_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions_bar