// chrome/browser/ui/webui_browser/bookmark_bar.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SHARED_INTERNAL_H_
#define CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace bookmark_bar::mojom {
namespace internal {
class BookmarkData_Data;

struct BookmarkType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  BookmarkData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t id;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  int32_t type;
  uint8_t pad2_[4];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> page_url_for_favicon;

 private:
  friend class mojo::internal::MessageFragment<BookmarkData_Data>;

  BookmarkData_Data();
  ~BookmarkData_Data() = delete;
};
static_assert(sizeof(BookmarkData_Data) == 40,
              "Bad sizeof(BookmarkData_Data)");
// Used by BookmarkData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BookmarkData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BookmarkData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BookmarkData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BookmarkData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BookmarkData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // bookmark_bar::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SHARED_INTERNAL_H_