// chrome/browser/ui/webui_browser/bookmark_bar.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_PARAMS_DATA_H_
#define CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace bookmark_bar::mojom {
namespace internal {
class  PageHandlerFactory_CreatePageHandler_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data page;
  mojo::internal::Handle_Data handler;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandlerFactory_CreatePageHandler_Params_Data>;

  PageHandlerFactory_CreatePageHandler_Params_Data();
  ~PageHandlerFactory_CreatePageHandler_Params_Data() = delete;
};
static_assert(sizeof(PageHandlerFactory_CreatePageHandler_Params_Data) == 24,
              "Bad sizeof(PageHandlerFactory_CreatePageHandler_Params_Data)");
class  PageHandler_GetBookmarkBar_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetBookmarkBar_Params_Data>;

  PageHandler_GetBookmarkBar_Params_Data();
  ~PageHandler_GetBookmarkBar_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetBookmarkBar_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetBookmarkBar_Params_Data)");
class  PageHandler_GetBookmarkBar_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::BookmarkData_Data>>> bookmarks;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetBookmarkBar_ResponseParams_Data>;

  PageHandler_GetBookmarkBar_ResponseParams_Data();
  ~PageHandler_GetBookmarkBar_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetBookmarkBar_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetBookmarkBar_ResponseParams_Data)");
class  PageHandler_OpenInNewTab_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t node_id;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_OpenInNewTab_Params_Data>;

  PageHandler_OpenInNewTab_Params_Data();
  ~PageHandler_OpenInNewTab_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_OpenInNewTab_Params_Data) == 16,
              "Bad sizeof(PageHandler_OpenInNewTab_Params_Data)");
class  Page_BookmarkLoaded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Page_BookmarkLoaded_Params_Data>;

  Page_BookmarkLoaded_Params_Data();
  ~Page_BookmarkLoaded_Params_Data() = delete;
};
static_assert(sizeof(Page_BookmarkLoaded_Params_Data) == 8,
              "Bad sizeof(Page_BookmarkLoaded_Params_Data)");
class  Page_FavIconChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::BookmarkData_Data> bookmark_data;

 private:
  friend class mojo::internal::MessageFragment<Page_FavIconChanged_Params_Data>;

  Page_FavIconChanged_Params_Data();
  ~Page_FavIconChanged_Params_Data() = delete;
};
static_assert(sizeof(Page_FavIconChanged_Params_Data) == 16,
              "Bad sizeof(Page_FavIconChanged_Params_Data)");
class  Page_Show_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Page_Show_Params_Data>;

  Page_Show_Params_Data();
  ~Page_Show_Params_Data() = delete;
};
static_assert(sizeof(Page_Show_Params_Data) == 8,
              "Bad sizeof(Page_Show_Params_Data)");
class  Page_Hide_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Page_Hide_Params_Data>;

  Page_Hide_Params_Data();
  ~Page_Hide_Params_Data() = delete;
};
static_assert(sizeof(Page_Hide_Params_Data) == 8,
              "Bad sizeof(Page_Hide_Params_Data)");

}  // namespace internal


class PageHandlerFactory_CreatePageHandler_ParamsDataView {
 public:
  PageHandlerFactory_CreatePageHandler_ParamsDataView() = default;

  PageHandlerFactory_CreatePageHandler_ParamsDataView(
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePage() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bookmark_bar::mojom::PageInterfaceBase>>(
            &data_->page, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::bookmark_bar::mojom::PageHandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandlerFactory_CreatePageHandler_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_GetBookmarkBar_ParamsDataView {
 public:
  PageHandler_GetBookmarkBar_ParamsDataView() = default;

  PageHandler_GetBookmarkBar_ParamsDataView(
      internal::PageHandler_GetBookmarkBar_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetBookmarkBar_Params_Data* data_ = nullptr;
};


class PageHandler_GetBookmarkBar_ResponseParamsDataView {
 public:
  PageHandler_GetBookmarkBar_ResponseParamsDataView() = default;

  PageHandler_GetBookmarkBar_ResponseParamsDataView(
      internal::PageHandler_GetBookmarkBar_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBookmarksDataView(
      mojo::ArrayDataView<BookmarkDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBookmarks(UserType* output) {
    
    auto* pointer = data_->bookmarks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bookmark_bar::mojom::BookmarkDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetBookmarkBar_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_OpenInNewTab_ParamsDataView {
 public:
  PageHandler_OpenInNewTab_ParamsDataView() = default;

  PageHandler_OpenInNewTab_ParamsDataView(
      internal::PageHandler_OpenInNewTab_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t node_id() const {
    return data_->node_id;
  }
 private:
  internal::PageHandler_OpenInNewTab_Params_Data* data_ = nullptr;
};


class Page_BookmarkLoaded_ParamsDataView {
 public:
  Page_BookmarkLoaded_ParamsDataView() = default;

  Page_BookmarkLoaded_ParamsDataView(
      internal::Page_BookmarkLoaded_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Page_BookmarkLoaded_Params_Data* data_ = nullptr;
};


class Page_FavIconChanged_ParamsDataView {
 public:
  Page_FavIconChanged_ParamsDataView() = default;

  Page_FavIconChanged_ParamsDataView(
      internal::Page_FavIconChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBookmarkDataDataView(
      BookmarkDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBookmarkData(UserType* output) {
    
    auto* pointer = data_->bookmark_data.Get();
    return mojo::internal::Deserialize<::bookmark_bar::mojom::BookmarkDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::Page_FavIconChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_Show_ParamsDataView {
 public:
  Page_Show_ParamsDataView() = default;

  Page_Show_ParamsDataView(
      internal::Page_Show_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Page_Show_Params_Data* data_ = nullptr;
};


class Page_Hide_ParamsDataView {
 public:
  Page_Hide_ParamsDataView() = default;

  Page_Hide_ParamsDataView(
      internal::Page_Hide_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Page_Hide_Params_Data* data_ = nullptr;
};





inline void PageHandler_GetBookmarkBar_ResponseParamsDataView::GetBookmarksDataView(
    mojo::ArrayDataView<BookmarkDataDataView>* output) {
  auto pointer = data_->bookmarks.Get();
  *output = mojo::ArrayDataView<BookmarkDataDataView>(pointer, message_);
}






inline void Page_FavIconChanged_ParamsDataView::GetBookmarkDataDataView(
    BookmarkDataDataView* output) {
  auto pointer = data_->bookmark_data.Get();
  *output = BookmarkDataDataView(pointer, message_);
}







}  // bookmark_bar::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_PARAMS_DATA_H_