// chrome/browser/ui/webui/whats_new/whats_new.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_WHATS_NEW_WHATS_NEW_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_WHATS_NEW_WHATS_NEW_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/whats_new/whats_new.mojom.h"


namespace whats_new::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void GetServerUrl(bool is_staging, GetServerUrlCallback callback) override;
  void RecordTimeToLoadContent(::base::Time time) override;
  void RecordVersionPageLoaded(bool is_auto_open) override;
  void RecordEditionPageLoaded(const std::string& page_uid, bool is_auto_open) override;
  void RecordModuleImpression(const std::string& module_name, ModulePosition position) override;
  void RecordExploreMoreToggled(bool expanded) override;
  void RecordScrollDepth(ScrollDepth depth) override;
  void RecordTimeOnPage(::base::TimeDelta time) override;
  void RecordModuleLinkClicked(const std::string& module_name, ModulePosition position) override;
  void RecordModuleVideoStarted(const std::string& module_name, ModulePosition position) override;
  void RecordModuleVideoEnded(const std::string& module_name, ModulePosition position) override;
  void RecordModulePlayClicked(const std::string& module_name, ModulePosition position) override;
  void RecordModulePauseClicked(const std::string& module_name, ModulePosition position) override;
  void RecordModuleRestartClicked(const std::string& module_name, ModulePosition position) override;
  void RecordBrowserCommandExecuted() override;
  void RecordQrCodeToggled(bool expanded) override;
  void RecordNavClick() override;
  void RecordFeatureTileNavigation() override;
  void RecordCarouselScrollButtonClick() override;
  void RecordExpandMediaToggled(const std::string& module_name, bool expanded) override;
  void RecordCtaClick() override;
  void RecordNextButtonClick() override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void GetServerUrl(
      bool is_staging, ::GURL* out_url);
  ::GURL GetServerUrl(bool is_staging);

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // whats_new::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_WHATS_NEW_WHATS_NEW_MOJOM_TEST_UTILS_H_