// chrome/browser/ui/webui/tab_strip/tab_strip.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-shared-internal.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip::mojom::TabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip::mojom::TabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip::mojom::internal::Tab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->active = Traits::active(input);

    decltype(Traits::alert_states(input)) in_alert_states = Traits::alert_states(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alert_states)::BaseType>
        alert_states_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs::mojom::internal::TabAlertState_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tabs::mojom::TabAlertState>>(
      in_alert_states,
      alert_states_fragment,
      &alert_states_validate_params);

    fragment->alert_states.Set(
        alert_states_fragment.is_null() ? nullptr : alert_states_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alert_states.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_states in Tab struct");

    fragment->blocked = Traits::blocked(input);

    fragment->crashed = Traits::crashed(input);

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

    decltype(Traits::active_favicon_url(input)) in_active_favicon_url = Traits::active_favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->active_favicon_url)::BaseType> active_favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_active_favicon_url,
      active_favicon_url_fragment);

    fragment->active_favicon_url.Set(
        active_favicon_url_fragment.is_null() ? nullptr : active_favicon_url_fragment.data());

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    fragment->id = Traits::id(input);

    fragment->index = Traits::index(input);

    fragment->is_default_favicon = Traits::is_default_favicon(input);

    
    mojo::internal::Serialize<::tabs::mojom::TabNetworkState>(
      Traits::network_state(input),
      &fragment->network_state);

    fragment->pinned = Traits::pinned(input);

    fragment->should_hide_throbber = Traits::should_hide_throbber(input);

    fragment->show_icon = Traits::show_icon(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in Tab struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in Tab struct");
  }

  static bool Deserialize(::tab_strip::mojom::internal::Tab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip::mojom::TabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip::mojom::TabGroupVisualDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip::mojom::TabGroupVisualDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip::mojom::internal::TabGroupVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::color(input)) in_color = Traits::color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color)::BaseType> color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_color,
      color_fragment);

    fragment->color.Set(
        color_fragment.is_null() ? nullptr : color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color in TabGroupVisualData struct");

    decltype(Traits::text_color(input)) in_text_color = Traits::text_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_color)::BaseType> text_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text_color,
      text_color_fragment);

    fragment->text_color.Set(
        text_color_fragment.is_null() ? nullptr : text_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_color in TabGroupVisualData struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabGroupVisualData struct");
  }

  static bool Deserialize(::tab_strip::mojom::internal::TabGroupVisualData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip::mojom::TabGroupVisualDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tab_strip::mojom {

inline void TabDataView::GetAlertStatesDataView(
    mojo::ArrayDataView<::tabs::mojom::TabAlertState>* output) {
  auto pointer = data_->alert_states.Get();
  *output = mojo::ArrayDataView<::tabs::mojom::TabAlertState>(pointer, message_);
}
inline void TabDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabDataView::GetActiveFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->active_favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void TabGroupVisualDataDataView::GetColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->color.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabGroupVisualDataDataView::GetTextColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_color.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabGroupVisualDataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // tab_strip::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_SHARED_H_