// chrome/browser/ui/webui/tab_search/tab_search.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-data-view.h"




namespace std {

template <>
struct hash<::tab_search::mojom::DeclutterCTREvent>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::DeclutterCTREvent> {};

template <>
struct hash<::tab_search::mojom::SelectorCTREvent>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::SelectorCTREvent> {};

template <>
struct hash<::tab_search::mojom::TabDeclutterEntryPoint>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::TabDeclutterEntryPoint> {};

template <>
struct hash<::tab_search::mojom::TabOrganizationState>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::TabOrganizationState> {};

template <>
struct hash<::tab_search::mojom::TabOrganizationFeature>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::TabOrganizationFeature> {};

template <>
struct hash<::tab_search::mojom::TabOrganizationError>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::TabOrganizationError> {};

template <>
struct hash<::tab_search::mojom::TabOrganizationModelStrategy>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::TabOrganizationModelStrategy> {};

template <>
struct hash<::tab_search::mojom::TabSearchSection>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::TabSearchSection> {};

template <>
struct hash<::tab_search::mojom::UserFeedback>
    : public mojo::internal::EnumHashImpl<::tab_search::mojom::UserFeedback> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::DeclutterCTREvent, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::DeclutterCTREvent, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::DeclutterCTREvent>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::SelectorCTREvent, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::SelectorCTREvent, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::SelectorCTREvent>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabDeclutterEntryPoint, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::TabDeclutterEntryPoint, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::TabDeclutterEntryPoint>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabOrganizationState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::TabOrganizationState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::TabOrganizationState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabOrganizationFeature, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::TabOrganizationFeature, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::TabOrganizationFeature>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabOrganizationError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::TabOrganizationError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::TabOrganizationError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabOrganizationModelStrategy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::TabOrganizationModelStrategy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::TabOrganizationModelStrategy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabSearchSection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::TabSearchSection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::TabSearchSection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::UserFeedback, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_search::mojom::UserFeedback, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_search::mojom::UserFeedback>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::ProfileDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::ProfileDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::ProfileData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::windows(input)) in_windows = Traits::windows(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->windows)::BaseType>
        windows_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& windows_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::WindowDataView>>(
      in_windows,
      windows_fragment,
      &windows_validate_params);

    fragment->windows.Set(
        windows_fragment.is_null() ? nullptr : windows_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->windows.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null windows in ProfileData struct");

    decltype(Traits::tab_groups(input)) in_tab_groups = Traits::tab_groups(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_groups)::BaseType>
        tab_groups_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tab_groups_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::TabGroupDataView>>(
      in_tab_groups,
      tab_groups_fragment,
      &tab_groups_validate_params);

    fragment->tab_groups.Set(
        tab_groups_fragment.is_null() ? nullptr : tab_groups_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab_groups.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_groups in ProfileData struct");

    decltype(Traits::recently_closed_tabs(input)) in_recently_closed_tabs = Traits::recently_closed_tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recently_closed_tabs)::BaseType>
        recently_closed_tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& recently_closed_tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::RecentlyClosedTabDataView>>(
      in_recently_closed_tabs,
      recently_closed_tabs_fragment,
      &recently_closed_tabs_validate_params);

    fragment->recently_closed_tabs.Set(
        recently_closed_tabs_fragment.is_null() ? nullptr : recently_closed_tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recently_closed_tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recently_closed_tabs in ProfileData struct");

    decltype(Traits::recently_closed_tab_groups(input)) in_recently_closed_tab_groups = Traits::recently_closed_tab_groups(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recently_closed_tab_groups)::BaseType>
        recently_closed_tab_groups_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& recently_closed_tab_groups_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::RecentlyClosedTabGroupDataView>>(
      in_recently_closed_tab_groups,
      recently_closed_tab_groups_fragment,
      &recently_closed_tab_groups_validate_params);

    fragment->recently_closed_tab_groups.Set(
        recently_closed_tab_groups_fragment.is_null() ? nullptr : recently_closed_tab_groups_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recently_closed_tab_groups.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recently_closed_tab_groups in ProfileData struct");

    fragment->recently_closed_section_expanded = Traits::recently_closed_section_expanded(input);
  }

  static bool Deserialize(::tab_search::mojom::internal::ProfileData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::ProfileDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::WindowDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::WindowDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::Window_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->active = Traits::active(input);

    fragment->is_host_window = Traits::is_host_window(input);

    fragment->height = Traits::height(input);

    decltype(Traits::tabs(input)) in_tabs = Traits::tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tabs)::BaseType>
        tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::TabDataView>>(
      in_tabs,
      tabs_fragment,
      &tabs_validate_params);

    fragment->tabs.Set(
        tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tabs in Window struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::Window_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::WindowDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::TabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::Tab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->active = Traits::active(input);

    fragment->visible = Traits::visible(input);

    decltype(Traits::alert_states(input)) in_alert_states = Traits::alert_states(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alert_states)::BaseType>
        alert_states_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs::mojom::internal::TabAlertState_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tabs::mojom::TabAlertState>>(
      in_alert_states,
      alert_states_fragment,
      &alert_states_validate_params);

    fragment->alert_states.Set(
        alert_states_fragment.is_null() ? nullptr : alert_states_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alert_states.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_states in Tab struct");

    fragment->index = Traits::index(input);

    fragment->tab_id = Traits::tab_id(input);

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    fragment->pinned = Traits::pinned(input);

    fragment->split = Traits::split(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in Tab struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in Tab struct");

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

    fragment->is_default_favicon = Traits::is_default_favicon(input);

    fragment->show_icon = Traits::show_icon(input);

    decltype(Traits::last_active_time_ticks(input)) in_last_active_time_ticks = Traits::last_active_time_ticks(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_active_time_ticks)::BaseType> last_active_time_ticks_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_last_active_time_ticks,
      last_active_time_ticks_fragment);

    fragment->last_active_time_ticks.Set(
        last_active_time_ticks_fragment.is_null() ? nullptr : last_active_time_ticks_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_active_time_ticks.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_active_time_ticks in Tab struct");

    decltype(Traits::last_active_elapsed_text(input)) in_last_active_elapsed_text = Traits::last_active_elapsed_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_active_elapsed_text)::BaseType> last_active_elapsed_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_last_active_elapsed_text,
      last_active_elapsed_text_fragment);

    fragment->last_active_elapsed_text.Set(
        last_active_elapsed_text_fragment.is_null() ? nullptr : last_active_elapsed_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_active_elapsed_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_active_elapsed_text in Tab struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::Tab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::TabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::RecentlyClosedTabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::RecentlyClosedTabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::RecentlyClosedTab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->tab_id = Traits::tab_id(input);

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in RecentlyClosedTab struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RecentlyClosedTab struct");

    decltype(Traits::last_active_time(input)) in_last_active_time = Traits::last_active_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_active_time)::BaseType> last_active_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_active_time,
      last_active_time_fragment);

    fragment->last_active_time.Set(
        last_active_time_fragment.is_null() ? nullptr : last_active_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_active_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_active_time in RecentlyClosedTab struct");

    decltype(Traits::last_active_elapsed_text(input)) in_last_active_elapsed_text = Traits::last_active_elapsed_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_active_elapsed_text)::BaseType> last_active_elapsed_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_last_active_elapsed_text,
      last_active_elapsed_text_fragment);

    fragment->last_active_elapsed_text.Set(
        last_active_elapsed_text_fragment.is_null() ? nullptr : last_active_elapsed_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_active_elapsed_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_active_elapsed_text in RecentlyClosedTab struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::RecentlyClosedTab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::RecentlyClosedTabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::TabGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::TabGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabGroup struct");

    
    mojo::internal::Serialize<::tab_groups::mojom::Color>(
      Traits::color(input),
      &fragment->color);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabGroup struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::TabGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::TabGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::RecentlyClosedTabGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::RecentlyClosedTabGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::RecentlyClosedTabGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->session_id = Traits::session_id(input);

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in RecentlyClosedTabGroup struct");

    
    mojo::internal::Serialize<::tab_groups::mojom::Color>(
      Traits::color(input),
      &fragment->color);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in RecentlyClosedTabGroup struct");

    fragment->tab_count = Traits::tab_count(input);

    decltype(Traits::last_active_time(input)) in_last_active_time = Traits::last_active_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_active_time)::BaseType> last_active_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_active_time,
      last_active_time_fragment);

    fragment->last_active_time.Set(
        last_active_time_fragment.is_null() ? nullptr : last_active_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_active_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_active_time in RecentlyClosedTabGroup struct");

    decltype(Traits::last_active_elapsed_text(input)) in_last_active_elapsed_text = Traits::last_active_elapsed_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_active_elapsed_text)::BaseType> last_active_elapsed_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_last_active_elapsed_text,
      last_active_elapsed_text_fragment);

    fragment->last_active_elapsed_text.Set(
        last_active_elapsed_text_fragment.is_null() ? nullptr : last_active_elapsed_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_active_elapsed_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_active_elapsed_text in RecentlyClosedTabGroup struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::RecentlyClosedTabGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::RecentlyClosedTabGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::SwitchToTabInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::SwitchToTabInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::SwitchToTabInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->tab_id = Traits::tab_id(input);
  }

  static bool Deserialize(::tab_search::mojom::internal::SwitchToTabInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::SwitchToTabInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabOrganizationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::TabOrganizationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::TabOrganization_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->organization_id = Traits::organization_id(input);

    decltype(Traits::tabs(input)) in_tabs = Traits::tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tabs)::BaseType>
        tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::TabDataView>>(
      in_tabs,
      tabs_fragment,
      &tabs_validate_params);

    fragment->tabs.Set(
        tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tabs in TabOrganization struct");

    fragment->first_new_tab_index = Traits::first_new_tab_index(input);

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in TabOrganization struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::TabOrganization_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::TabOrganizationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabOrganizationSessionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::TabOrganizationSessionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::TabOrganizationSession_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->session_id = Traits::session_id(input);

    
    mojo::internal::Serialize<::tab_search::mojom::TabOrganizationState>(
      Traits::state(input),
      &fragment->state);

    decltype(Traits::organizations(input)) in_organizations = Traits::organizations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->organizations)::BaseType>
        organizations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& organizations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::TabOrganizationDataView>>(
      in_organizations,
      organizations_fragment,
      &organizations_validate_params);

    fragment->organizations.Set(
        organizations_fragment.is_null() ? nullptr : organizations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->organizations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null organizations in TabOrganizationSession struct");

    
    mojo::internal::Serialize<::tab_search::mojom::TabOrganizationError>(
      Traits::error(input),
      &fragment->error);

    fragment->active_tab_id = Traits::active_tab_id(input);
  }

  static bool Deserialize(::tab_search::mojom::internal::TabOrganizationSession_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::TabOrganizationSessionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabUpdateInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::TabUpdateInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::TabUpdateInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->in_active_window = Traits::in_active_window(input);

    fragment->in_host_window = Traits::in_host_window(input);

    decltype(Traits::tab(input)) in_tab = Traits::tab(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab)::BaseType> tab_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_search::mojom::TabDataView>(
      in_tab,
      tab_fragment);

    fragment->tab.Set(
        tab_fragment.is_null() ? nullptr : tab_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab in TabUpdateInfo struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::TabUpdateInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::TabUpdateInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::TabsRemovedInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::TabsRemovedInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::TabsRemovedInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tab_ids(input)) in_tab_ids = Traits::tab_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_ids)::BaseType>
        tab_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tab_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_tab_ids,
      tab_ids_fragment,
      &tab_ids_validate_params);

    fragment->tab_ids.Set(
        tab_ids_fragment.is_null() ? nullptr : tab_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_ids in TabsRemovedInfo struct");

    decltype(Traits::recently_closed_tabs(input)) in_recently_closed_tabs = Traits::recently_closed_tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recently_closed_tabs)::BaseType>
        recently_closed_tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& recently_closed_tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::RecentlyClosedTabDataView>>(
      in_recently_closed_tabs,
      recently_closed_tabs_fragment,
      &recently_closed_tabs_validate_params);

    fragment->recently_closed_tabs.Set(
        recently_closed_tabs_fragment.is_null() ? nullptr : recently_closed_tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recently_closed_tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recently_closed_tabs in TabsRemovedInfo struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::TabsRemovedInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::TabsRemovedInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_search::mojom::UnusedTabInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_search::mojom::UnusedTabInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_search::mojom::internal::UnusedTabInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::stale_tabs(input)) in_stale_tabs = Traits::stale_tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stale_tabs)::BaseType>
        stale_tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& stale_tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::TabDataView>>(
      in_stale_tabs,
      stale_tabs_fragment,
      &stale_tabs_validate_params);

    fragment->stale_tabs.Set(
        stale_tabs_fragment.is_null() ? nullptr : stale_tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stale_tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stale_tabs in UnusedTabInfo struct");

    decltype(Traits::duplicate_tabs(input)) in_duplicate_tabs = Traits::duplicate_tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duplicate_tabs)::BaseType>
        duplicate_tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& duplicate_tabs_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<::tab_search::mojom::TabDataView>>>(
      in_duplicate_tabs,
      duplicate_tabs_fragment,
      &duplicate_tabs_validate_params);

    fragment->duplicate_tabs.Set(
        duplicate_tabs_fragment.is_null() ? nullptr : duplicate_tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->duplicate_tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duplicate_tabs in UnusedTabInfo struct");
  }

  static bool Deserialize(::tab_search::mojom::internal::UnusedTabInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_search::mojom::UnusedTabInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tab_search::mojom {

inline void ProfileDataDataView::GetWindowsDataView(
    mojo::ArrayDataView<WindowDataView>* output) {
  auto pointer = data_->windows.Get();
  *output = mojo::ArrayDataView<WindowDataView>(pointer, message_);
}
inline void ProfileDataDataView::GetTabGroupsDataView(
    mojo::ArrayDataView<TabGroupDataView>* output) {
  auto pointer = data_->tab_groups.Get();
  *output = mojo::ArrayDataView<TabGroupDataView>(pointer, message_);
}
inline void ProfileDataDataView::GetRecentlyClosedTabsDataView(
    mojo::ArrayDataView<RecentlyClosedTabDataView>* output) {
  auto pointer = data_->recently_closed_tabs.Get();
  *output = mojo::ArrayDataView<RecentlyClosedTabDataView>(pointer, message_);
}
inline void ProfileDataDataView::GetRecentlyClosedTabGroupsDataView(
    mojo::ArrayDataView<RecentlyClosedTabGroupDataView>* output) {
  auto pointer = data_->recently_closed_tab_groups.Get();
  *output = mojo::ArrayDataView<RecentlyClosedTabGroupDataView>(pointer, message_);
}


inline void WindowDataView::GetTabsDataView(
    mojo::ArrayDataView<TabDataView>* output) {
  auto pointer = data_->tabs.Get();
  *output = mojo::ArrayDataView<TabDataView>(pointer, message_);
}


inline void TabDataView::GetAlertStatesDataView(
    mojo::ArrayDataView<::tabs::mojom::TabAlertState>* output) {
  auto pointer = data_->alert_states.Get();
  *output = mojo::ArrayDataView<::tabs::mojom::TabAlertState>(pointer, message_);
}
inline void TabDataView::GetGroupIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void TabDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabDataView::GetLastActiveTimeTicksDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->last_active_time_ticks.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void TabDataView::GetLastActiveElapsedTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->last_active_elapsed_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void RecentlyClosedTabDataView::GetGroupIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void RecentlyClosedTabDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RecentlyClosedTabDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RecentlyClosedTabDataView::GetLastActiveTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_active_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void RecentlyClosedTabDataView::GetLastActiveElapsedTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->last_active_elapsed_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TabGroupDataView::GetIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void TabGroupDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void RecentlyClosedTabGroupDataView::GetIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void RecentlyClosedTabGroupDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RecentlyClosedTabGroupDataView::GetLastActiveTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_active_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void RecentlyClosedTabGroupDataView::GetLastActiveElapsedTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->last_active_elapsed_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void TabOrganizationDataView::GetTabsDataView(
    mojo::ArrayDataView<TabDataView>* output) {
  auto pointer = data_->tabs.Get();
  *output = mojo::ArrayDataView<TabDataView>(pointer, message_);
}
inline void TabOrganizationDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void TabOrganizationSessionDataView::GetOrganizationsDataView(
    mojo::ArrayDataView<TabOrganizationDataView>* output) {
  auto pointer = data_->organizations.Get();
  *output = mojo::ArrayDataView<TabOrganizationDataView>(pointer, message_);
}


inline void TabUpdateInfoDataView::GetTabDataView(
    TabDataView* output) {
  auto pointer = data_->tab.Get();
  *output = TabDataView(pointer, message_);
}


inline void TabsRemovedInfoDataView::GetTabIdsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->tab_ids.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void TabsRemovedInfoDataView::GetRecentlyClosedTabsDataView(
    mojo::ArrayDataView<RecentlyClosedTabDataView>* output) {
  auto pointer = data_->recently_closed_tabs.Get();
  *output = mojo::ArrayDataView<RecentlyClosedTabDataView>(pointer, message_);
}


inline void UnusedTabInfoDataView::GetStaleTabsDataView(
    mojo::ArrayDataView<TabDataView>* output) {
  auto pointer = data_->stale_tabs.Get();
  *output = mojo::ArrayDataView<TabDataView>(pointer, message_);
}
inline void UnusedTabInfoDataView::GetDuplicateTabsDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<TabDataView>>* output) {
  auto pointer = data_->duplicate_tabs.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<TabDataView>>(pointer, message_);
}



}  // tab_search::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::DeclutterCTREvent> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::DeclutterCTREvent value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::SelectorCTREvent> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::SelectorCTREvent value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::TabDeclutterEntryPoint> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::TabDeclutterEntryPoint value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::TabOrganizationState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::TabOrganizationState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::TabOrganizationFeature> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::TabOrganizationFeature value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::TabOrganizationError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::TabOrganizationError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::TabOrganizationModelStrategy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::TabOrganizationModelStrategy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::TabSearchSection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::TabSearchSection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_search::mojom::UserFeedback> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_search::mojom::UserFeedback value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_SHARED_H_