// chrome/browser/ui/webui/suggest_internals/suggest_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/suggest_internals/suggest_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/suggest_internals/suggest_internals.mojom-params-data.h"
namespace suggest_internals {
namespace mojom {

NOINLINE static const char* RequestStatusToStringHelper(RequestStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestStatus::kHardcoded:
      return "kHardcoded";
    case RequestStatus::kCreated:
      return "kCreated";
    case RequestStatus::kSent:
      return "kSent";
    case RequestStatus::kSucceeded:
      return "kSucceeded";
    case RequestStatus::kFailed:
      return "kFailed";
    default:
      return nullptr;
  }
}

std::string RequestStatusToString(RequestStatus value) {
  const char *str = RequestStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestStatus value) {
  return os << RequestStatusToString(value);
}

namespace internal {


// static
bool Request_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Request_Data* object =
      static_cast<const Request_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }


  if (!::suggest_internals::mojom::internal::RequestStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& response_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->response, validation_context,
                                         &response_validate_params)) {
    return false;
  }

  return true;
}

Request_Data::Request_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPage_Params_Data* object =
      static_cast<const PageHandler_SetPage_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandler_SetPage_Params_Data::PageHandler_SetPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_HardcodeResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_HardcodeResponse_Params_Data* object =
      static_cast<const PageHandler_HardcodeResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& response_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->response, validation_context,
                                         &response_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->delay, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->delay, validation_context))
    return false;

  return true;
}

PageHandler_HardcodeResponse_Params_Data::PageHandler_HardcodeResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_HardcodeResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_HardcodeResponse_ResponseParams_Data* object =
      static_cast<const PageHandler_HardcodeResponse_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

PageHandler_HardcodeResponse_ResponseParams_Data::PageHandler_HardcodeResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnRequestCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnRequestCreated_Params_Data* object =
      static_cast<const Page_OnRequestCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

Page_OnRequestCreated_Params_Data::Page_OnRequestCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnRequestStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnRequestStarted_Params_Data* object =
      static_cast<const Page_OnRequestStarted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

Page_OnRequestStarted_Params_Data::Page_OnRequestStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnRequestCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnRequestCompleted_Params_Data* object =
      static_cast<const Page_OnRequestCompleted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

Page_OnRequestCompleted_Params_Data::Page_OnRequestCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace suggest_internals

namespace perfetto {

// static
void TraceFormatTraits<::suggest_internals::mojom::RequestStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::suggest_internals::mojom::RequestStatus value) {
  return std::move(context).WriteString(::suggest_internals::mojom::RequestStatusToString(value));
}

} // namespace perfetto