// chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIGNIN_SIGNOUT_CONFIRMATION_SIGNOUT_CONFIRMATION_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_SIGNIN_SIGNOUT_CONFIRMATION_SIGNOUT_CONFIRMATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::signout_confirmation::mojom::ExtensionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::signout_confirmation::mojom::ExtensionInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::signout_confirmation::mojom::internal::ExtensionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ExtensionInfo struct");

    decltype(Traits::icon_url(input)) in_icon_url = Traits::icon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon_url)::BaseType> icon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_icon_url,
      icon_url_fragment);

    fragment->icon_url.Set(
        icon_url_fragment.is_null() ? nullptr : icon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_url in ExtensionInfo struct");
  }

  static bool Deserialize(::signout_confirmation::mojom::internal::ExtensionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::signout_confirmation::mojom::ExtensionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::signout_confirmation::mojom::SignoutConfirmationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::signout_confirmation::mojom::SignoutConfirmationDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::signout_confirmation::mojom::internal::SignoutConfirmationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::dialog_title(input)) in_dialog_title = Traits::dialog_title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dialog_title)::BaseType> dialog_title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_dialog_title,
      dialog_title_fragment);

    fragment->dialog_title.Set(
        dialog_title_fragment.is_null() ? nullptr : dialog_title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dialog_title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dialog_title in SignoutConfirmationData struct");

    decltype(Traits::dialog_subtitle(input)) in_dialog_subtitle = Traits::dialog_subtitle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dialog_subtitle)::BaseType> dialog_subtitle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_dialog_subtitle,
      dialog_subtitle_fragment);

    fragment->dialog_subtitle.Set(
        dialog_subtitle_fragment.is_null() ? nullptr : dialog_subtitle_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dialog_subtitle.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dialog_subtitle in SignoutConfirmationData struct");

    decltype(Traits::accept_button_label(input)) in_accept_button_label = Traits::accept_button_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept_button_label)::BaseType> accept_button_label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_accept_button_label,
      accept_button_label_fragment);

    fragment->accept_button_label.Set(
        accept_button_label_fragment.is_null() ? nullptr : accept_button_label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accept_button_label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accept_button_label in SignoutConfirmationData struct");

    decltype(Traits::cancel_button_label(input)) in_cancel_button_label = Traits::cancel_button_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cancel_button_label)::BaseType> cancel_button_label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_cancel_button_label,
      cancel_button_label_fragment);

    fragment->cancel_button_label.Set(
        cancel_button_label_fragment.is_null() ? nullptr : cancel_button_label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cancel_button_label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cancel_button_label in SignoutConfirmationData struct");

    decltype(Traits::account_extensions(input)) in_account_extensions = Traits::account_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->account_extensions)::BaseType>
        account_extensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& account_extensions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::signout_confirmation::mojom::ExtensionInfoDataView>>(
      in_account_extensions,
      account_extensions_fragment,
      &account_extensions_validate_params);

    fragment->account_extensions.Set(
        account_extensions_fragment.is_null() ? nullptr : account_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->account_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null account_extensions in SignoutConfirmationData struct");

    fragment->has_unsynced_data = Traits::has_unsynced_data(input);
  }

  static bool Deserialize(::signout_confirmation::mojom::internal::SignoutConfirmationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::signout_confirmation::mojom::SignoutConfirmationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace signout_confirmation::mojom {

inline void ExtensionInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionInfoDataView::GetIconUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->icon_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SignoutConfirmationDataDataView::GetDialogTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->dialog_title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignoutConfirmationDataDataView::GetDialogSubtitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->dialog_subtitle.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignoutConfirmationDataDataView::GetAcceptButtonLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->accept_button_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignoutConfirmationDataDataView::GetCancelButtonLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cancel_button_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignoutConfirmationDataDataView::GetAccountExtensionsDataView(
    mojo::ArrayDataView<ExtensionInfoDataView>* output) {
  auto pointer = data_->account_extensions.Get();
  *output = mojo::ArrayDataView<ExtensionInfoDataView>(pointer, message_);
}



}  // signout_confirmation::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_SIGNIN_SIGNOUT_CONFIRMATION_SIGNOUT_CONFIRMATION_MOJOM_SHARED_H_