// chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-params-data.h"
#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-import-headers.h"
#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-test-utils.h"


namespace side_panel::mojom {
BackgroundImage::BackgroundImage()
    : url(),
      snapshot_url(),
      is_uploaded_image(),
      local_background_id(),
      title(),
      collection_id(),
      daily_refresh_enabled() {}

BackgroundImage::BackgroundImage(
    const ::GURL& url_in,
    const ::GURL& snapshot_url_in,
    bool is_uploaded_image_in,
    const std::optional<::base::Token>& local_background_id_in,
    const std::string& title_in,
    const std::string& collection_id_in,
    bool daily_refresh_enabled_in)
    : url(std::move(url_in)),
      snapshot_url(std::move(snapshot_url_in)),
      is_uploaded_image(std::move(is_uploaded_image_in)),
      local_background_id(std::move(local_background_id_in)),
      title(std::move(title_in)),
      collection_id(std::move(collection_id_in)),
      daily_refresh_enabled(std::move(daily_refresh_enabled_in)) {}

BackgroundImage::~BackgroundImage() = default;

void BackgroundImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "snapshot_url"), this->snapshot_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_uploaded_image"), this->is_uploaded_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_background_id"), this->local_background_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::Token>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "collection_id"), this->collection_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "daily_refresh_enabled"), this->daily_refresh_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackgroundImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ThirdPartyThemeInfo::ThirdPartyThemeInfo()
    : id(),
      name() {}

ThirdPartyThemeInfo::ThirdPartyThemeInfo(
    const std::string& id_in,
    const std::string& name_in)
    : id(std::move(id_in)),
      name(std::move(name_in)) {}

ThirdPartyThemeInfo::~ThirdPartyThemeInfo() = default;
size_t ThirdPartyThemeInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->name);
  return seed;
}

void ThirdPartyThemeInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ThirdPartyThemeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Theme::Theme()
    : background_image(),
      third_party_theme_info(),
      background_color(),
      foreground_color(),
      background_managed_by_policy(),
      follow_device_theme() {}

Theme::Theme(
    BackgroundImagePtr background_image_in,
    ThirdPartyThemeInfoPtr third_party_theme_info_in,
    ::SkColor background_color_in,
    std::optional<::SkColor> foreground_color_in,
    bool background_managed_by_policy_in,
    bool follow_device_theme_in)
    : background_image(std::move(background_image_in)),
      third_party_theme_info(std::move(third_party_theme_info_in)),
      background_color(std::move(background_color_in)),
      foreground_color(std::move(foreground_color_in)),
      background_managed_by_policy(std::move(background_managed_by_policy_in)),
      follow_device_theme(std::move(follow_device_theme_in)) {}

Theme::~Theme() = default;

void Theme::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image"), this->background_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BackgroundImagePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "third_party_theme_info"), this->third_party_theme_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ThirdPartyThemeInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "foreground_color"), this->foreground_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::SkColor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_managed_by_policy"), this->background_managed_by_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "follow_device_theme"), this->follow_device_theme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Theme::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundCollection::BackgroundCollection()
    : id(),
      label(),
      preview_image_url(),
      image_verified() {}

BackgroundCollection::BackgroundCollection(
    const std::string& id_in,
    const std::string& label_in,
    const ::GURL& preview_image_url_in,
    bool image_verified_in)
    : id(std::move(id_in)),
      label(std::move(label_in)),
      preview_image_url(std::move(preview_image_url_in)),
      image_verified(std::move(image_verified_in)) {}

BackgroundCollection::~BackgroundCollection() = default;

void BackgroundCollection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preview_image_url"), this->preview_image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_verified"), this->image_verified,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackgroundCollection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CollectionImage::CollectionImage()
    : attribution_1(),
      attribution_2(),
      attribution_url(),
      image_url(),
      preview_image_url(),
      collection_id(),
      image_verified() {}

CollectionImage::CollectionImage(
    const std::string& attribution_1_in,
    const std::string& attribution_2_in,
    const ::GURL& attribution_url_in,
    const ::GURL& image_url_in,
    const ::GURL& preview_image_url_in,
    const std::string& collection_id_in,
    bool image_verified_in)
    : attribution_1(std::move(attribution_1_in)),
      attribution_2(std::move(attribution_2_in)),
      attribution_url(std::move(attribution_url_in)),
      image_url(std::move(image_url_in)),
      preview_image_url(std::move(preview_image_url_in)),
      collection_id(std::move(collection_id_in)),
      image_verified(std::move(image_verified_in)) {}

CollectionImage::~CollectionImage() = default;

void CollectionImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_1"), this->attribution_1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_2"), this->attribution_2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_url"), this->attribution_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_url"), this->image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preview_image_url"), this->preview_image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "collection_id"), this->collection_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_verified"), this->image_verified,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CollectionImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ModuleSettings::ModuleSettings()
    : id(),
      name(),
      description(),
      enabled(),
      visible() {}

ModuleSettings::ModuleSettings(
    const std::string& id_in,
    const std::string& name_in,
    const std::optional<std::string>& description_in,
    bool enabled_in,
    bool visible_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      description(std::move(description_in)),
      enabled(std::move(enabled_in)),
      visible(std::move(visible_in)) {}

ModuleSettings::~ModuleSettings() = default;

void ModuleSettings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled"), this->enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible"), this->visible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ModuleSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManagementNoticeState::ManagementNoticeState()
    : can_be_shown(),
      enabled_by_policy() {}

ManagementNoticeState::ManagementNoticeState(
    bool can_be_shown_in,
    bool enabled_by_policy_in)
    : can_be_shown(std::move(can_be_shown_in)),
      enabled_by_policy(std::move(enabled_by_policy_in)) {}

ManagementNoticeState::~ManagementNoticeState() = default;
size_t ManagementNoticeState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->can_be_shown);
  seed = mojo::internal::Hash(seed, this->enabled_by_policy);
  return seed;
}

void ManagementNoticeState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_be_shown"), this->can_be_shown,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_by_policy"), this->enabled_by_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManagementNoticeState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CustomizeChromePageHandlerFactory::IPCStableHashFunction CustomizeChromePageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeChromePageHandlerFactory>(message.name())) {
    case messages::CustomizeChromePageHandlerFactory::kCreatePageHandler: {
      return &CustomizeChromePageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeChromePageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeChromePageHandlerFactory>(message.name())) {
      case messages::CustomizeChromePageHandlerFactory::kCreatePageHandler:
            return "Receive side_panel::mojom::CustomizeChromePageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::CustomizeChromePageHandlerFactory>(message.name())) {
      case messages::CustomizeChromePageHandlerFactory::kCreatePageHandler:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeChromePageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b5c5abf;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CustomizeChromePageHandlerFactoryProxy::CustomizeChromePageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeChromePageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<CustomizeChromePage> in_page, ::mojo::PendingReceiver<CustomizeChromePageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<CustomizeChromePage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<CustomizeChromePageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::side_panel::mojom::CustomizeChromePageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in CustomizeChromePageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::side_panel::mojom::CustomizeChromePageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in CustomizeChromePageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CustomizeChromePageHandlerFactoryStubDispatch::Accept(
    CustomizeChromePageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeChromePageHandlerFactory>(message->header()->name)) {
    case messages::CustomizeChromePageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<CustomizeChromePage> p_page{};
      ::mojo::PendingReceiver<CustomizeChromePageHandler> p_handler{};
      CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool CustomizeChromePageHandlerFactoryStubDispatch::AcceptWithResponder(
    CustomizeChromePageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeChromePageHandlerFactory>(message->header()->name)) {
    case messages::CustomizeChromePageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeChromePageHandlerFactoryValidationInfo[] = {
    { &internal::CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeChromePageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::mojom::CustomizeChromePageHandlerFactory::Name_,
    kCustomizeChromePageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

CustomizeChromePageHandler::IPCStableHashFunction CustomizeChromePageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeChromePageHandler>(message.name())) {
    case messages::CustomizeChromePageHandler::kSetMostVisitedSettings: {
      return &CustomizeChromePageHandler::SetMostVisitedSettings_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateMostVisitedSettings: {
      return &CustomizeChromePageHandler::UpdateMostVisitedSettings_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kGetBackgroundCollections: {
      return &CustomizeChromePageHandler::GetBackgroundCollections_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kGetReplacementCollectionPreviewImage: {
      return &CustomizeChromePageHandler::GetReplacementCollectionPreviewImage_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kGetBackgroundImages: {
      return &CustomizeChromePageHandler::GetBackgroundImages_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateModulesSettings: {
      return &CustomizeChromePageHandler::UpdateModulesSettings_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateTheme: {
      return &CustomizeChromePageHandler::UpdateTheme_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateThemeEditable: {
      return &CustomizeChromePageHandler::UpdateThemeEditable_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kSetDefaultColor: {
      return &CustomizeChromePageHandler::SetDefaultColor_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kSetFollowDeviceTheme: {
      return &CustomizeChromePageHandler::SetFollowDeviceTheme_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kRemoveBackgroundImage: {
      return &CustomizeChromePageHandler::RemoveBackgroundImage_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kChooseLocalCustomBackground: {
      return &CustomizeChromePageHandler::ChooseLocalCustomBackground_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kSetBackgroundImage: {
      return &CustomizeChromePageHandler::SetBackgroundImage_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kSetDailyRefreshCollectionId: {
      return &CustomizeChromePageHandler::SetDailyRefreshCollectionId_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStore: {
      return &CustomizeChromePageHandler::OpenChromeWebStore_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreHomePage: {
      return &CustomizeChromePageHandler::OpenChromeWebStoreHomePage_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kOpenThirdPartyThemePage: {
      return &CustomizeChromePageHandler::OpenThirdPartyThemePage_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCategoryPage: {
      return &CustomizeChromePageHandler::OpenChromeWebStoreCategoryPage_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCollectionPage: {
      return &CustomizeChromePageHandler::OpenChromeWebStoreCollectionPage_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kOpenNtpManagedByPage: {
      return &CustomizeChromePageHandler::OpenNtpManagedByPage_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kSetModulesVisible: {
      return &CustomizeChromePageHandler::SetModulesVisible_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kSetModuleDisabled: {
      return &CustomizeChromePageHandler::SetModuleDisabled_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kSetToolChipsVisible: {
      return &CustomizeChromePageHandler::SetToolChipsVisible_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateToolChipsSettings: {
      return &CustomizeChromePageHandler::UpdateToolChipsSettings_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateScrollToSection: {
      return &CustomizeChromePageHandler::UpdateScrollToSection_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateAttachedTabState: {
      return &CustomizeChromePageHandler::UpdateAttachedTabState_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateNtpManagedByName: {
      return &CustomizeChromePageHandler::UpdateNtpManagedByName_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kSetFooterVisible: {
      return &CustomizeChromePageHandler::SetFooterVisible_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePageHandler::kUpdateFooterSettings: {
      return &CustomizeChromePageHandler::UpdateFooterSettings_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeChromePageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeChromePageHandler>(message.name())) {
      case messages::CustomizeChromePageHandler::kSetMostVisitedSettings:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetMostVisitedSettings";
      case messages::CustomizeChromePageHandler::kUpdateMostVisitedSettings:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateMostVisitedSettings";
      case messages::CustomizeChromePageHandler::kGetBackgroundCollections:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::GetBackgroundCollections";
      case messages::CustomizeChromePageHandler::kGetReplacementCollectionPreviewImage:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::GetReplacementCollectionPreviewImage";
      case messages::CustomizeChromePageHandler::kGetBackgroundImages:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::GetBackgroundImages";
      case messages::CustomizeChromePageHandler::kUpdateModulesSettings:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateModulesSettings";
      case messages::CustomizeChromePageHandler::kUpdateTheme:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateTheme";
      case messages::CustomizeChromePageHandler::kUpdateThemeEditable:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateThemeEditable";
      case messages::CustomizeChromePageHandler::kSetDefaultColor:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetDefaultColor";
      case messages::CustomizeChromePageHandler::kSetFollowDeviceTheme:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetFollowDeviceTheme";
      case messages::CustomizeChromePageHandler::kRemoveBackgroundImage:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::RemoveBackgroundImage";
      case messages::CustomizeChromePageHandler::kChooseLocalCustomBackground:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::ChooseLocalCustomBackground";
      case messages::CustomizeChromePageHandler::kSetBackgroundImage:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetBackgroundImage";
      case messages::CustomizeChromePageHandler::kSetDailyRefreshCollectionId:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetDailyRefreshCollectionId";
      case messages::CustomizeChromePageHandler::kOpenChromeWebStore:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStore";
      case messages::CustomizeChromePageHandler::kOpenChromeWebStoreHomePage:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreHomePage";
      case messages::CustomizeChromePageHandler::kOpenThirdPartyThemePage:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::OpenThirdPartyThemePage";
      case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCategoryPage:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreCategoryPage";
      case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCollectionPage:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreCollectionPage";
      case messages::CustomizeChromePageHandler::kOpenNtpManagedByPage:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::OpenNtpManagedByPage";
      case messages::CustomizeChromePageHandler::kSetModulesVisible:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetModulesVisible";
      case messages::CustomizeChromePageHandler::kSetModuleDisabled:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetModuleDisabled";
      case messages::CustomizeChromePageHandler::kSetToolChipsVisible:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetToolChipsVisible";
      case messages::CustomizeChromePageHandler::kUpdateToolChipsSettings:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateToolChipsSettings";
      case messages::CustomizeChromePageHandler::kUpdateScrollToSection:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateScrollToSection";
      case messages::CustomizeChromePageHandler::kUpdateAttachedTabState:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateAttachedTabState";
      case messages::CustomizeChromePageHandler::kUpdateNtpManagedByName:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateNtpManagedByName";
      case messages::CustomizeChromePageHandler::kSetFooterVisible:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::SetFooterVisible";
      case messages::CustomizeChromePageHandler::kUpdateFooterSettings:
            return "Receive side_panel::mojom::CustomizeChromePageHandler::UpdateFooterSettings";
    }
  } else {
    switch (static_cast<messages::CustomizeChromePageHandler>(message.name())) {
      case messages::CustomizeChromePageHandler::kSetMostVisitedSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetMostVisitedSettings";
      case messages::CustomizeChromePageHandler::kUpdateMostVisitedSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateMostVisitedSettings";
      case messages::CustomizeChromePageHandler::kGetBackgroundCollections:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::GetBackgroundCollections";
      case messages::CustomizeChromePageHandler::kGetReplacementCollectionPreviewImage:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::GetReplacementCollectionPreviewImage";
      case messages::CustomizeChromePageHandler::kGetBackgroundImages:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::GetBackgroundImages";
      case messages::CustomizeChromePageHandler::kUpdateModulesSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateModulesSettings";
      case messages::CustomizeChromePageHandler::kUpdateTheme:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateTheme";
      case messages::CustomizeChromePageHandler::kUpdateThemeEditable:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateThemeEditable";
      case messages::CustomizeChromePageHandler::kSetDefaultColor:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetDefaultColor";
      case messages::CustomizeChromePageHandler::kSetFollowDeviceTheme:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetFollowDeviceTheme";
      case messages::CustomizeChromePageHandler::kRemoveBackgroundImage:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::RemoveBackgroundImage";
      case messages::CustomizeChromePageHandler::kChooseLocalCustomBackground:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::ChooseLocalCustomBackground";
      case messages::CustomizeChromePageHandler::kSetBackgroundImage:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetBackgroundImage";
      case messages::CustomizeChromePageHandler::kSetDailyRefreshCollectionId:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetDailyRefreshCollectionId";
      case messages::CustomizeChromePageHandler::kOpenChromeWebStore:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStore";
      case messages::CustomizeChromePageHandler::kOpenChromeWebStoreHomePage:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreHomePage";
      case messages::CustomizeChromePageHandler::kOpenThirdPartyThemePage:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::OpenThirdPartyThemePage";
      case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCategoryPage:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreCategoryPage";
      case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCollectionPage:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreCollectionPage";
      case messages::CustomizeChromePageHandler::kOpenNtpManagedByPage:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::OpenNtpManagedByPage";
      case messages::CustomizeChromePageHandler::kSetModulesVisible:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetModulesVisible";
      case messages::CustomizeChromePageHandler::kSetModuleDisabled:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetModuleDisabled";
      case messages::CustomizeChromePageHandler::kSetToolChipsVisible:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetToolChipsVisible";
      case messages::CustomizeChromePageHandler::kUpdateToolChipsSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateToolChipsSettings";
      case messages::CustomizeChromePageHandler::kUpdateScrollToSection:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateScrollToSection";
      case messages::CustomizeChromePageHandler::kUpdateAttachedTabState:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateAttachedTabState";
      case messages::CustomizeChromePageHandler::kUpdateNtpManagedByName:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateNtpManagedByName";
      case messages::CustomizeChromePageHandler::kSetFooterVisible:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::SetFooterVisible";
      case messages::CustomizeChromePageHandler::kUpdateFooterSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePageHandler::UpdateFooterSettings";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeChromePageHandler::SetMostVisitedSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb62bc5e4;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetMostVisitedSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateMostVisitedSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95fd62c3;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateMostVisitedSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::GetBackgroundCollections_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb0e0b836;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::GetBackgroundCollections
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::GetReplacementCollectionPreviewImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2ac20d3;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::GetReplacementCollectionPreviewImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::GetBackgroundImages_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f544634;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::GetBackgroundImages
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateModulesSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x32ba334c;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateModulesSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateTheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2e283f8;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateTheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateThemeEditable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2829accc;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateThemeEditable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::SetDefaultColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb178ecf7;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetDefaultColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::SetFollowDeviceTheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x58ebd88b;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetFollowDeviceTheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::RemoveBackgroundImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd6ba7423;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::RemoveBackgroundImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::ChooseLocalCustomBackground_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa29ea584;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::ChooseLocalCustomBackground
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::SetBackgroundImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44f918cc;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetBackgroundImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::SetDailyRefreshCollectionId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xef9a2365;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetDailyRefreshCollectionId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::OpenChromeWebStore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa0f666dc;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::OpenChromeWebStoreHomePage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6177d02c;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreHomePage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::OpenThirdPartyThemePage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a29a8a7;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::OpenThirdPartyThemePage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::OpenChromeWebStoreCategoryPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6bca2fc1;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreCategoryPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::OpenChromeWebStoreCollectionPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13c887c6;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreCollectionPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::OpenNtpManagedByPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeee7705c;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::OpenNtpManagedByPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::SetModulesVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad0f60e0;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetModulesVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::SetModuleDisabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0629fc32;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetModuleDisabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::SetToolChipsVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4af16322;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetToolChipsVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateToolChipsSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf1be9541;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateToolChipsSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateScrollToSection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2aa5950;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateScrollToSection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateAttachedTabState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76ca8da9;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateAttachedTabState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateNtpManagedByName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17e84f9b;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateNtpManagedByName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::SetFooterVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xefcd104e;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::SetFooterVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePageHandler::UpdateFooterSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x68dd575d;  // IPCStableHash for side_panel::mojom::CustomizeChromePageHandler::UpdateFooterSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CustomizeChromePageHandler_GetBackgroundCollections_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomizeChromePageHandler_GetBackgroundCollections_ForwardToCallback(
      CustomizeChromePageHandler::GetBackgroundCollectionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CustomizeChromePageHandler_GetBackgroundCollections_ForwardToCallback(const CustomizeChromePageHandler_GetBackgroundCollections_ForwardToCallback&) = delete;
  CustomizeChromePageHandler_GetBackgroundCollections_ForwardToCallback& operator=(const CustomizeChromePageHandler_GetBackgroundCollections_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CustomizeChromePageHandler::GetBackgroundCollectionsCallback callback_;
};

class CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ForwardToCallback(
      CustomizeChromePageHandler::GetReplacementCollectionPreviewImageCallback callback
      ) : callback_(std::move(callback)) {
  }

  CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ForwardToCallback(const CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ForwardToCallback&) = delete;
  CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ForwardToCallback& operator=(const CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CustomizeChromePageHandler::GetReplacementCollectionPreviewImageCallback callback_;
};

class CustomizeChromePageHandler_GetBackgroundImages_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomizeChromePageHandler_GetBackgroundImages_ForwardToCallback(
      CustomizeChromePageHandler::GetBackgroundImagesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CustomizeChromePageHandler_GetBackgroundImages_ForwardToCallback(const CustomizeChromePageHandler_GetBackgroundImages_ForwardToCallback&) = delete;
  CustomizeChromePageHandler_GetBackgroundImages_ForwardToCallback& operator=(const CustomizeChromePageHandler_GetBackgroundImages_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CustomizeChromePageHandler::GetBackgroundImagesCallback callback_;
};

class CustomizeChromePageHandler_ChooseLocalCustomBackground_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomizeChromePageHandler_ChooseLocalCustomBackground_ForwardToCallback(
      CustomizeChromePageHandler::ChooseLocalCustomBackgroundCallback callback
      ) : callback_(std::move(callback)) {
  }

  CustomizeChromePageHandler_ChooseLocalCustomBackground_ForwardToCallback(const CustomizeChromePageHandler_ChooseLocalCustomBackground_ForwardToCallback&) = delete;
  CustomizeChromePageHandler_ChooseLocalCustomBackground_ForwardToCallback& operator=(const CustomizeChromePageHandler_ChooseLocalCustomBackground_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CustomizeChromePageHandler::ChooseLocalCustomBackgroundCallback callback_;
};

CustomizeChromePageHandlerProxy::CustomizeChromePageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeChromePageHandlerProxy::SetMostVisitedSettings(
    const std::vector<::ntp_tiles::mojom::TileType>& in_shortcuts_types, bool in_shortcuts_visible, bool in_personal_shortcuts_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetMostVisitedSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcuts_types"), in_shortcuts_types,
                        "<value of type const std::vector<::ntp_tiles::mojom::TileType>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcuts_visible"), in_shortcuts_visible,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("personal_shortcuts_visible"), in_personal_shortcuts_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetMostVisitedSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shortcuts_types)::BaseType>
      shortcuts_types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& shortcuts_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::ntp_tiles::mojom::internal::TileType_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ntp_tiles::mojom::TileType>>(
    in_shortcuts_types,
    shortcuts_types_fragment,
    &shortcuts_types_validate_params);

  params->shortcuts_types.Set(
      shortcuts_types_fragment.is_null() ? nullptr : shortcuts_types_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shortcuts_types.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shortcuts_types in CustomizeChromePageHandler.SetMostVisitedSettings request");

  params->shortcuts_visible = in_shortcuts_visible;

  params->personal_shortcuts_visible = in_personal_shortcuts_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetMostVisitedSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::UpdateMostVisitedSettings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateMostVisitedSettings");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateMostVisitedSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateMostVisitedSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::GetBackgroundCollections(
    GetBackgroundCollectionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::GetBackgroundCollections");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kGetBackgroundCollections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_GetBackgroundCollections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("GetBackgroundCollections");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomizeChromePageHandler_GetBackgroundCollections_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CustomizeChromePageHandlerProxy::GetReplacementCollectionPreviewImage(
    const std::string& in_collection_id, GetReplacementCollectionPreviewImageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::GetReplacementCollectionPreviewImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collection_id"), in_collection_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kGetReplacementCollectionPreviewImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->collection_id)::BaseType> collection_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_collection_id,
    collection_id_fragment);

  params->collection_id.Set(
      collection_id_fragment.is_null() ? nullptr : collection_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->collection_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null collection_id in CustomizeChromePageHandler.GetReplacementCollectionPreviewImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("GetReplacementCollectionPreviewImage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CustomizeChromePageHandlerProxy::GetBackgroundImages(
    const std::string& in_collection_id, GetBackgroundImagesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::GetBackgroundImages", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collection_id"), in_collection_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kGetBackgroundImages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_GetBackgroundImages_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->collection_id)::BaseType> collection_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_collection_id,
    collection_id_fragment);

  params->collection_id.Set(
      collection_id_fragment.is_null() ? nullptr : collection_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->collection_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null collection_id in CustomizeChromePageHandler.GetBackgroundImages request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("GetBackgroundImages");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomizeChromePageHandler_GetBackgroundImages_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CustomizeChromePageHandlerProxy::UpdateModulesSettings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateModulesSettings");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateModulesSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateModulesSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateModulesSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::UpdateTheme(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateTheme");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateTheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateTheme_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::UpdateThemeEditable(
    bool in_is_theme_editable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateThemeEditable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_theme_editable"), in_is_theme_editable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateThemeEditable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateThemeEditable_Params_Data> params(
          message);
  params.Allocate();

  params->is_theme_editable = in_is_theme_editable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateThemeEditable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::SetDefaultColor(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetDefaultColor");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetDefaultColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetDefaultColor_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetDefaultColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::SetFollowDeviceTheme(
    bool in_follow) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetFollowDeviceTheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("follow"), in_follow,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetFollowDeviceTheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data> params(
          message);
  params.Allocate();

  params->follow = in_follow;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetFollowDeviceTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::RemoveBackgroundImage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::RemoveBackgroundImage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kRemoveBackgroundImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("RemoveBackgroundImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::ChooseLocalCustomBackground(
    ChooseLocalCustomBackgroundCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::ChooseLocalCustomBackground");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kChooseLocalCustomBackground), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("ChooseLocalCustomBackground");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomizeChromePageHandler_ChooseLocalCustomBackground_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CustomizeChromePageHandlerProxy::SetBackgroundImage(
    const std::string& in_attribution_1, const std::string& in_attribution_2, const ::GURL& in_attribution_url, const ::GURL& in_image_url, const ::GURL& in_thumbnail_url, const std::string& in_collection_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetBackgroundImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attribution_1"), in_attribution_1,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attribution_2"), in_attribution_2,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attribution_url"), in_attribution_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_url"), in_image_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thumbnail_url"), in_thumbnail_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collection_id"), in_collection_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetBackgroundImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetBackgroundImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->attribution_1)::BaseType> attribution_1_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_attribution_1,
    attribution_1_fragment);

  params->attribution_1.Set(
      attribution_1_fragment.is_null() ? nullptr : attribution_1_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attribution_1.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attribution_1 in CustomizeChromePageHandler.SetBackgroundImage request");
  mojo::internal::MessageFragment<
      typename decltype(params->attribution_2)::BaseType> attribution_2_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_attribution_2,
    attribution_2_fragment);

  params->attribution_2.Set(
      attribution_2_fragment.is_null() ? nullptr : attribution_2_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attribution_2.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attribution_2 in CustomizeChromePageHandler.SetBackgroundImage request");
  mojo::internal::MessageFragment<
      typename decltype(params->attribution_url)::BaseType> attribution_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_attribution_url,
    attribution_url_fragment);

  params->attribution_url.Set(
      attribution_url_fragment.is_null() ? nullptr : attribution_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attribution_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attribution_url in CustomizeChromePageHandler.SetBackgroundImage request");
  mojo::internal::MessageFragment<
      typename decltype(params->image_url)::BaseType> image_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_image_url,
    image_url_fragment);

  params->image_url.Set(
      image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_url in CustomizeChromePageHandler.SetBackgroundImage request");
  mojo::internal::MessageFragment<
      typename decltype(params->thumbnail_url)::BaseType> thumbnail_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_thumbnail_url,
    thumbnail_url_fragment);

  params->thumbnail_url.Set(
      thumbnail_url_fragment.is_null() ? nullptr : thumbnail_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->thumbnail_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null thumbnail_url in CustomizeChromePageHandler.SetBackgroundImage request");
  mojo::internal::MessageFragment<
      typename decltype(params->collection_id)::BaseType> collection_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_collection_id,
    collection_id_fragment);

  params->collection_id.Set(
      collection_id_fragment.is_null() ? nullptr : collection_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->collection_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null collection_id in CustomizeChromePageHandler.SetBackgroundImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetBackgroundImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::SetDailyRefreshCollectionId(
    const std::string& in_collection_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetDailyRefreshCollectionId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collection_id"), in_collection_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetDailyRefreshCollectionId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->collection_id)::BaseType> collection_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_collection_id,
    collection_id_fragment);

  params->collection_id.Set(
      collection_id_fragment.is_null() ? nullptr : collection_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->collection_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null collection_id in CustomizeChromePageHandler.SetDailyRefreshCollectionId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetDailyRefreshCollectionId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::OpenChromeWebStore(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStore");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kOpenChromeWebStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_OpenChromeWebStore_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("OpenChromeWebStore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::OpenChromeWebStoreHomePage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreHomePage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kOpenChromeWebStoreHomePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("OpenChromeWebStoreHomePage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::OpenThirdPartyThemePage(
    const std::string& in_theme_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::OpenThirdPartyThemePage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme_id"), in_theme_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kOpenThirdPartyThemePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme_id)::BaseType> theme_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_theme_id,
    theme_id_fragment);

  params->theme_id.Set(
      theme_id_fragment.is_null() ? nullptr : theme_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->theme_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null theme_id in CustomizeChromePageHandler.OpenThirdPartyThemePage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("OpenThirdPartyThemePage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::OpenChromeWebStoreCategoryPage(
    ChromeWebStoreCategory in_category) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreCategoryPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("category"), in_category,
                        "<value of type ChromeWebStoreCategory>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kOpenChromeWebStoreCategoryPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::mojom::ChromeWebStoreCategory>(
    in_category,
    &params->category);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("OpenChromeWebStoreCategoryPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::OpenChromeWebStoreCollectionPage(
    ChromeWebStoreCollection in_collection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::OpenChromeWebStoreCollectionPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collection"), in_collection,
                        "<value of type ChromeWebStoreCollection>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kOpenChromeWebStoreCollectionPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::mojom::ChromeWebStoreCollection>(
    in_collection,
    &params->collection);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("OpenChromeWebStoreCollectionPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::OpenNtpManagedByPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::OpenNtpManagedByPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kOpenNtpManagedByPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("OpenNtpManagedByPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::SetModulesVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetModulesVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetModulesVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetModulesVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetModulesVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::SetModuleDisabled(
    const std::string& in_module_id, bool in_disabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetModuleDisabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_id"), in_module_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disabled"), in_disabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetModuleDisabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetModuleDisabled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_id)::BaseType> module_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_id,
    module_id_fragment);

  params->module_id.Set(
      module_id_fragment.is_null() ? nullptr : module_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_id in CustomizeChromePageHandler.SetModuleDisabled request");

  params->disabled = in_disabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetModuleDisabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::SetToolChipsVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetToolChipsVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetToolChipsVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetToolChipsVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetToolChipsVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::UpdateToolChipsSettings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateToolChipsSettings");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateToolChipsSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateToolChipsSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateToolChipsSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::UpdateScrollToSection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateScrollToSection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateScrollToSection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateScrollToSection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateScrollToSection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::UpdateAttachedTabState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateAttachedTabState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateAttachedTabState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateAttachedTabState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::UpdateNtpManagedByName(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateNtpManagedByName");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateNtpManagedByName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateNtpManagedByName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::SetFooterVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePageHandler::SetFooterVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kSetFooterVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_SetFooterVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("SetFooterVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageHandlerProxy::UpdateFooterSettings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::CustomizeChromePageHandler::UpdateFooterSettings");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kUpdateFooterSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_UpdateFooterSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("UpdateFooterSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CustomizeChromePageHandler_GetBackgroundCollections_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CustomizeChromePageHandler::GetBackgroundCollectionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CustomizeChromePageHandler_GetBackgroundCollections_ProxyToResponder> proxy(
        new CustomizeChromePageHandler_GetBackgroundCollections_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CustomizeChromePageHandler_GetBackgroundCollections_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomizeChromePageHandler_GetBackgroundCollections_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CustomizeChromePageHandler_GetBackgroundCollections_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CustomizeChromePageHandler::GetBackgroundCollectionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<BackgroundCollectionPtr> in_collections);
};

bool CustomizeChromePageHandler_GetBackgroundCollections_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CustomizeChromePageHandler.2
  bool success = true;
  std::vector<BackgroundCollectionPtr> p_collections{};
  CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCollections(&p_collections))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomizeChromePageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_collections));
  }
  return true;
}

void CustomizeChromePageHandler_GetBackgroundCollections_ProxyToResponder::Run(
    std::vector<BackgroundCollectionPtr> in_collections) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::mojom::CustomizeChromePageHandler::GetBackgroundCollections", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collections"), in_collections,
                        "<value of type std::vector<BackgroundCollectionPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kGetBackgroundCollections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->collections)::BaseType>
      collections_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& collections_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::mojom::BackgroundCollectionDataView>>(
    in_collections,
    collections_fragment,
    &collections_validate_params);

  params->collections.Set(
      collections_fragment.is_null() ? nullptr : collections_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->collections.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null collections in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("GetBackgroundCollections");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CustomizeChromePageHandler::GetReplacementCollectionPreviewImageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ProxyToResponder> proxy(
        new CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CustomizeChromePageHandler::GetReplacementCollectionPreviewImageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::GURL>& in_preview_image_url);
};

bool CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CustomizeChromePageHandler.3
  bool success = true;
  std::optional<::GURL> p_preview_image_url{};
  CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPreviewImageUrl(&p_preview_image_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomizeChromePageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_preview_image_url));
  }
  return true;
}

void CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ProxyToResponder::Run(
    const std::optional<::GURL>& in_preview_image_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::mojom::CustomizeChromePageHandler::GetReplacementCollectionPreviewImage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview_image_url"), in_preview_image_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kGetReplacementCollectionPreviewImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->preview_image_url)::BaseType> preview_image_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_preview_image_url,
    preview_image_url_fragment);

  params->preview_image_url.Set(
      preview_image_url_fragment.is_null() ? nullptr : preview_image_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("GetReplacementCollectionPreviewImage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CustomizeChromePageHandler_GetBackgroundImages_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CustomizeChromePageHandler::GetBackgroundImagesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CustomizeChromePageHandler_GetBackgroundImages_ProxyToResponder> proxy(
        new CustomizeChromePageHandler_GetBackgroundImages_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CustomizeChromePageHandler_GetBackgroundImages_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomizeChromePageHandler_GetBackgroundImages_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CustomizeChromePageHandler_GetBackgroundImages_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CustomizeChromePageHandler::GetBackgroundImagesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<CollectionImagePtr> in_images);
};

bool CustomizeChromePageHandler_GetBackgroundImages_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CustomizeChromePageHandler.4
  bool success = true;
  std::vector<CollectionImagePtr> p_images{};
  CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImages(&p_images))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomizeChromePageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_images));
  }
  return true;
}

void CustomizeChromePageHandler_GetBackgroundImages_ProxyToResponder::Run(
    std::vector<CollectionImagePtr> in_images) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::mojom::CustomizeChromePageHandler::GetBackgroundImages", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("images"), in_images,
                        "<value of type std::vector<CollectionImagePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kGetBackgroundImages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->images)::BaseType>
      images_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::mojom::CollectionImageDataView>>(
    in_images,
    images_fragment,
    &images_validate_params);

  params->images.Set(
      images_fragment.is_null() ? nullptr : images_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->images.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null images in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("GetBackgroundImages");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CustomizeChromePageHandler_ChooseLocalCustomBackground_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CustomizeChromePageHandler::ChooseLocalCustomBackgroundCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CustomizeChromePageHandler_ChooseLocalCustomBackground_ProxyToResponder> proxy(
        new CustomizeChromePageHandler_ChooseLocalCustomBackground_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CustomizeChromePageHandler_ChooseLocalCustomBackground_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomizeChromePageHandler_ChooseLocalCustomBackground_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CustomizeChromePageHandler_ChooseLocalCustomBackground_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CustomizeChromePageHandler::ChooseLocalCustomBackgroundCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool CustomizeChromePageHandler_ChooseLocalCustomBackground_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CustomizeChromePageHandler.11
  bool success = true;
  bool p_success{};
  CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomizeChromePageHandler::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void CustomizeChromePageHandler_ChooseLocalCustomBackground_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::mojom::CustomizeChromePageHandler::ChooseLocalCustomBackground", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePageHandler::kChooseLocalCustomBackground), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePageHandler::Name_);
  message.set_method_name("ChooseLocalCustomBackground");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CustomizeChromePageHandlerStubDispatch::Accept(
    CustomizeChromePageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeChromePageHandler>(message->header()->name)) {
    case messages::CustomizeChromePageHandler::kSetMostVisitedSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.0
      bool success = true;
      std::vector<::ntp_tiles::mojom::TileType> p_shortcuts_types{};
      bool p_shortcuts_visible{};
      bool p_personal_shortcuts_visible{};
      CustomizeChromePageHandler_SetMostVisitedSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadShortcutsTypes(&p_shortcuts_types))
        success = false;
      if (success)
        p_shortcuts_visible = input_data_view.shortcuts_visible();
      if (success)
        p_personal_shortcuts_visible = input_data_view.personal_shortcuts_visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMostVisitedSettings(        
        std::move(p_shortcuts_types), 
        std::move(p_shortcuts_visible), 
        std::move(p_personal_shortcuts_visible));
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateMostVisitedSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.1
      bool success = true;
      CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateMostVisitedSettings(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kGetBackgroundCollections: {
      break;
    }
    case messages::CustomizeChromePageHandler::kGetReplacementCollectionPreviewImage: {
      break;
    }
    case messages::CustomizeChromePageHandler::kGetBackgroundImages: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateModulesSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateModulesSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateModulesSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.5
      bool success = true;
      CustomizeChromePageHandler_UpdateModulesSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateModulesSettings(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateTheme: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateTheme_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateTheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.6
      bool success = true;
      CustomizeChromePageHandler_UpdateTheme_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTheme(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateThemeEditable: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateThemeEditable_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateThemeEditable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.7
      bool success = true;
      bool p_is_theme_editable{};
      CustomizeChromePageHandler_UpdateThemeEditable_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_theme_editable = input_data_view.is_theme_editable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateThemeEditable(        
        std::move(p_is_theme_editable));
      return true;
    }
    case messages::CustomizeChromePageHandler::kSetDefaultColor: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetDefaultColor_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetDefaultColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.8
      bool success = true;
      CustomizeChromePageHandler_SetDefaultColor_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDefaultColor(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kSetFollowDeviceTheme: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.9
      bool success = true;
      bool p_follow{};
      CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_follow = input_data_view.follow();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFollowDeviceTheme(        
        std::move(p_follow));
      return true;
    }
    case messages::CustomizeChromePageHandler::kRemoveBackgroundImage: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.10
      bool success = true;
      CustomizeChromePageHandler_RemoveBackgroundImage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveBackgroundImage(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kChooseLocalCustomBackground: {
      break;
    }
    case messages::CustomizeChromePageHandler::kSetBackgroundImage: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetBackgroundImage_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetBackgroundImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.12
      bool success = true;
      std::string p_attribution_1{};
      std::string p_attribution_2{};
      ::GURL p_attribution_url{};
      ::GURL p_image_url{};
      ::GURL p_thumbnail_url{};
      std::string p_collection_id{};
      CustomizeChromePageHandler_SetBackgroundImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAttribution1(&p_attribution_1))
        success = false;
      if (success && !input_data_view.ReadAttribution2(&p_attribution_2))
        success = false;
      if (success && !input_data_view.ReadAttributionUrl(&p_attribution_url))
        success = false;
      if (success && !input_data_view.ReadImageUrl(&p_image_url))
        success = false;
      if (success && !input_data_view.ReadThumbnailUrl(&p_thumbnail_url))
        success = false;
      if (success && !input_data_view.ReadCollectionId(&p_collection_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundImage(        
        std::move(p_attribution_1), 
        std::move(p_attribution_2), 
        std::move(p_attribution_url), 
        std::move(p_image_url), 
        std::move(p_thumbnail_url), 
        std::move(p_collection_id));
      return true;
    }
    case messages::CustomizeChromePageHandler::kSetDailyRefreshCollectionId: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.13
      bool success = true;
      std::string p_collection_id{};
      CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCollectionId(&p_collection_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDailyRefreshCollectionId(        
        std::move(p_collection_id));
      return true;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStore: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_OpenChromeWebStore_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_OpenChromeWebStore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.14
      bool success = true;
      CustomizeChromePageHandler_OpenChromeWebStore_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChromeWebStore(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreHomePage: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.15
      bool success = true;
      CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChromeWebStoreHomePage(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kOpenThirdPartyThemePage: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.16
      bool success = true;
      std::string p_theme_id{};
      CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThemeId(&p_theme_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenThirdPartyThemePage(        
        std::move(p_theme_id));
      return true;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCategoryPage: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.17
      bool success = true;
      ChromeWebStoreCategory p_category{};
      CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCategory(&p_category))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChromeWebStoreCategoryPage(        
        std::move(p_category));
      return true;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCollectionPage: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.18
      bool success = true;
      ChromeWebStoreCollection p_collection{};
      CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCollection(&p_collection))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChromeWebStoreCollectionPage(        
        std::move(p_collection));
      return true;
    }
    case messages::CustomizeChromePageHandler::kOpenNtpManagedByPage: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.19
      bool success = true;
      CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenNtpManagedByPage(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kSetModulesVisible: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetModulesVisible_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetModulesVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.20
      bool success = true;
      bool p_visible{};
      CustomizeChromePageHandler_SetModulesVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModulesVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::CustomizeChromePageHandler::kSetModuleDisabled: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetModuleDisabled_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetModuleDisabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.21
      bool success = true;
      std::string p_module_id{};
      bool p_disabled{};
      CustomizeChromePageHandler_SetModuleDisabled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleId(&p_module_id))
        success = false;
      if (success)
        p_disabled = input_data_view.disabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModuleDisabled(        
        std::move(p_module_id), 
        std::move(p_disabled));
      return true;
    }
    case messages::CustomizeChromePageHandler::kSetToolChipsVisible: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetToolChipsVisible_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetToolChipsVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.22
      bool success = true;
      bool p_visible{};
      CustomizeChromePageHandler_SetToolChipsVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetToolChipsVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateToolChipsSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateToolChipsSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateToolChipsSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.23
      bool success = true;
      CustomizeChromePageHandler_UpdateToolChipsSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateToolChipsSettings(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateScrollToSection: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateScrollToSection_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateScrollToSection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.24
      bool success = true;
      CustomizeChromePageHandler_UpdateScrollToSection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateScrollToSection(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateAttachedTabState: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.25
      bool success = true;
      CustomizeChromePageHandler_UpdateAttachedTabState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAttachedTabState(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateNtpManagedByName: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.26
      bool success = true;
      CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateNtpManagedByName(        );
      return true;
    }
    case messages::CustomizeChromePageHandler::kSetFooterVisible: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_SetFooterVisible_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_SetFooterVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.27
      bool success = true;
      bool p_visible{};
      CustomizeChromePageHandler_SetFooterVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFooterVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateFooterSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePageHandler_UpdateFooterSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePageHandler_UpdateFooterSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.28
      bool success = true;
      CustomizeChromePageHandler_UpdateFooterSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateFooterSettings(        );
      return true;
    }
  }
  return false;
}

// static
bool CustomizeChromePageHandlerStubDispatch::AcceptWithResponder(
    CustomizeChromePageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeChromePageHandler>(message->header()->name)) {
    case messages::CustomizeChromePageHandler::kSetMostVisitedSettings: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateMostVisitedSettings: {
      break;
    }
    case messages::CustomizeChromePageHandler::kGetBackgroundCollections: {
      internal::CustomizeChromePageHandler_GetBackgroundCollections_Params_Data* params =
          reinterpret_cast<
              internal::CustomizeChromePageHandler_GetBackgroundCollections_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.2
      bool success = true;
      CustomizeChromePageHandler_GetBackgroundCollections_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          CustomizeChromePageHandler_GetBackgroundCollections_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBackgroundCollections(std::move(callback));
      return true;
    }
    case messages::CustomizeChromePageHandler::kGetReplacementCollectionPreviewImage: {
      internal::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data* params =
          reinterpret_cast<
              internal::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.3
      bool success = true;
      std::string p_collection_id{};
      CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCollectionId(&p_collection_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetReplacementCollectionPreviewImage(        
        std::move(p_collection_id), std::move(callback));
      return true;
    }
    case messages::CustomizeChromePageHandler::kGetBackgroundImages: {
      internal::CustomizeChromePageHandler_GetBackgroundImages_Params_Data* params =
          reinterpret_cast<
              internal::CustomizeChromePageHandler_GetBackgroundImages_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.4
      bool success = true;
      std::string p_collection_id{};
      CustomizeChromePageHandler_GetBackgroundImages_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCollectionId(&p_collection_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          CustomizeChromePageHandler_GetBackgroundImages_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBackgroundImages(        
        std::move(p_collection_id), std::move(callback));
      return true;
    }
    case messages::CustomizeChromePageHandler::kUpdateModulesSettings: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateTheme: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateThemeEditable: {
      break;
    }
    case messages::CustomizeChromePageHandler::kSetDefaultColor: {
      break;
    }
    case messages::CustomizeChromePageHandler::kSetFollowDeviceTheme: {
      break;
    }
    case messages::CustomizeChromePageHandler::kRemoveBackgroundImage: {
      break;
    }
    case messages::CustomizeChromePageHandler::kChooseLocalCustomBackground: {
      internal::CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data* params =
          reinterpret_cast<
              internal::CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CustomizeChromePageHandler.11
      bool success = true;
      CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePageHandler::Name_, 11, false);
        return false;
      }
      auto callback =
          CustomizeChromePageHandler_ChooseLocalCustomBackground_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChooseLocalCustomBackground(std::move(callback));
      return true;
    }
    case messages::CustomizeChromePageHandler::kSetBackgroundImage: {
      break;
    }
    case messages::CustomizeChromePageHandler::kSetDailyRefreshCollectionId: {
      break;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStore: {
      break;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreHomePage: {
      break;
    }
    case messages::CustomizeChromePageHandler::kOpenThirdPartyThemePage: {
      break;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCategoryPage: {
      break;
    }
    case messages::CustomizeChromePageHandler::kOpenChromeWebStoreCollectionPage: {
      break;
    }
    case messages::CustomizeChromePageHandler::kOpenNtpManagedByPage: {
      break;
    }
    case messages::CustomizeChromePageHandler::kSetModulesVisible: {
      break;
    }
    case messages::CustomizeChromePageHandler::kSetModuleDisabled: {
      break;
    }
    case messages::CustomizeChromePageHandler::kSetToolChipsVisible: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateToolChipsSettings: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateScrollToSection: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateAttachedTabState: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateNtpManagedByName: {
      break;
    }
    case messages::CustomizeChromePageHandler::kSetFooterVisible: {
      break;
    }
    case messages::CustomizeChromePageHandler::kUpdateFooterSettings: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeChromePageHandlerValidationInfo[] = {
    { &internal::CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_GetBackgroundCollections_Params_Data::Validate,
     &internal::CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data::Validate},
    { &internal::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data::Validate,
     &internal::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data::Validate},
    { &internal::CustomizeChromePageHandler_GetBackgroundImages_Params_Data::Validate,
     &internal::CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data::Validate},
    { &internal::CustomizeChromePageHandler_UpdateModulesSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_UpdateTheme_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_UpdateThemeEditable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_SetDefaultColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data::Validate,
     &internal::CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data::Validate},
    { &internal::CustomizeChromePageHandler_SetBackgroundImage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_OpenChromeWebStore_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_SetModulesVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_SetModuleDisabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_SetToolChipsVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_UpdateToolChipsSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_UpdateScrollToSection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_SetFooterVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePageHandler_UpdateFooterSettings_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeChromePageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::mojom::CustomizeChromePageHandler::Name_,
    kCustomizeChromePageHandlerValidationInfo);
}

bool CustomizeChromePageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::side_panel::mojom::CustomizeChromePageHandler::Name_,
    kCustomizeChromePageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

CustomizeChromePage::IPCStableHashFunction CustomizeChromePage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeChromePage>(message.name())) {
    case messages::CustomizeChromePage::kSetModulesSettings: {
      return &CustomizeChromePage::SetModulesSettings_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePage::kSetMostVisitedSettings: {
      return &CustomizeChromePage::SetMostVisitedSettings_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePage::kSetToolsSettings: {
      return &CustomizeChromePage::SetToolsSettings_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePage::kSetFooterSettings: {
      return &CustomizeChromePage::SetFooterSettings_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePage::kSetTheme: {
      return &CustomizeChromePage::SetTheme_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePage::kSetThemeEditable: {
      return &CustomizeChromePage::SetThemeEditable_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePage::kScrollToSection: {
      return &CustomizeChromePage::ScrollToSection_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePage::kAttachedTabStateUpdated: {
      return &CustomizeChromePage::AttachedTabStateUpdated_Sym::IPCStableHash;
    }
    case messages::CustomizeChromePage::kNtpManagedByNameUpdated: {
      return &CustomizeChromePage::NtpManagedByNameUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeChromePage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeChromePage>(message.name())) {
      case messages::CustomizeChromePage::kSetModulesSettings:
            return "Receive side_panel::mojom::CustomizeChromePage::SetModulesSettings";
      case messages::CustomizeChromePage::kSetMostVisitedSettings:
            return "Receive side_panel::mojom::CustomizeChromePage::SetMostVisitedSettings";
      case messages::CustomizeChromePage::kSetToolsSettings:
            return "Receive side_panel::mojom::CustomizeChromePage::SetToolsSettings";
      case messages::CustomizeChromePage::kSetFooterSettings:
            return "Receive side_panel::mojom::CustomizeChromePage::SetFooterSettings";
      case messages::CustomizeChromePage::kSetTheme:
            return "Receive side_panel::mojom::CustomizeChromePage::SetTheme";
      case messages::CustomizeChromePage::kSetThemeEditable:
            return "Receive side_panel::mojom::CustomizeChromePage::SetThemeEditable";
      case messages::CustomizeChromePage::kScrollToSection:
            return "Receive side_panel::mojom::CustomizeChromePage::ScrollToSection";
      case messages::CustomizeChromePage::kAttachedTabStateUpdated:
            return "Receive side_panel::mojom::CustomizeChromePage::AttachedTabStateUpdated";
      case messages::CustomizeChromePage::kNtpManagedByNameUpdated:
            return "Receive side_panel::mojom::CustomizeChromePage::NtpManagedByNameUpdated";
    }
  } else {
    switch (static_cast<messages::CustomizeChromePage>(message.name())) {
      case messages::CustomizeChromePage::kSetModulesSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePage::SetModulesSettings";
      case messages::CustomizeChromePage::kSetMostVisitedSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePage::SetMostVisitedSettings";
      case messages::CustomizeChromePage::kSetToolsSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePage::SetToolsSettings";
      case messages::CustomizeChromePage::kSetFooterSettings:
            return "Receive reply side_panel::mojom::CustomizeChromePage::SetFooterSettings";
      case messages::CustomizeChromePage::kSetTheme:
            return "Receive reply side_panel::mojom::CustomizeChromePage::SetTheme";
      case messages::CustomizeChromePage::kSetThemeEditable:
            return "Receive reply side_panel::mojom::CustomizeChromePage::SetThemeEditable";
      case messages::CustomizeChromePage::kScrollToSection:
            return "Receive reply side_panel::mojom::CustomizeChromePage::ScrollToSection";
      case messages::CustomizeChromePage::kAttachedTabStateUpdated:
            return "Receive reply side_panel::mojom::CustomizeChromePage::AttachedTabStateUpdated";
      case messages::CustomizeChromePage::kNtpManagedByNameUpdated:
            return "Receive reply side_panel::mojom::CustomizeChromePage::NtpManagedByNameUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeChromePage::SetModulesSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x234b77b5;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::SetModulesSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePage::SetMostVisitedSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1bba722b;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::SetMostVisitedSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePage::SetToolsSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49e7ac09;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::SetToolsSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePage::SetFooterSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf6f2f0a;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::SetFooterSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePage::SetTheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1941be48;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::SetTheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePage::SetThemeEditable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0cfc0270;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::SetThemeEditable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePage::ScrollToSection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa08fd6b7;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::ScrollToSection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePage::AttachedTabStateUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaad3045e;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::AttachedTabStateUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeChromePage::NtpManagedByNameUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8744838;  // IPCStableHash for side_panel::mojom::CustomizeChromePage::NtpManagedByNameUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CustomizeChromePageProxy::CustomizeChromePageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeChromePageProxy::SetModulesSettings(
    std::vector<ModuleSettingsPtr> in_modules_settings, bool in_managed, bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::SetModulesSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modules_settings"), in_modules_settings,
                        "<value of type std::vector<ModuleSettingsPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("managed"), in_managed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kSetModulesSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_SetModulesSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->modules_settings)::BaseType>
      modules_settings_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& modules_settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::mojom::ModuleSettingsDataView>>(
    in_modules_settings,
    modules_settings_fragment,
    &modules_settings_validate_params);

  params->modules_settings.Set(
      modules_settings_fragment.is_null() ? nullptr : modules_settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->modules_settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null modules_settings in CustomizeChromePage.SetModulesSettings request");

  params->managed = in_managed;

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("SetModulesSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageProxy::SetMostVisitedSettings(
    const std::vector<::ntp_tiles::mojom::TileType>& in_shortcuts_types, bool in_visible, bool in_personal_shortcuts_visible, const std::vector<::ntp_tiles::mojom::TileType>& in_disabled_shortcuts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::SetMostVisitedSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcuts_types"), in_shortcuts_types,
                        "<value of type const std::vector<::ntp_tiles::mojom::TileType>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("personal_shortcuts_visible"), in_personal_shortcuts_visible,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disabled_shortcuts"), in_disabled_shortcuts,
                        "<value of type const std::vector<::ntp_tiles::mojom::TileType>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kSetMostVisitedSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_SetMostVisitedSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shortcuts_types)::BaseType>
      shortcuts_types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& shortcuts_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::ntp_tiles::mojom::internal::TileType_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ntp_tiles::mojom::TileType>>(
    in_shortcuts_types,
    shortcuts_types_fragment,
    &shortcuts_types_validate_params);

  params->shortcuts_types.Set(
      shortcuts_types_fragment.is_null() ? nullptr : shortcuts_types_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shortcuts_types.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shortcuts_types in CustomizeChromePage.SetMostVisitedSettings request");

  params->visible = in_visible;

  params->personal_shortcuts_visible = in_personal_shortcuts_visible;
  mojo::internal::MessageFragment<
      typename decltype(params->disabled_shortcuts)::BaseType>
      disabled_shortcuts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& disabled_shortcuts_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::ntp_tiles::mojom::internal::TileType_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ntp_tiles::mojom::TileType>>(
    in_disabled_shortcuts,
    disabled_shortcuts_fragment,
    &disabled_shortcuts_validate_params);

  params->disabled_shortcuts.Set(
      disabled_shortcuts_fragment.is_null() ? nullptr : disabled_shortcuts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->disabled_shortcuts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null disabled_shortcuts in CustomizeChromePage.SetMostVisitedSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("SetMostVisitedSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageProxy::SetToolsSettings(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::SetToolsSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kSetToolsSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_SetToolsSettings_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("SetToolsSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageProxy::SetFooterSettings(
    bool in_visible, bool in_extension_policy_enabled, ManagementNoticeStatePtr in_management_notice_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::SetFooterSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_policy_enabled"), in_extension_policy_enabled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("management_notice_state"), in_management_notice_state,
                        "<value of type ManagementNoticeStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kSetFooterSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_SetFooterSettings_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

  params->extension_policy_enabled = in_extension_policy_enabled;
  mojo::internal::MessageFragment<
      typename decltype(params->management_notice_state)::BaseType> management_notice_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::side_panel::mojom::ManagementNoticeStateDataView>(
    in_management_notice_state,
    management_notice_state_fragment);

  params->management_notice_state.Set(
      management_notice_state_fragment.is_null() ? nullptr : management_notice_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->management_notice_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null management_notice_state in CustomizeChromePage.SetFooterSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("SetFooterSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageProxy::SetTheme(
    ThemePtr in_theme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::SetTheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme"), in_theme,
                        "<value of type ThemePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kSetTheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_SetTheme_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme)::BaseType> theme_fragment(
          params.message());
  
  mojo::internal::Serialize<::side_panel::mojom::ThemeDataView>(
    in_theme,
    theme_fragment);

  params->theme.Set(
      theme_fragment.is_null() ? nullptr : theme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->theme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null theme in CustomizeChromePage.SetTheme request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("SetTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageProxy::SetThemeEditable(
    bool in_is_theme_editable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::SetThemeEditable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_theme_editable"), in_is_theme_editable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kSetThemeEditable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_SetThemeEditable_Params_Data> params(
          message);
  params.Allocate();

  params->is_theme_editable = in_is_theme_editable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("SetThemeEditable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageProxy::ScrollToSection(
    ::CustomizeChromeSection in_section) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::ScrollToSection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("section"), in_section,
                        "<value of type ::CustomizeChromeSection>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kScrollToSection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_ScrollToSection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::mojom::CustomizeChromeSection>(
    in_section,
    &params->section);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("ScrollToSection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageProxy::AttachedTabStateUpdated(
    NewTabPageType in_ntp_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::AttachedTabStateUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ntp_type"), in_ntp_type,
                        "<value of type NewTabPageType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kAttachedTabStateUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_AttachedTabStateUpdated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::mojom::NewTabPageType>(
    in_ntp_type,
    &params->ntp_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("AttachedTabStateUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeChromePageProxy::NtpManagedByNameUpdated(
    const std::string& in_name, const std::string& in_description) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::CustomizeChromePage::NtpManagedByNameUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description"), in_description,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeChromePage::kNtpManagedByNameUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::CustomizeChromePage_NtpManagedByNameUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in CustomizeChromePage.NtpManagedByNameUpdated request");
  mojo::internal::MessageFragment<
      typename decltype(params->description)::BaseType> description_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_description,
    description_fragment);

  params->description.Set(
      description_fragment.is_null() ? nullptr : description_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->description.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null description in CustomizeChromePage.NtpManagedByNameUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeChromePage::Name_);
  message.set_method_name("NtpManagedByNameUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CustomizeChromePageStubDispatch::Accept(
    CustomizeChromePage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeChromePage>(message->header()->name)) {
    case messages::CustomizeChromePage::kSetModulesSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_SetModulesSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_SetModulesSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.0
      bool success = true;
      std::vector<ModuleSettingsPtr> p_modules_settings{};
      bool p_managed{};
      bool p_visible{};
      CustomizeChromePage_SetModulesSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModulesSettings(&p_modules_settings))
        success = false;
      if (success)
        p_managed = input_data_view.managed();
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModulesSettings(        
        std::move(p_modules_settings), 
        std::move(p_managed), 
        std::move(p_visible));
      return true;
    }
    case messages::CustomizeChromePage::kSetMostVisitedSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_SetMostVisitedSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_SetMostVisitedSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.1
      bool success = true;
      std::vector<::ntp_tiles::mojom::TileType> p_shortcuts_types{};
      bool p_visible{};
      bool p_personal_shortcuts_visible{};
      std::vector<::ntp_tiles::mojom::TileType> p_disabled_shortcuts{};
      CustomizeChromePage_SetMostVisitedSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadShortcutsTypes(&p_shortcuts_types))
        success = false;
      if (success)
        p_visible = input_data_view.visible();
      if (success)
        p_personal_shortcuts_visible = input_data_view.personal_shortcuts_visible();
      if (success && !input_data_view.ReadDisabledShortcuts(&p_disabled_shortcuts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMostVisitedSettings(        
        std::move(p_shortcuts_types), 
        std::move(p_visible), 
        std::move(p_personal_shortcuts_visible), 
        std::move(p_disabled_shortcuts));
      return true;
    }
    case messages::CustomizeChromePage::kSetToolsSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_SetToolsSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_SetToolsSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.2
      bool success = true;
      bool p_visible{};
      CustomizeChromePage_SetToolsSettings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetToolsSettings(        
        std::move(p_visible));
      return true;
    }
    case messages::CustomizeChromePage::kSetFooterSettings: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_SetFooterSettings_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_SetFooterSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.3
      bool success = true;
      bool p_visible{};
      bool p_extension_policy_enabled{};
      ManagementNoticeStatePtr p_management_notice_state{};
      CustomizeChromePage_SetFooterSettings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (success)
        p_extension_policy_enabled = input_data_view.extension_policy_enabled();
      if (success && !input_data_view.ReadManagementNoticeState(&p_management_notice_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFooterSettings(        
        std::move(p_visible), 
        std::move(p_extension_policy_enabled), 
        std::move(p_management_notice_state));
      return true;
    }
    case messages::CustomizeChromePage::kSetTheme: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_SetTheme_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_SetTheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.4
      bool success = true;
      ThemePtr p_theme{};
      CustomizeChromePage_SetTheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTheme(&p_theme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTheme(        
        std::move(p_theme));
      return true;
    }
    case messages::CustomizeChromePage::kSetThemeEditable: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_SetThemeEditable_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_SetThemeEditable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.5
      bool success = true;
      bool p_is_theme_editable{};
      CustomizeChromePage_SetThemeEditable_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_theme_editable = input_data_view.is_theme_editable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetThemeEditable(        
        std::move(p_is_theme_editable));
      return true;
    }
    case messages::CustomizeChromePage::kScrollToSection: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_ScrollToSection_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_ScrollToSection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.6
      bool success = true;
      ::CustomizeChromeSection p_section{};
      CustomizeChromePage_ScrollToSection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSection(&p_section))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollToSection(        
        std::move(p_section));
      return true;
    }
    case messages::CustomizeChromePage::kAttachedTabStateUpdated: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_AttachedTabStateUpdated_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_AttachedTabStateUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.7
      bool success = true;
      NewTabPageType p_ntp_type{};
      CustomizeChromePage_AttachedTabStateUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNtpType(&p_ntp_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachedTabStateUpdated(        
        std::move(p_ntp_type));
      return true;
    }
    case messages::CustomizeChromePage::kNtpManagedByNameUpdated: {
      DCHECK(message->is_serialized());
      internal::CustomizeChromePage_NtpManagedByNameUpdated_Params_Data* params =
          reinterpret_cast<internal::CustomizeChromePage_NtpManagedByNameUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeChromePage.8
      bool success = true;
      std::string p_name{};
      std::string p_description{};
      CustomizeChromePage_NtpManagedByNameUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeChromePage::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NtpManagedByNameUpdated(        
        std::move(p_name), 
        std::move(p_description));
      return true;
    }
  }
  return false;
}

// static
bool CustomizeChromePageStubDispatch::AcceptWithResponder(
    CustomizeChromePage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeChromePage>(message->header()->name)) {
    case messages::CustomizeChromePage::kSetModulesSettings: {
      break;
    }
    case messages::CustomizeChromePage::kSetMostVisitedSettings: {
      break;
    }
    case messages::CustomizeChromePage::kSetToolsSettings: {
      break;
    }
    case messages::CustomizeChromePage::kSetFooterSettings: {
      break;
    }
    case messages::CustomizeChromePage::kSetTheme: {
      break;
    }
    case messages::CustomizeChromePage::kSetThemeEditable: {
      break;
    }
    case messages::CustomizeChromePage::kScrollToSection: {
      break;
    }
    case messages::CustomizeChromePage::kAttachedTabStateUpdated: {
      break;
    }
    case messages::CustomizeChromePage::kNtpManagedByNameUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeChromePageValidationInfo[] = {
    { &internal::CustomizeChromePage_SetModulesSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePage_SetMostVisitedSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePage_SetToolsSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePage_SetFooterSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePage_SetTheme_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePage_SetThemeEditable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePage_ScrollToSection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePage_AttachedTabStateUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeChromePage_NtpManagedByNameUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeChromePageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::mojom::CustomizeChromePage::Name_,
    kCustomizeChromePageValidationInfo);
}



}  // side_panel::mojom


namespace mojo {


// static
bool StructTraits<::side_panel::mojom::BackgroundImage::DataView, ::side_panel::mojom::BackgroundImagePtr>::Read(
    ::side_panel::mojom::BackgroundImage::DataView input,
    ::side_panel::mojom::BackgroundImagePtr* output) {
  bool success = true;
  ::side_panel::mojom::BackgroundImagePtr result(::side_panel::mojom::BackgroundImage::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSnapshotUrl(&result->snapshot_url))
        success = false;
      if (success)
        result->is_uploaded_image = input.is_uploaded_image();
      if (success && !input.ReadLocalBackgroundId(&result->local_background_id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadCollectionId(&result->collection_id))
        success = false;
      if (success)
        result->daily_refresh_enabled = input.daily_refresh_enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::mojom::ThirdPartyThemeInfo::DataView, ::side_panel::mojom::ThirdPartyThemeInfoPtr>::Read(
    ::side_panel::mojom::ThirdPartyThemeInfo::DataView input,
    ::side_panel::mojom::ThirdPartyThemeInfoPtr* output) {
  bool success = true;
  ::side_panel::mojom::ThirdPartyThemeInfoPtr result(::side_panel::mojom::ThirdPartyThemeInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::mojom::Theme::DataView, ::side_panel::mojom::ThemePtr>::Read(
    ::side_panel::mojom::Theme::DataView input,
    ::side_panel::mojom::ThemePtr* output) {
  bool success = true;
  ::side_panel::mojom::ThemePtr result(::side_panel::mojom::Theme::New());
  
      if (success && !input.ReadBackgroundImage(&result->background_image))
        success = false;
      if (success && !input.ReadThirdPartyThemeInfo(&result->third_party_theme_info))
        success = false;
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success && !input.ReadForegroundColor(&result->foreground_color))
        success = false;
      if (success)
        result->background_managed_by_policy = input.background_managed_by_policy();
      if (success)
        result->follow_device_theme = input.follow_device_theme();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::mojom::BackgroundCollection::DataView, ::side_panel::mojom::BackgroundCollectionPtr>::Read(
    ::side_panel::mojom::BackgroundCollection::DataView input,
    ::side_panel::mojom::BackgroundCollectionPtr* output) {
  bool success = true;
  ::side_panel::mojom::BackgroundCollectionPtr result(::side_panel::mojom::BackgroundCollection::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadPreviewImageUrl(&result->preview_image_url))
        success = false;
      if (success)
        result->image_verified = input.image_verified();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::mojom::CollectionImage::DataView, ::side_panel::mojom::CollectionImagePtr>::Read(
    ::side_panel::mojom::CollectionImage::DataView input,
    ::side_panel::mojom::CollectionImagePtr* output) {
  bool success = true;
  ::side_panel::mojom::CollectionImagePtr result(::side_panel::mojom::CollectionImage::New());
  
      if (success && !input.ReadAttribution1(&result->attribution_1))
        success = false;
      if (success && !input.ReadAttribution2(&result->attribution_2))
        success = false;
      if (success && !input.ReadAttributionUrl(&result->attribution_url))
        success = false;
      if (success && !input.ReadImageUrl(&result->image_url))
        success = false;
      if (success && !input.ReadPreviewImageUrl(&result->preview_image_url))
        success = false;
      if (success && !input.ReadCollectionId(&result->collection_id))
        success = false;
      if (success)
        result->image_verified = input.image_verified();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::mojom::ModuleSettings::DataView, ::side_panel::mojom::ModuleSettingsPtr>::Read(
    ::side_panel::mojom::ModuleSettings::DataView input,
    ::side_panel::mojom::ModuleSettingsPtr* output) {
  bool success = true;
  ::side_panel::mojom::ModuleSettingsPtr result(::side_panel::mojom::ModuleSettings::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success)
        result->enabled = input.enabled();
      if (success)
        result->visible = input.visible();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::mojom::ManagementNoticeState::DataView, ::side_panel::mojom::ManagementNoticeStatePtr>::Read(
    ::side_panel::mojom::ManagementNoticeState::DataView input,
    ::side_panel::mojom::ManagementNoticeStatePtr* output) {
  bool success = true;
  ::side_panel::mojom::ManagementNoticeStatePtr result(::side_panel::mojom::ManagementNoticeState::New());
  
      if (success)
        result->can_be_shown = input.can_be_shown();
      if (success)
        result->enabled_by_policy = input.enabled_by_policy();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace side_panel::mojom {


void CustomizeChromePageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<CustomizeChromePage> page, ::mojo::PendingReceiver<CustomizeChromePageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
CustomizeChromePageHandlerFactoryAsyncWaiter::CustomizeChromePageHandlerFactoryAsyncWaiter(
    CustomizeChromePageHandlerFactory* proxy) : proxy_(proxy) {}

CustomizeChromePageHandlerFactoryAsyncWaiter::~CustomizeChromePageHandlerFactoryAsyncWaiter() = default;





void CustomizeChromePageHandlerInterceptorForTesting::SetMostVisitedSettings(const std::vector<::ntp_tiles::mojom::TileType>& shortcuts_types, bool shortcuts_visible, bool personal_shortcuts_visible) {
  GetForwardingInterface()->SetMostVisitedSettings(
    std::move(shortcuts_types)
    , 
    std::move(shortcuts_visible)
    , 
    std::move(personal_shortcuts_visible)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateMostVisitedSettings() {
  GetForwardingInterface()->UpdateMostVisitedSettings();
}
void CustomizeChromePageHandlerInterceptorForTesting::GetBackgroundCollections(GetBackgroundCollectionsCallback callback) {
  GetForwardingInterface()->GetBackgroundCollections(std::move(callback));
}
void CustomizeChromePageHandlerInterceptorForTesting::GetReplacementCollectionPreviewImage(const std::string& collection_id, GetReplacementCollectionPreviewImageCallback callback) {
  GetForwardingInterface()->GetReplacementCollectionPreviewImage(
    std::move(collection_id)
    , std::move(callback));
}
void CustomizeChromePageHandlerInterceptorForTesting::GetBackgroundImages(const std::string& collection_id, GetBackgroundImagesCallback callback) {
  GetForwardingInterface()->GetBackgroundImages(
    std::move(collection_id)
    , std::move(callback));
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateModulesSettings() {
  GetForwardingInterface()->UpdateModulesSettings();
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateTheme() {
  GetForwardingInterface()->UpdateTheme();
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateThemeEditable(bool is_theme_editable) {
  GetForwardingInterface()->UpdateThemeEditable(
    std::move(is_theme_editable)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::SetDefaultColor() {
  GetForwardingInterface()->SetDefaultColor();
}
void CustomizeChromePageHandlerInterceptorForTesting::SetFollowDeviceTheme(bool follow) {
  GetForwardingInterface()->SetFollowDeviceTheme(
    std::move(follow)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::RemoveBackgroundImage() {
  GetForwardingInterface()->RemoveBackgroundImage();
}
void CustomizeChromePageHandlerInterceptorForTesting::ChooseLocalCustomBackground(ChooseLocalCustomBackgroundCallback callback) {
  GetForwardingInterface()->ChooseLocalCustomBackground(std::move(callback));
}
void CustomizeChromePageHandlerInterceptorForTesting::SetBackgroundImage(const std::string& attribution_1, const std::string& attribution_2, const ::GURL& attribution_url, const ::GURL& image_url, const ::GURL& thumbnail_url, const std::string& collection_id) {
  GetForwardingInterface()->SetBackgroundImage(
    std::move(attribution_1)
    , 
    std::move(attribution_2)
    , 
    std::move(attribution_url)
    , 
    std::move(image_url)
    , 
    std::move(thumbnail_url)
    , 
    std::move(collection_id)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::SetDailyRefreshCollectionId(const std::string& collection_id) {
  GetForwardingInterface()->SetDailyRefreshCollectionId(
    std::move(collection_id)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::OpenChromeWebStore() {
  GetForwardingInterface()->OpenChromeWebStore();
}
void CustomizeChromePageHandlerInterceptorForTesting::OpenChromeWebStoreHomePage() {
  GetForwardingInterface()->OpenChromeWebStoreHomePage();
}
void CustomizeChromePageHandlerInterceptorForTesting::OpenThirdPartyThemePage(const std::string& theme_id) {
  GetForwardingInterface()->OpenThirdPartyThemePage(
    std::move(theme_id)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::OpenChromeWebStoreCategoryPage(ChromeWebStoreCategory category) {
  GetForwardingInterface()->OpenChromeWebStoreCategoryPage(
    std::move(category)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::OpenChromeWebStoreCollectionPage(ChromeWebStoreCollection collection) {
  GetForwardingInterface()->OpenChromeWebStoreCollectionPage(
    std::move(collection)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::OpenNtpManagedByPage() {
  GetForwardingInterface()->OpenNtpManagedByPage();
}
void CustomizeChromePageHandlerInterceptorForTesting::SetModulesVisible(bool visible) {
  GetForwardingInterface()->SetModulesVisible(
    std::move(visible)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::SetModuleDisabled(const std::string& module_id, bool disabled) {
  GetForwardingInterface()->SetModuleDisabled(
    std::move(module_id)
    , 
    std::move(disabled)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::SetToolChipsVisible(bool visible) {
  GetForwardingInterface()->SetToolChipsVisible(
    std::move(visible)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateToolChipsSettings() {
  GetForwardingInterface()->UpdateToolChipsSettings();
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateScrollToSection() {
  GetForwardingInterface()->UpdateScrollToSection();
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateAttachedTabState() {
  GetForwardingInterface()->UpdateAttachedTabState();
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateNtpManagedByName() {
  GetForwardingInterface()->UpdateNtpManagedByName();
}
void CustomizeChromePageHandlerInterceptorForTesting::SetFooterVisible(bool visible) {
  GetForwardingInterface()->SetFooterVisible(
    std::move(visible)
    );
}
void CustomizeChromePageHandlerInterceptorForTesting::UpdateFooterSettings() {
  GetForwardingInterface()->UpdateFooterSettings();
}
CustomizeChromePageHandlerAsyncWaiter::CustomizeChromePageHandlerAsyncWaiter(
    CustomizeChromePageHandler* proxy) : proxy_(proxy) {}

CustomizeChromePageHandlerAsyncWaiter::~CustomizeChromePageHandlerAsyncWaiter() = default;


void CustomizeChromePageHandlerAsyncWaiter::GetBackgroundCollections(
    std::vector<BackgroundCollectionPtr>* out_collections) {
  base::RunLoop loop;
  proxy_->GetBackgroundCollections(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<BackgroundCollectionPtr>* out_collections
,
             std::vector<BackgroundCollectionPtr> collections) {*out_collections = std::move(collections);
            loop->Quit();
          },
          &loop,
          out_collections));
  loop.Run();
}

std::vector<BackgroundCollectionPtr> CustomizeChromePageHandlerAsyncWaiter::GetBackgroundCollections(
    ) {
  std::vector<BackgroundCollectionPtr> async_wait_result;
  GetBackgroundCollections(&async_wait_result);
  return async_wait_result;
}

void CustomizeChromePageHandlerAsyncWaiter::GetReplacementCollectionPreviewImage(
    const std::string& collection_id, std::optional<::GURL>* out_preview_image_url) {
  base::RunLoop loop;
  proxy_->GetReplacementCollectionPreviewImage(
      std::move(collection_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::GURL>* out_preview_image_url
,
             const std::optional<::GURL>& preview_image_url) {*out_preview_image_url = std::move(preview_image_url);
            loop->Quit();
          },
          &loop,
          out_preview_image_url));
  loop.Run();
}

std::optional<::GURL> CustomizeChromePageHandlerAsyncWaiter::GetReplacementCollectionPreviewImage(
    const std::string& collection_id) {
  std::optional<::GURL> async_wait_result;
  GetReplacementCollectionPreviewImage(std::move(collection_id),&async_wait_result);
  return async_wait_result;
}

void CustomizeChromePageHandlerAsyncWaiter::GetBackgroundImages(
    const std::string& collection_id, std::vector<CollectionImagePtr>* out_images) {
  base::RunLoop loop;
  proxy_->GetBackgroundImages(
      std::move(collection_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<CollectionImagePtr>* out_images
,
             std::vector<CollectionImagePtr> images) {*out_images = std::move(images);
            loop->Quit();
          },
          &loop,
          out_images));
  loop.Run();
}

std::vector<CollectionImagePtr> CustomizeChromePageHandlerAsyncWaiter::GetBackgroundImages(
    const std::string& collection_id) {
  std::vector<CollectionImagePtr> async_wait_result;
  GetBackgroundImages(std::move(collection_id),&async_wait_result);
  return async_wait_result;
}

void CustomizeChromePageHandlerAsyncWaiter::ChooseLocalCustomBackground(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->ChooseLocalCustomBackground(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool CustomizeChromePageHandlerAsyncWaiter::ChooseLocalCustomBackground(
    ) {
  bool async_wait_result;
  ChooseLocalCustomBackground(&async_wait_result);
  return async_wait_result;
}




void CustomizeChromePageInterceptorForTesting::SetModulesSettings(std::vector<ModuleSettingsPtr> modules_settings, bool managed, bool visible) {
  GetForwardingInterface()->SetModulesSettings(
    std::move(modules_settings)
    , 
    std::move(managed)
    , 
    std::move(visible)
    );
}
void CustomizeChromePageInterceptorForTesting::SetMostVisitedSettings(const std::vector<::ntp_tiles::mojom::TileType>& shortcuts_types, bool visible, bool personal_shortcuts_visible, const std::vector<::ntp_tiles::mojom::TileType>& disabled_shortcuts) {
  GetForwardingInterface()->SetMostVisitedSettings(
    std::move(shortcuts_types)
    , 
    std::move(visible)
    , 
    std::move(personal_shortcuts_visible)
    , 
    std::move(disabled_shortcuts)
    );
}
void CustomizeChromePageInterceptorForTesting::SetToolsSettings(bool visible) {
  GetForwardingInterface()->SetToolsSettings(
    std::move(visible)
    );
}
void CustomizeChromePageInterceptorForTesting::SetFooterSettings(bool visible, bool extension_policy_enabled, ManagementNoticeStatePtr management_notice_state) {
  GetForwardingInterface()->SetFooterSettings(
    std::move(visible)
    , 
    std::move(extension_policy_enabled)
    , 
    std::move(management_notice_state)
    );
}
void CustomizeChromePageInterceptorForTesting::SetTheme(ThemePtr theme) {
  GetForwardingInterface()->SetTheme(
    std::move(theme)
    );
}
void CustomizeChromePageInterceptorForTesting::SetThemeEditable(bool is_theme_editable) {
  GetForwardingInterface()->SetThemeEditable(
    std::move(is_theme_editable)
    );
}
void CustomizeChromePageInterceptorForTesting::ScrollToSection(::CustomizeChromeSection section) {
  GetForwardingInterface()->ScrollToSection(
    std::move(section)
    );
}
void CustomizeChromePageInterceptorForTesting::AttachedTabStateUpdated(NewTabPageType ntp_type) {
  GetForwardingInterface()->AttachedTabStateUpdated(
    std::move(ntp_type)
    );
}
void CustomizeChromePageInterceptorForTesting::NtpManagedByNameUpdated(const std::string& name, const std::string& description) {
  GetForwardingInterface()->NtpManagedByNameUpdated(
    std::move(name)
    , 
    std::move(description)
    );
}
CustomizeChromePageAsyncWaiter::CustomizeChromePageAsyncWaiter(
    CustomizeChromePage* proxy) : proxy_(proxy) {}

CustomizeChromePageAsyncWaiter::~CustomizeChromePageAsyncWaiter() = default;







}  // side_panel::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif