// chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-shared-internal.h"


namespace related_website_sets::mojom {
class MemberDataView;

class RelatedWebsiteSetDataView;

class GetRelatedWebsiteSetsResponseDataView;


}  // related_website_sets::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::related_website_sets::mojom::MemberDataView> {
  using Data = ::related_website_sets::mojom::internal::Member_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::related_website_sets::mojom::RelatedWebsiteSetDataView> {
  using Data = ::related_website_sets::mojom::internal::RelatedWebsiteSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::related_website_sets::mojom::GetRelatedWebsiteSetsResponseDataView> {
  using Data = ::related_website_sets::mojom::internal::GetRelatedWebsiteSetsResponse_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace related_website_sets::mojom {


enum class SiteType : int32_t {
  
  kPrimary = 0,
  
  kAssociated = 1,
  
  kService = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SiteType value);
inline bool IsKnownEnumValue(SiteType value) {
  return internal::SiteType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class RelatedWebsiteSetsPageHandlerInterfaceBase {};

using RelatedWebsiteSetsPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<RelatedWebsiteSetsPageHandlerInterfaceBase>;
using RelatedWebsiteSetsPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<RelatedWebsiteSetsPageHandlerInterfaceBase>;
using RelatedWebsiteSetsPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RelatedWebsiteSetsPageHandlerInterfaceBase>;
using RelatedWebsiteSetsPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RelatedWebsiteSetsPageHandlerInterfaceBase>;


class MemberDataView {
 public:
  MemberDataView() = default;

  MemberDataView(
      internal::Member_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::related_website_sets::mojom::SiteType>(
        data_value, output);
  }
  SiteType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::related_website_sets::mojom::SiteType>(data_->type));
  }
 private:
  internal::Member_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RelatedWebsiteSetDataView {
 public:
  RelatedWebsiteSetDataView() = default;

  RelatedWebsiteSetDataView(
      internal::RelatedWebsiteSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrimarySiteDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimarySite(UserType* output) {
    
    auto* pointer = data_->primary_site.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMemberSitesDataView(
      mojo::ArrayDataView<MemberDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemberSites(UserType* output) {
    
    auto* pointer = data_->member_sites.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::related_website_sets::mojom::MemberDataView>>(
        pointer, output, message_);
  }
  bool managed_by_enterprise() const {
    return data_->managed_by_enterprise;
  }
 private:
  internal::RelatedWebsiteSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetRelatedWebsiteSetsResponseDataView {
 public:
  using Tag = internal::GetRelatedWebsiteSetsResponse_Data::GetRelatedWebsiteSetsResponse_Tag;

  GetRelatedWebsiteSetsResponseDataView() = default;

  GetRelatedWebsiteSetsResponseDataView(
      internal::GetRelatedWebsiteSetsResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_related_website_sets() const { return data_->tag == Tag::kRelatedWebsiteSets; }
  inline void GetRelatedWebsiteSetsDataView(
      mojo::ArrayDataView<RelatedWebsiteSetDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRelatedWebsiteSets(UserType* output) const {
    
    CHECK(is_related_website_sets());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::related_website_sets::mojom::RelatedWebsiteSetDataView>>(
        data_->data.f_related_website_sets.Get(), output, message_);
  }
  bool is_error_message() const { return data_->tag == Tag::kErrorMessage; }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) const {
    
    CHECK(is_error_message());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error_message.Get(), output, message_);
  }

 private:
  internal::GetRelatedWebsiteSetsResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // related_website_sets::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_DATA_VIEW_H_