// chrome/browser/ui/webui/password_manager/password_manager.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-shared-internal.h"

#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::password_manager::mojom::FormattedUrlDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::password_manager::mojom::FormattedUrlDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::password_manager::mojom::internal::FormattedUrl_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::human_readable_url(input)) in_human_readable_url = Traits::human_readable_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->human_readable_url)::BaseType> human_readable_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_human_readable_url,
        human_readable_url_fragment);

      fragment->human_readable_url.Set(
          human_readable_url_fragment.is_null() ? nullptr : human_readable_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->human_readable_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null human_readable_url in FormattedUrl struct");

      decltype(Traits::link(input)) in_link = Traits::link(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->link)::BaseType> link_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_link,
        link_fragment);

      fragment->link.Set(
          link_fragment.is_null() ? nullptr : link_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->link.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null link in FormattedUrl struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::password_manager::mojom::ActorLoginPermissionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::password_manager::mojom::ActorLoginPermissionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::password_manager::mojom::internal::ActorLoginPermission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::password_manager::mojom::FormattedUrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ActorLoginPermission struct");

      decltype(Traits::username(input)) in_username = Traits::username(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->username)::BaseType> username_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_username,
        username_fragment);

      fragment->username.Set(
          username_fragment.is_null() ? nullptr : username_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->username.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username in ActorLoginPermission struct");
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_SEND_VALIDATION_H_