// chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NTP_MICROSOFT_AUTH_NTP_MICROSOFT_AUTH_UNTRUSTED_UI_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_NTP_MICROSOFT_AUTH_NTP_MICROSOFT_AUTH_UNTRUSTED_UI_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_shared_ui.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace new_tab_page::mojom {

class MicrosoftAuthUntrustedDocumentInterfacesFactoryProxy;

template <typename ImplRefTraits>
class MicrosoftAuthUntrustedDocumentInterfacesFactoryStub;

class MicrosoftAuthUntrustedDocumentInterfacesFactoryRequestValidator;


class MicrosoftAuthUntrustedDocumentInterfacesFactory
    : public MicrosoftAuthUntrustedDocumentInterfacesFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "new_tab_page.mojom.MicrosoftAuthUntrustedDocumentInterfacesFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MicrosoftAuthUntrustedDocumentInterfacesFactoryInterfaceBase;
  using Proxy_ = MicrosoftAuthUntrustedDocumentInterfacesFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = MicrosoftAuthUntrustedDocumentInterfacesFactoryStub<ImplRefTraits>;

  using RequestValidator_ = MicrosoftAuthUntrustedDocumentInterfacesFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kConnectToParentDocumentMinVersion = 0,
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ConnectToParentDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MicrosoftAuthUntrustedDocumentInterfacesFactory() = default;

  virtual void ConnectToParentDocument(::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> child_document) = 0;

  virtual void CreatePageHandler(::mojo::PendingReceiver<MicrosoftAuthUntrustedPageHandler> handler, ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> document) = 0;
};

class MicrosoftAuthUntrustedPageHandlerProxy;

template <typename ImplRefTraits>
class MicrosoftAuthUntrustedPageHandlerStub;

class MicrosoftAuthUntrustedPageHandlerRequestValidator;


class MicrosoftAuthUntrustedPageHandler
    : public MicrosoftAuthUntrustedPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "new_tab_page.mojom.MicrosoftAuthUntrustedPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MicrosoftAuthUntrustedPageHandlerInterfaceBase;
  using Proxy_ = MicrosoftAuthUntrustedPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MicrosoftAuthUntrustedPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = MicrosoftAuthUntrustedPageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kClearAuthDataMinVersion = 0,
    kMaybeAcquireTokenSilentMinVersion = 0,
    kSetAccessTokenMinVersion = 0,
    kSetAuthStateErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ClearAuthData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeAcquireTokenSilent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAccessToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAuthStateError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MicrosoftAuthUntrustedPageHandler() = default;

  virtual void ClearAuthData() = 0;

  virtual void MaybeAcquireTokenSilent() = 0;

  virtual void SetAccessToken(AccessTokenPtr access_token) = 0;

  virtual void SetAuthStateError(const std::string& error_code, const std::string& error_message) = 0;
};



class  MicrosoftAuthUntrustedDocumentInterfacesFactoryProxy
    : public MicrosoftAuthUntrustedDocumentInterfacesFactory {
 public:
  using InterfaceType = MicrosoftAuthUntrustedDocumentInterfacesFactory;

  explicit MicrosoftAuthUntrustedDocumentInterfacesFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ConnectToParentDocument(::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> child_document) final;
  
  void CreatePageHandler(::mojo::PendingReceiver<MicrosoftAuthUntrustedPageHandler> handler, ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> document) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MicrosoftAuthUntrustedPageHandlerProxy
    : public MicrosoftAuthUntrustedPageHandler {
 public:
  using InterfaceType = MicrosoftAuthUntrustedPageHandler;

  explicit MicrosoftAuthUntrustedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ClearAuthData() final;
  
  void MaybeAcquireTokenSilent() final;
  
  void SetAccessToken(AccessTokenPtr access_token) final;
  
  void SetAuthStateError(const std::string& error_code, const std::string& error_message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MicrosoftAuthUntrustedDocumentInterfacesFactoryStubDispatch {
 public:
  static bool Accept(MicrosoftAuthUntrustedDocumentInterfacesFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MicrosoftAuthUntrustedDocumentInterfacesFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MicrosoftAuthUntrustedDocumentInterfacesFactory>>
class MicrosoftAuthUntrustedDocumentInterfacesFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MicrosoftAuthUntrustedDocumentInterfacesFactoryStub() = default;
  ~MicrosoftAuthUntrustedDocumentInterfacesFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MicrosoftAuthUntrustedDocumentInterfacesFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MicrosoftAuthUntrustedDocumentInterfacesFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MicrosoftAuthUntrustedPageHandlerStubDispatch {
 public:
  static bool Accept(MicrosoftAuthUntrustedPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MicrosoftAuthUntrustedPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MicrosoftAuthUntrustedPageHandler>>
class MicrosoftAuthUntrustedPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MicrosoftAuthUntrustedPageHandlerStub() = default;
  ~MicrosoftAuthUntrustedPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MicrosoftAuthUntrustedPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MicrosoftAuthUntrustedPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MicrosoftAuthUntrustedDocumentInterfacesFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MicrosoftAuthUntrustedPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  AccessToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AccessToken, T>::value>;
  using DataView = AccessTokenDataView;
  using Data_ = internal::AccessToken_Data;

  template <typename... Args>
  static AccessTokenPtr New(Args&&... args) {
    return AccessTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AccessTokenPtr From(const U& u) {
    return mojo::TypeConverter<AccessTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AccessToken>::Convert(*this);
  }


  AccessToken();

  AccessToken(
      const std::string& token,
      ::base::Time expiration);


  ~AccessToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AccessTokenPtr>
  AccessTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AccessToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AccessToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AccessToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AccessToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AccessToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AccessToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AccessToken_UnserializedMessageContext<
            UserType, AccessToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AccessToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AccessToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AccessToken_UnserializedMessageContext<
            UserType, AccessToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AccessToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string token;
  
  ::base::Time expiration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AccessToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AccessToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AccessToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AccessToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AccessTokenPtr AccessToken::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(expiration)
  );
}

template <typename T, AccessToken::EnableIfSame<T>*>
bool AccessToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->expiration, other_struct.expiration))
    return false;
  return true;
}

template <typename T, AccessToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.expiration < rhs.expiration)
    return true;
  if (rhs.expiration < lhs.expiration)
    return false;
  return false;
}


}  // new_tab_page::mojom

namespace mojo {


template <>
struct  StructTraits<::new_tab_page::mojom::AccessToken::DataView,
                                         ::new_tab_page::mojom::AccessTokenPtr> {
  static bool IsNull(const ::new_tab_page::mojom::AccessTokenPtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::AccessTokenPtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::AccessToken::token)& token(
      const ::new_tab_page::mojom::AccessTokenPtr& input) {
    return input->token;
  }

  static const decltype(::new_tab_page::mojom::AccessToken::expiration)& expiration(
      const ::new_tab_page::mojom::AccessTokenPtr& input) {
    return input->expiration;
  }

  static bool Read(::new_tab_page::mojom::AccessToken::DataView input, ::new_tab_page::mojom::AccessTokenPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_NTP_MICROSOFT_AUTH_NTP_MICROSOFT_AUTH_UNTRUSTED_UI_MOJOM_H_