// chrome/browser/ui/webui/downloads/downloads.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/downloads/downloads.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/downloads/downloads.mojom-params-data.h"
#include "chrome/browser/ui/webui/downloads/downloads.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/downloads/downloads.mojom-import-headers.h"
#include "chrome/browser/ui/webui/downloads/downloads.mojom-test-utils.h"


namespace downloads::mojom {
Data::Data()
    : file_externally_removed(),
      is_dangerous(),
      is_insecure(),
      is_reviewable(),
      otr(),
      resume(),
      retry(),
      percent(),
      started(),
      total(),
      by_ext_id(),
      by_ext_name(),
      danger_type(),
      tailored_warning_type(),
      date_string(),
      file_name(),
      file_path(),
      file_url(),
      id(),
      last_reason_text(),
      progress_status_text(),
      show_in_folder_text(),
      since_string(),
      state(),
      display_initiator_origin(),
      url(),
      display_url(),
      safe_browsing_state(),
      has_safe_browsing_verdict() {}

Data::Data(
    bool file_externally_removed_in,
    bool is_dangerous_in,
    bool is_insecure_in,
    bool is_reviewable_in,
    bool otr_in,
    bool resume_in,
    bool retry_in,
    int32_t percent_in,
    int32_t started_in,
    int64_t total_in,
    const std::string& by_ext_id_in,
    const std::string& by_ext_name_in,
    DangerType danger_type_in,
    TailoredWarningType tailored_warning_type_in,
    const std::string& date_string_in,
    const std::string& file_name_in,
    const std::string& file_path_in,
    const std::string& file_url_in,
    const std::string& id_in,
    const std::string& last_reason_text_in,
    const std::string& progress_status_text_in,
    const std::string& show_in_folder_text_in,
    const std::string& since_string_in,
    State state_in,
    const ::std::u16string& display_initiator_origin_in,
    const std::optional<::GURL>& url_in,
    const ::std::u16string& display_url_in,
    SafeBrowsingState safe_browsing_state_in,
    bool has_safe_browsing_verdict_in)
    : file_externally_removed(std::move(file_externally_removed_in)),
      is_dangerous(std::move(is_dangerous_in)),
      is_insecure(std::move(is_insecure_in)),
      is_reviewable(std::move(is_reviewable_in)),
      otr(std::move(otr_in)),
      resume(std::move(resume_in)),
      retry(std::move(retry_in)),
      percent(std::move(percent_in)),
      started(std::move(started_in)),
      total(std::move(total_in)),
      by_ext_id(std::move(by_ext_id_in)),
      by_ext_name(std::move(by_ext_name_in)),
      danger_type(std::move(danger_type_in)),
      tailored_warning_type(std::move(tailored_warning_type_in)),
      date_string(std::move(date_string_in)),
      file_name(std::move(file_name_in)),
      file_path(std::move(file_path_in)),
      file_url(std::move(file_url_in)),
      id(std::move(id_in)),
      last_reason_text(std::move(last_reason_text_in)),
      progress_status_text(std::move(progress_status_text_in)),
      show_in_folder_text(std::move(show_in_folder_text_in)),
      since_string(std::move(since_string_in)),
      state(std::move(state_in)),
      display_initiator_origin(std::move(display_initiator_origin_in)),
      url(std::move(url_in)),
      display_url(std::move(display_url_in)),
      safe_browsing_state(std::move(safe_browsing_state_in)),
      has_safe_browsing_verdict(std::move(has_safe_browsing_verdict_in)) {}

Data::~Data() = default;

void Data::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_externally_removed"), this->file_externally_removed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_dangerous"), this->is_dangerous,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_insecure"), this->is_insecure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_reviewable"), this->is_reviewable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "otr"), this->otr,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resume"), this->resume,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "retry"), this->retry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "percent"), this->percent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "started"), this->started,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "by_ext_id"), this->by_ext_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "by_ext_name"), this->by_ext_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "danger_type"), this->danger_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DangerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tailored_warning_type"), this->tailored_warning_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TailoredWarningType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "date_string"), this->date_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_name"), this->file_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_path"), this->file_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_url"), this->file_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_reason_text"), this->last_reason_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "progress_status_text"), this->progress_status_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_in_folder_text"), this->show_in_folder_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "since_string"), this->since_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type State>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_initiator_origin"), this->display_initiator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_url"), this->display_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safe_browsing_state"), this->safe_browsing_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SafeBrowsingState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_safe_browsing_verdict"), this->has_safe_browsing_verdict,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive downloads::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply downloads::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafd0d173;  // IPCStableHash for downloads::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::downloads::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::downloads::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::downloads::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetDownloads: {
      return &PageHandler::GetDownloads_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenFileRequiringGesture: {
      return &PageHandler::OpenFileRequiringGesture_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDrag: {
      return &PageHandler::Drag_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSaveSuspiciousRequiringGesture: {
      return &PageHandler::SaveSuspiciousRequiringGesture_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordOpenBypassWarningDialog: {
      return &PageHandler::RecordOpenBypassWarningDialog_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSaveDangerousFromDialogRequiringGesture: {
      return &PageHandler::SaveDangerousFromDialogRequiringGesture_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordCancelBypassWarningDialog: {
      return &PageHandler::RecordCancelBypassWarningDialog_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDiscardDangerous: {
      return &PageHandler::DiscardDangerous_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRetryDownload: {
      return &PageHandler::RetryDownload_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShow: {
      return &PageHandler::Show_Sym::IPCStableHash;
    }
    case messages::PageHandler::kPause: {
      return &PageHandler::Pause_Sym::IPCStableHash;
    }
    case messages::PageHandler::kResume: {
      return &PageHandler::Resume_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRemove: {
      return &PageHandler::Remove_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUndo: {
      return &PageHandler::Undo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCancel: {
      return &PageHandler::Cancel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kClearAll: {
      return &PageHandler::ClearAll_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenDownloadsFolderRequiringGesture: {
      return &PageHandler::OpenDownloadsFolderRequiringGesture_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenEsbSettings: {
      return &PageHandler::OpenEsbSettings_Sym::IPCStableHash;
    }
    case messages::PageHandler::kLogEsbPromotionRowViewed: {
      return &PageHandler::LogEsbPromotionRowViewed_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenDuringScanningRequiringGesture: {
      return &PageHandler::OpenDuringScanningRequiringGesture_Sym::IPCStableHash;
    }
    case messages::PageHandler::kReviewDangerousRequiringGesture: {
      return &PageHandler::ReviewDangerousRequiringGesture_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeepScan: {
      return &PageHandler::DeepScan_Sym::IPCStableHash;
    }
    case messages::PageHandler::kBypassDeepScanRequiringGesture: {
      return &PageHandler::BypassDeepScanRequiringGesture_Sym::IPCStableHash;
    }
    case messages::PageHandler::kIsEligibleForEsbPromo: {
      return &PageHandler::IsEligibleForEsbPromo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetDownloads:
            return "Receive downloads::mojom::PageHandler::GetDownloads";
      case messages::PageHandler::kOpenFileRequiringGesture:
            return "Receive downloads::mojom::PageHandler::OpenFileRequiringGesture";
      case messages::PageHandler::kDrag:
            return "Receive downloads::mojom::PageHandler::Drag";
      case messages::PageHandler::kSaveSuspiciousRequiringGesture:
            return "Receive downloads::mojom::PageHandler::SaveSuspiciousRequiringGesture";
      case messages::PageHandler::kRecordOpenBypassWarningDialog:
            return "Receive downloads::mojom::PageHandler::RecordOpenBypassWarningDialog";
      case messages::PageHandler::kSaveDangerousFromDialogRequiringGesture:
            return "Receive downloads::mojom::PageHandler::SaveDangerousFromDialogRequiringGesture";
      case messages::PageHandler::kRecordCancelBypassWarningDialog:
            return "Receive downloads::mojom::PageHandler::RecordCancelBypassWarningDialog";
      case messages::PageHandler::kDiscardDangerous:
            return "Receive downloads::mojom::PageHandler::DiscardDangerous";
      case messages::PageHandler::kRetryDownload:
            return "Receive downloads::mojom::PageHandler::RetryDownload";
      case messages::PageHandler::kShow:
            return "Receive downloads::mojom::PageHandler::Show";
      case messages::PageHandler::kPause:
            return "Receive downloads::mojom::PageHandler::Pause";
      case messages::PageHandler::kResume:
            return "Receive downloads::mojom::PageHandler::Resume";
      case messages::PageHandler::kRemove:
            return "Receive downloads::mojom::PageHandler::Remove";
      case messages::PageHandler::kUndo:
            return "Receive downloads::mojom::PageHandler::Undo";
      case messages::PageHandler::kCancel:
            return "Receive downloads::mojom::PageHandler::Cancel";
      case messages::PageHandler::kClearAll:
            return "Receive downloads::mojom::PageHandler::ClearAll";
      case messages::PageHandler::kOpenDownloadsFolderRequiringGesture:
            return "Receive downloads::mojom::PageHandler::OpenDownloadsFolderRequiringGesture";
      case messages::PageHandler::kOpenEsbSettings:
            return "Receive downloads::mojom::PageHandler::OpenEsbSettings";
      case messages::PageHandler::kLogEsbPromotionRowViewed:
            return "Receive downloads::mojom::PageHandler::LogEsbPromotionRowViewed";
      case messages::PageHandler::kOpenDuringScanningRequiringGesture:
            return "Receive downloads::mojom::PageHandler::OpenDuringScanningRequiringGesture";
      case messages::PageHandler::kReviewDangerousRequiringGesture:
            return "Receive downloads::mojom::PageHandler::ReviewDangerousRequiringGesture";
      case messages::PageHandler::kDeepScan:
            return "Receive downloads::mojom::PageHandler::DeepScan";
      case messages::PageHandler::kBypassDeepScanRequiringGesture:
            return "Receive downloads::mojom::PageHandler::BypassDeepScanRequiringGesture";
      case messages::PageHandler::kIsEligibleForEsbPromo:
            return "Receive downloads::mojom::PageHandler::IsEligibleForEsbPromo";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetDownloads:
            return "Receive reply downloads::mojom::PageHandler::GetDownloads";
      case messages::PageHandler::kOpenFileRequiringGesture:
            return "Receive reply downloads::mojom::PageHandler::OpenFileRequiringGesture";
      case messages::PageHandler::kDrag:
            return "Receive reply downloads::mojom::PageHandler::Drag";
      case messages::PageHandler::kSaveSuspiciousRequiringGesture:
            return "Receive reply downloads::mojom::PageHandler::SaveSuspiciousRequiringGesture";
      case messages::PageHandler::kRecordOpenBypassWarningDialog:
            return "Receive reply downloads::mojom::PageHandler::RecordOpenBypassWarningDialog";
      case messages::PageHandler::kSaveDangerousFromDialogRequiringGesture:
            return "Receive reply downloads::mojom::PageHandler::SaveDangerousFromDialogRequiringGesture";
      case messages::PageHandler::kRecordCancelBypassWarningDialog:
            return "Receive reply downloads::mojom::PageHandler::RecordCancelBypassWarningDialog";
      case messages::PageHandler::kDiscardDangerous:
            return "Receive reply downloads::mojom::PageHandler::DiscardDangerous";
      case messages::PageHandler::kRetryDownload:
            return "Receive reply downloads::mojom::PageHandler::RetryDownload";
      case messages::PageHandler::kShow:
            return "Receive reply downloads::mojom::PageHandler::Show";
      case messages::PageHandler::kPause:
            return "Receive reply downloads::mojom::PageHandler::Pause";
      case messages::PageHandler::kResume:
            return "Receive reply downloads::mojom::PageHandler::Resume";
      case messages::PageHandler::kRemove:
            return "Receive reply downloads::mojom::PageHandler::Remove";
      case messages::PageHandler::kUndo:
            return "Receive reply downloads::mojom::PageHandler::Undo";
      case messages::PageHandler::kCancel:
            return "Receive reply downloads::mojom::PageHandler::Cancel";
      case messages::PageHandler::kClearAll:
            return "Receive reply downloads::mojom::PageHandler::ClearAll";
      case messages::PageHandler::kOpenDownloadsFolderRequiringGesture:
            return "Receive reply downloads::mojom::PageHandler::OpenDownloadsFolderRequiringGesture";
      case messages::PageHandler::kOpenEsbSettings:
            return "Receive reply downloads::mojom::PageHandler::OpenEsbSettings";
      case messages::PageHandler::kLogEsbPromotionRowViewed:
            return "Receive reply downloads::mojom::PageHandler::LogEsbPromotionRowViewed";
      case messages::PageHandler::kOpenDuringScanningRequiringGesture:
            return "Receive reply downloads::mojom::PageHandler::OpenDuringScanningRequiringGesture";
      case messages::PageHandler::kReviewDangerousRequiringGesture:
            return "Receive reply downloads::mojom::PageHandler::ReviewDangerousRequiringGesture";
      case messages::PageHandler::kDeepScan:
            return "Receive reply downloads::mojom::PageHandler::DeepScan";
      case messages::PageHandler::kBypassDeepScanRequiringGesture:
            return "Receive reply downloads::mojom::PageHandler::BypassDeepScanRequiringGesture";
      case messages::PageHandler::kIsEligibleForEsbPromo:
            return "Receive reply downloads::mojom::PageHandler::IsEligibleForEsbPromo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetDownloads_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5db6dcb2;  // IPCStableHash for downloads::mojom::PageHandler::GetDownloads
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenFileRequiringGesture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x817a91d8;  // IPCStableHash for downloads::mojom::PageHandler::OpenFileRequiringGesture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Drag_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x56b3643f;  // IPCStableHash for downloads::mojom::PageHandler::Drag
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SaveSuspiciousRequiringGesture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x163d59dd;  // IPCStableHash for downloads::mojom::PageHandler::SaveSuspiciousRequiringGesture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordOpenBypassWarningDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xceb6a8ea;  // IPCStableHash for downloads::mojom::PageHandler::RecordOpenBypassWarningDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SaveDangerousFromDialogRequiringGesture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18f81dde;  // IPCStableHash for downloads::mojom::PageHandler::SaveDangerousFromDialogRequiringGesture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordCancelBypassWarningDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb0ceb09;  // IPCStableHash for downloads::mojom::PageHandler::RecordCancelBypassWarningDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DiscardDangerous_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa41d508f;  // IPCStableHash for downloads::mojom::PageHandler::DiscardDangerous
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RetryDownload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70dfaf3f;  // IPCStableHash for downloads::mojom::PageHandler::RetryDownload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Show_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11d4a91e;  // IPCStableHash for downloads::mojom::PageHandler::Show
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Pause_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71335c3a;  // IPCStableHash for downloads::mojom::PageHandler::Pause
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Resume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x716ee3be;  // IPCStableHash for downloads::mojom::PageHandler::Resume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Remove_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5cb0cb5b;  // IPCStableHash for downloads::mojom::PageHandler::Remove
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Undo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84dd0e71;  // IPCStableHash for downloads::mojom::PageHandler::Undo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f4ec81c;  // IPCStableHash for downloads::mojom::PageHandler::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ClearAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b64a0d6;  // IPCStableHash for downloads::mojom::PageHandler::ClearAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenDownloadsFolderRequiringGesture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x06394a39;  // IPCStableHash for downloads::mojom::PageHandler::OpenDownloadsFolderRequiringGesture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenEsbSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ebcb7f4;  // IPCStableHash for downloads::mojom::PageHandler::OpenEsbSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::LogEsbPromotionRowViewed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x235a5afb;  // IPCStableHash for downloads::mojom::PageHandler::LogEsbPromotionRowViewed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenDuringScanningRequiringGesture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5d1f087;  // IPCStableHash for downloads::mojom::PageHandler::OpenDuringScanningRequiringGesture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ReviewDangerousRequiringGesture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3f18eb5;  // IPCStableHash for downloads::mojom::PageHandler::ReviewDangerousRequiringGesture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeepScan_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a2502d1;  // IPCStableHash for downloads::mojom::PageHandler::DeepScan
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::BypassDeepScanRequiringGesture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x741c55e8;  // IPCStableHash for downloads::mojom::PageHandler::BypassDeepScanRequiringGesture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::IsEligibleForEsbPromo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x381c1b0b;  // IPCStableHash for downloads::mojom::PageHandler::IsEligibleForEsbPromo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_IsEligibleForEsbPromo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_IsEligibleForEsbPromo_ForwardToCallback(
      PageHandler::IsEligibleForEsbPromoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_IsEligibleForEsbPromo_ForwardToCallback(const PageHandler_IsEligibleForEsbPromo_ForwardToCallback&) = delete;
  PageHandler_IsEligibleForEsbPromo_ForwardToCallback& operator=(const PageHandler_IsEligibleForEsbPromo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::IsEligibleForEsbPromoCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetDownloads(
    const std::vector<std::string>& in_search_terms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::GetDownloads", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("search_terms"), in_search_terms,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDownloads), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_GetDownloads_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->search_terms)::BaseType>
      search_terms_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& search_terms_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_search_terms,
    search_terms_fragment,
    &search_terms_validate_params);

  params->search_terms.Set(
      search_terms_fragment.is_null() ? nullptr : search_terms_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->search_terms.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null search_terms in PageHandler.GetDownloads request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDownloads");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenFileRequiringGesture(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::OpenFileRequiringGesture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenFileRequiringGesture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_OpenFileRequiringGesture_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.OpenFileRequiringGesture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenFileRequiringGesture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Drag(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::Drag", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_Drag_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.Drag request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Drag");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SaveSuspiciousRequiringGesture(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::SaveSuspiciousRequiringGesture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSaveSuspiciousRequiringGesture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_SaveSuspiciousRequiringGesture_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.SaveSuspiciousRequiringGesture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SaveSuspiciousRequiringGesture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordOpenBypassWarningDialog(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::RecordOpenBypassWarningDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordOpenBypassWarningDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_RecordOpenBypassWarningDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.RecordOpenBypassWarningDialog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordOpenBypassWarningDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SaveDangerousFromDialogRequiringGesture(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::SaveDangerousFromDialogRequiringGesture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSaveDangerousFromDialogRequiringGesture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.SaveDangerousFromDialogRequiringGesture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SaveDangerousFromDialogRequiringGesture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordCancelBypassWarningDialog(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::RecordCancelBypassWarningDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordCancelBypassWarningDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_RecordCancelBypassWarningDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.RecordCancelBypassWarningDialog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordCancelBypassWarningDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::DiscardDangerous(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::DiscardDangerous", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDiscardDangerous), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_DiscardDangerous_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.DiscardDangerous request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DiscardDangerous");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RetryDownload(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::RetryDownload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRetryDownload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_RetryDownload_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.RetryDownload request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RetryDownload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Show(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::Show", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_Show_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.Show request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Show");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Pause(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::Pause", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kPause), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_Pause_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.Pause request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Pause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Resume(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::Resume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_Resume_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.Resume request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Remove(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::Remove", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_Remove_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.Remove request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Remove");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Undo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send downloads::mojom::PageHandler::Undo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUndo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_Undo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Undo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Cancel(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::Cancel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_Cancel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.Cancel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ClearAll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send downloads::mojom::PageHandler::ClearAll");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClearAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_ClearAll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ClearAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenDownloadsFolderRequiringGesture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send downloads::mojom::PageHandler::OpenDownloadsFolderRequiringGesture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenDownloadsFolderRequiringGesture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenDownloadsFolderRequiringGesture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenEsbSettings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send downloads::mojom::PageHandler::OpenEsbSettings");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenEsbSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_OpenEsbSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenEsbSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::LogEsbPromotionRowViewed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send downloads::mojom::PageHandler::LogEsbPromotionRowViewed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLogEsbPromotionRowViewed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_LogEsbPromotionRowViewed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LogEsbPromotionRowViewed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenDuringScanningRequiringGesture(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::OpenDuringScanningRequiringGesture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenDuringScanningRequiringGesture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_OpenDuringScanningRequiringGesture_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.OpenDuringScanningRequiringGesture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenDuringScanningRequiringGesture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ReviewDangerousRequiringGesture(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::ReviewDangerousRequiringGesture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReviewDangerousRequiringGesture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_ReviewDangerousRequiringGesture_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.ReviewDangerousRequiringGesture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReviewDangerousRequiringGesture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::DeepScan(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::DeepScan", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeepScan), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_DeepScan_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.DeepScan request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeepScan");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::BypassDeepScanRequiringGesture(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::PageHandler::BypassDeepScanRequiringGesture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kBypassDeepScanRequiringGesture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_BypassDeepScanRequiringGesture_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.BypassDeepScanRequiringGesture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("BypassDeepScanRequiringGesture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::IsEligibleForEsbPromo(
    IsEligibleForEsbPromoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send downloads::mojom::PageHandler::IsEligibleForEsbPromo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsEligibleForEsbPromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_IsEligibleForEsbPromo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsEligibleForEsbPromo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_IsEligibleForEsbPromo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_IsEligibleForEsbPromo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::IsEligibleForEsbPromoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_IsEligibleForEsbPromo_ProxyToResponder> proxy(
        new PageHandler_IsEligibleForEsbPromo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_IsEligibleForEsbPromo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_IsEligibleForEsbPromo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_IsEligibleForEsbPromo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::IsEligibleForEsbPromoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool PageHandler_IsEligibleForEsbPromo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_IsEligibleForEsbPromo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_IsEligibleForEsbPromo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.23
  bool success = true;
  bool p_result{};
  PageHandler_IsEligibleForEsbPromo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void PageHandler_IsEligibleForEsbPromo_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply downloads::mojom::PageHandler::IsEligibleForEsbPromo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsEligibleForEsbPromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::PageHandler_IsEligibleForEsbPromo_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsEligibleForEsbPromo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetDownloads: {
      DCHECK(message->is_serialized());
      internal::PageHandler_GetDownloads_Params_Data* params =
          reinterpret_cast<internal::PageHandler_GetDownloads_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      std::vector<std::string> p_search_terms{};
      PageHandler_GetDownloads_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSearchTerms(&p_search_terms))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDownloads(        
        std::move(p_search_terms));
      return true;
    }
    case messages::PageHandler::kOpenFileRequiringGesture: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenFileRequiringGesture_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenFileRequiringGesture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      std::string p_id{};
      PageHandler_OpenFileRequiringGesture_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFileRequiringGesture(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kDrag: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Drag_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Drag_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      std::string p_id{};
      PageHandler_Drag_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Drag(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kSaveSuspiciousRequiringGesture: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SaveSuspiciousRequiringGesture_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SaveSuspiciousRequiringGesture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::string p_id{};
      PageHandler_SaveSuspiciousRequiringGesture_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveSuspiciousRequiringGesture(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kRecordOpenBypassWarningDialog: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordOpenBypassWarningDialog_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordOpenBypassWarningDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_id{};
      PageHandler_RecordOpenBypassWarningDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordOpenBypassWarningDialog(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kSaveDangerousFromDialogRequiringGesture: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      std::string p_id{};
      PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveDangerousFromDialogRequiringGesture(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kRecordCancelBypassWarningDialog: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordCancelBypassWarningDialog_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordCancelBypassWarningDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      std::string p_id{};
      PageHandler_RecordCancelBypassWarningDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordCancelBypassWarningDialog(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kDiscardDangerous: {
      DCHECK(message->is_serialized());
      internal::PageHandler_DiscardDangerous_Params_Data* params =
          reinterpret_cast<internal::PageHandler_DiscardDangerous_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      std::string p_id{};
      PageHandler_DiscardDangerous_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DiscardDangerous(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kRetryDownload: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RetryDownload_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RetryDownload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      std::string p_id{};
      PageHandler_RetryDownload_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RetryDownload(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kShow: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Show_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Show_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      std::string p_id{};
      PageHandler_Show_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Show(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kPause: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Pause_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Pause_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      std::string p_id{};
      PageHandler_Pause_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Pause(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kResume: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Resume_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Resume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      std::string p_id{};
      PageHandler_Resume_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kRemove: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Remove_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Remove_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      std::string p_id{};
      PageHandler_Remove_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Remove(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kUndo: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Undo_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Undo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      PageHandler_Undo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Undo(        );
      return true;
    }
    case messages::PageHandler::kCancel: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Cancel_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      std::string p_id{};
      PageHandler_Cancel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kClearAll: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ClearAll_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ClearAll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      PageHandler_ClearAll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearAll(        );
      return true;
    }
    case messages::PageHandler::kOpenDownloadsFolderRequiringGesture: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.16
      bool success = true;
      PageHandler_OpenDownloadsFolderRequiringGesture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDownloadsFolderRequiringGesture(        );
      return true;
    }
    case messages::PageHandler::kOpenEsbSettings: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenEsbSettings_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenEsbSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.17
      bool success = true;
      PageHandler_OpenEsbSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenEsbSettings(        );
      return true;
    }
    case messages::PageHandler::kLogEsbPromotionRowViewed: {
      DCHECK(message->is_serialized());
      internal::PageHandler_LogEsbPromotionRowViewed_Params_Data* params =
          reinterpret_cast<internal::PageHandler_LogEsbPromotionRowViewed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.18
      bool success = true;
      PageHandler_LogEsbPromotionRowViewed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogEsbPromotionRowViewed(        );
      return true;
    }
    case messages::PageHandler::kOpenDuringScanningRequiringGesture: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenDuringScanningRequiringGesture_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenDuringScanningRequiringGesture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.19
      bool success = true;
      std::string p_id{};
      PageHandler_OpenDuringScanningRequiringGesture_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDuringScanningRequiringGesture(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kReviewDangerousRequiringGesture: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ReviewDangerousRequiringGesture_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ReviewDangerousRequiringGesture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.20
      bool success = true;
      std::string p_id{};
      PageHandler_ReviewDangerousRequiringGesture_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReviewDangerousRequiringGesture(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kDeepScan: {
      DCHECK(message->is_serialized());
      internal::PageHandler_DeepScan_Params_Data* params =
          reinterpret_cast<internal::PageHandler_DeepScan_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.21
      bool success = true;
      std::string p_id{};
      PageHandler_DeepScan_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeepScan(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kBypassDeepScanRequiringGesture: {
      DCHECK(message->is_serialized());
      internal::PageHandler_BypassDeepScanRequiringGesture_Params_Data* params =
          reinterpret_cast<internal::PageHandler_BypassDeepScanRequiringGesture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.22
      bool success = true;
      std::string p_id{};
      PageHandler_BypassDeepScanRequiringGesture_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BypassDeepScanRequiringGesture(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kIsEligibleForEsbPromo: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetDownloads: {
      break;
    }
    case messages::PageHandler::kOpenFileRequiringGesture: {
      break;
    }
    case messages::PageHandler::kDrag: {
      break;
    }
    case messages::PageHandler::kSaveSuspiciousRequiringGesture: {
      break;
    }
    case messages::PageHandler::kRecordOpenBypassWarningDialog: {
      break;
    }
    case messages::PageHandler::kSaveDangerousFromDialogRequiringGesture: {
      break;
    }
    case messages::PageHandler::kRecordCancelBypassWarningDialog: {
      break;
    }
    case messages::PageHandler::kDiscardDangerous: {
      break;
    }
    case messages::PageHandler::kRetryDownload: {
      break;
    }
    case messages::PageHandler::kShow: {
      break;
    }
    case messages::PageHandler::kPause: {
      break;
    }
    case messages::PageHandler::kResume: {
      break;
    }
    case messages::PageHandler::kRemove: {
      break;
    }
    case messages::PageHandler::kUndo: {
      break;
    }
    case messages::PageHandler::kCancel: {
      break;
    }
    case messages::PageHandler::kClearAll: {
      break;
    }
    case messages::PageHandler::kOpenDownloadsFolderRequiringGesture: {
      break;
    }
    case messages::PageHandler::kOpenEsbSettings: {
      break;
    }
    case messages::PageHandler::kLogEsbPromotionRowViewed: {
      break;
    }
    case messages::PageHandler::kOpenDuringScanningRequiringGesture: {
      break;
    }
    case messages::PageHandler::kReviewDangerousRequiringGesture: {
      break;
    }
    case messages::PageHandler::kDeepScan: {
      break;
    }
    case messages::PageHandler::kBypassDeepScanRequiringGesture: {
      break;
    }
    case messages::PageHandler::kIsEligibleForEsbPromo: {
      internal::PageHandler_IsEligibleForEsbPromo_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_IsEligibleForEsbPromo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.23
      bool success = true;
      PageHandler_IsEligibleForEsbPromo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 23, false);
        return false;
      }
      auto callback =
          PageHandler_IsEligibleForEsbPromo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsEligibleForEsbPromo(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetDownloads_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenFileRequiringGesture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Drag_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SaveSuspiciousRequiringGesture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordOpenBypassWarningDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordCancelBypassWarningDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_DiscardDangerous_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RetryDownload_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Show_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Pause_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Resume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Remove_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Undo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Cancel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ClearAll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenEsbSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_LogEsbPromotionRowViewed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenDuringScanningRequiringGesture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ReviewDangerousRequiringGesture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_DeepScan_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_BypassDeepScanRequiringGesture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_IsEligibleForEsbPromo_Params_Data::Validate,
     &internal::PageHandler_IsEligibleForEsbPromo_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::downloads::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::downloads::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kRemoveItem: {
      return &Page::RemoveItem_Sym::IPCStableHash;
    }
    case messages::Page::kUpdateItem: {
      return &Page::UpdateItem_Sym::IPCStableHash;
    }
    case messages::Page::kInsertItems: {
      return &Page::InsertItems_Sym::IPCStableHash;
    }
    case messages::Page::kClearAll: {
      return &Page::ClearAll_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kRemoveItem:
            return "Receive downloads::mojom::Page::RemoveItem";
      case messages::Page::kUpdateItem:
            return "Receive downloads::mojom::Page::UpdateItem";
      case messages::Page::kInsertItems:
            return "Receive downloads::mojom::Page::InsertItems";
      case messages::Page::kClearAll:
            return "Receive downloads::mojom::Page::ClearAll";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kRemoveItem:
            return "Receive reply downloads::mojom::Page::RemoveItem";
      case messages::Page::kUpdateItem:
            return "Receive reply downloads::mojom::Page::UpdateItem";
      case messages::Page::kInsertItems:
            return "Receive reply downloads::mojom::Page::InsertItems";
      case messages::Page::kClearAll:
            return "Receive reply downloads::mojom::Page::ClearAll";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::RemoveItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6d07b6e5;  // IPCStableHash for downloads::mojom::Page::RemoveItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::UpdateItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb339fd36;  // IPCStableHash for downloads::mojom::Page::UpdateItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::InsertItems_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x07ea2d88;  // IPCStableHash for downloads::mojom::Page::InsertItems
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ClearAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf050f1ae;  // IPCStableHash for downloads::mojom::Page::ClearAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::RemoveItem(
    int32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::Page::RemoveItem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kRemoveItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::Page_RemoveItem_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("RemoveItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::UpdateItem(
    int32_t in_index, DataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::Page::UpdateItem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type DataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kUpdateItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::Page_UpdateItem_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::downloads::mojom::DataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Page.UpdateItem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("UpdateItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::InsertItems(
    int32_t in_index, std::vector<DataPtr> in_items) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send downloads::mojom::Page::InsertItems", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("items"), in_items,
                        "<value of type std::vector<DataPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kInsertItems), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::Page_InsertItems_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->items)::BaseType>
      items_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::downloads::mojom::DataDataView>>(
    in_items,
    items_fragment,
    &items_validate_params);

  params->items.Set(
      items_fragment.is_null() ? nullptr : items_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->items.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null items in Page.InsertItems request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("InsertItems");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ClearAll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send downloads::mojom::Page::ClearAll");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kClearAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::downloads::mojom::internal::Page_ClearAll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ClearAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kRemoveItem: {
      DCHECK(message->is_serialized());
      internal::Page_RemoveItem_Params_Data* params =
          reinterpret_cast<internal::Page_RemoveItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      int32_t p_index{};
      Page_RemoveItem_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveItem(        
        std::move(p_index));
      return true;
    }
    case messages::Page::kUpdateItem: {
      DCHECK(message->is_serialized());
      internal::Page_UpdateItem_Params_Data* params =
          reinterpret_cast<internal::Page_UpdateItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      int32_t p_index{};
      DataPtr p_data{};
      Page_UpdateItem_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateItem(        
        std::move(p_index), 
        std::move(p_data));
      return true;
    }
    case messages::Page::kInsertItems: {
      DCHECK(message->is_serialized());
      internal::Page_InsertItems_Params_Data* params =
          reinterpret_cast<internal::Page_InsertItems_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      int32_t p_index{};
      std::vector<DataPtr> p_items{};
      Page_InsertItems_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadItems(&p_items))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InsertItems(        
        std::move(p_index), 
        std::move(p_items));
      return true;
    }
    case messages::Page::kClearAll: {
      DCHECK(message->is_serialized());
      internal::Page_ClearAll_Params_Data* params =
          reinterpret_cast<internal::Page_ClearAll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      Page_ClearAll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearAll(        );
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kRemoveItem: {
      break;
    }
    case messages::Page::kUpdateItem: {
      break;
    }
    case messages::Page::kInsertItems: {
      break;
    }
    case messages::Page::kClearAll: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_RemoveItem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_UpdateItem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_InsertItems_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ClearAll_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::downloads::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // downloads::mojom


namespace mojo {


// static
bool StructTraits<::downloads::mojom::Data::DataView, ::downloads::mojom::DataPtr>::Read(
    ::downloads::mojom::Data::DataView input,
    ::downloads::mojom::DataPtr* output) {
  bool success = true;
  ::downloads::mojom::DataPtr result(::downloads::mojom::Data::New());
  
      if (success)
        result->file_externally_removed = input.file_externally_removed();
      if (success)
        result->is_dangerous = input.is_dangerous();
      if (success)
        result->is_insecure = input.is_insecure();
      if (success)
        result->is_reviewable = input.is_reviewable();
      if (success)
        result->otr = input.otr();
      if (success)
        result->resume = input.resume();
      if (success)
        result->retry = input.retry();
      if (success)
        result->percent = input.percent();
      if (success)
        result->started = input.started();
      if (success)
        result->total = input.total();
      if (success && !input.ReadByExtId(&result->by_ext_id))
        success = false;
      if (success && !input.ReadByExtName(&result->by_ext_name))
        success = false;
      if (success && !input.ReadDangerType(&result->danger_type))
        success = false;
      if (success && !input.ReadTailoredWarningType(&result->tailored_warning_type))
        success = false;
      if (success && !input.ReadDateString(&result->date_string))
        success = false;
      if (success && !input.ReadFileName(&result->file_name))
        success = false;
      if (success && !input.ReadFilePath(&result->file_path))
        success = false;
      if (success && !input.ReadFileUrl(&result->file_url))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadLastReasonText(&result->last_reason_text))
        success = false;
      if (success && !input.ReadProgressStatusText(&result->progress_status_text))
        success = false;
      if (success && !input.ReadShowInFolderText(&result->show_in_folder_text))
        success = false;
      if (success && !input.ReadSinceString(&result->since_string))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success && !input.ReadDisplayInitiatorOrigin(&result->display_initiator_origin))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadDisplayUrl(&result->display_url))
        success = false;
      if (success && !input.ReadSafeBrowsingState(&result->safe_browsing_state))
        success = false;
      if (success)
        result->has_safe_browsing_verdict = input.has_safe_browsing_verdict();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace downloads::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetDownloads(const std::vector<std::string>& search_terms) {
  GetForwardingInterface()->GetDownloads(
    std::move(search_terms)
    );
}
void PageHandlerInterceptorForTesting::OpenFileRequiringGesture(const std::string& id) {
  GetForwardingInterface()->OpenFileRequiringGesture(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::Drag(const std::string& id) {
  GetForwardingInterface()->Drag(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::SaveSuspiciousRequiringGesture(const std::string& id) {
  GetForwardingInterface()->SaveSuspiciousRequiringGesture(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::RecordOpenBypassWarningDialog(const std::string& id) {
  GetForwardingInterface()->RecordOpenBypassWarningDialog(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::SaveDangerousFromDialogRequiringGesture(const std::string& id) {
  GetForwardingInterface()->SaveDangerousFromDialogRequiringGesture(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::RecordCancelBypassWarningDialog(const std::string& id) {
  GetForwardingInterface()->RecordCancelBypassWarningDialog(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::DiscardDangerous(const std::string& id) {
  GetForwardingInterface()->DiscardDangerous(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::RetryDownload(const std::string& id) {
  GetForwardingInterface()->RetryDownload(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::Show(const std::string& id) {
  GetForwardingInterface()->Show(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::Pause(const std::string& id) {
  GetForwardingInterface()->Pause(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::Resume(const std::string& id) {
  GetForwardingInterface()->Resume(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::Remove(const std::string& id) {
  GetForwardingInterface()->Remove(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::Undo() {
  GetForwardingInterface()->Undo();
}
void PageHandlerInterceptorForTesting::Cancel(const std::string& id) {
  GetForwardingInterface()->Cancel(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::ClearAll() {
  GetForwardingInterface()->ClearAll();
}
void PageHandlerInterceptorForTesting::OpenDownloadsFolderRequiringGesture() {
  GetForwardingInterface()->OpenDownloadsFolderRequiringGesture();
}
void PageHandlerInterceptorForTesting::OpenEsbSettings() {
  GetForwardingInterface()->OpenEsbSettings();
}
void PageHandlerInterceptorForTesting::LogEsbPromotionRowViewed() {
  GetForwardingInterface()->LogEsbPromotionRowViewed();
}
void PageHandlerInterceptorForTesting::OpenDuringScanningRequiringGesture(const std::string& id) {
  GetForwardingInterface()->OpenDuringScanningRequiringGesture(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::ReviewDangerousRequiringGesture(const std::string& id) {
  GetForwardingInterface()->ReviewDangerousRequiringGesture(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::DeepScan(const std::string& id) {
  GetForwardingInterface()->DeepScan(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::BypassDeepScanRequiringGesture(const std::string& id) {
  GetForwardingInterface()->BypassDeepScanRequiringGesture(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::IsEligibleForEsbPromo(IsEligibleForEsbPromoCallback callback) {
  GetForwardingInterface()->IsEligibleForEsbPromo(std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::IsEligibleForEsbPromo(
    bool* out_result) {
  base::RunLoop loop;
  proxy_->IsEligibleForEsbPromo(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool PageHandlerAsyncWaiter::IsEligibleForEsbPromo(
    ) {
  bool async_wait_result;
  IsEligibleForEsbPromo(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::RemoveItem(int32_t index) {
  GetForwardingInterface()->RemoveItem(
    std::move(index)
    );
}
void PageInterceptorForTesting::UpdateItem(int32_t index, DataPtr data) {
  GetForwardingInterface()->UpdateItem(
    std::move(index)
    , 
    std::move(data)
    );
}
void PageInterceptorForTesting::InsertItems(int32_t index, std::vector<DataPtr> items) {
  GetForwardingInterface()->InsertItems(
    std::move(index)
    , 
    std::move(items)
    );
}
void PageInterceptorForTesting::ClearAll() {
  GetForwardingInterface()->ClearAll();
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // downloads::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif