// chrome/browser/ui/webui/discards/site_data.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/discards/site_data.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/discards/site_data.mojom-params-data.h"
#include "chrome/browser/ui/webui/discards/site_data.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/discards/site_data.mojom-import-headers.h"
#include "chrome/browser/ui/webui/discards/site_data.mojom-test-utils.h"


namespace discards::mojom {
SiteDataFeature::SiteDataFeature()
    : observation_duration(),
      use_timestamp() {}

SiteDataFeature::SiteDataFeature(
    int64_t observation_duration_in,
    int64_t use_timestamp_in)
    : observation_duration(std::move(observation_duration_in)),
      use_timestamp(std::move(use_timestamp_in)) {}

SiteDataFeature::~SiteDataFeature() = default;
size_t SiteDataFeature::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->observation_duration);
  seed = mojo::internal::Hash(seed, this->use_timestamp);
  return seed;
}

void SiteDataFeature::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "observation_duration"), this->observation_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_timestamp"), this->use_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteDataFeature::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SiteDataPerformanceMeasurement::SiteDataPerformanceMeasurement()
    : avg_cpu_usage_us(),
      avg_footprint_kb(),
      avg_load_duration_us() {}

SiteDataPerformanceMeasurement::SiteDataPerformanceMeasurement(
    float avg_cpu_usage_us_in,
    float avg_footprint_kb_in,
    float avg_load_duration_us_in)
    : avg_cpu_usage_us(std::move(avg_cpu_usage_us_in)),
      avg_footprint_kb(std::move(avg_footprint_kb_in)),
      avg_load_duration_us(std::move(avg_load_duration_us_in)) {}

SiteDataPerformanceMeasurement::~SiteDataPerformanceMeasurement() = default;
size_t SiteDataPerformanceMeasurement::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->avg_cpu_usage_us);
  seed = mojo::internal::Hash(seed, this->avg_footprint_kb);
  seed = mojo::internal::Hash(seed, this->avg_load_duration_us);
  return seed;
}

void SiteDataPerformanceMeasurement::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "avg_cpu_usage_us"), this->avg_cpu_usage_us,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "avg_footprint_kb"), this->avg_footprint_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "avg_load_duration_us"), this->avg_load_duration_us,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteDataPerformanceMeasurement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SiteDataDatabaseSize::SiteDataDatabaseSize()
    : num_rows(),
      on_disk_size_kb() {}

SiteDataDatabaseSize::SiteDataDatabaseSize(
    int64_t num_rows_in,
    int64_t on_disk_size_kb_in)
    : num_rows(std::move(num_rows_in)),
      on_disk_size_kb(std::move(on_disk_size_kb_in)) {}

SiteDataDatabaseSize::~SiteDataDatabaseSize() = default;
size_t SiteDataDatabaseSize::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->num_rows);
  seed = mojo::internal::Hash(seed, this->on_disk_size_kb);
  return seed;
}

void SiteDataDatabaseSize::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_rows"), this->num_rows,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "on_disk_size_kb"), this->on_disk_size_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteDataDatabaseSize::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SiteDataValue::SiteDataValue()
    : last_loaded(),
      updates_favicon_in_background(),
      updates_title_in_background(),
      uses_audio_in_background(),
      load_time_estimates() {}

SiteDataValue::SiteDataValue(
    uint32_t last_loaded_in,
    SiteDataFeaturePtr updates_favicon_in_background_in,
    SiteDataFeaturePtr updates_title_in_background_in,
    SiteDataFeaturePtr uses_audio_in_background_in,
    SiteDataPerformanceMeasurementPtr load_time_estimates_in)
    : last_loaded(std::move(last_loaded_in)),
      updates_favicon_in_background(std::move(updates_favicon_in_background_in)),
      updates_title_in_background(std::move(updates_title_in_background_in)),
      uses_audio_in_background(std::move(uses_audio_in_background_in)),
      load_time_estimates(std::move(load_time_estimates_in)) {}

SiteDataValue::~SiteDataValue() = default;

void SiteDataValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_loaded"), this->last_loaded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updates_favicon_in_background"), this->updates_favicon_in_background,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SiteDataFeaturePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updates_title_in_background"), this->updates_title_in_background,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SiteDataFeaturePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uses_audio_in_background"), this->uses_audio_in_background,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SiteDataFeaturePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_time_estimates"), this->load_time_estimates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SiteDataPerformanceMeasurementPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteDataValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SiteDataEntry::SiteDataEntry()
    : origin(),
      is_dirty(),
      value() {}

SiteDataEntry::SiteDataEntry(
    const std::string& origin_in,
    bool is_dirty_in,
    SiteDataValuePtr value_in)
    : origin(std::move(origin_in)),
      is_dirty(std::move(is_dirty_in)),
      value(std::move(value_in)) {}

SiteDataEntry::~SiteDataEntry() = default;

void SiteDataEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_dirty"), this->is_dirty,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SiteDataValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteDataEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SiteDataArray::SiteDataArray()
    : db_rows() {}

SiteDataArray::SiteDataArray(
    std::vector<SiteDataEntryPtr> db_rows_in)
    : db_rows(std::move(db_rows_in)) {}

SiteDataArray::~SiteDataArray() = default;

void SiteDataArray::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "db_rows"), this->db_rows,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SiteDataEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteDataArray::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SiteDataProvider::IPCStableHashFunction SiteDataProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SiteDataProvider>(message.name())) {
    case messages::SiteDataProvider::kGetSiteDataArray: {
      return &SiteDataProvider::GetSiteDataArray_Sym::IPCStableHash;
    }
    case messages::SiteDataProvider::kGetSiteDataDatabaseSize: {
      return &SiteDataProvider::GetSiteDataDatabaseSize_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SiteDataProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SiteDataProvider>(message.name())) {
      case messages::SiteDataProvider::kGetSiteDataArray:
            return "Receive discards::mojom::SiteDataProvider::GetSiteDataArray";
      case messages::SiteDataProvider::kGetSiteDataDatabaseSize:
            return "Receive discards::mojom::SiteDataProvider::GetSiteDataDatabaseSize";
    }
  } else {
    switch (static_cast<messages::SiteDataProvider>(message.name())) {
      case messages::SiteDataProvider::kGetSiteDataArray:
            return "Receive reply discards::mojom::SiteDataProvider::GetSiteDataArray";
      case messages::SiteDataProvider::kGetSiteDataDatabaseSize:
            return "Receive reply discards::mojom::SiteDataProvider::GetSiteDataDatabaseSize";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SiteDataProvider::GetSiteDataArray_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x877dd0de;  // IPCStableHash for discards::mojom::SiteDataProvider::GetSiteDataArray
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SiteDataProvider::GetSiteDataDatabaseSize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe29d3388;  // IPCStableHash for discards::mojom::SiteDataProvider::GetSiteDataDatabaseSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SiteDataProvider_GetSiteDataArray_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SiteDataProvider_GetSiteDataArray_ForwardToCallback(
      SiteDataProvider::GetSiteDataArrayCallback callback
      ) : callback_(std::move(callback)) {
  }

  SiteDataProvider_GetSiteDataArray_ForwardToCallback(const SiteDataProvider_GetSiteDataArray_ForwardToCallback&) = delete;
  SiteDataProvider_GetSiteDataArray_ForwardToCallback& operator=(const SiteDataProvider_GetSiteDataArray_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SiteDataProvider::GetSiteDataArrayCallback callback_;
};

class SiteDataProvider_GetSiteDataDatabaseSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SiteDataProvider_GetSiteDataDatabaseSize_ForwardToCallback(
      SiteDataProvider::GetSiteDataDatabaseSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  SiteDataProvider_GetSiteDataDatabaseSize_ForwardToCallback(const SiteDataProvider_GetSiteDataDatabaseSize_ForwardToCallback&) = delete;
  SiteDataProvider_GetSiteDataDatabaseSize_ForwardToCallback& operator=(const SiteDataProvider_GetSiteDataDatabaseSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SiteDataProvider::GetSiteDataDatabaseSizeCallback callback_;
};

SiteDataProviderProxy::SiteDataProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SiteDataProviderProxy::GetSiteDataArray(
    const std::vector<std::string>& in_explicitly_requested_origins, GetSiteDataArrayCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::SiteDataProvider::GetSiteDataArray", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("explicitly_requested_origins"), in_explicitly_requested_origins,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SiteDataProvider::kGetSiteDataArray), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::SiteDataProvider_GetSiteDataArray_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->explicitly_requested_origins)::BaseType>
      explicitly_requested_origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& explicitly_requested_origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_explicitly_requested_origins,
    explicitly_requested_origins_fragment,
    &explicitly_requested_origins_validate_params);

  params->explicitly_requested_origins.Set(
      explicitly_requested_origins_fragment.is_null() ? nullptr : explicitly_requested_origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->explicitly_requested_origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null explicitly_requested_origins in SiteDataProvider.GetSiteDataArray request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SiteDataProvider::Name_);
  message.set_method_name("GetSiteDataArray");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SiteDataProvider_GetSiteDataArray_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SiteDataProviderProxy::GetSiteDataDatabaseSize(
    GetSiteDataDatabaseSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send discards::mojom::SiteDataProvider::GetSiteDataDatabaseSize");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SiteDataProvider::kGetSiteDataDatabaseSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::SiteDataProvider_GetSiteDataDatabaseSize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SiteDataProvider::Name_);
  message.set_method_name("GetSiteDataDatabaseSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SiteDataProvider_GetSiteDataDatabaseSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SiteDataProvider_GetSiteDataArray_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SiteDataProvider::GetSiteDataArrayCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SiteDataProvider_GetSiteDataArray_ProxyToResponder> proxy(
        new SiteDataProvider_GetSiteDataArray_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SiteDataProvider_GetSiteDataArray_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SiteDataProvider_GetSiteDataArray_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SiteDataProvider_GetSiteDataArray_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SiteDataProvider::GetSiteDataArrayCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SiteDataArrayPtr in_result);
};

bool SiteDataProvider_GetSiteDataArray_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SiteDataProvider_GetSiteDataArray_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SiteDataProvider_GetSiteDataArray_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SiteDataProvider.0
  bool success = true;
  SiteDataArrayPtr p_result{};
  SiteDataProvider_GetSiteDataArray_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SiteDataProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SiteDataProvider_GetSiteDataArray_ProxyToResponder::Run(
    SiteDataArrayPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply discards::mojom::SiteDataProvider::GetSiteDataArray", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SiteDataArrayPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SiteDataProvider::kGetSiteDataArray), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::SiteDataProvider_GetSiteDataArray_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::SiteDataArrayDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SiteDataProvider::Name_);
  message.set_method_name("GetSiteDataArray");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SiteDataProvider_GetSiteDataDatabaseSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SiteDataProvider::GetSiteDataDatabaseSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SiteDataProvider_GetSiteDataDatabaseSize_ProxyToResponder> proxy(
        new SiteDataProvider_GetSiteDataDatabaseSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SiteDataProvider_GetSiteDataDatabaseSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SiteDataProvider_GetSiteDataDatabaseSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SiteDataProvider_GetSiteDataDatabaseSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SiteDataProvider::GetSiteDataDatabaseSizeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SiteDataDatabaseSizePtr in_db_size);
};

bool SiteDataProvider_GetSiteDataDatabaseSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SiteDataProvider_GetSiteDataDatabaseSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SiteDataProvider_GetSiteDataDatabaseSize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SiteDataProvider.1
  bool success = true;
  SiteDataDatabaseSizePtr p_db_size{};
  SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDbSize(&p_db_size))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SiteDataProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_db_size));
  }
  return true;
}

void SiteDataProvider_GetSiteDataDatabaseSize_ProxyToResponder::Run(
    SiteDataDatabaseSizePtr in_db_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply discards::mojom::SiteDataProvider::GetSiteDataDatabaseSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("db_size"), in_db_size,
                        "<value of type SiteDataDatabaseSizePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SiteDataProvider::kGetSiteDataDatabaseSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::SiteDataProvider_GetSiteDataDatabaseSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->db_size)::BaseType> db_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::SiteDataDatabaseSizeDataView>(
    in_db_size,
    db_size_fragment);

  params->db_size.Set(
      db_size_fragment.is_null() ? nullptr : db_size_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SiteDataProvider::Name_);
  message.set_method_name("GetSiteDataDatabaseSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SiteDataProviderStubDispatch::Accept(
    SiteDataProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SiteDataProvider>(message->header()->name)) {
    case messages::SiteDataProvider::kGetSiteDataArray: {
      break;
    }
    case messages::SiteDataProvider::kGetSiteDataDatabaseSize: {
      break;
    }
  }
  return false;
}

// static
bool SiteDataProviderStubDispatch::AcceptWithResponder(
    SiteDataProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SiteDataProvider>(message->header()->name)) {
    case messages::SiteDataProvider::kGetSiteDataArray: {
      internal::SiteDataProvider_GetSiteDataArray_Params_Data* params =
          reinterpret_cast<
              internal::SiteDataProvider_GetSiteDataArray_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SiteDataProvider.0
      bool success = true;
      std::vector<std::string> p_explicitly_requested_origins{};
      SiteDataProvider_GetSiteDataArray_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExplicitlyRequestedOrigins(&p_explicitly_requested_origins))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SiteDataProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          SiteDataProvider_GetSiteDataArray_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSiteDataArray(        
        std::move(p_explicitly_requested_origins), std::move(callback));
      return true;
    }
    case messages::SiteDataProvider::kGetSiteDataDatabaseSize: {
      internal::SiteDataProvider_GetSiteDataDatabaseSize_Params_Data* params =
          reinterpret_cast<
              internal::SiteDataProvider_GetSiteDataDatabaseSize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SiteDataProvider.1
      bool success = true;
      SiteDataProvider_GetSiteDataDatabaseSize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SiteDataProvider::Name_, 1, false);
        return false;
      }
      auto callback =
          SiteDataProvider_GetSiteDataDatabaseSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSiteDataDatabaseSize(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSiteDataProviderValidationInfo[] = {
    { &internal::SiteDataProvider_GetSiteDataArray_Params_Data::Validate,
     &internal::SiteDataProvider_GetSiteDataArray_ResponseParams_Data::Validate},
    { &internal::SiteDataProvider_GetSiteDataDatabaseSize_Params_Data::Validate,
     &internal::SiteDataProvider_GetSiteDataDatabaseSize_ResponseParams_Data::Validate},
};

bool SiteDataProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::discards::mojom::SiteDataProvider::Name_,
    kSiteDataProviderValidationInfo);
}

bool SiteDataProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::discards::mojom::SiteDataProvider::Name_,
    kSiteDataProviderValidationInfo);
}


}  // discards::mojom


namespace mojo {


// static
bool StructTraits<::discards::mojom::SiteDataFeature::DataView, ::discards::mojom::SiteDataFeaturePtr>::Read(
    ::discards::mojom::SiteDataFeature::DataView input,
    ::discards::mojom::SiteDataFeaturePtr* output) {
  bool success = true;
  ::discards::mojom::SiteDataFeaturePtr result(::discards::mojom::SiteDataFeature::New());
  
      if (success)
        result->observation_duration = input.observation_duration();
      if (success)
        result->use_timestamp = input.use_timestamp();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::SiteDataPerformanceMeasurement::DataView, ::discards::mojom::SiteDataPerformanceMeasurementPtr>::Read(
    ::discards::mojom::SiteDataPerformanceMeasurement::DataView input,
    ::discards::mojom::SiteDataPerformanceMeasurementPtr* output) {
  bool success = true;
  ::discards::mojom::SiteDataPerformanceMeasurementPtr result(::discards::mojom::SiteDataPerformanceMeasurement::New());
  
      if (success)
        result->avg_cpu_usage_us = input.avg_cpu_usage_us();
      if (success)
        result->avg_footprint_kb = input.avg_footprint_kb();
      if (success)
        result->avg_load_duration_us = input.avg_load_duration_us();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::SiteDataDatabaseSize::DataView, ::discards::mojom::SiteDataDatabaseSizePtr>::Read(
    ::discards::mojom::SiteDataDatabaseSize::DataView input,
    ::discards::mojom::SiteDataDatabaseSizePtr* output) {
  bool success = true;
  ::discards::mojom::SiteDataDatabaseSizePtr result(::discards::mojom::SiteDataDatabaseSize::New());
  
      if (success)
        result->num_rows = input.num_rows();
      if (success)
        result->on_disk_size_kb = input.on_disk_size_kb();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::SiteDataValue::DataView, ::discards::mojom::SiteDataValuePtr>::Read(
    ::discards::mojom::SiteDataValue::DataView input,
    ::discards::mojom::SiteDataValuePtr* output) {
  bool success = true;
  ::discards::mojom::SiteDataValuePtr result(::discards::mojom::SiteDataValue::New());
  
      if (success)
        result->last_loaded = input.last_loaded();
      if (success && !input.ReadUpdatesFaviconInBackground(&result->updates_favicon_in_background))
        success = false;
      if (success && !input.ReadUpdatesTitleInBackground(&result->updates_title_in_background))
        success = false;
      if (success && !input.ReadUsesAudioInBackground(&result->uses_audio_in_background))
        success = false;
      if (success && !input.ReadLoadTimeEstimates(&result->load_time_estimates))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::SiteDataEntry::DataView, ::discards::mojom::SiteDataEntryPtr>::Read(
    ::discards::mojom::SiteDataEntry::DataView input,
    ::discards::mojom::SiteDataEntryPtr* output) {
  bool success = true;
  ::discards::mojom::SiteDataEntryPtr result(::discards::mojom::SiteDataEntry::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->is_dirty = input.is_dirty();
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::SiteDataArray::DataView, ::discards::mojom::SiteDataArrayPtr>::Read(
    ::discards::mojom::SiteDataArray::DataView input,
    ::discards::mojom::SiteDataArrayPtr* output) {
  bool success = true;
  ::discards::mojom::SiteDataArrayPtr result(::discards::mojom::SiteDataArray::New());
  
      if (success && !input.ReadDbRows(&result->db_rows))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace discards::mojom {


void SiteDataProviderInterceptorForTesting::GetSiteDataArray(const std::vector<std::string>& explicitly_requested_origins, GetSiteDataArrayCallback callback) {
  GetForwardingInterface()->GetSiteDataArray(
    std::move(explicitly_requested_origins)
    , std::move(callback));
}
void SiteDataProviderInterceptorForTesting::GetSiteDataDatabaseSize(GetSiteDataDatabaseSizeCallback callback) {
  GetForwardingInterface()->GetSiteDataDatabaseSize(std::move(callback));
}
SiteDataProviderAsyncWaiter::SiteDataProviderAsyncWaiter(
    SiteDataProvider* proxy) : proxy_(proxy) {}

SiteDataProviderAsyncWaiter::~SiteDataProviderAsyncWaiter() = default;


void SiteDataProviderAsyncWaiter::GetSiteDataArray(
    const std::vector<std::string>& explicitly_requested_origins, SiteDataArrayPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetSiteDataArray(
      std::move(explicitly_requested_origins),
      base::BindOnce(
          [](base::RunLoop* loop,
             SiteDataArrayPtr* out_result
,
             SiteDataArrayPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SiteDataArrayPtr SiteDataProviderAsyncWaiter::GetSiteDataArray(
    const std::vector<std::string>& explicitly_requested_origins) {
  SiteDataArrayPtr async_wait_result;
  GetSiteDataArray(std::move(explicitly_requested_origins),&async_wait_result);
  return async_wait_result;
}

void SiteDataProviderAsyncWaiter::GetSiteDataDatabaseSize(
    SiteDataDatabaseSizePtr* out_db_size) {
  base::RunLoop loop;
  proxy_->GetSiteDataDatabaseSize(
      base::BindOnce(
          [](base::RunLoop* loop,
             SiteDataDatabaseSizePtr* out_db_size
,
             SiteDataDatabaseSizePtr db_size) {*out_db_size = std::move(db_size);
            loop->Quit();
          },
          &loop,
          out_db_size));
  loop.Run();
}

SiteDataDatabaseSizePtr SiteDataProviderAsyncWaiter::GetSiteDataDatabaseSize(
    ) {
  SiteDataDatabaseSizePtr async_wait_result;
  GetSiteDataDatabaseSize(&async_wait_result);
  return async_wait_result;
}






}  // discards::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif