// chrome/browser/ui/webui/discards/site_data.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';








export type SiteDataProviderPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<SiteDataProviderPendingReceiver>;

export class SiteDataProviderPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<SiteDataProvider> {

  handle: mojo.internal.interfaceSupport.Endpoint<SiteDataProviderPendingReceiver>;
  constructor(handle: MojoHandle|SiteDataProviderPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'discards.mojom.SiteDataProvider',
        scope);
  }
}

export interface SiteDataProviderInterface {
  getSiteDataArray(explicitlyRequestedOrigins: string[]): Promise<{
        result: (SiteDataArray | null), }>;
  getSiteDataDatabaseSize(): Promise<{
        dbSize: (SiteDataDatabaseSize | null), }>;
}

export class SiteDataProviderRemote implements SiteDataProviderInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<SiteDataProviderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<SiteDataProviderPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|SiteDataProviderPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SiteDataProviderPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getSiteDataArray(
      explicitlyRequestedOrigins: string[]): Promise<{
        result: (SiteDataArray | null), }> {
    return this.proxy.sendMessage(
        0,
        SiteDataProvider_GetSiteDataArray_ParamsSpec.$,
        SiteDataProvider_GetSiteDataArray_ResponseParamsSpec.$,
        [
          explicitlyRequestedOrigins
        ],
        false);
  }

  getSiteDataDatabaseSize(): Promise<{
        dbSize: (SiteDataDatabaseSize | null), }> {
    return this.proxy.sendMessage(
        1,
        SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec.$,
        SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SiteDataProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SiteDataProviderReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    SiteDataProviderRemote, SiteDataProviderPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    SiteDataProviderRemote, SiteDataProviderPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: SiteDataProviderInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SiteDataProviderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SiteDataProvider_GetSiteDataArray_ParamsSpec.$,
        SiteDataProvider_GetSiteDataArray_ResponseParamsSpec.$,
        impl.getSiteDataArray.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec.$,
        SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec.$,
        impl.getSiteDataDatabaseSize.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SiteDataProvider {
  static get $interfaceName(): string {
    return "discards.mojom.SiteDataProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): SiteDataProviderRemote {
    let remote = new SiteDataProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the SiteDataProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SiteDataProviderCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    SiteDataProviderRemote, SiteDataProviderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    SiteDataProviderRemote, SiteDataProviderPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getSiteDataArray: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSiteDataDatabaseSize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SiteDataProviderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getSiteDataArray =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SiteDataProvider_GetSiteDataArray_ParamsSpec.$,
        SiteDataProvider_GetSiteDataArray_ResponseParamsSpec.$,
        this.getSiteDataArray.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getSiteDataDatabaseSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec.$,
        SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec.$,
        this.getSiteDataDatabaseSize.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const SiteDataFeatureSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataPerformanceMeasurementSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataDatabaseSizeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataValueSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataEntrySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataArraySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataProvider_GetSiteDataArray_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataProvider_GetSiteDataArray_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface SiteDataFeatureMojoType {
  observationDuration: bigint;
  useTimestamp: bigint;
}


export type SiteDataFeature = SiteDataFeatureMojoType;
mojo.internal.Struct<SiteDataFeatureMojoType>(
    SiteDataFeatureSpec.$,
    'SiteDataFeature',
    [
      mojo.internal.StructField<SiteDataFeatureMojoType, bigint>(
        'observationDuration', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataFeatureMojoType, bigint>(
        'useTimestamp', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SiteDataPerformanceMeasurementMojoType {
  avgCpuUsageUs: number;
  avgFootprintKb: number;
  avgLoadDurationUs: number;
}


export type SiteDataPerformanceMeasurement = SiteDataPerformanceMeasurementMojoType;
mojo.internal.Struct<SiteDataPerformanceMeasurementMojoType>(
    SiteDataPerformanceMeasurementSpec.$,
    'SiteDataPerformanceMeasurement',
    [
      mojo.internal.StructField<SiteDataPerformanceMeasurementMojoType, number>(
        'avgCpuUsageUs', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataPerformanceMeasurementMojoType, number>(
        'avgFootprintKb', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataPerformanceMeasurementMojoType, number>(
        'avgLoadDurationUs', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SiteDataDatabaseSizeMojoType {
  numRows: bigint;
  onDiskSizeKb: bigint;
}


export type SiteDataDatabaseSize = SiteDataDatabaseSizeMojoType;
mojo.internal.Struct<SiteDataDatabaseSizeMojoType>(
    SiteDataDatabaseSizeSpec.$,
    'SiteDataDatabaseSize',
    [
      mojo.internal.StructField<SiteDataDatabaseSizeMojoType, bigint>(
        'numRows', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataDatabaseSizeMojoType, bigint>(
        'onDiskSizeKb', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SiteDataValueMojoType {
  lastLoaded: number;
  updatesFaviconInBackground: SiteDataFeature;
  updatesTitleInBackground: SiteDataFeature;
  usesAudioInBackground: SiteDataFeature;
  loadTimeEstimates: (SiteDataPerformanceMeasurement | null);
}


export type SiteDataValue = SiteDataValueMojoType;
mojo.internal.Struct<SiteDataValueMojoType>(
    SiteDataValueSpec.$,
    'SiteDataValue',
    [
      mojo.internal.StructField<SiteDataValueMojoType, number>(
        'lastLoaded', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataValueMojoType, SiteDataFeature>(
        'updatesFaviconInBackground', 8,
        0,
        SiteDataFeatureSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataValueMojoType, SiteDataFeature>(
        'updatesTitleInBackground', 16,
        0,
        SiteDataFeatureSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataValueMojoType, SiteDataFeature>(
        'usesAudioInBackground', 24,
        0,
        SiteDataFeatureSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataValueMojoType, SiteDataPerformanceMeasurement>(
        'loadTimeEstimates', 32,
        0,
        SiteDataPerformanceMeasurementSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface SiteDataEntryMojoType {
  origin: string;
  isDirty: boolean;
  value: (SiteDataValue | null);
}


export type SiteDataEntry = SiteDataEntryMojoType;
mojo.internal.Struct<SiteDataEntryMojoType>(
    SiteDataEntrySpec.$,
    'SiteDataEntry',
    [
      mojo.internal.StructField<SiteDataEntryMojoType, string>(
        'origin', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataEntryMojoType, boolean>(
        'isDirty', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteDataEntryMojoType, SiteDataValue>(
        'value', 16,
        0,
        SiteDataValueSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface SiteDataArrayMojoType {
  dbRows: SiteDataEntry[];
}


export type SiteDataArray = SiteDataArrayMojoType;
mojo.internal.Struct<SiteDataArrayMojoType>(
    SiteDataArraySpec.$,
    'SiteDataArray',
    [
      mojo.internal.StructField<SiteDataArrayMojoType, SiteDataEntry[]>(
        'dbRows', 0,
        0,
        mojo.internal.Array(SiteDataEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface SiteDataProvider_GetSiteDataArray_ParamsMojoType {
  explicitlyRequestedOrigins: string[];
}


export type SiteDataProvider_GetSiteDataArray_Params = SiteDataProvider_GetSiteDataArray_ParamsMojoType;
mojo.internal.Struct<SiteDataProvider_GetSiteDataArray_ParamsMojoType>(
    SiteDataProvider_GetSiteDataArray_ParamsSpec.$,
    'SiteDataProvider_GetSiteDataArray_Params',
    [
      mojo.internal.StructField<SiteDataProvider_GetSiteDataArray_ParamsMojoType, string[]>(
        'explicitlyRequestedOrigins', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface SiteDataProvider_GetSiteDataArray_ResponseParamsMojoType {
  result: (SiteDataArray | null);
}


export type SiteDataProvider_GetSiteDataArray_ResponseParams = SiteDataProvider_GetSiteDataArray_ResponseParamsMojoType;
mojo.internal.Struct<SiteDataProvider_GetSiteDataArray_ResponseParamsMojoType>(
    SiteDataProvider_GetSiteDataArray_ResponseParamsSpec.$,
    'SiteDataProvider_GetSiteDataArray_ResponseParams',
    [
      mojo.internal.StructField<SiteDataProvider_GetSiteDataArray_ResponseParamsMojoType, SiteDataArray>(
        'result', 0,
        0,
        SiteDataArraySpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface SiteDataProvider_GetSiteDataDatabaseSize_ParamsMojoType {
}


export type SiteDataProvider_GetSiteDataDatabaseSize_Params = SiteDataProvider_GetSiteDataDatabaseSize_ParamsMojoType;
mojo.internal.Struct<SiteDataProvider_GetSiteDataDatabaseSize_ParamsMojoType>(
    SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec.$,
    'SiteDataProvider_GetSiteDataDatabaseSize_Params',
    [
    ],
    [[0, 8],]);





export interface SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsMojoType {
  dbSize: (SiteDataDatabaseSize | null);
}


export type SiteDataProvider_GetSiteDataDatabaseSize_ResponseParams = SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsMojoType;
mojo.internal.Struct<SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsMojoType>(
    SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec.$,
    'SiteDataProvider_GetSiteDataDatabaseSize_ResponseParams',
    [
      mojo.internal.StructField<SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsMojoType, SiteDataDatabaseSize>(
        'dbSize', 0,
        0,
        SiteDataDatabaseSizeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



