// chrome/browser/ui/webui/discards/site_data.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/webui/discards/site_data.mojom-shared-internal.h"


namespace discards::mojom {
class SiteDataFeatureDataView;

class SiteDataPerformanceMeasurementDataView;

class SiteDataDatabaseSizeDataView;

class SiteDataValueDataView;

class SiteDataEntryDataView;

class SiteDataArrayDataView;



}  // discards::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::discards::mojom::SiteDataFeatureDataView> {
  using Data = ::discards::mojom::internal::SiteDataFeature_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::SiteDataPerformanceMeasurementDataView> {
  using Data = ::discards::mojom::internal::SiteDataPerformanceMeasurement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::SiteDataDatabaseSizeDataView> {
  using Data = ::discards::mojom::internal::SiteDataDatabaseSize_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::SiteDataValueDataView> {
  using Data = ::discards::mojom::internal::SiteDataValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::SiteDataEntryDataView> {
  using Data = ::discards::mojom::internal::SiteDataEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::SiteDataArrayDataView> {
  using Data = ::discards::mojom::internal::SiteDataArray_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace discards::mojom {
// Interface base classes. They are used for type safety check.
class SiteDataProviderInterfaceBase {};

using SiteDataProviderPtrDataView =
    mojo::InterfacePtrDataView<SiteDataProviderInterfaceBase>;
using SiteDataProviderRequestDataView =
    mojo::InterfaceRequestDataView<SiteDataProviderInterfaceBase>;
using SiteDataProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SiteDataProviderInterfaceBase>;
using SiteDataProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SiteDataProviderInterfaceBase>;


class SiteDataFeatureDataView {
 public:
  SiteDataFeatureDataView() = default;

  SiteDataFeatureDataView(
      internal::SiteDataFeature_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t observation_duration() const {
    return data_->observation_duration;
  }
  int64_t use_timestamp() const {
    return data_->use_timestamp;
  }
 private:
  internal::SiteDataFeature_Data* data_ = nullptr;
};


class SiteDataPerformanceMeasurementDataView {
 public:
  SiteDataPerformanceMeasurementDataView() = default;

  SiteDataPerformanceMeasurementDataView(
      internal::SiteDataPerformanceMeasurement_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float avg_cpu_usage_us() const {
    return data_->avg_cpu_usage_us;
  }
  float avg_footprint_kb() const {
    return data_->avg_footprint_kb;
  }
  float avg_load_duration_us() const {
    return data_->avg_load_duration_us;
  }
 private:
  internal::SiteDataPerformanceMeasurement_Data* data_ = nullptr;
};


class SiteDataDatabaseSizeDataView {
 public:
  SiteDataDatabaseSizeDataView() = default;

  SiteDataDatabaseSizeDataView(
      internal::SiteDataDatabaseSize_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t num_rows() const {
    return data_->num_rows;
  }
  int64_t on_disk_size_kb() const {
    return data_->on_disk_size_kb;
  }
 private:
  internal::SiteDataDatabaseSize_Data* data_ = nullptr;
};


class SiteDataValueDataView {
 public:
  SiteDataValueDataView() = default;

  SiteDataValueDataView(
      internal::SiteDataValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t last_loaded() const {
    return data_->last_loaded;
  }
  inline void GetUpdatesFaviconInBackgroundDataView(
      SiteDataFeatureDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatesFaviconInBackground(UserType* output) {
    
    auto* pointer = data_->updates_favicon_in_background.Get();
    return mojo::internal::Deserialize<::discards::mojom::SiteDataFeatureDataView>(
        pointer, output, message_);
  }
  inline void GetUpdatesTitleInBackgroundDataView(
      SiteDataFeatureDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatesTitleInBackground(UserType* output) {
    
    auto* pointer = data_->updates_title_in_background.Get();
    return mojo::internal::Deserialize<::discards::mojom::SiteDataFeatureDataView>(
        pointer, output, message_);
  }
  inline void GetUsesAudioInBackgroundDataView(
      SiteDataFeatureDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsesAudioInBackground(UserType* output) {
    
    auto* pointer = data_->uses_audio_in_background.Get();
    return mojo::internal::Deserialize<::discards::mojom::SiteDataFeatureDataView>(
        pointer, output, message_);
  }
  inline void GetLoadTimeEstimatesDataView(
      SiteDataPerformanceMeasurementDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadTimeEstimates(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::discards::mojom::SiteDataPerformanceMeasurementDataView, UserType>(),
    "Attempting to read the optional `load_time_estimates` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLoadTimeEstimates` instead "
    "of `ReadLoadTimeEstimates if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->load_time_estimates.Get();
    return mojo::internal::Deserialize<::discards::mojom::SiteDataPerformanceMeasurementDataView>(
        pointer, output, message_);
  }
 private:
  internal::SiteDataValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SiteDataEntryDataView {
 public:
  SiteDataEntryDataView() = default;

  SiteDataEntryDataView(
      internal::SiteDataEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_dirty() const {
    return data_->is_dirty;
  }
  inline void GetValueDataView(
      SiteDataValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::discards::mojom::SiteDataValueDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::discards::mojom::SiteDataValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::SiteDataEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SiteDataArrayDataView {
 public:
  SiteDataArrayDataView() = default;

  SiteDataArrayDataView(
      internal::SiteDataArray_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDbRowsDataView(
      mojo::ArrayDataView<SiteDataEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDbRows(UserType* output) {
    
    auto* pointer = data_->db_rows.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::discards::mojom::SiteDataEntryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SiteDataArray_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // discards::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_DATA_VIEW_H_