// chrome/browser/ui/webui/app_home/app_home.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/app_home/app_home.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/app_home/app_home.mojom-params-data.h"
#include "chrome/browser/ui/webui/app_home/app_home.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/app_home/app_home.mojom-import-headers.h"
#include "chrome/browser/ui/webui/app_home/app_home.mojom-test-utils.h"


namespace app_home::mojom {
AppInfo::AppInfo()
    : app_type(),
      id(),
      start_url(),
      name(),
      icon_url(),
      may_show_run_on_os_login_mode(),
      may_toggle_run_on_os_login_mode(),
      run_on_os_login_mode(),
      is_locally_installed(),
      open_in_window(),
      may_uninstall(),
      store_page_url() {}

AppInfo::AppInfo(
    AppType app_type_in,
    const std::string& id_in,
    const ::GURL& start_url_in,
    const std::string& name_in,
    const ::GURL& icon_url_in,
    bool may_show_run_on_os_login_mode_in,
    bool may_toggle_run_on_os_login_mode_in,
    ::web_app::RunOnOsLoginMode run_on_os_login_mode_in,
    bool is_locally_installed_in,
    bool open_in_window_in,
    bool may_uninstall_in,
    const std::optional<::GURL>& store_page_url_in)
    : app_type(std::move(app_type_in)),
      id(std::move(id_in)),
      start_url(std::move(start_url_in)),
      name(std::move(name_in)),
      icon_url(std::move(icon_url_in)),
      may_show_run_on_os_login_mode(std::move(may_show_run_on_os_login_mode_in)),
      may_toggle_run_on_os_login_mode(std::move(may_toggle_run_on_os_login_mode_in)),
      run_on_os_login_mode(std::move(run_on_os_login_mode_in)),
      is_locally_installed(std::move(is_locally_installed_in)),
      open_in_window(std::move(open_in_window_in)),
      may_uninstall(std::move(may_uninstall_in)),
      store_page_url(std::move(store_page_url_in)) {}

AppInfo::~AppInfo() = default;

void AppInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_type"), this->app_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AppType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_url"), this->start_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_url"), this->icon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_show_run_on_os_login_mode"), this->may_show_run_on_os_login_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_toggle_run_on_os_login_mode"), this->may_toggle_run_on_os_login_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "run_on_os_login_mode"), this->run_on_os_login_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::web_app::RunOnOsLoginMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_locally_installed"), this->is_locally_installed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "open_in_window"), this->open_in_window,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_uninstall"), this->may_uninstall,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "store_page_url"), this->store_page_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AppInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClickEvent::ClickEvent()
    : button(),
      alt_key(),
      ctrl_key(),
      meta_key(),
      shift_key() {}

ClickEvent::ClickEvent(
    double button_in,
    bool alt_key_in,
    bool ctrl_key_in,
    bool meta_key_in,
    bool shift_key_in)
    : button(std::move(button_in)),
      alt_key(std::move(alt_key_in)),
      ctrl_key(std::move(ctrl_key_in)),
      meta_key(std::move(meta_key_in)),
      shift_key(std::move(shift_key_in)) {}

ClickEvent::~ClickEvent() = default;
size_t ClickEvent::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->button);
  seed = mojo::internal::Hash(seed, this->alt_key);
  seed = mojo::internal::Hash(seed, this->ctrl_key);
  seed = mojo::internal::Hash(seed, this->meta_key);
  seed = mojo::internal::Hash(seed, this->shift_key);
  return seed;
}

void ClickEvent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "button"), this->button,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alt_key"), this->alt_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ctrl_key"), this->ctrl_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta_key"), this->meta_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shift_key"), this->shift_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClickEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive app_home::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply app_home::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a5757fc;  // IPCStableHash for app_home::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::app_home::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::app_home::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::app_home::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetApps: {
      return &PageHandler::GetApps_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetDeprecationLinkString: {
      return &PageHandler::GetDeprecationLinkString_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUninstallApp: {
      return &PageHandler::UninstallApp_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowAppSettings: {
      return &PageHandler::ShowAppSettings_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCreateAppShortcut: {
      return &PageHandler::CreateAppShortcut_Sym::IPCStableHash;
    }
    case messages::PageHandler::kLaunchApp: {
      return &PageHandler::LaunchApp_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetRunOnOsLoginMode: {
      return &PageHandler::SetRunOnOsLoginMode_Sym::IPCStableHash;
    }
    case messages::PageHandler::kLaunchDeprecatedAppDialog: {
      return &PageHandler::LaunchDeprecatedAppDialog_Sym::IPCStableHash;
    }
    case messages::PageHandler::kInstallAppLocally: {
      return &PageHandler::InstallAppLocally_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetUserDisplayMode: {
      return &PageHandler::SetUserDisplayMode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetApps:
            return "Receive app_home::mojom::PageHandler::GetApps";
      case messages::PageHandler::kGetDeprecationLinkString:
            return "Receive app_home::mojom::PageHandler::GetDeprecationLinkString";
      case messages::PageHandler::kUninstallApp:
            return "Receive app_home::mojom::PageHandler::UninstallApp";
      case messages::PageHandler::kShowAppSettings:
            return "Receive app_home::mojom::PageHandler::ShowAppSettings";
      case messages::PageHandler::kCreateAppShortcut:
            return "Receive app_home::mojom::PageHandler::CreateAppShortcut";
      case messages::PageHandler::kLaunchApp:
            return "Receive app_home::mojom::PageHandler::LaunchApp";
      case messages::PageHandler::kSetRunOnOsLoginMode:
            return "Receive app_home::mojom::PageHandler::SetRunOnOsLoginMode";
      case messages::PageHandler::kLaunchDeprecatedAppDialog:
            return "Receive app_home::mojom::PageHandler::LaunchDeprecatedAppDialog";
      case messages::PageHandler::kInstallAppLocally:
            return "Receive app_home::mojom::PageHandler::InstallAppLocally";
      case messages::PageHandler::kSetUserDisplayMode:
            return "Receive app_home::mojom::PageHandler::SetUserDisplayMode";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetApps:
            return "Receive reply app_home::mojom::PageHandler::GetApps";
      case messages::PageHandler::kGetDeprecationLinkString:
            return "Receive reply app_home::mojom::PageHandler::GetDeprecationLinkString";
      case messages::PageHandler::kUninstallApp:
            return "Receive reply app_home::mojom::PageHandler::UninstallApp";
      case messages::PageHandler::kShowAppSettings:
            return "Receive reply app_home::mojom::PageHandler::ShowAppSettings";
      case messages::PageHandler::kCreateAppShortcut:
            return "Receive reply app_home::mojom::PageHandler::CreateAppShortcut";
      case messages::PageHandler::kLaunchApp:
            return "Receive reply app_home::mojom::PageHandler::LaunchApp";
      case messages::PageHandler::kSetRunOnOsLoginMode:
            return "Receive reply app_home::mojom::PageHandler::SetRunOnOsLoginMode";
      case messages::PageHandler::kLaunchDeprecatedAppDialog:
            return "Receive reply app_home::mojom::PageHandler::LaunchDeprecatedAppDialog";
      case messages::PageHandler::kInstallAppLocally:
            return "Receive reply app_home::mojom::PageHandler::InstallAppLocally";
      case messages::PageHandler::kSetUserDisplayMode:
            return "Receive reply app_home::mojom::PageHandler::SetUserDisplayMode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetApps_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9aa8c4eb;  // IPCStableHash for app_home::mojom::PageHandler::GetApps
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetDeprecationLinkString_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb52d5384;  // IPCStableHash for app_home::mojom::PageHandler::GetDeprecationLinkString
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UninstallApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe24743b;  // IPCStableHash for app_home::mojom::PageHandler::UninstallApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowAppSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafde6368;  // IPCStableHash for app_home::mojom::PageHandler::ShowAppSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CreateAppShortcut_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc977b95a;  // IPCStableHash for app_home::mojom::PageHandler::CreateAppShortcut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::LaunchApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x05187b74;  // IPCStableHash for app_home::mojom::PageHandler::LaunchApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetRunOnOsLoginMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac867333;  // IPCStableHash for app_home::mojom::PageHandler::SetRunOnOsLoginMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::LaunchDeprecatedAppDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x988b67a7;  // IPCStableHash for app_home::mojom::PageHandler::LaunchDeprecatedAppDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::InstallAppLocally_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4757a9b1;  // IPCStableHash for app_home::mojom::PageHandler::InstallAppLocally
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetUserDisplayMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc666430;  // IPCStableHash for app_home::mojom::PageHandler::SetUserDisplayMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetApps_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetApps_ForwardToCallback(
      PageHandler::GetAppsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetApps_ForwardToCallback(const PageHandler_GetApps_ForwardToCallback&) = delete;
  PageHandler_GetApps_ForwardToCallback& operator=(const PageHandler_GetApps_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAppsCallback callback_;
};

class PageHandler_GetDeprecationLinkString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetDeprecationLinkString_ForwardToCallback(
      PageHandler::GetDeprecationLinkStringCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetDeprecationLinkString_ForwardToCallback(const PageHandler_GetDeprecationLinkString_ForwardToCallback&) = delete;
  PageHandler_GetDeprecationLinkString_ForwardToCallback& operator=(const PageHandler_GetDeprecationLinkString_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetDeprecationLinkStringCallback callback_;
};

class PageHandler_CreateAppShortcut_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_CreateAppShortcut_ForwardToCallback(
      PageHandler::CreateAppShortcutCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_CreateAppShortcut_ForwardToCallback(const PageHandler_CreateAppShortcut_ForwardToCallback&) = delete;
  PageHandler_CreateAppShortcut_ForwardToCallback& operator=(const PageHandler_CreateAppShortcut_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::CreateAppShortcutCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetApps(
    GetAppsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send app_home::mojom::PageHandler::GetApps");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetApps), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_GetApps_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetApps");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetApps_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetDeprecationLinkString(
    GetDeprecationLinkStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send app_home::mojom::PageHandler::GetDeprecationLinkString");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDeprecationLinkString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_GetDeprecationLinkString_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDeprecationLinkString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetDeprecationLinkString_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::UninstallApp(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::PageHandler::UninstallApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUninstallApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_UninstallApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.UninstallApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UninstallApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowAppSettings(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::PageHandler::ShowAppSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowAppSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_ShowAppSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.ShowAppSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowAppSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::CreateAppShortcut(
    const std::string& in_app_id, CreateAppShortcutCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::PageHandler::CreateAppShortcut", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCreateAppShortcut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_CreateAppShortcut_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.CreateAppShortcut request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CreateAppShortcut");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_CreateAppShortcut_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::LaunchApp(
    const std::string& in_app_id, ClickEventPtr in_click_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::PageHandler::LaunchApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("click_event"), in_click_event,
                        "<value of type ClickEventPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLaunchApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_LaunchApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.LaunchApp request");
  mojo::internal::MessageFragment<
      typename decltype(params->click_event)::BaseType> click_event_fragment(
          params.message());
  
  mojo::internal::Serialize<::app_home::mojom::ClickEventDataView>(
    in_click_event,
    click_event_fragment);

  params->click_event.Set(
      click_event_fragment.is_null() ? nullptr : click_event_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LaunchApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetRunOnOsLoginMode(
    const std::string& in_app_id, ::web_app::RunOnOsLoginMode in_run_on_os_login_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::PageHandler::SetRunOnOsLoginMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("run_on_os_login_mode"), in_run_on_os_login_mode,
                        "<value of type ::web_app::RunOnOsLoginMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetRunOnOsLoginMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_SetRunOnOsLoginMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetRunOnOsLoginMode request");

  
  mojo::internal::Serialize<::app_home::mojom::RunOnOsLoginMode>(
    in_run_on_os_login_mode,
    &params->run_on_os_login_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetRunOnOsLoginMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::LaunchDeprecatedAppDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send app_home::mojom::PageHandler::LaunchDeprecatedAppDialog");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLaunchDeprecatedAppDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_LaunchDeprecatedAppDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LaunchDeprecatedAppDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::InstallAppLocally(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::PageHandler::InstallAppLocally", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kInstallAppLocally), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_InstallAppLocally_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.InstallAppLocally request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("InstallAppLocally");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetUserDisplayMode(
    const std::string& in_app_id, ::web_app::mojom::UserDisplayMode in_display_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::PageHandler::SetUserDisplayMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_mode"), in_display_mode,
                        "<value of type ::web_app::mojom::UserDisplayMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetUserDisplayMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_SetUserDisplayMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetUserDisplayMode request");

  
  mojo::internal::Serialize<::web_app::mojom::UserDisplayMode>(
    in_display_mode,
    &params->display_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetUserDisplayMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetApps_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAppsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetApps_ProxyToResponder> proxy(
        new PageHandler_GetApps_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetApps_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetApps_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetApps_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetAppsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AppInfoPtr> in_app_list);
};

bool PageHandler_GetApps_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetApps_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetApps_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  std::vector<AppInfoPtr> p_app_list{};
  PageHandler_GetApps_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAppList(&p_app_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_app_list));
  }
  return true;
}

void PageHandler_GetApps_ProxyToResponder::Run(
    std::vector<AppInfoPtr> in_app_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply app_home::mojom::PageHandler::GetApps", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_list"), in_app_list,
                        "<value of type std::vector<AppInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetApps), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_GetApps_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_list)::BaseType>
      app_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& app_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::app_home::mojom::AppInfoDataView>>(
    in_app_list,
    app_list_fragment,
    &app_list_validate_params);

  params->app_list.Set(
      app_list_fragment.is_null() ? nullptr : app_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_list in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetApps");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetDeprecationLinkString_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetDeprecationLinkStringCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetDeprecationLinkString_ProxyToResponder> proxy(
        new PageHandler_GetDeprecationLinkString_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetDeprecationLinkString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetDeprecationLinkString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetDeprecationLinkString_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetDeprecationLinkStringCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_link_string);
};

bool PageHandler_GetDeprecationLinkString_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetDeprecationLinkString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetDeprecationLinkString_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  std::string p_link_string{};
  PageHandler_GetDeprecationLinkString_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadLinkString(&p_link_string))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_link_string));
  }
  return true;
}

void PageHandler_GetDeprecationLinkString_ProxyToResponder::Run(
    const std::string& in_link_string) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply app_home::mojom::PageHandler::GetDeprecationLinkString", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("link_string"), in_link_string,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDeprecationLinkString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_GetDeprecationLinkString_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->link_string)::BaseType> link_string_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_link_string,
    link_string_fragment);

  params->link_string.Set(
      link_string_fragment.is_null() ? nullptr : link_string_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->link_string.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null link_string in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDeprecationLinkString");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_CreateAppShortcut_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::CreateAppShortcutCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_CreateAppShortcut_ProxyToResponder> proxy(
        new PageHandler_CreateAppShortcut_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_CreateAppShortcut_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_CreateAppShortcut_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_CreateAppShortcut_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::CreateAppShortcutCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PageHandler_CreateAppShortcut_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_CreateAppShortcut_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_CreateAppShortcut_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.4
  bool success = true;
  PageHandler_CreateAppShortcut_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PageHandler_CreateAppShortcut_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply app_home::mojom::PageHandler::CreateAppShortcut");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCreateAppShortcut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::PageHandler_CreateAppShortcut_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CreateAppShortcut");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetApps: {
      break;
    }
    case messages::PageHandler::kGetDeprecationLinkString: {
      break;
    }
    case messages::PageHandler::kUninstallApp: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UninstallApp_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UninstallApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      std::string p_app_id{};
      PageHandler_UninstallApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UninstallApp(        
        std::move(p_app_id));
      return true;
    }
    case messages::PageHandler::kShowAppSettings: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowAppSettings_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowAppSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::string p_app_id{};
      PageHandler_ShowAppSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowAppSettings(        
        std::move(p_app_id));
      return true;
    }
    case messages::PageHandler::kCreateAppShortcut: {
      break;
    }
    case messages::PageHandler::kLaunchApp: {
      DCHECK(message->is_serialized());
      internal::PageHandler_LaunchApp_Params_Data* params =
          reinterpret_cast<internal::PageHandler_LaunchApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      std::string p_app_id{};
      ClickEventPtr p_click_event{};
      PageHandler_LaunchApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadClickEvent(&p_click_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LaunchApp(        
        std::move(p_app_id), 
        std::move(p_click_event));
      return true;
    }
    case messages::PageHandler::kSetRunOnOsLoginMode: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetRunOnOsLoginMode_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetRunOnOsLoginMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      std::string p_app_id{};
      ::web_app::RunOnOsLoginMode p_run_on_os_login_mode{};
      PageHandler_SetRunOnOsLoginMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadRunOnOsLoginMode(&p_run_on_os_login_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRunOnOsLoginMode(        
        std::move(p_app_id), 
        std::move(p_run_on_os_login_mode));
      return true;
    }
    case messages::PageHandler::kLaunchDeprecatedAppDialog: {
      DCHECK(message->is_serialized());
      internal::PageHandler_LaunchDeprecatedAppDialog_Params_Data* params =
          reinterpret_cast<internal::PageHandler_LaunchDeprecatedAppDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      PageHandler_LaunchDeprecatedAppDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LaunchDeprecatedAppDialog(        );
      return true;
    }
    case messages::PageHandler::kInstallAppLocally: {
      DCHECK(message->is_serialized());
      internal::PageHandler_InstallAppLocally_Params_Data* params =
          reinterpret_cast<internal::PageHandler_InstallAppLocally_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      std::string p_app_id{};
      PageHandler_InstallAppLocally_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallAppLocally(        
        std::move(p_app_id));
      return true;
    }
    case messages::PageHandler::kSetUserDisplayMode: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetUserDisplayMode_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetUserDisplayMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      std::string p_app_id{};
      ::web_app::mojom::UserDisplayMode p_display_mode{};
      PageHandler_SetUserDisplayMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadDisplayMode(&p_display_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserDisplayMode(        
        std::move(p_app_id), 
        std::move(p_display_mode));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetApps: {
      internal::PageHandler_GetApps_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetApps_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetApps_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetApps_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetApps(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetDeprecationLinkString: {
      internal::PageHandler_GetDeprecationLinkString_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetDeprecationLinkString_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_GetDeprecationLinkString_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_GetDeprecationLinkString_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeprecationLinkString(std::move(callback));
      return true;
    }
    case messages::PageHandler::kUninstallApp: {
      break;
    }
    case messages::PageHandler::kShowAppSettings: {
      break;
    }
    case messages::PageHandler::kCreateAppShortcut: {
      internal::PageHandler_CreateAppShortcut_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_CreateAppShortcut_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_app_id{};
      PageHandler_CreateAppShortcut_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          PageHandler_CreateAppShortcut_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAppShortcut(        
        std::move(p_app_id), std::move(callback));
      return true;
    }
    case messages::PageHandler::kLaunchApp: {
      break;
    }
    case messages::PageHandler::kSetRunOnOsLoginMode: {
      break;
    }
    case messages::PageHandler::kLaunchDeprecatedAppDialog: {
      break;
    }
    case messages::PageHandler::kInstallAppLocally: {
      break;
    }
    case messages::PageHandler::kSetUserDisplayMode: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetApps_Params_Data::Validate,
     &internal::PageHandler_GetApps_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetDeprecationLinkString_Params_Data::Validate,
     &internal::PageHandler_GetDeprecationLinkString_ResponseParams_Data::Validate},
    { &internal::PageHandler_UninstallApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowAppSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_CreateAppShortcut_Params_Data::Validate,
     &internal::PageHandler_CreateAppShortcut_ResponseParams_Data::Validate},
    { &internal::PageHandler_LaunchApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetRunOnOsLoginMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_LaunchDeprecatedAppDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_InstallAppLocally_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetUserDisplayMode_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::app_home::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::app_home::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kAddApp: {
      return &Page::AddApp_Sym::IPCStableHash;
    }
    case messages::Page::kRemoveApp: {
      return &Page::RemoveApp_Sym::IPCStableHash;
    }
    case messages::Page::kUpdateApp: {
      return &Page::UpdateApp_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kAddApp:
            return "Receive app_home::mojom::Page::AddApp";
      case messages::Page::kRemoveApp:
            return "Receive app_home::mojom::Page::RemoveApp";
      case messages::Page::kUpdateApp:
            return "Receive app_home::mojom::Page::UpdateApp";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kAddApp:
            return "Receive reply app_home::mojom::Page::AddApp";
      case messages::Page::kRemoveApp:
            return "Receive reply app_home::mojom::Page::RemoveApp";
      case messages::Page::kUpdateApp:
            return "Receive reply app_home::mojom::Page::UpdateApp";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::AddApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a946aa5;  // IPCStableHash for app_home::mojom::Page::AddApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::RemoveApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c9ea173;  // IPCStableHash for app_home::mojom::Page::RemoveApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::UpdateApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x268cc6e9;  // IPCStableHash for app_home::mojom::Page::UpdateApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::AddApp(
    AppInfoPtr in_app_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::Page::AddApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_info"), in_app_info,
                        "<value of type AppInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kAddApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::Page_AddApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_info)::BaseType> app_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::app_home::mojom::AppInfoDataView>(
    in_app_info,
    app_info_fragment);

  params->app_info.Set(
      app_info_fragment.is_null() ? nullptr : app_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_info in Page.AddApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("AddApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::RemoveApp(
    AppInfoPtr in_app_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::Page::RemoveApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_info"), in_app_info,
                        "<value of type AppInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kRemoveApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::Page_RemoveApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_info)::BaseType> app_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::app_home::mojom::AppInfoDataView>(
    in_app_info,
    app_info_fragment);

  params->app_info.Set(
      app_info_fragment.is_null() ? nullptr : app_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_info in Page.RemoveApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("RemoveApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::UpdateApp(
    AppInfoPtr in_app_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_home::mojom::Page::UpdateApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_info"), in_app_info,
                        "<value of type AppInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kUpdateApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_home::mojom::internal::Page_UpdateApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_info)::BaseType> app_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::app_home::mojom::AppInfoDataView>(
    in_app_info,
    app_info_fragment);

  params->app_info.Set(
      app_info_fragment.is_null() ? nullptr : app_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_info in Page.UpdateApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("UpdateApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kAddApp: {
      DCHECK(message->is_serialized());
      internal::Page_AddApp_Params_Data* params =
          reinterpret_cast<internal::Page_AddApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      AppInfoPtr p_app_info{};
      Page_AddApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppInfo(&p_app_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddApp(        
        std::move(p_app_info));
      return true;
    }
    case messages::Page::kRemoveApp: {
      DCHECK(message->is_serialized());
      internal::Page_RemoveApp_Params_Data* params =
          reinterpret_cast<internal::Page_RemoveApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      AppInfoPtr p_app_info{};
      Page_RemoveApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppInfo(&p_app_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveApp(        
        std::move(p_app_info));
      return true;
    }
    case messages::Page::kUpdateApp: {
      DCHECK(message->is_serialized());
      internal::Page_UpdateApp_Params_Data* params =
          reinterpret_cast<internal::Page_UpdateApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      AppInfoPtr p_app_info{};
      Page_UpdateApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppInfo(&p_app_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateApp(        
        std::move(p_app_info));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kAddApp: {
      break;
    }
    case messages::Page::kRemoveApp: {
      break;
    }
    case messages::Page::kUpdateApp: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_AddApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_RemoveApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_UpdateApp_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::app_home::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // app_home::mojom


namespace mojo {


// static
bool StructTraits<::app_home::mojom::AppInfo::DataView, ::app_home::mojom::AppInfoPtr>::Read(
    ::app_home::mojom::AppInfo::DataView input,
    ::app_home::mojom::AppInfoPtr* output) {
  bool success = true;
  ::app_home::mojom::AppInfoPtr result(::app_home::mojom::AppInfo::New());
  
      if (success && !input.ReadAppType(&result->app_type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadStartUrl(&result->start_url))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIconUrl(&result->icon_url))
        success = false;
      if (success)
        result->may_show_run_on_os_login_mode = input.may_show_run_on_os_login_mode();
      if (success)
        result->may_toggle_run_on_os_login_mode = input.may_toggle_run_on_os_login_mode();
      if (success && !input.ReadRunOnOsLoginMode(&result->run_on_os_login_mode))
        success = false;
      if (success)
        result->is_locally_installed = input.is_locally_installed();
      if (success)
        result->open_in_window = input.open_in_window();
      if (success)
        result->may_uninstall = input.may_uninstall();
      if (success && !input.ReadStorePageUrl(&result->store_page_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::app_home::mojom::ClickEvent::DataView, ::app_home::mojom::ClickEventPtr>::Read(
    ::app_home::mojom::ClickEvent::DataView input,
    ::app_home::mojom::ClickEventPtr* output) {
  bool success = true;
  ::app_home::mojom::ClickEventPtr result(::app_home::mojom::ClickEvent::New());
  
      if (success)
        result->button = input.button();
      if (success)
        result->alt_key = input.alt_key();
      if (success)
        result->ctrl_key = input.ctrl_key();
      if (success)
        result->meta_key = input.meta_key();
      if (success)
        result->shift_key = input.shift_key();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace app_home::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetApps(GetAppsCallback callback) {
  GetForwardingInterface()->GetApps(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetDeprecationLinkString(GetDeprecationLinkStringCallback callback) {
  GetForwardingInterface()->GetDeprecationLinkString(std::move(callback));
}
void PageHandlerInterceptorForTesting::UninstallApp(const std::string& app_id) {
  GetForwardingInterface()->UninstallApp(
    std::move(app_id)
    );
}
void PageHandlerInterceptorForTesting::ShowAppSettings(const std::string& app_id) {
  GetForwardingInterface()->ShowAppSettings(
    std::move(app_id)
    );
}
void PageHandlerInterceptorForTesting::CreateAppShortcut(const std::string& app_id, CreateAppShortcutCallback callback) {
  GetForwardingInterface()->CreateAppShortcut(
    std::move(app_id)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::LaunchApp(const std::string& app_id, ClickEventPtr click_event) {
  GetForwardingInterface()->LaunchApp(
    std::move(app_id)
    , 
    std::move(click_event)
    );
}
void PageHandlerInterceptorForTesting::SetRunOnOsLoginMode(const std::string& app_id, ::web_app::RunOnOsLoginMode run_on_os_login_mode) {
  GetForwardingInterface()->SetRunOnOsLoginMode(
    std::move(app_id)
    , 
    std::move(run_on_os_login_mode)
    );
}
void PageHandlerInterceptorForTesting::LaunchDeprecatedAppDialog() {
  GetForwardingInterface()->LaunchDeprecatedAppDialog();
}
void PageHandlerInterceptorForTesting::InstallAppLocally(const std::string& app_id) {
  GetForwardingInterface()->InstallAppLocally(
    std::move(app_id)
    );
}
void PageHandlerInterceptorForTesting::SetUserDisplayMode(const std::string& app_id, ::web_app::mojom::UserDisplayMode display_mode) {
  GetForwardingInterface()->SetUserDisplayMode(
    std::move(app_id)
    , 
    std::move(display_mode)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetApps(
    std::vector<AppInfoPtr>* out_app_list) {
  base::RunLoop loop;
  proxy_->GetApps(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<AppInfoPtr>* out_app_list
,
             std::vector<AppInfoPtr> app_list) {*out_app_list = std::move(app_list);
            loop->Quit();
          },
          &loop,
          out_app_list));
  loop.Run();
}

std::vector<AppInfoPtr> PageHandlerAsyncWaiter::GetApps(
    ) {
  std::vector<AppInfoPtr> async_wait_result;
  GetApps(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetDeprecationLinkString(
    std::string* out_link_string) {
  base::RunLoop loop;
  proxy_->GetDeprecationLinkString(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_link_string
,
             const std::string& link_string) {*out_link_string = std::move(link_string);
            loop->Quit();
          },
          &loop,
          out_link_string));
  loop.Run();
}

std::string PageHandlerAsyncWaiter::GetDeprecationLinkString(
    ) {
  std::string async_wait_result;
  GetDeprecationLinkString(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::CreateAppShortcut(
    const std::string& app_id) {
  base::RunLoop loop;
  proxy_->CreateAppShortcut(
      std::move(app_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void PageInterceptorForTesting::AddApp(AppInfoPtr app_info) {
  GetForwardingInterface()->AddApp(
    std::move(app_info)
    );
}
void PageInterceptorForTesting::RemoveApp(AppInfoPtr app_info) {
  GetForwardingInterface()->RemoveApp(
    std::move(app_info)
    );
}
void PageInterceptorForTesting::UpdateApp(AppInfoPtr app_info) {
  GetForwardingInterface()->UpdateApp(
    std::move(app_info)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // app_home::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif