// chrome/browser/ui/webui/app_home/app_home.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/app_home/app_home.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/app_home/app_home.mojom-params-data.h"
namespace app_home {
namespace mojom {

NOINLINE static const char* RunOnOsLoginModeToStringHelper(RunOnOsLoginMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RunOnOsLoginMode::kNotRun:
      return "kNotRun";
    case RunOnOsLoginMode::kWindowed:
      return "kWindowed";
    case RunOnOsLoginMode::kMinimized:
      return "kMinimized";
    default:
      return nullptr;
  }
}

std::string RunOnOsLoginModeToString(RunOnOsLoginMode value) {
  const char *str = RunOnOsLoginModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RunOnOsLoginMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RunOnOsLoginMode value) {
  return os << RunOnOsLoginModeToString(value);
}

NOINLINE static const char* AppTypeToStringHelper(AppType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppType::kWebApp:
      return "kWebApp";
    case AppType::kIsolatedWebApp:
      return "kIsolatedWebApp";
    case AppType::kDeprecatedChromeApp:
      return "kDeprecatedChromeApp";
    default:
      return nullptr;
  }
}

std::string AppTypeToString(AppType value) {
  const char *str = AppTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppType value) {
  return os << AppTypeToString(value);
}

namespace internal {


// static
bool AppInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppInfo_Data* object =
      static_cast<const AppInfo_Data*>(data);


  if (!::app_home::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_url, validation_context))
    return false;


  if (!::app_home::mojom::internal::RunOnOsLoginMode_Data
        ::Validate(object->run_on_os_login_mode, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->store_page_url, validation_context))
    return false;

  return true;
}

AppInfo_Data::AppInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClickEvent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClickEvent_Data* object =
      static_cast<const ClickEvent_Data*>(data);

  return true;
}

ClickEvent_Data::ClickEvent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetApps_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetApps_Params_Data* object =
      static_cast<const PageHandler_GetApps_Params_Data*>(data);

  return true;
}

PageHandler_GetApps_Params_Data::PageHandler_GetApps_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetApps_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetApps_ResponseParams_Data* object =
      static_cast<const PageHandler_GetApps_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_list, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_list, validation_context,
                                         &app_list_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetApps_ResponseParams_Data::PageHandler_GetApps_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetDeprecationLinkString_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetDeprecationLinkString_Params_Data* object =
      static_cast<const PageHandler_GetDeprecationLinkString_Params_Data*>(data);

  return true;
}

PageHandler_GetDeprecationLinkString_Params_Data::PageHandler_GetDeprecationLinkString_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetDeprecationLinkString_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetDeprecationLinkString_ResponseParams_Data* object =
      static_cast<const PageHandler_GetDeprecationLinkString_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->link_string, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& link_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->link_string, validation_context,
                                         &link_string_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetDeprecationLinkString_ResponseParams_Data::PageHandler_GetDeprecationLinkString_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UninstallApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UninstallApp_Params_Data* object =
      static_cast<const PageHandler_UninstallApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_UninstallApp_Params_Data::PageHandler_UninstallApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowAppSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowAppSettings_Params_Data* object =
      static_cast<const PageHandler_ShowAppSettings_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ShowAppSettings_Params_Data::PageHandler_ShowAppSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CreateAppShortcut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CreateAppShortcut_Params_Data* object =
      static_cast<const PageHandler_CreateAppShortcut_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_CreateAppShortcut_Params_Data::PageHandler_CreateAppShortcut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CreateAppShortcut_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CreateAppShortcut_ResponseParams_Data* object =
      static_cast<const PageHandler_CreateAppShortcut_ResponseParams_Data*>(data);

  return true;
}

PageHandler_CreateAppShortcut_ResponseParams_Data::PageHandler_CreateAppShortcut_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_LaunchApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_LaunchApp_Params_Data* object =
      static_cast<const PageHandler_LaunchApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->click_event, validation_context))
    return false;

  return true;
}

PageHandler_LaunchApp_Params_Data::PageHandler_LaunchApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetRunOnOsLoginMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetRunOnOsLoginMode_Params_Data* object =
      static_cast<const PageHandler_SetRunOnOsLoginMode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::app_home::mojom::internal::RunOnOsLoginMode_Data
        ::Validate(object->run_on_os_login_mode, validation_context))
    return false;

  return true;
}

PageHandler_SetRunOnOsLoginMode_Params_Data::PageHandler_SetRunOnOsLoginMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_LaunchDeprecatedAppDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_LaunchDeprecatedAppDialog_Params_Data* object =
      static_cast<const PageHandler_LaunchDeprecatedAppDialog_Params_Data*>(data);

  return true;
}

PageHandler_LaunchDeprecatedAppDialog_Params_Data::PageHandler_LaunchDeprecatedAppDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_InstallAppLocally_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_InstallAppLocally_Params_Data* object =
      static_cast<const PageHandler_InstallAppLocally_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_InstallAppLocally_Params_Data::PageHandler_InstallAppLocally_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetUserDisplayMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetUserDisplayMode_Params_Data* object =
      static_cast<const PageHandler_SetUserDisplayMode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::web_app::mojom::internal::UserDisplayMode_Data
        ::Validate(object->display_mode, validation_context))
    return false;

  return true;
}

PageHandler_SetUserDisplayMode_Params_Data::PageHandler_SetUserDisplayMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_AddApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_AddApp_Params_Data* object =
      static_cast<const Page_AddApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->app_info, validation_context))
    return false;

  return true;
}

Page_AddApp_Params_Data::Page_AddApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_RemoveApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_RemoveApp_Params_Data* object =
      static_cast<const Page_RemoveApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->app_info, validation_context))
    return false;

  return true;
}

Page_RemoveApp_Params_Data::Page_RemoveApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_UpdateApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_UpdateApp_Params_Data* object =
      static_cast<const Page_UpdateApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->app_info, validation_context))
    return false;

  return true;
}

Page_UpdateApp_Params_Data::Page_UpdateApp_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace app_home

namespace perfetto {

// static
void TraceFormatTraits<::app_home::mojom::RunOnOsLoginMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_home::mojom::RunOnOsLoginMode value) {
  return std::move(context).WriteString(::app_home::mojom::RunOnOsLoginModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::app_home::mojom::AppType>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_home::mojom::AppType value) {
  return std::move(context).WriteString(::app_home::mojom::AppTypeToString(value));
}

} // namespace perfetto