// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{Command}from"chrome://resources/js/browser_command.mojom-webui.js";import{BrowserCommandProxy}from"chrome://resources/js/browser_command/browser_command_proxy.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{isChromeOS}from"chrome://resources/js/platform.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{ModulePosition,ScrollDepth}from"./whats_new.mojom-webui.js";import{getCss}from"./whats_new_app.css.js";import{getHtml}from"./whats_new_app.html.js";import{WhatsNewProxyImpl}from"./whats_new_proxy.js";var EventType;(function(EventType){EventType["BROWSER_COMMAND"]="browser_command";EventType["PAGE_LOADED"]="page_loaded";EventType["MODULE_IMPRESSION"]="module_impression";EventType["EXPLORE_MORE_OPEN"]="explore_more_open";EventType["EXPLORE_MORE_CLOSE"]="explore_more_close";EventType["SCROLL"]="scroll";EventType["TIME_ON_PAGE_MS"]="time_on_page_ms";EventType["GENERAL_LINK_CLICK"]="general_link_click";EventType["MODULES_RENDERED"]="modules_rendered";EventType["VIDEO_STARTED"]="video_started";EventType["VIDEO_ENDED"]="video_ended";EventType["PLAY_CLICKED"]="play_clicked";EventType["PAUSE_CLICKED"]="pause_clicked";EventType["RESTART_CLICKED"]="restart_clicked";EventType["QR_CODE_TOGGLE_OPEN"]="qr_code_toggle_open";EventType["QR_CODE_TOGGLE_CLOSE"]="qr_code_toggle_close";EventType["NAV_CLICK"]="nav_click";EventType["FEATURE_TILE_NAVIGATION"]="feature_tile_navigation";EventType["CAROUSEL_SCROLL_BUTTON_CLICK"]="carousel_scroll_button_click";EventType["EXPEND_MEDIA"]="expand_media";EventType["CLOSE_EXPANDED_MEDIA"]="close_expanded_media";EventType["CTA_CLICK"]="cta_click";EventType["NEXT_BUTTON_CLICK"]="next_button_click"})(EventType||(EventType={}));var SectionType;(function(SectionType){SectionType["SPOTLIGHT"]="spotlight";SectionType["EXPLORE_MORE"]="explore_more"})(SectionType||(SectionType={}));const kModulePositionsMap={[SectionType.SPOTLIGHT]:[ModulePosition.kSpotlight1,ModulePosition.kSpotlight2,ModulePosition.kSpotlight3,ModulePosition.kSpotlight4],[SectionType.EXPLORE_MORE]:[ModulePosition.kExploreMore1,ModulePosition.kExploreMore2,ModulePosition.kExploreMore3,ModulePosition.kExploreMore4,ModulePosition.kExploreMore5,ModulePosition.kExploreMore6]};function handleBrowserCommand(messageData){if(!Object.values(Command).includes(messageData.commandId)){return}const{commandId:commandId}=messageData;const handler=BrowserCommandProxy.getInstance().handler;handler.canExecuteCommand(commandId).then((({canExecute:canExecute})=>{if(canExecute){handler.executeCommand(commandId,messageData.clickInfo);const pageHandler=WhatsNewProxyImpl.getInstance().handler;pageHandler.recordBrowserCommandExecuted()}else{console.warn("Received invalid command: "+commandId)}}))}function handlePageLoadMetric(data,isAutoOpen){const{handler:handler}=WhatsNewProxyImpl.getInstance();const now=new Date;handler.recordTimeToLoadContent(now);handler.recordScrollDepth(ScrollDepth.k0);switch(data.type){case"version":if(Number.isInteger(data.version)){const{handler:handler}=WhatsNewProxyImpl.getInstance();handler.recordVersionPageLoaded(isAutoOpen)}break;case"edition":const{handler:handler}=WhatsNewProxyImpl.getInstance();handler.recordEditionPageLoaded(data.page_uid,isAutoOpen);break;default:console.warn("Unrecognized page version: "+data.type)}}function handleScrollDepthMetric(data){let scrollDepth;switch(data.percent_scrolled){case"25":scrollDepth=ScrollDepth.k25;break;case"50":scrollDepth=ScrollDepth.k50;break;case"75":scrollDepth=ScrollDepth.k75;break;case"100":scrollDepth=ScrollDepth.k100;break;default:break}if(scrollDepth){const{handler:handler}=WhatsNewProxyImpl.getInstance();handler.recordScrollDepth(scrollDepth)}else{console.warn("Unrecognized scroll percentage: ",data.percent_scrolled)}}function parseOrder(section,order){if(!section||!order){return ModulePosition.kUndefined}if(!Object.values(SectionType).includes(section)){return ModulePosition.kUndefined}const moduleSection=kModulePositionsMap[section];const orderAsNumber=Number.parseInt(order,10);if(Number.isNaN(orderAsNumber)||orderAsNumber>moduleSection.length||orderAsNumber<1){return ModulePosition.kUndefined}return moduleSection[orderAsNumber-1]}function uppercaseFirstLetter(word){return word.replace(/^\w/,(firstLetter=>firstLetter.toUpperCase()))}function kebabCaseToCamelCase(input){return input.split("-").map(uppercaseFirstLetter).join("")}export function formatModuleName(moduleName){if(!moduleName.includes("-")){return moduleName}const withoutPrefix=moduleName.replace(/^\d{3}-/,"");return kebabCaseToCamelCase(withoutPrefix)}function handleModuleEvent(data){if(!data.module_name){return}const position=parseOrder(data.section,data.order);const{handler:handler}=WhatsNewProxyImpl.getInstance();switch(data.event){case EventType.MODULE_IMPRESSION:handler.recordModuleImpression(formatModuleName(data.module_name),position);break;case EventType.GENERAL_LINK_CLICK:handler.recordModuleLinkClicked(formatModuleName(data.module_name),position);break;case EventType.VIDEO_STARTED:handler.recordModuleVideoStarted(formatModuleName(data.module_name),position);break;case EventType.VIDEO_ENDED:handler.recordModuleVideoEnded(formatModuleName(data.module_name),position);break;case EventType.PLAY_CLICKED:handler.recordModulePlayClicked(formatModuleName(data.module_name),position);break;case EventType.PAUSE_CLICKED:handler.recordModulePauseClicked(formatModuleName(data.module_name),position);break;case EventType.RESTART_CLICKED:handler.recordModuleRestartClicked(formatModuleName(data.module_name),position);break;case EventType.EXPEND_MEDIA:WhatsNewProxyImpl.getInstance().handler.recordExpandMediaToggled(data.module_name,true);break;case EventType.CLOSE_EXPANDED_MEDIA:WhatsNewProxyImpl.getInstance().handler.recordExpandMediaToggled(data.module_name,false);break;default:break}}function handleTimeOnPageMetric(data){if(Number.isInteger(data.time)&&data.time>0){const{handler:handler}=WhatsNewProxyImpl.getInstance();const delta={microseconds:BigInt(data.time)*1000n};handler.recordTimeOnPage(delta)}else{console.warn("Invalid time: ",data.time)}}export class WhatsNewAppElement extends CrLitElement{static get is(){return"whats-new-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{url_:{type:String}}}#url__accessor_storage="";get url_(){return this.#url__accessor_storage}set url_(value){this.#url__accessor_storage=value}isAutoOpen_=false;eventTracker_=new EventTracker;constructor(){super();const queryParams=new URLSearchParams(window.location.search);this.isAutoOpen_=queryParams.has("auto");window.history.replaceState(undefined,"","/")}connectedCallback(){super.connectedCallback();WhatsNewProxyImpl.getInstance().handler.getServerUrl(loadTimeData.getBoolean("isStaging")).then((({url:url})=>this.handleUrlResult_(url.url)))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}handleUrlResult_(url){if(!url){return}const latest=this.isAutoOpen_&&!isChromeOS?"true":"false";url+=url.includes("?")?"&":"?";this.url_=url.concat(`updated=${latest}`);this.eventTracker_.add(window,"message",(event=>this.handleMessage_(event)))}handleMessage_(event){if(!this.url_){return}const iframeUrl=new URL(this.url_);if(!event.data||event.origin!==iframeUrl.origin){return}const data=event.data.data;if(!data){return}switch(data.event){case EventType.BROWSER_COMMAND:handleBrowserCommand(data);break;case EventType.PAGE_LOADED:handlePageLoadMetric(data,this.isAutoOpen_);break;case EventType.MODULES_RENDERED:break;case EventType.EXPLORE_MORE_OPEN:WhatsNewProxyImpl.getInstance().handler.recordExploreMoreToggled(true);break;case EventType.EXPLORE_MORE_CLOSE:WhatsNewProxyImpl.getInstance().handler.recordExploreMoreToggled(false);break;case EventType.SCROLL:handleScrollDepthMetric(data);break;case EventType.TIME_ON_PAGE_MS:handleTimeOnPageMetric(data);break;case EventType.MODULE_IMPRESSION:case EventType.GENERAL_LINK_CLICK:case EventType.VIDEO_STARTED:case EventType.VIDEO_ENDED:case EventType.PLAY_CLICKED:case EventType.PAUSE_CLICKED:case EventType.RESTART_CLICKED:case EventType.EXPEND_MEDIA:case EventType.CLOSE_EXPANDED_MEDIA:handleModuleEvent(data);break;case EventType.QR_CODE_TOGGLE_OPEN:WhatsNewProxyImpl.getInstance().handler.recordQrCodeToggled(true);break;case EventType.QR_CODE_TOGGLE_CLOSE:WhatsNewProxyImpl.getInstance().handler.recordQrCodeToggled(false);break;case EventType.NAV_CLICK:WhatsNewProxyImpl.getInstance().handler.recordNavClick();break;case EventType.FEATURE_TILE_NAVIGATION:WhatsNewProxyImpl.getInstance().handler.recordFeatureTileNavigation();break;case EventType.CAROUSEL_SCROLL_BUTTON_CLICK:WhatsNewProxyImpl.getInstance().handler.recordCarouselScrollButtonClick();break;case EventType.CTA_CLICK:WhatsNewProxyImpl.getInstance().handler.recordCtaClick();break;case EventType.NEXT_BUTTON_CLICK:WhatsNewProxyImpl.getInstance().handler.recordNextButtonClick();break;default:console.warn("Unrecognized message.",data)}}}customElements.define(WhatsNewAppElement.is,WhatsNewAppElement);