import type { ItemData, TabData, TabGroupData } from './tab_data.js';
export interface OptionKeyObject {
    name: string;
    getter: (data: TabData | TabGroupData) => string | undefined;
    weight: number;
}
export interface SearchOptions {
    includeScore?: boolean;
    includeMatches?: boolean;
    ignoreLocation?: boolean;
    threshold?: number;
    distance?: number;
    keys: OptionKeyObject[];
}
/**
 * @return A new array of entries satisfying the input. If no search input is
 *     present, returns a shallow copy of the records.
 */
export declare function search<T extends ItemData>(input: string, records: T[], options: SearchOptions): T[];
