import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import '/strings.m.js';
import './auto_tab_groups_new_badge.js';
import './auto_tab_groups_results_actions.js';
import '../tab_search_item.js';
import type { CrPageSelectorElement } from 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { TabData } from '../tab_data.js';
import type { Tab } from '../tab_search.mojom-webui.js';
export interface AutoTabGroupsGroupElement {
    $: {
        selector: CrPageSelectorElement;
    };
}
export declare class AutoTabGroupsGroupElement extends CrLitElement {
    static get is(): string;
    static get properties(): {
        tabs: {
            type: ArrayConstructor;
        };
        firstNewTabIndex: {
            type: NumberConstructor;
        };
        name: {
            type: StringConstructor;
        };
        organizationId: {
            type: NumberConstructor;
        };
        showReject: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        lastFocusedIndex_: {
            type: NumberConstructor;
        };
        showInput_: {
            type: BooleanConstructor;
        };
        tabDatas_: {
            type: ArrayConstructor;
        };
        changedName_: {
            type: BooleanConstructor;
        };
    };
    accessor tabs: Tab[];
    accessor firstNewTabIndex: number;
    accessor name: string;
    accessor organizationId: number;
    accessor showReject: boolean;
    private accessor lastFocusedIndex_;
    protected accessor showInput_: boolean;
    protected accessor tabDatas_: TabData[];
    private accessor changedName_;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    connectedCallback(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    updated(changedProperties: PropertyValues<this>): void;
    focusInput(): void;
    private getInput_;
    private computeTabDatas_;
    protected getTabIndex_(index: number): number;
    protected getInputAriaLabel_(): string;
    protected getEditButtonAriaLabel_(): string;
    protected getRejectButtonAriaLabel_(): string;
    protected showNewTabSectionHeader_(index: number): boolean;
    protected onInputFocus_(): void;
    protected onInputBlur_(): void;
    protected maybeRenameGroup_(): void;
    protected onInputKeyDown_(event: KeyboardEvent): void;
    protected onListKeyDown_(event: KeyboardEvent): void;
    protected onSelectedChanged_(): void;
    protected onTabRemove_(e: Event): void;
    protected onTabFocus_(e: Event): void;
    protected onTabBlur_(_e: Event): void;
    protected getCloseButtonAriaLabel_(tabData: TabData): string;
    protected onEditClick_(): void;
    protected onRejectGroupClick_(event: CustomEvent): void;
    protected onCreateGroupClick_(event: CustomEvent): void;
    protected onNameChanged_(e: CustomEvent<{
        value: string;
    }>): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'auto-tab-groups-group': AutoTabGroupsGroupElement;
    }
}
