// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./icons.html.js";import"//resources/cr_elements/cr_collapse/cr_collapse.js";import"//resources/cr_elements/cr_expand_button/cr_expand_button.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/cr_icon/cr_icon.js";import"//resources/cr_elements/icons.html.js";import"//resources/cr_elements/cr_chip/cr_chip.js";import{assert}from"//resources/js/assert.js";import{sanitizeInnerHtml}from"//resources/js/parse_html_subset.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{PageClassification}from"./omnibox.mojom-webui.js";import{getCss}from"./request.css.js";import{getHtml}from"./request.html.js";import{RequestStatus}from"./suggest_internals.mojom-webui.js";export class SuggestRequestElement extends CrLitElement{static get is(){return"suggest-request"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{request:{type:Object},requestDataJson_:{type:String},responseJson_:{type:String},pgcl_:{type:String},expanded_:{type:Boolean}}}#request_accessor_storage=null;get request(){return this.#request_accessor_storage}set request(value){this.#request_accessor_storage=value}#requestDataJson__accessor_storage="";get requestDataJson_(){return this.#requestDataJson__accessor_storage}set requestDataJson_(value){this.#requestDataJson__accessor_storage=value}#responseJson__accessor_storage="";get responseJson_(){return this.#responseJson__accessor_storage}set responseJson_(value){this.#responseJson__accessor_storage=value}#pgcl__accessor_storage="";get pgcl_(){return this.#pgcl__accessor_storage}set pgcl_(value){this.#pgcl__accessor_storage=value}#expanded__accessor_storage=false;get expanded_(){return this.#expanded__accessor_storage}set expanded_(value){this.#expanded__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(this.request===null){this.requestDataJson_="";this.responseJson_="";this.pgcl_="";return}this.requestDataJson_=this.computeRequestDataJson_();this.responseJson_=this.computeResponseJson_();this.pgcl_=this.computePageClassification_()}computeRequestDataJson_(){assert(this.request);try{this.request.data["Request-Body"]=JSON.parse(this.request.data["Request-Body"])}finally{return JSON.stringify(this.request.data,null,2)}}computeResponseJson_(){assert(this.request);try{const validJson=this.request.response.replace(")]}'","").trim();const parsedJson=JSON.parse(validJson);return JSON.stringify(parsedJson,null,2)}catch(e){return""}}computePageClassification_(){assert(this.request);if(!this.request.url.url){return""}const url=new URL(this.request.url.url);const queryMatches=url.search.match(/pgcl=(?<pgcl>[^&]*)/);if(queryMatches===null||!queryMatches.groups){return""}return queryMatches.groups["pgcl"]||""}getPageClassificationLabel_(){return PageClassification[parseInt(this.pgcl_)]}insertTextProtoLinks_(stringJSON){const regexGroups=/"(?<type>(?:google:entityinfo|google:groupsinfo|X-Client-Data))":\s"(?<proto>(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?)"/g;return stringJSON.replace(regexGroups,((_match,_p1,_p2,_offset,_string,groups)=>{let urlType="";switch(groups.type){case"google:entityinfo":urlType="gws.searchbox.chrome.EntityInfo";break;case"google:groupsinfo":urlType="gws.searchbox.chrome.GroupsInfo";break;case"X-Client-Data":urlType="webserver.gws.ClientDataHeader"}return`"${groups.type}": <a target='_blank' href=https://protoshop.corp.google.com/embed?tabs=textproto&type=${urlType}&protobytes=${groups.proto}>${groups.proto}</a>`}))}getRequestDataHtml_(){const htmlJSON=this.insertTextProtoLinks_(this.requestDataJson_);return sanitizeInnerHtml(htmlJSON)}getRequestPath_(){if(this.request===null){return""}try{const url=new URL(this.request.url.url);const queryMatches=url.search.match(/(q|delq)=[^&]*/);return url.pathname+"?"+(queryMatches?queryMatches[0]:"")}catch(e){return""}}getResponseHtml_(){const htmlJSON=this.insertTextProtoLinks_(this.responseJson_);return sanitizeInnerHtml(htmlJSON)}getStatusIcon_(){switch(this.request?.status){case RequestStatus.kHardcoded:return"suggest:lock";case RequestStatus.kCreated:return"cr:create";case RequestStatus.kSent:return"cr:schedule";case RequestStatus.kSucceeded:return"cr:check-circle";case RequestStatus.kFailed:return"cr:cancel";default:return""}}getStatusTitle_(){switch(this.request?.status){case RequestStatus.kHardcoded:return"hardcoded";case RequestStatus.kCreated:return"created";case RequestStatus.kSent:return"pending";case RequestStatus.kSucceeded:const startTimeMs=Number(this.request.startTime.internalValue)/1e3;const endTimeMs=Number(this.request.endTime.internalValue)/1e3;return`succeeded in ${Math.round(endTimeMs-startTimeMs)} ms`;case RequestStatus.kFailed:return"failed";default:return""}}getTimestamp_(){if(this.request===null){return""}const windowsEpoch=Date.UTC(1601,0,1,0,0,0,0);const unixEpoch=Date.UTC(1970,0,1,0,0,0,0);const epochDeltaMs=unixEpoch-windowsEpoch;const startTimeMs=Number(this.request.startTime.internalValue)/1e3;return new Date(startTimeMs-epochDeltaMs).toLocaleTimeString()}onCopyRequestClick_(){navigator.clipboard.writeText(this.requestDataJson_);this.dispatchEvent(new CustomEvent("show-toast",{bubbles:true,composed:true,detail:"Request Copied to Clipboard"}))}onCopyResponseClick_(){navigator.clipboard.writeText(this.responseJson_);this.dispatchEvent(new CustomEvent("show-toast",{bubbles:true,composed:true,detail:"Response Copied to Clipboard"}))}onHardcodeResponseClick_(){this.dispatchEvent(new CustomEvent("open-hardcode-response-dialog",{bubbles:true,composed:true,detail:this.responseJson_}))}onChipClick_(e){this.dispatchEvent(new CustomEvent("chip-click",{bubbles:true,composed:true,detail:this.pgcl_}));const button=this.shadowRoot.querySelector("cr-expand-button");const label=button.shadowRoot.querySelector("#label");label.ariaHidden="false";e.stopPropagation();e.preventDefault()}onExpandedChanged_(e){this.expanded_=e.detail.value}}customElements.define(SuggestRequestElement.is,SuggestRequestElement);